/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual.antlr.ast;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.qual.antlr.ast.ARASTTreeWalker;
import com.bmc.thirdparty.org.antlr.runtime.tree.CommonTree;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ASTQualTreeWalker
extends ARASTTreeWalker {
    private static final Logger logger = Logger.getLogger(ASTQualTreeWalker.class);

    public ASTQualTreeWalker(ARParseFormatInfo in) {
        super(in);
    }

    public ASTQualTreeWalker(CommonTree root, ARParseFormatInfo in) {
        super(root, in);
    }

    public QualifierInfo createQualifierInfo() throws ARException {
        return this.createQualifierInfo(this.root);
    }

    public QualifierInfo createQualifierInfo(CommonTree tree) throws ARException {
        this.root = tree;
        QualifierInfo result = null;
        int operation = -1;
        if (tree == null) {
            logger.info("Qualification String length is zero returning null.");
            return null;
        }
        switch (tree.getType()) {
            case 6: {
                operation = 2;
                break;
            }
            case 7: {
                operation = 1;
                break;
            }
            case 8: {
                operation = 3;
                break;
            }
            case 5: {
                operation = 5;
                break;
            }
        }
        result = operation == 5 ? this.loadFromFieldInfo((CommonTree)tree.getChild(0)) : (operation != -1 ? new QualifierInfo(operation, this.createQualifierInfo((CommonTree)tree.getChild(0)), this.createQualifierInfo((CommonTree)tree.getChild(1))) : new QualifierInfo(this.createRelationalOperationInfo(tree)));
        return result;
    }

    public RelationalOperationInfo createRelationalOperationInfo(CommonTree tree) throws ARException {
        int operation = -1;
        RelationalOperationInfo relOpInfo = null;
        ArithmeticOrRelationalOperand leftOperand = null;
        ArithmeticOrRelationalOperand rightOperand = null;
        switch (tree.getType()) {
            case 9: {
                operation = 1;
                break;
            }
            case 10: {
                operation = 6;
                break;
            }
            case 11: {
                operation = 4;
                break;
            }
            case 13: {
                operation = 2;
                break;
            }
            case 12: {
                operation = 5;
                break;
            }
            case 14: {
                operation = 3;
                break;
            }
            case 15: {
                operation = 7;
                break;
            }
            case 16: {
                operation = 8;
                break;
            }
            default: {
                throw new ARException(2, 1583, " position " + tree.getCharPositionInLine(), this.info.getLocale());
            }
        }
        leftOperand = this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(0));
        if (operation == 8) {
            ArrayList<Value> valList = new ArrayList<Value>();
            for (int valSetCtr = 1; valSetCtr <= tree.getChildCount(); valSetCtr += 2) {
                rightOperand = this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(valSetCtr));
                valList.add((Value)rightOperand.getValue());
            }
            rightOperand = new ArithmeticOrRelationalOperand(valList);
        } else {
            rightOperand = this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(1));
        }
        if (leftOperand != null && rightOperand != null) {
            this.loadCharWithValue(leftOperand, rightOperand, operation, true);
            this.loadCharWithValue(rightOperand, leftOperand, operation, true);
        }
        relOpInfo = new RelationalOperationInfo(operation, leftOperand, rightOperand);
        return relOpInfo;
    }

    public ArithmeticOperationInfo createArithmeticOperationInfo(CommonTree tree) throws ARException {
        int operation = -1;
        ArithmeticOperationInfo arithOpInfo = null;
        ArithmeticOrRelationalOperand leftOperand = null;
        ArithmeticOrRelationalOperand rightOperand = null;
        switch (tree.getType()) {
            case 19: {
                operation = 1;
                break;
            }
            case 20: {
                operation = 2;
                break;
            }
            case 21: {
                operation = 3;
                break;
            }
            case 22: {
                operation = 4;
                break;
            }
            case 23: {
                operation = 5;
                break;
            }
            default: {
                throw new ARException(2, 1582, " position " + tree.getCharPositionInLine(), this.info.getLocale());
            }
        }
        leftOperand = this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(0));
        rightOperand = this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(1));
        arithOpInfo = new ArithmeticOperationInfo(operation, leftOperand, rightOperand);
        return arithOpInfo;
    }

    public ArithmeticOrRelationalOperand createArithmeticOrRelationalOperand(CommonTree tree) throws ARException {
        if (tree == null) {
            return null;
        }
        ArithmeticOrRelationalOperand arithOrRelOperand = null;
        NumberFormat numberFormat = null;
        Number number = null;
        String nodeText = tree.getText();
        switch (tree.getType()) {
            case 24: 
            case 26: {
                arithOrRelOperand = this.parseField(tree);
                break;
            }
            case 25: {
                nodeText = nodeText.replaceAll("\"\"", "\"");
                if (nodeText == null) {
                    arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value());
                    break;
                }
                arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(nodeText, DataType.CHAR));
                break;
            }
            case 27: {
                try {
                    int tmpValue = Integer.parseInt(nodeText);
                    arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(Integer.valueOf(tmpValue).toString(), DataType.INTEGER));
                }
                catch (NumberFormatException nfe) {
                    numberFormat = NumberFormat.getInstance(this.info.getLocale());
                    try {
                        if (numberFormat instanceof DecimalFormat) {
                            ((DecimalFormat)numberFormat).setParseBigDecimal(true);
                            number = numberFormat.parse(nodeText);
                            arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(((BigDecimal)number).toString(), DataType.DECIMAL));
                            break;
                        }
                        number = numberFormat.parse(nodeText);
                        arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(number.toString(), DataType.DECIMAL));
                    }
                    catch (ParseException e) {
                        this.reportError(1584, tree);
                    }
                }
                break;
            }
            case 28: {
                numberFormat = NumberFormat.getInstance(this.info.getLocale());
                try {
                    if (numberFormat instanceof DecimalFormat) {
                        ((DecimalFormat)numberFormat).setParseBigDecimal(true);
                        number = numberFormat.parse(nodeText);
                        arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(((BigDecimal)number).toString(), DataType.DECIMAL));
                        break;
                    }
                    number = numberFormat.parse(nodeText);
                    arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value(number.toString(), DataType.DECIMAL));
                }
                catch (ParseException e) {
                    this.reportError(1584, tree);
                }
                break;
            }
            case 29: {
                arithOrRelOperand = new ArithmeticOrRelationalOperand(new Value());
                break;
            }
            case 4: {
                ArithmeticOperationInfo arithInfo = new ArithmeticOperationInfo(6, null, this.createArithmeticOrRelationalOperand((CommonTree)tree.getChild(0)));
                arithOrRelOperand = new ArithmeticOrRelationalOperand(arithInfo);
                break;
            }
            default: {
                ArithmeticOperationInfo arithOpInfo = this.createArithmeticOperationInfo(tree);
                arithOrRelOperand = new ArithmeticOrRelationalOperand(arithOpInfo);
            }
        }
        return arithOrRelOperand;
    }

    private ArithmeticOrRelationalOperand parseField(CommonTree tree) throws ARException {
        Field field = null;
        String nodeValue = tree.getText();
        int oprndType = -1;
        if (tree.getType() == 26) {
            oprndType = 99;
            nodeValue = nodeValue.replaceAll("\\$\\$", "\\$");
            Keyword keyword = null;
            if (this.isNullKeyword(nodeValue)) {
                return new ArithmeticOrRelationalOperand(new Value());
            }
            keyword = Keyword.toKeyword(nodeValue);
            if (keyword != null) {
                return new ArithmeticOrRelationalOperand(new Value(keyword));
            }
            if (nodeValue.startsWith("$") && nodeValue.endsWith("$") && nodeValue.length() > 1) {
                nodeValue = nodeValue.substring(1, nodeValue.length() - 1);
                if (this.info.getLocation() == 4 && !this.info.getExceptionWhenFieldNotFound()) {
                    try {
                        int id = Integer.parseInt(nodeValue);
                        return new ArithmeticOrRelationalOperand(oprndType, id);
                    }
                    catch (NumberFormatException id) {}
                }
            }
        } else if (tree.getType() == 24) {
            oprndType = 1;
            nodeValue = nodeValue.replaceAll("''", "'");
            if (this.info.getLocation() == 2) {
                oprndType = 99;
            }
        }
        String[] parts = nodeValue.split("\\.");
        field = this.getField(nodeValue, tree);
        if (parts.length == 1 || field != null) {
            if (field != null) {
                if (field.getDataType() == 12) {
                    oprndType = oprndType == 99 ? 56 : 6;
                    return new ArithmeticOrRelationalOperand(oprndType, new CurrencyPartInfo(field.getFieldID(), 0, ""));
                }
                return new ArithmeticOrRelationalOperand(oprndType, field.getFieldID());
            }
            int fldId = ConversionUtil.getIntValue(nodeValue);
            if (!(fldId == 0 || this.info.getExceptionWhenFieldNotFound() && 4 != this.info.getLocation())) {
                return new ArithmeticOrRelationalOperand(oprndType, fldId);
            }
        }
        if ((parts[0].equalsIgnoreCase("TR") || parts[0].equalsIgnoreCase("DB")) && this.info.getLocation() != 2) {
            this.reportError(1581, tree);
        } else if (parts[0].equalsIgnoreCase("TR")) {
            oprndType = 50;
        } else if (parts[0].equalsIgnoreCase("DB")) {
            oprndType = 51;
        } else {
            field = this.getField(parts[0], tree);
            if (field == null) {
                Field statusHistoryField = this.getField(String.valueOf(15), tree);
                if (statusHistoryField != null && parts[0].equalsIgnoreCase(statusHistoryField.getName()) || ConversionUtil.getIntValue(parts[0]) == 15) {
                    oprndType = 4;
                    field = statusHistoryField;
                } else {
                    String tempStr = parts[0].equalsIgnoreCase("Status-History") ? "Status History" : parts[0];
                    statusHistoryField = this.getField(tempStr, tree);
                    if (statusHistoryField != null) {
                        oprndType = 4;
                        field = statusHistoryField;
                    } else {
                        field = this.getField(nodeValue, tree);
                        if (field != null) {
                            if (field.getDataType() == 12) {
                                oprndType = oprndType == 99 ? 56 : 6;
                                return new ArithmeticOrRelationalOperand(oprndType, new CurrencyPartInfo(field.getFieldID(), 0, ""));
                            }
                            return new ArithmeticOrRelationalOperand(oprndType, field.getFieldID());
                        }
                    }
                }
            }
        }
        if (oprndType == -1 || parts.length <= 1 && (oprndType == 50 || oprndType == 51)) {
            this.reportError(1587, tree);
        }
        int currIndx = 0;
        if (field == null && (oprndType == 50 || oprndType == 51)) {
            currIndx = 1;
            String[] nodes = nodeValue.split("\\.", 2);
            field = this.getField(parts[currIndx], tree);
            if (field == null) {
                field = this.getField(nodes[currIndx], tree);
            }
        }
        if (field == null) {
            StringBuilder tempFldName = null;
            tempFldName = new StringBuilder(parts[currIndx]);
            ++currIndx;
            while (currIndx < parts.length) {
                tempFldName.append(".").append(parts[currIndx]);
                field = this.getField(tempFldName.toString(), tree);
                if (field != null) break;
                ++currIndx;
            }
        }
        if (field == null) {
            this.reportError(1587, tree);
        }
        ++currIndx;
        if (field.getFieldID() == 15) {
            String[] strValueParts = new String[parts.length - currIndx];
            System.arraycopy(parts, currIndx, strValueParts, 0, strValueParts.length);
            Field statusField = this.getField(String.valueOf(7), tree);
            StatusHistoryValueIndicator statHistValIndicator = this.loadStatusHistoryValueIndicator(strValueParts, statusField, tree);
            return new ArithmeticOrRelationalOperand(statHistValIndicator);
        }
        if (field.getDataType() == 12) {
            if (parts.length > currIndx + 2) {
                this.reportError(1587, tree);
            }
            CurrencyPartInfo currencyPartInfo = null;
            if (parts.length == currIndx) {
                currencyPartInfo = new CurrencyPartInfo(field.getFieldID(), 0, "");
            } else if (parts.length == currIndx + 1) {
                currencyPartInfo = this.loadCurrencyField(parts[currIndx], field, tree);
            } else if (parts.length == currIndx + 2) {
                if ((currencyPartInfo = this.loadCurrencyField(parts[currIndx++], field, tree)).getPartTag() == 4 && parts[currIndx].length() == 3) {
                    currencyPartInfo = new CurrencyPartInfo(field.getFieldID(), 4, parts[currIndx]);
                } else {
                    this.reportError(1588, tree);
                }
            }
            oprndType = oprndType == 1 ? 6 : (oprndType == 50 ? 54 : (oprndType == 51 ? 55 : 56));
            return new ArithmeticOrRelationalOperand(oprndType, currencyPartInfo);
        }
        return new ArithmeticOrRelationalOperand(oprndType, field.getFieldID());
    }

    public void loadCharWithValue(ArithmeticOrRelationalOperand leftOperand, ArithmeticOrRelationalOperand rightOperand, int operation, boolean isTopNode) throws ARException {
        if (rightOperand == null) {
            return;
        }
        if (rightOperand.getType().toInt() == 3) {
            ArithmeticOperationInfo arithOpnInfo = (ArithmeticOperationInfo)rightOperand.getValue();
            this.loadCharWithValue(arithOpnInfo.getRightOperand(), arithOpnInfo.getLeftOperand(), arithOpnInfo.getOperation(), false);
            this.loadCharWithValue(arithOpnInfo.getLeftOperand(), arithOpnInfo.getRightOperand(), arithOpnInfo.getOperation(), false);
            this.loadCharWithValue(leftOperand, arithOpnInfo.getLeftOperand(), arithOpnInfo.getOperation(), false);
            this.loadCharWithValue(leftOperand, arithOpnInfo.getRightOperand(), arithOpnInfo.getOperation(), false);
        } else if (rightOperand.getType().toInt() == 2) {
            int rightOprndDataType = ((Value)rightOperand.getValue()).getDataType().toInt();
            if (rightOprndDataType != 4 && rightOprndDataType != 2) {
                return;
            }
            if (leftOperand == null) {
                return;
            }
            int leftOprndType = leftOperand.getType().toInt();
            block0 : switch (leftOprndType) {
                case 1: 
                case 50: 
                case 51: 
                case 99: {
                    Field field = null;
                    field = leftOprndType == 99 && this.info.getLocation() != 2 ? this.info.getRemoteField(leftOperand.getValue().toString()) : this.info.getLocalField(leftOperand.getValue().toString());
                    if (field == null) break;
                    switch (field.getDataType()) {
                        case 4: {
                            if (rightOprndDataType != 4) break block0;
                            String op = rightOperand.getValue().toString();
                            op = op.replaceAll("\r\n", "\n");
                            rightOperand.setValue(new Value(op));
                            break block0;
                        }
                        case 6: 
                        case 34: {
                            if (!isTopNode) break block0;
                            this.convertCharToEnum(rightOperand, field, operation == 1 || rightOprndDataType == 4);
                            break block0;
                        }
                        case 7: {
                            if (rightOprndDataType != 4) break block0;
                            Keyword keyWord = Keyword.toKeyword((String)((Value)rightOperand.getValue()).getValue());
                            if (keyWord != null) {
                                rightOperand.setValue(new Value(keyWord));
                                break block0;
                            }
                            this.convertCharToTime(rightOperand, this.info.getLocale());
                            break block0;
                        }
                        case 13: {
                            if (rightOprndDataType != 4) break block0;
                            Keyword keyWord = Keyword.toKeyword((String)((Value)rightOperand.getValue()).getValue());
                            if (keyWord != null) {
                                rightOperand.setValue(new Value(keyWord));
                                break block0;
                            }
                            this.convertCharToDate(rightOperand, this.info.getLocale());
                            break block0;
                        }
                        case 14: {
                            if (rightOprndDataType != 4) break block0;
                            Keyword keyWord = Keyword.toKeyword((String)((Value)rightOperand.getValue()).getValue());
                            if (keyWord != null) {
                                rightOperand.setValue(new Value(keyWord));
                                break block0;
                            }
                            this.convertCharToTimeOfDay(rightOperand, this.info.getLocale());
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    Value value = (Value)leftOperand.getValue();
                    if (value.getDataType().toInt() != 1 || rightOprndDataType != 4 || !isTopNode) break;
                    Keyword keyword = (Keyword)value.getValue();
                    switch (keyword.toInt()) {
                        case 2: {
                            this.convertCharToDate(rightOperand, this.info.getLocale());
                            break block0;
                        }
                        case 3: {
                            this.convertCharToTimeOfDay(rightOperand, this.info.getLocale());
                            break block0;
                        }
                        case 4: {
                            this.convertCharToTime(rightOperand, this.info.getLocale());
                            break block0;
                        }
                    }
                    break;
                }
                case 6: 
                case 54: 
                case 55: 
                case 56: {
                    if (!(leftOperand.getValue() instanceof CurrencyPartInfo) || rightOprndDataType == 2 || !isTopNode) break;
                    switch (((CurrencyPartInfo)leftOperand.getValue()).getPartTag()) {
                        default: {
                            String textValue = rightOperand.getValue().toString();
                            if (textValue == null || "".equals(textValue)) {
                                rightOperand.setValue(new Value());
                                return;
                            }
                            NumberFormat numberFormat = NumberFormat.getInstance(this.info.getLocale());
                            ParsePosition parsePosition = null;
                            Number number = null;
                            numberFormat.setParseIntegerOnly(true);
                            parsePosition = new ParsePosition(0);
                            number = numberFormat.parse(textValue, parsePosition);
                            if (parsePosition.getIndex() == textValue.length()) {
                                rightOperand.setValue(new Value(Integer.parseInt(textValue)));
                                return;
                            }
                            parsePosition = new ParsePosition(0);
                            numberFormat.setParseIntegerOnly(false);
                            number = numberFormat.parse(textValue, parsePosition);
                            if (parsePosition.getIndex() == textValue.length()) {
                                rightOperand.setValue(new Value(new BigDecimal(number.toString())));
                                return;
                            }
                            if (((CurrencyPartInfo)leftOperand.getValue()).getPartTag() == 4 || ((CurrencyPartInfo)leftOperand.getValue()).getPartTag() == 1) {
                                rightOperand.setValue(new Value(textValue));
                                break block0;
                            }
                            CurrencyValue currencyValue = new CurrencyValue(textValue, this.info.getLocale());
                            if (currencyValue.getCurrencyCode() != null && currencyValue.getCurrencyCode().length() <= 3) {
                                rightOperand.setValue(new Value(currencyValue));
                                break block0;
                            }
                            rightOperand.setValue(new Value(textValue));
                            break block0;
                        }
                        case 3: {
                            this.convertCharToTime(rightOperand, this.info.getLocale());
                            break block0;
                        }
                        case 2: 
                    }
                    rightOperand.setValue(new Value(rightOperand.getValue().toString()));
                    break;
                }
                case 4: {
                    StatusHistoryValueIndicator statusHisVal = (StatusHistoryValueIndicator)leftOperand.getValue();
                    if (!statusHisVal.isTime() || rightOprndDataType != 4) break;
                    this.convertCharToTime(rightOperand, this.info.getLocale());
                    break;
                }
                case 13: {
                    if (rightOprndDataType != 4) break;
                    this.convertCharToDate(rightOperand, this.info.getLocale());
                    break;
                }
                case 7: {
                    if (rightOprndDataType != 4) break;
                    this.convertCharToTimeOfDay(rightOperand, this.info.getLocale());
                    break;
                }
                case 14: {
                    if (rightOprndDataType != 4) break;
                    this.convertCharToTime(rightOperand, this.info.getLocale());
                }
            }
        }
    }

    private QualifierInfo loadFromFieldInfo(CommonTree tree) throws ARException {
        Field field;
        String nodeValue = tree.getText();
        if (nodeValue == null || nodeValue.length() == 0) {
            this.reportError(1581, tree);
        }
        switch (tree.getType()) {
            case 24: {
                if (this.info.getLocation() != 1 && this.info.getLocation() != 2 && this.info.getLocation() != 4) {
                    this.reportError(1581, tree);
                }
                if (!nodeValue.startsWith("'") || !nodeValue.endsWith("'")) break;
                nodeValue = nodeValue.substring(1, nodeValue.length() - 1);
                nodeValue.replaceAll("''", "'");
                break;
            }
            case 26: {
                if (!nodeValue.startsWith("$") || !nodeValue.endsWith("$")) break;
                nodeValue = nodeValue.substring(1, nodeValue.length() - 1);
                nodeValue.replaceAll("\\$\\$", "\\$");
                break;
            }
            default: {
                this.reportError(1581, tree);
            }
        }
        if ((field = this.info.getLocalField(nodeValue)) == null) {
            field = this.info.getRemoteField(nodeValue);
        }
        if (field != null) {
            return new QualifierInfo(new QualifierFromFieldInfo(field.getFieldID()));
        }
        int oprndType = -1;
        String[] parts = nodeValue.split("\\.");
        if ((parts[0].equalsIgnoreCase("TR") || parts[0].equalsIgnoreCase("DB")) && this.info.getLocation() != 2) {
            this.reportError(1581, tree);
        } else if (parts[0].equalsIgnoreCase("TR")) {
            oprndType = 50;
        } else if (parts[0].equalsIgnoreCase("DB")) {
            oprndType = 51;
        }
        if (this.info.getLocation() != 4 && (oprndType == -1 || parts.length <= 1 && (oprndType == 50 || oprndType == 51))) {
            this.reportError(1587, tree);
        }
        int currIndx = 0;
        if (field == null && (oprndType == 50 || oprndType == 51)) {
            currIndx = 1;
            String[] nodes = nodeValue.split("\\.", 2);
            field = this.getField(nodes[currIndx], tree);
            if (field == null) {
                field = this.getField(parts[currIndx], tree);
            }
        }
        int fieldId = -1;
        if (field == null) {
            if (this.info.getLocation() == 4) {
                try {
                    fieldId = Integer.parseInt(nodeValue);
                }
                catch (NumberFormatException e) {
                    this.reportError(1587, tree);
                }
            }
        } else {
            fieldId = field.getFieldID();
        }
        return new QualifierInfo(new QualifierFromFieldInfo(fieldId, oprndType));
    }

    private Field getField(String name, CommonTree tree) {
        Field field = null;
        if (tree.getType() == 26) {
            field = this.info.getRemoteField(name);
        } else if (tree.getType() == 24) {
            field = this.info.getLocalField(name);
        }
        return field;
    }
}

