/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual.antlr.ast;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentField;
import com.bmc.arsys.api.CharacterField;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.CurrencyField;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateOnlyField;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.DecimalField;
import com.bmc.arsys.api.DiaryField;
import com.bmc.arsys.api.DisplayField;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.IntegerField;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TimeOnlyField;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ViewField;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.qual.AssignParseFormatInfo;
import com.bmc.arsys.qual.antlr.ast.ARASTTreeWalker;
import com.bmc.thirdparty.org.antlr.runtime.tree.CommonTree;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ASTAssignTreeWalker
extends ARASTTreeWalker {
    private static final Logger logger = Logger.getLogger(ASTAssignTreeWalker.class);
    private AssignParseFormatInfo asgnInfo;

    public ASTAssignTreeWalker(AssignParseFormatInfo in) {
        super(in);
        this.asgnInfo = in;
    }

    public ASTAssignTreeWalker(CommonTree root, AssignParseFormatInfo in) {
        super(root, in);
        this.asgnInfo = in;
    }

    private QualifierInfo getQualifierInfo() throws ARException {
        return this.asgnInfo.getQualifierInfo();
    }

    /*
     * Unable to fully structure code
     */
    public AssignInfo createAssignInfo(CommonTree tree) throws ARException {
        block22: {
            block21: {
                ASTAssignTreeWalker.logger.debug("> Started walking through AST");
                if (this.asgnInfo == null) {
                    throw new ARException(2, 0, "Not enough information to parse the assignment string");
                }
                asgn = new AssignInfo();
                if (tree != null) break block21;
                ASTAssignTreeWalker.logger.info("Assignment String length is zero returning null.");
                break block22;
            }
            switch (tree.getType()) {
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    asgn.setAssignType(4);
                    if (this.asgnInfo.isTopLevelNode()) {
                        this.asgnInfo.setTopLevelNode(false);
                    }
                    asgn.setArithOp(this.createArithOpAssignInfo(tree));
                    break;
                }
                case 6: {
                    asgn.setAssignType(5);
                    asgn.setFunction(this.createFunctionAssignInfo(tree));
                    break;
                }
                case 19: {
                    asgn.setAssignType(3);
                    asgn.setProcess(tree.getText());
                    break;
                }
                case 12: {
                    try {
                        asgn.setAssignType(2);
                        asgn.setField(this.createFieldAssignInfo(tree));
                        break;
                    }
                    catch (ARException e) {
                        throw new ARException(2, 0, e.getMessage() + ". \n" + "At position " + tree.getLine() + " : " + tree.getCharPositionInLine());
                    }
                }
                case 14: {
                    keyword = null;
                    if (this.isNullKeyword(tree.getText())) {
                        asgn.setAssignType(1);
                        asgn.setValue(new Value());
                        break;
                    }
                    keyword = Keyword.toKeyword(tree.getText());
                    if (keyword != null) {
                        asgn.setAssignType(1);
                        asgn.setValue(new Value(keyword));
                        break;
                    }
                    if (this.asgnInfo.getAssignMode() == 8) {
                        asgn.setAssignType(8);
                        asgn.setFilterApi(this.createAssignFilterAPIInfo(tree));
                        break;
                    }
                    if (this.asgnInfo.getAssignMode() == 7) {
                        asgn.setAssignType(7);
                        asgn.setSql(this.createAssignSQLInfo(tree));
                        break;
                    }
                    asgnFldInfo = this.createFieldAssignInfo(tree);
                    asgnFldInfo.setServer(this.asgnInfo.getAssignServer());
                    asgnFldInfo.setForm(this.asgnInfo.getAssignSchema());
                    asgnFldInfo.setNoMatchOption(1);
                    asgnFldInfo.setMultiMatchOption(4);
                    asgnFldInfo.setQualifier(this.getQualifierInfo());
                    asgn.setAssignType(2);
                    asgn.setField(asgnFldInfo);
                    break;
                }
                case 13: 
                case 15: 
                case 16: {
                    asgn.setAssignType(1);
                    value = null;
                    fieldType = this.asgnInfo.getAssignField().getDataType();
                    text = tree.getText();
                    if (13 == tree.getType()) {
                        text = tree.getText().replaceAll("\"\"", "\"");
                    }
                    if (!this.info.isTopLevelNode() || fieldType != 14 && fieldType != 13 && fieldType != 7 && fieldType != 6) ** GOTO lbl72
                    value = tree.getType() == 15 ? new Value(text, DataType.INTEGER) : new Value(text, DataType.CHAR);
                    operand = new ArithmeticOrRelationalOperand(value);
                    this.loadCharWithValue(operand, this.asgnInfo.getLocale());
                    value = (Value)operand.getValue();
                    ** GOTO lbl84
lbl72:
                    // 1 sources

                    if (tree.getType() != 15) ** GOTO lbl83
                    try {
                        value = new Value(Integer.parseInt(text));
                    }
                    catch (NumberFormatException e) {
                        try {
                            value = new Value(Long.parseLong(text));
                            ** GOTO lbl84
                        }
                        catch (NumberFormatException nfe) {
                            value = new Value(new BigDecimal(text));
                        }
                    }
                    ** GOTO lbl84
lbl83:
                    // 1 sources

                    value = tree.getType() == 16 ? new Value(text, DataType.DECIMAL) : new Value(text, DataType.CHAR);
lbl84:
                    // 5 sources

                    asgn.setValue(value);
                    if (!this.asgnInfo.isTopLevelNode()) break;
                    this.asgnInfo.setTopLevelNode(false);
                    break;
                }
            }
        }
        ASTAssignTreeWalker.logger.debug("< Finished walking through AST");
        return asgn;
    }

    private ArithOpAssignInfo createArithOpAssignInfo(CommonTree tree) throws ARException {
        ArithOpAssignInfo arithOp = null;
        Field field = this.asgnInfo.getAssignField();
        if (field == null) {
            throw new ARException(2, 0, "Not enough information to parse the assignment string");
        }
        int arithType = this.getArithOpType(tree.getType());
        if (arithType == -1) {
            throw new ARException(2, 0, "Invlid arithop type");
        }
        arithOp = new ArithOpAssignInfo();
        arithOp.setOperation(arithType);
        AssignInfo leftOp = null;
        AssignInfo rightOp = null;
        if (arithType == 6) {
            leftOp = new AssignInfo();
            leftOp.setAssignType(0);
            rightOp = this.createAssignInfo((CommonTree)tree.getChild(0));
        } else {
            leftOp = this.createAssignInfo((CommonTree)tree.getChild(0));
            rightOp = this.createAssignInfo((CommonTree)tree.getChild(1));
        }
        arithOp.setOperandLeft(leftOp);
        arithOp.setOperandRight(rightOp);
        if (rightOp != null && leftOp != null && arithOp.getOperation() != 1 && leftOp.getAssignType() == 1 && leftOp.getValue().getDataType() == DataType.CHAR && rightOp.getAssignType() == 1 && rightOp.getValue().getDataType() == DataType.CHAR) {
            throw new ARException(2, 1581, "at position " + tree.getCharPositionInLine() + " ('" + tree.getText() + "') .");
        }
        return arithOp;
    }

    private int getArithOpType(int grammarType) {
        int type = -1;
        switch (grammarType) {
            case 7: {
                type = 1;
                break;
            }
            case 8: {
                type = 2;
                break;
            }
            case 9: {
                type = 3;
                break;
            }
            case 10: {
                type = 4;
                break;
            }
            case 11: {
                type = 5;
                break;
            }
            case 4: {
                type = 6;
                break;
            }
        }
        return type;
    }

    private AssignFieldInfo createFieldAssignInfo(CommonTree tree) throws ARException {
        String[] parts;
        AssignFieldInfo assignFieldInfo = new AssignFieldInfo();
        int oprndType = 1;
        Field field = null;
        String text = tree.getText();
        if (tree.getType() == 14) {
            oprndType = 99;
            if ((text = text.replaceAll("\\$\\$", "\\$")).startsWith("$") && text.endsWith("$") && text.length() > 1) {
                text = text.substring(1, text.length() - 1);
            }
        } else {
            oprndType = 1;
            text = text.replaceAll("''", "'");
        }
        if ((field = this.getField(text, tree.getType())) != null) {
            if (field.getDataType() == 12) {
                oprndType = 6;
                assignFieldInfo.setCurrencyPart(new CurrencyPartInfo(field.getFieldID(), 0, "    "));
                assignFieldInfo.setTag(oprndType);
                return assignFieldInfo;
            }
            oprndType = 1;
            assignFieldInfo.setFieldId(field.getFieldID());
            assignFieldInfo.setTag(oprndType);
            return assignFieldInfo;
        }
        if (text.indexOf(".") == -1 && field == null) {
            this.reportError(1587, tree);
        }
        if ((field = this.getField((parts = text.split("\\."))[0], tree.getType())) == null) {
            Field statusHistoryField = this.getField(String.valueOf(15), tree.getType());
            if (statusHistoryField != null && parts[0].equalsIgnoreCase(statusHistoryField.getName()) || ConversionUtil.getIntValue(parts[0]) == 15) {
                oprndType = 4;
                field = statusHistoryField;
            } else {
                String tempStr = parts[0].equalsIgnoreCase("Status-History") ? "Status History" : parts[0];
                statusHistoryField = this.getField(tempStr, tree.getType());
                if (statusHistoryField != null) {
                    oprndType = 4;
                    field = statusHistoryField;
                } else {
                    int tmpId;
                    field = this.getField(text, tree.getType());
                    if (field == null && (tmpId = ConversionUtil.getIntValue(text)) != 0) {
                        assignFieldInfo.setFieldId(tmpId);
                        assignFieldInfo.setTag(oprndType);
                        return assignFieldInfo;
                    }
                }
            }
        }
        if (field.getFieldID() == 15) {
            String[] strValueParts = new String[parts.length - 1];
            System.arraycopy(parts, 1, strValueParts, 0, strValueParts.length);
            Field statusField = this.getField(String.valueOf(7), tree.getType());
            StatusHistoryValueIndicator statHistValIndicator = this.loadStatusHistoryValueIndicator(strValueParts, statusField, tree);
            oprndType = 4;
            assignFieldInfo.setStatHistory(statHistValIndicator);
            assignFieldInfo.setTag(oprndType);
            return assignFieldInfo;
        }
        if (field.getDataType() == 12) {
            CurrencyPartInfo currencyPartInfo = null;
            switch (parts.length) {
                case 1: {
                    currencyPartInfo = new CurrencyPartInfo(field.getFieldID(), 0, "    ");
                    break;
                }
                case 2: {
                    currencyPartInfo = this.loadCurrencyField(parts[1], field, tree);
                    break;
                }
                default: {
                    this.reportError(314, tree);
                }
            }
            if (currencyPartInfo != null) {
                oprndType = oprndType == 1 ? 56 : (oprndType == 50 ? 54 : (oprndType == 51 ? 55 : 6));
            }
            assignFieldInfo.setCurrencyPart(currencyPartInfo);
            assignFieldInfo.setTag(oprndType);
            return assignFieldInfo;
        }
        oprndType = 1;
        assignFieldInfo.setFieldId(field.getFieldID());
        assignFieldInfo.setTag(oprndType);
        return assignFieldInfo;
    }

    private FunctionAssignInfo createFunctionAssignInfo(CommonTree tree) throws ARException {
        Field origField = this.asgnInfo.getAssignField();
        int code = FunctionAssignInfo.toFuncCode(tree.getChild(0).getText());
        if ((code == 47 || code == 48) && this.info.getLocation() != 2 && this.info.getLocation() != 3) {
            throw new ARException(2, 230);
        }
        FunctionAssignInfo funcAsgnInfo = new FunctionAssignInfo();
        funcAsgnInfo.setFunctionCode(code);
        ArrayList<AssignInfo> parameterList = new ArrayList<AssignInfo>();
        if (tree.getChildCount() - 1 > 3 && code != 25 && code != 26 && code != 50) {
            throw new ARException(2, 2299);
        }
        for (int i = 1; i < tree.getChildCount(); ++i) {
            int paramType = 4;
            int paramIndx = i - 1;
            Field tempField = null;
            paramType = paramIndx > 2 ? (code == 50 ? 4 : origField.getDataType()) : FunctionAssignInfo.getParamType(code, paramIndx);
            switch (paramType) {
                case 2: {
                    tempField = new IntegerField();
                    break;
                }
                case 3: {
                    tempField = new RealField();
                    break;
                }
                case 5: {
                    tempField = new DiaryField();
                    break;
                }
                case 6: {
                    tempField = new SelectionField();
                    break;
                }
                case 7: {
                    tempField = new DateTimeField();
                    break;
                }
                case 10: {
                    tempField = new DecimalField();
                    break;
                }
                case 11: {
                    tempField = new AttachmentField();
                    break;
                }
                case 12: {
                    tempField = new CurrencyField();
                    break;
                }
                case 13: {
                    tempField = new DateOnlyField();
                    break;
                }
                case 14: {
                    tempField = new TimeOnlyField();
                    break;
                }
                case 33: {
                    tempField = new TableField();
                    break;
                }
                case 34: {
                    tempField = new ColumnField();
                    break;
                }
                case 42: {
                    tempField = new ViewField();
                    break;
                }
                case 43: {
                    tempField = new DisplayField();
                    break;
                }
                default: {
                    tempField = new CharacterField();
                }
            }
            this.asgnInfo.setAssignField(tempField);
            AssignInfo funcAssign = this.createAssignInfo((CommonTree)tree.getChild(i));
            parameterList.add(paramIndx, funcAssign);
            this.asgnInfo.setAssignField(origField);
        }
        funcAsgnInfo.setParameterList(parameterList);
        return funcAsgnInfo;
    }

    private AssignFilterApiInfo createAssignFilterAPIInfo(CommonTree tree) throws ARException {
        String nodeVal = tree.getText();
        long index = -1L;
        nodeVal = nodeVal.substring(1, nodeVal.length() - 1);
        try {
            index = Long.parseLong(nodeVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        AssignFilterApiInfo filterApiInfo = new AssignFilterApiInfo();
        filterApiInfo.setValueIndex(index);
        return filterApiInfo;
    }

    private AssignSQLInfo createAssignSQLInfo(CommonTree tree) {
        String text = tree.getText();
        if (text.startsWith("$") && text.endsWith("$")) {
            text = text.substring(1, text.length() - 1);
        }
        return new AssignSQLInfo("", "", Integer.parseInt(text), 0, 0);
    }

    public void loadCharWithValue(ArithmeticOrRelationalOperand rightOperand, Locale loc) throws ARException {
        switch (this.asgnInfo.getAssignField().getDataType()) {
            case 13: {
                this.convertCharToDate(rightOperand, loc);
                break;
            }
            case 14: {
                this.convertCharToTimeOfDay(rightOperand, loc);
                break;
            }
            case 7: {
                this.convertCharToTime(rightOperand, loc);
                break;
            }
            case 6: {
                this.convertCharToEnum(rightOperand, this.asgnInfo.getAssignField(), true);
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                Value value;
                if (rightOperand.getType().toInt() != 2 || rightOperand.getValue() == null || (value = (Value)rightOperand.getValue()).getDataType().toInt() != 4) break;
                throw new ARException(2, 310);
            }
        }
    }

    private Field getField(String name, int type) {
        Field field = null;
        if (type == 14) {
            field = this.info.getLocalField(name);
        } else if (type == 12) {
            field = this.info.getRemoteField(name);
        }
        return field;
    }
}

