/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual.antlr.ast;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.utils.LocaleUtil;
import com.bmc.thirdparty.org.antlr.runtime.tree.CommonTree;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class ARASTTreeWalker {
    private static final Logger logger = Logger.getLogger(ARASTTreeWalker.class);
    protected ARParseFormatInfo info = null;
    protected CommonTree root = null;

    public ARASTTreeWalker(ARParseFormatInfo in) {
        this.info = in;
    }

    public ARASTTreeWalker(CommonTree root, ARParseFormatInfo in) {
        this.info = in;
        this.root = root;
    }

    protected void reportError(int errorCode, CommonTree tree) throws ARException {
        ARException exception = new ARException(2, errorCode, " at position " + tree.getCharPositionInLine() + " ( '" + tree.getText() + "' )", this.info.getLocale());
        logger.error(exception);
        throw exception;
    }

    protected boolean isNullKeyword(String keywordStr) {
        return keywordStr.equals("--1") || keywordStr.equals("\\--1") || keywordStr.equals("$--1$") || keywordStr.equals("$\\--1$") || keywordStr.equalsIgnoreCase("NULL") || keywordStr.equalsIgnoreCase("$NULL$") || keywordStr.equalsIgnoreCase("$\\NULL$");
    }

    protected CurrencyPartInfo loadCurrencyField(String part, Field field, CommonTree tree) throws ARException {
        if (part == null) {
            return null;
        }
        CurrencyPartInfo currencyPartInfo = null;
        int intPartTag = -1;
        if (part.equalsIgnoreCase("VALUE") || ConversionUtil.getIntValue(part) == 1) {
            intPartTag = 1;
        } else if (part.equalsIgnoreCase("TYPE") || ConversionUtil.getIntValue(part) == 2) {
            intPartTag = 2;
        } else if (part.equalsIgnoreCase("DATE") || ConversionUtil.getIntValue(part) == 3) {
            intPartTag = 3;
        } else if (part.length() == 3) {
            intPartTag = 4;
        } else if (ConversionUtil.getIntValue(part) == 4) {
            intPartTag = 4;
            part = "USD";
        }
        if (intPartTag != -1) {
            currencyPartInfo = new CurrencyPartInfo(field.getFieldID(), intPartTag, intPartTag == 4 ? part : "");
        } else {
            this.reportError(1588, tree);
        }
        return currencyPartInfo;
    }

    protected StatusHistoryValueIndicator loadStatusHistoryValueIndicator(String[] parts, Field field, CommonTree tree) throws ARException {
        String strStatusHistValue;
        if (parts.length <= 1) {
            this.reportError(1584, tree);
        } else if (parts.length > 2) {
            this.reportError(1588, tree);
        }
        StatusHistoryValueIndicator statHistField = null;
        int statusHistValue = -1;
        int statusHistType = -1;
        int partValue = -1;
        partValue = ConversionUtil.getIntValue(parts[0]);
        if (partValue == 0) {
            partValue = parts[0].trim().equalsIgnoreCase("0") ? 0 : -1;
        }
        SelectionFieldLimit selectionFieldLimit = (SelectionFieldLimit)((SelectionField)field).getFieldLimit();
        List<EnumItem> listEnumItem = selectionFieldLimit.getValues();
        for (EnumItem item : listEnumItem) {
            if (!parts[0].equalsIgnoreCase(item.getEnumItemName()) && partValue != item.getEnumItemNumber()) continue;
            statusHistValue = item.getEnumItemNumber();
            break;
        }
        if ((strStatusHistValue = this.info.getEnumValueFromAlias(String.valueOf(field.getFieldID()), parts[0])) != null) {
            statusHistValue = ConversionUtil.getIntValue(strStatusHistValue);
        }
        if (statusHistValue == -1) {
            this.reportError(1588, tree);
        }
        if (parts[1].equalsIgnoreCase("USER") || ConversionUtil.getIntValue(parts[1]) == 1) {
            statusHistType = 1;
        } else if (parts[1].equalsIgnoreCase("TIME") || ConversionUtil.getIntValue(parts[1]) == 2) {
            statusHistType = 2;
        } else {
            this.reportError(1584, tree);
        }
        statHistField = new StatusHistoryValueIndicator(statusHistType == 1, statusHistValue);
        return statHistField;
    }

    protected void convertCharToDate(ArithmeticOrRelationalOperand operand, Locale loc) throws ARException {
        String strValue = operand.getValue().toString().trim();
        Date date = LocaleUtil.parseDateTime(strValue, 1, this.info.getLocale());
        if (date != null) {
            Calendar cal = Calendar.getInstance(loc);
            cal.setTime(date);
            int year = cal.get(1);
            int currentYear = Calendar.getInstance().get(1);
            if (year >= 0 && year < 100 && cal.get(0) != 0) {
                year = currentYear - currentYear % 100 + year;
            }
            year = cal.get(0) == 0 ? -(year - 1) : year;
            DateInfo days = new DateInfo();
            days.setDate(year, cal.get(2) + 1, cal.get(5));
            operand.setValue(new Value(days));
            return;
        }
        throw new ARException(2, 8957, "(" + strValue + ")");
    }

    protected void convertCharToEnum(ArithmeticOrRelationalOperand arithmOrRelOperand, Field field, boolean validate) throws ARException {
        if (arithmOrRelOperand == null && field == null) {
            return;
        }
        int aliasIntValue = -1;
        int fieldType = field.getDataType();
        boolean isIntValue = false;
        String valueStr = arithmOrRelOperand.getValue().toString();
        int oprndDataType = ((Value)arithmOrRelOperand.getValue()).getDataType().toInt();
        if (arithmOrRelOperand.getType().toInt() != 2 && (fieldType != 6 || fieldType != 34)) {
            return;
        }
        try {
            aliasIntValue = Integer.parseInt(valueStr);
            isIntValue = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (fieldType) {
            case 6: {
                int index;
                SelectionFieldLimit selectionFieldLimit = (SelectionFieldLimit)((SelectionField)field).getFieldLimit();
                if (selectionFieldLimit != null && (index = this.info.getEnumIndex(valueStr, selectionFieldLimit.getValues(), oprndDataType)) != -1) {
                    arithmOrRelOperand.setValue(new Value((Object)index, DataType.ENUM));
                    return;
                }
                String aliasName = this.info.getEnumValueFromAlias(String.valueOf(field.getFieldID()), valueStr);
                if (aliasName == null) break;
                arithmOrRelOperand.setValue(new Value((Object)ConversionUtil.getIntValue(aliasName), DataType.ENUM));
                return;
            }
            case 34: {
                Field dataField = this.info.getDataField(field);
                if (dataField == null || dataField.getDataType() != 6) {
                    return;
                }
                SelectionFieldLimit limit = (SelectionFieldLimit)((SelectionField)dataField).getFieldLimit();
                int index = this.info.getEnumIndex(valueStr, limit.getValues());
                if (index == -1) break;
                arithmOrRelOperand.setValue(new Value((Object)index, DataType.ENUM));
                return;
            }
        }
        if (validate) {
            throw new ARException(2, 1588, " (" + valueStr + ").", this.info.getLocale());
        }
        if (isIntValue) {
            arithmOrRelOperand.setValue(new Value((Object)aliasIntValue, DataType.ENUM));
        }
    }

    protected void convertCharToTime(ArithmeticOrRelationalOperand operand, Locale loc) throws ARException {
        String strValue = operand.getValue().toString();
        Date date = null;
        date = LocaleUtil.parseDateTime(strValue, 0, this.info.getLocale(), true, this.info.getTimeZone());
        if (date == null) {
            date = LocaleUtil.parseDateTime(strValue, 1, this.info.getLocale());
        }
        if (date == null) {
            Date time = LocaleUtil.parseDateTime(strValue, 2, this.info.getLocale());
            if (time != null) {
                Calendar nowCal = Calendar.getInstance(loc);
                nowCal.setTime(new Date());
                Calendar timeCal = Calendar.getInstance(loc);
                timeCal.setTime(time);
                nowCal.set(10, timeCal.get(10));
                nowCal.set(12, timeCal.get(12));
                nowCal.set(13, timeCal.get(13));
                nowCal.set(9, timeCal.get(9));
                date = new Date(nowCal.getTimeInMillis());
            } else {
                throw new ARException(2, 8957, "(" + strValue + ")");
            }
        }
        Calendar cal = Calendar.getInstance(loc);
        cal.setTime(date);
        Value value = new Value(new Timestamp(date));
        operand.setValue(value);
    }

    protected void convertCharToTimeOfDay(ArithmeticOrRelationalOperand operand, Locale loc) throws ARException {
        String strValue = operand.getValue().toString();
        if (strValue == null || strValue.equals("")) {
            operand.setValue(new Value());
            return;
        }
        Date date = null;
        date = LocaleUtil.parseDateTime(strValue, 2, this.info.getLocale());
        if (date == null) {
            throw new ARException(2, 8957, "(" + strValue + ")");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        long lTime = calendar.get(11) * 60 * 60;
        lTime += (long)(calendar.get(12) * 60);
        operand.setValue(new Value(new Time(lTime += (long)calendar.get(13))));
    }
}

