/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.qual.ARQualAssignDecoderBase;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class ARQualifierDecoder
extends ARQualAssignDecoderBase {
    private static final Logger log = Logger.getLogger(ARQualifierDecoder.class);
    static final String AR_CURRENT_SERVER_TAG = "@";
    static final int QUAL_TYPE_MARKER = 100;

    public ARQualifierDecoder(ARServerUser context, String encodedString) throws ARException {
        super(context, encodedString);
    }

    public QualifierInfo decodeQualifierInfo() throws ARException {
        log.debug("> decodeQualifierInfo for encoded string " + this._encStr);
        QualifierInfo qualInfo = null;
        if (this.scanner == null) {
            return null;
        }
        int operator = this.readInt();
        switch (operator) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                qualInfo = new QualifierInfo();
                qualInfo.setOperation(operator);
                qualInfo.setLeftOperand(this.decodeQualifierInfo());
                qualInfo.setRightOperand(this.decodeQualifierInfo());
                break;
            }
            case 3: {
                qualInfo = new QualifierInfo();
                qualInfo.setLeftOperand(this.decodeQualifierInfo());
                qualInfo.setOperation(3);
                break;
            }
            case 4: {
                qualInfo = new QualifierInfo(this.decodeRelationalOperationInfo());
                qualInfo.setOperation(4);
                break;
            }
            case 5: {
                qualInfo = new QualifierInfo(new QualifierFromFieldInfo(this.readInt()));
                break;
            }
            default: {
                this.throwError();
            }
        }
        log.debug("< decodeQualifierInfo");
        return qualInfo;
    }

    private RelationalOperationInfo decodeRelationalOperationInfo() throws ARException {
        RelationalOperationInfo relOpInfo = null;
        int relOperation = this.readInt();
        if (relOperation < 1 || relOperation > 8) {
            this.throwError();
        }
        relOpInfo = new RelationalOperationInfo(relOperation, this.decodeArithmeticOrRelationalOperand(), this.decodeArithmeticOrRelationalOperand());
        return relOpInfo;
    }

    private ArithmeticOrRelationalOperand decodeArithmeticOrRelationalOperand() throws ARException {
        ArithmeticOrRelationalOperand arithOrRelOperand = null;
        int operand = this.readInt();
        if (operand >= 1 && operand <= 6 || operand >= 50 && operand <= 56 || operand == 99 || operand < 13 || operand > 26) {
            // empty if block
        }
        OperandType ot = null;
        switch (operand) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                ot = OperandType.getOperandType(operand);
                arithOrRelOperand = new ArithmeticOrRelationalOperand(ot, this.readInt());
                break;
            }
            case 2: {
                ot = OperandType.getOperandType(2);
                arithOrRelOperand = new ArithmeticOrRelationalOperand(this.loadValue());
                break;
            }
            case 3: {
                ArithmeticOrRelationalOperand aroLeft = null;
                ArithmeticOrRelationalOperand aroRight = null;
                int arOperation = this.readInt();
                if (6 != arOperation) {
                    aroLeft = this.decodeArithmeticOrRelationalOperand();
                }
                aroRight = this.decodeArithmeticOrRelationalOperand();
                ArithmeticOperationInfo aoi = new ArithmeticOperationInfo(arOperation, aroLeft, aroRight);
                arithOrRelOperand = new ArithmeticOrRelationalOperand(aoi);
                break;
            }
            case 4: {
                int enumValue = this.readInt();
                boolean bType = this.readInt() == 1;
                StatusHistoryValueIndicator statusHist = new StatusHistoryValueIndicator(bType, enumValue);
                arithOrRelOperand = new ArithmeticOrRelationalOperand(statusHist);
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                int currFId = this.readInt();
                int pTag = this.readInt();
                CurrencyPartInfo cpi = new CurrencyPartInfo(currFId, pTag, pTag == 4 ? this.readString() : "");
                arithOrRelOperand = new ArithmeticOrRelationalOperand(operand, cpi);
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                break;
            }
        }
        return arithOrRelOperand;
    }

    private CurrencyValue decodeCurrencyValue() throws ARException {
        CurrencyValue cv = null;
        this.readInt();
        int valueLength = this.readInt();
        this.scanner.useDelimiter("\\Z");
        String tempStr = this.readLine();
        String currVal = tempStr.substring(1, valueLength + 1);
        if (tempStr != null) {
            this.scanner = new Scanner(tempStr.substring(valueLength + 1)).useDelimiter("\\\\");
        }
        int currCodeLength = this.readInt();
        this.scanner.useDelimiter("\\Z");
        tempStr = this.readLine();
        String currCode = tempStr.substring(1, currCodeLength + 1);
        if (tempStr != null) {
            this.scanner = new Scanner(tempStr.substring(currCodeLength + 1)).useDelimiter("\\\\");
        }
        int timestamp = this.readInt();
        int numFuncItems = this.readInt();
        cv = new CurrencyValue();
        cv.setValue(new BigDecimal(currVal));
        cv.setCurrencyCode(currCode);
        cv.setConversionDate(timestamp);
        if (numFuncItems == 0 && this.scanner.hasNext()) {
            this.scanner.next();
        } else {
            ArrayList<FuncCurrencyInfo> listFuncInfo = new ArrayList<FuncCurrencyInfo>(numFuncItems);
            for (int i = 0; i < numFuncItems; ++i) {
                listFuncInfo.add(new FuncCurrencyInfo(this.resetScannerTo(this.readInt()), this.resetScannerTo(this.readInt())));
            }
            cv.setFuncCurrencyList(listFuncInfo);
        }
        return cv;
    }

    protected Value loadValue() throws ARException {
        Value value = null;
        int type = this.readInt();
        switch (type) {
            case 0: {
                value = new Value();
                break;
            }
            case 1: {
                value = new Value(Keyword.toKeyword(this.readInt()));
                break;
            }
            case 2: {
                value = new Value(this.readInt());
                break;
            }
            case 3: {
                value = new Value(this.readDouble());
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 42: 
            case 43: {
                int charValueLength = this.readInt();
                this.scanner.useDelimiter("\\Z");
                String tempStr = this.readString();
                try {
                    byte[] tempByteArr = tempStr.getBytes(this.getServerCharSet());
                    charValueLength = tempByteArr.length - 2 < charValueLength ? tempByteArr.length : charValueLength;
                    byte[] bytesValue = new byte[charValueLength];
                    System.arraycopy(tempByteArr, 1, bytesValue, 0, charValueLength);
                    String strValue = new String(bytesValue, this.getServerCharSet());
                    if (type == 5) {
                        try {
                            value = new Value(DiaryListValue.decode(strValue));
                        }
                        catch (ARException ex) {
                            value = new Value((Object)strValue, DataType.DIARY);
                        }
                    } else {
                        value = new Value(strValue, DataType.toDataType(type));
                    }
                    if (tempStr == null) break;
                    byte[] bytesLine = new byte[tempByteArr.length - (bytesValue.length + 1)];
                    System.arraycopy(tempByteArr, bytesValue.length + 1, bytesLine, 0, bytesLine.length);
                    this.scanner = new Scanner(new String(bytesLine, this.getServerCharSet())).useDelimiter("\\\\");
                }
                catch (UnsupportedEncodingException e) {
                    this.throwError();
                }
                break;
            }
            case 6: {
                String strEnum = this.readString();
                value = new Value(strEnum, DataType.toDataType(type));
                break;
            }
            case 7: {
                value = new Value(new Timestamp(this.readLong()));
                break;
            }
            case 14: {
                value = new Value(new Time(this.readLong()));
                break;
            }
            case 13: {
                DateInfo di = new DateInfo(this.readInt());
                value = new Value(di);
                break;
            }
            case 8: {
                value = new Value(this.readString(), DataType.BITMASK);
                break;
            }
            case 12: {
                value = new Value(this.decodeCurrencyValue());
                break;
            }
            case 11: {
                break;
            }
            case 9: 
            case 33: 
            case 37: 
            case 40: 
            case 41: 
            case 100: {
                value = new Value(this.readString(), DataType.toDataType(type));
                break;
            }
        }
        return value;
    }
}

