/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import java.util.Scanner;

public abstract class ARQualAssignDecoderBase {
    static String AR_ERROR_UNEXPECTED_ERROR = "UnExpected Error while formatting";
    static final String FILE_DELIMITER = "\\\\";
    static final int ERROR_UNEXPECTED_VALUE = -1;
    protected ARServerUser context;
    protected Scanner scanner;
    protected String _encStr;
    private String _serverCharSet;

    public ARQualAssignDecoderBase(ARServerUser context, String encodedString) throws ARException {
        this.context = context;
        this._encStr = encodedString;
        this.init();
    }

    private void init() throws ARException {
        this._serverCharSet = this.context.getServerCharSet();
        this.scanner = this._encStr != null && this._encStr.length() != 0 ? new Scanner(this._encStr).useDelimiter(FILE_DELIMITER) : null;
    }

    protected int readInt() throws ARException {
        if (!this.scanner.hasNextInt()) {
            this.throwError();
        }
        int result = this.scanner.nextInt();
        return result;
    }

    protected String readString() throws ARException {
        if (!this.scanner.hasNext()) {
            this.throwError();
        }
        String result = this.scanner.next();
        return result;
    }

    protected long readLong() throws ARException {
        if (!this.scanner.hasNextLong()) {
            this.throwError();
        }
        long result = this.scanner.nextLong();
        return result;
    }

    protected double readDouble() throws ARException {
        String value;
        String string = value = this.scanner.hasNext() ? this.scanner.next() : null;
        if (value == null) {
            this.throwError();
        }
        double doubleValue = 0.0;
        try {
            doubleValue = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return doubleValue;
    }

    protected String readLine() throws ARException {
        if (!this.scanner.hasNextLine()) {
            this.throwError();
        }
        String result = this.scanner.nextLine();
        return result;
    }

    protected void throwError() throws ARException {
        String msg = "Error while decoding.";
        throw new ARException(2, 0, msg);
    }

    protected String resetScannerTo(int length) throws ARException {
        String result = null;
        String tempStr = null;
        this.scanner.useDelimiter("\\Z");
        tempStr = this.readLine();
        result = tempStr.substring(1, length + 1);
        if (tempStr != null) {
            this.scanner = new Scanner(tempStr.substring(length + 1)).useDelimiter(FILE_DELIMITER);
        }
        return result;
    }

    protected String getServerCharSet() {
        return this._serverCharSet;
    }
}

