/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.qual.ARQualifierDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ARAssignDecoder
extends ARQualifierDecoder {
    public ARAssignDecoder(ARServerUser context, String encodedString) throws ARException {
        super(context, encodedString);
        this.scanner = new Scanner(encodedString).useDelimiter("\\\\");
    }

    public AssignInfo decodeAssignInfo() throws ARException {
        AssignInfo asgn = new AssignInfo();
        if (this.scanner == null) {
            return null;
        }
        int operator = this.readInt();
        if (operator >= 100) {
            operator -= 100;
        }
        asgn.setAssignType(operator);
        switch (operator) {
            default: {
                break;
            }
            case 1: {
                Value val = this.loadValue();
                asgn.setValue(val);
                break;
            }
            case 2: {
                asgn.setField(this.loadAssignFieldInfo());
                break;
            }
            case 3: {
                int len = this.readInt();
                asgn.setProcess(this.resetScannerTo(len));
                break;
            }
            case 4: {
                ArithOpAssignInfo arOp = this.decodeArithAssignInfo();
                asgn.setArithOp(arOp);
                break;
            }
            case 5: {
                FunctionAssignInfo faI = this.decodeFunctionAssignInfo();
                asgn.setFunction(faI);
                break;
            }
            case 6: {
                DDEAction ddeAction = this.decodeDDE();
                asgn.setDde(ddeAction);
                break;
            }
            case 7: {
                AssignSQLInfo sqlInfo = this.loadAssignSQLInfo();
                asgn.setSql(sqlInfo);
                break;
            }
            case 8: {
                AssignFilterApiInfo assignFilterApiInfo = this.loadAssignFilterApiInfo();
                asgn.setFilterApi(assignFilterApiInfo);
            }
        }
        return asgn;
    }

    private AssignFieldInfo loadAssignFieldInfo() throws ARException {
        int serverNameLen = this.readInt();
        String serverName = this.resetScannerTo(serverNameLen);
        int schemaLen = this.readInt();
        String schemaName = this.resetScannerTo(schemaLen);
        int type = this.readInt();
        int fieldId = this.readInt();
        QualifierInfo qual = this.decodeQualifierInfo();
        int noMatchOption = this.readInt();
        int multiMatchOption = this.readInt();
        AssignFieldInfo fldAsgn = new AssignFieldInfo();
        fldAsgn.setServer(serverName);
        fldAsgn.setForm(schemaName);
        fldAsgn.setQualifier(qual);
        fldAsgn.setFieldId(fieldId);
        fldAsgn.setTag(type);
        fldAsgn.setNoMatchOption(noMatchOption);
        fldAsgn.setMultiMatchOption(multiMatchOption);
        return fldAsgn;
    }

    private DDEAction decodeDDE() throws ARException {
        int tempLen = this.readInt();
        String serviceName = this.resetScannerTo(tempLen);
        tempLen = this.readInt();
        String topic = this.resetScannerTo(tempLen);
        int intAction = this.readInt();
        tempLen = this.readInt();
        String pathToProgram = this.resetScannerTo(tempLen);
        tempLen = this.readInt();
        String strCommand = "";
        if (tempLen != 0) {
            strCommand = this.resetScannerTo(tempLen);
        } else {
            this.scanner.next();
        }
        tempLen = this.readInt();
        String item = null;
        if (tempLen != 0) {
            item = this.resetScannerTo(tempLen);
        } else {
            this.scanner.next();
        }
        DDEAction dde = new DDEAction(serviceName, topic, item, intAction, pathToProgram, strCommand);
        return dde;
    }

    private ArithOpAssignInfo decodeArithAssignInfo() throws ARException {
        ArithOpAssignInfo arOp = new ArithOpAssignInfo();
        int operator = this.readInt();
        arOp.setOperation(operator);
        if (6 != operator) {
            AssignInfo aroLeft = this.decodeAssignInfo();
            arOp.setOperandLeft(aroLeft);
        }
        AssignInfo aroRight = this.decodeAssignInfo();
        arOp.setOperandRight(aroRight);
        return arOp;
    }

    private FunctionAssignInfo decodeFunctionAssignInfo() throws ARException {
        int funCode = this.readInt();
        List<AssignInfo> lAsi = this.decodeFuncParameterList();
        FunctionAssignInfo fai = new FunctionAssignInfo(funCode, lAsi);
        return fai;
    }

    private List<AssignInfo> decodeFuncParameterList() throws ARException {
        ArrayList<AssignInfo> lAsi = new ArrayList<AssignInfo>();
        int no_of_Parameters = this.readInt();
        for (int i = 0; i < no_of_Parameters; ++i) {
            lAsi.add(this.decodeAssignInfo());
        }
        return lAsi;
    }

    private AssignSQLInfo loadAssignSQLInfo() throws ARException {
        int tempInt = this.readInt();
        String server = this.resetScannerTo(tempInt);
        tempInt = this.readInt();
        String sql = this.resetScannerTo(tempInt);
        int index = this.readInt();
        int noMatchOption = this.readInt();
        int multiMatchOption = this.readInt();
        AssignSQLInfo sqlInfo = new AssignSQLInfo(server, sql, index, noMatchOption, multiMatchOption);
        return sqlInfo;
    }

    private AssignFilterApiInfo loadAssignFilterApiInfo() throws ARException {
        AssignFilterApiInfo assignFilterApiInfo = new AssignFilterApiInfo();
        int tempInt = this.readInt();
        assignFilterApiInfo.setService(this.resetScannerTo(tempInt));
        tempInt = this.readInt();
        ArrayList<AssignInfo> inputValues = new ArrayList<AssignInfo>(tempInt);
        for (int i = 0; i < tempInt; ++i) {
            AssignInfo asgnInfo = this.decodeAssignInfo();
            inputValues.add(i, asgnInfo);
        }
        assignFilterApiInfo.setInputValues(inputValues);
        assignFilterApiInfo.setValueIndex(this.readInt());
        return assignFilterApiInfo;
    }
}

