/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.PerfJavaDriver;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;

public class PerfThreadControlBlock
extends ThreadControlBlock {
    long auxCount;
    private int resultFileCount;
    private String resultFileName;
    PrintWriter resultFile;
    Stack<String> resultStack;

    @Override
    public boolean isResultFileOpened() {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            return this.resultStack != null;
        }
        return this.resultFile != null;
    }

    @Override
    public void writeInResultFile(String content) {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            if (this.resultStack == null) {
                this.resultStack = new Stack();
            }
            this.resultStack.push(content);
        } else if (PerfJavaDriver.isForOutputFile()) {
            this.resultFile.println(content);
        }
    }

    @Override
    protected void logTransaction(String commentLine) throws IOException {
        super.logTransaction(commentLine);
        if (!JavaDriver.javaDriverOnly && (PerfJavaDriver.getOutputSetting() & (PerfJavaDriver.OUT_MODE_PERF_LOG | PerfJavaDriver.OUT_MODE_PERF_LOG_MEM)) != 0L) {
            if (this.getResultFile() == null) {
                this.initLogMethod();
            }
            this.writeInResultFile(commentLine);
            if (commentLine.startsWith("## transaction end") && this.resultFile != null) {
                this.resultFile.flush();
            }
        }
    }

    public void initLogMethod() throws IOException {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            this.setResultStack();
        } else {
            String fullFileName = this.preparePerfResultFileName();
            this.setResultFile(fullFileName);
            if (this.getOutputFileName() != null) {
                this.writeInResultFile("\nCorresponding Output File: " + this.getOutputFileName() + "\n");
            }
        }
    }

    protected String preparePerfResultFileName() {
        this.resultFileCount = PerfJavaDriver.getAndIncrementTheFileCount();
        String fileCountStr = String.valueOf(this.resultFileCount);
        StringBuilder prefix = new StringBuilder();
        for (int i = fileCountStr.length(); i < 5; ++i) {
            prefix.append("0");
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append("perf_").append(prefix.toString()).append(fileCountStr).append(".log");
        String fullFileName = fileName.toString();
        if (JavaDriver.getResultDirectory() != null) {
            fullFileName = JavaDriver.getResultDirectory() + "\\" + fullFileName;
        }
        return fullFileName;
    }

    public long getAuxCount() {
        return this.auxCount;
    }

    public void setAuxCount(long count) {
        this.auxCount = count;
    }

    public Stack<String> getResultStack() {
        return this.resultStack;
    }

    public PrintWriter getResultFile() {
        return this.resultFile;
    }

    public void closeResultFile() {
        if (this.resultFile != null) {
            this.resultFile.flush();
            this.resultFile.close();
            this.resultFile = null;
        }
    }

    public void closeResultStack() {
        if (this.resultStack != null && !this.resultStack.empty()) {
            this.resultStack.clear();
        }
    }

    public void setResultStack() {
        this.resultStack = new Stack();
    }

    public void setResultFile(String fileName) throws IOException {
        this.resultFileName = fileName;
        this.resultFile = new PrintWriter(new FileOutputStream(new File(fileName)));
    }

    public boolean hasResultFile() {
        return this.resultFileName != null;
    }

    public void setResultFileCount(int count) {
        this.resultFileCount = count;
    }

    public int getResultFileCount() {
        return this.resultFileCount;
    }

    @Override
    protected void threadSleep(long sleepTimeInMilliSeconds) {
        long sleepTime = sleepTimeInMilliSeconds / 1L;
        long elapsedTimeMilliSec = System.currentTimeMillis() - PerfJavaDriver.driverStartTime;
        String statString = PerfJavaDriver.getStatString(elapsedTimeMilliSec, this.getCurrentCommand(), 0L, sleepTime);
        this.writeInResultFile(statString);
        if (this.resultFile != null) {
            this.resultFile.flush();
        }
        super.threadSleep(sleepTime);
    }
}

