/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.IOException;

class CommandProcessor {
    static final int SLEEP_ADJUST_FACTOR = 1;

    CommandProcessor() {
    }

    void randomSleep(long lowerBound, long upperBound) {
        int randomValue = JavaDriver.getRandomNumber();
        if (randomValue < 0) {
            randomValue *= -1;
        }
        long sleepSeconds = lowerBound + ((long)randomValue * (upperBound - lowerBound) + (long)((JavaDriver.RAND_MAX + 1) / 2)) / (long)(JavaDriver.RAND_MAX + 1);
        JavaDriver.outputWriter.printResult("\n   Sleeping for " + sleepSeconds + " second(s)\n");
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        if (!threadControlBlockObject.isResultFileOpened()) {
            try {
                Thread.sleep(sleepSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            threadControlBlockObject.threadSleep(sleepSeconds * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseWaitingThreads() {
        SyncObject releaseObject;
        JavaDriver.outputWriter.driverPrintHeader("RELEASE WAITING THREADS");
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        SyncObject syncObject = releaseObject = threadControlBlockObject.getReleaseObject();
        synchronized (syncObject) {
            releaseObject.setFlag(true);
            releaseObject.notifyAll();
        }
    }

    void sleepTimer() throws IOException {
        long sleepSeconds = InputReader.getLong("Number of seconds (0): ", 0L);
        JavaDriver.outputWriter.printResult("\n   Sleeping for" + sleepSeconds + " second(s) . . .\n");
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        threadControlBlockObject.threadSleep(sleepSeconds * 1000L);
    }

    void millisecondSleepTimer() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("MILLISECOND SLEEP TIMER");
        long sleepMilliSeconds = InputReader.getLong("Number of milliseconds (0): ", 0L);
        ThreadControlBlock threadControlBlockObject = JavaDriver.getThreadControlBlockPtr();
        threadControlBlockObject.threadSleep(sleepMilliSeconds);
    }

    void randomSleepTimer() throws IOException {
        long lowerBound = InputReader.getLong("Lower Bound (0): ", 0L);
        long upperBound = InputReader.getLong("Upper Bound (0): ", 0L);
        if (upperBound < lowerBound) {
            JavaDriver.outputWriter.driverPrintError(" **** upper bound is less than lower bound\n");
            return;
        }
        this.randomSleep(lowerBound, upperBound);
    }
}

