/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARMdCrypto;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LogBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class PasswordFieldEncryption {
    private static Logger logger = Logger.getLogger(PasswordFieldEncryption.class);
    protected boolean _DEBUG_CONFIG_ON = this.isDebugEnabled();
    protected boolean logFlag = false;

    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    public PasswordFieldEncryption(boolean debug) {
        this.setLogFlag(debug);
    }

    protected boolean setLogFlag(boolean debug) {
        this.logFlag = debug && logger.isDebugEnabled() && this._DEBUG_CONFIG_ON;
        return this.logFlag;
    }

    public boolean isEncryptionNeededField(int fieldId) {
        boolean needEnc = false;
        if (fieldId == 102) {
            needEnc = true;
        }
        return needEnc;
    }

    public boolean isEncryptedPasswordBytes(byte[] bs) {
        boolean encrypted = false;
        if (bs != null && bs.length == 28) {
            encrypted = true;
        }
        return encrypted;
    }

    public byte[] hashPassword(byte[] fromBuf) throws AREncryptionException {
        byte[] hashed = StringByteUtil.base64Encode(this.arHashPassword(fromBuf));
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(hashed, "FormPasswordFieldEncryption.hashPassword- rst");
            LogBytes.printByteArrayAsString(hashed, "FormPasswordFieldEncryption.hashPassword - rst");
        }
        return hashed;
    }

    private byte[] arHashPassword(byte[] fromBuf) throws AREncryptionException {
        if (fromBuf.length > 30) {
            fromBuf = StringByteUtil.resizeByteArray(fromBuf, 30);
        }
        int psdLen = fromBuf.length;
        byte[] buf1 = new byte[30 - psdLen];
        byte[] saltBuffer = StringByteUtil.generateRandomBytes(5);
        for (int i = 0; i < 30 - psdLen; ++i) {
            buf1[i] = 9;
        }
        byte[] hashbuf = StringByteUtil.concatenateByteArrays(saltBuffer, fromBuf, buf1);
        ARMdCrypto md = new ARMdCrypto();
        byte[] hashValue = md.MD5(hashbuf);
        byte[] saltedHashBuf = StringByteUtil.concatenateByteArrays(saltBuffer, hashValue);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(saltedHashBuf, "FormPasswordFieldEncryption.arHashPassword- saltedHashBuf");
        }
        return saltedHashBuf;
    }

    public boolean validatePassword(byte[] orgBuf, byte[] hashedBuf) throws AREncryptionException {
        if (this.logFlag) {
            LogBytes.printByteArrayAsHexArray(hashedBuf, "FormPasswordFieldEncryption.validatePassword- returned hash buffer");
        }
        byte[] hashed = StringByteUtil.base64Decode(hashedBuf);
        boolean expected = this.arValidatePassword(orgBuf, hashed);
        String spaceStr = " ";
        if (!expected) {
            byte[] spaceBuf = spaceStr.getBytes();
            expected = this.arValidatePassword(spaceBuf, hashed);
        }
        return expected;
    }

    private boolean arValidatePassword(byte[] orgBuf, byte[] hashedBuf) throws AREncryptionException {
        byte[] saltBuffer = StringByteUtil.getByteArrays(hashedBuf, 0, 5);
        int psdLen = orgBuf.length;
        byte[] buf1 = new byte[30 - psdLen];
        for (int i = 0; i < 30 - psdLen; ++i) {
            buf1[i] = 9;
        }
        byte[] hashbuf = StringByteUtil.concatenateByteArrays(saltBuffer, orgBuf, buf1);
        ARMdCrypto md = new ARMdCrypto();
        byte[] hashValue = md.MD5(hashbuf);
        byte[] oldHashValue = StringByteUtil.getByteArrays(hashedBuf, 5, 16);
        boolean expected = Arrays.equals(hashValue, oldHashValue);
        return expected;
    }
}

