/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantLock;

public class ClientTypeRpcQueueMapping {
    private HashMap<Integer, Integer> theMapping = new HashMap();
    private final ReentrantLock statusLock = new ReentrantLock();

    public void putAll(String mappingStr) {
        block6: {
            try {
                Map<Integer, Integer> newMap = this.parseMappingLine(mappingStr);
                if (newMap.equals(this.theMapping)) break block6;
                this.statusLock.lock();
                try {
                    this.theMapping.clear();
                    this.theMapping.putAll(newMap);
                }
                finally {
                    if (this.statusLock.getHoldCount() > 0) {
                        this.statusLock.unlock();
                    }
                }
            }
            catch (ARException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<Integer, Integer> parseMappingLine(String multiSetting) throws ARException {
        HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
        StringTokenizer lineTokenizer = new StringTokenizer(multiSetting, ";");
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            this.parseOneMappingLine(line, newMap);
        }
        return newMap;
    }

    private void parseOneMappingLine(String line, Map<Integer, Integer> newMap) throws ARException {
        try {
            StringTokenizer typeTokenizer = new StringTokenizer(line, " ");
            String type = typeTokenizer.nextToken();
            String queue = typeTokenizer.nextToken();
            int clientType = 0;
            if (type != null && type.length() > 0) {
                clientType = Integer.parseInt(type);
            }
            int rpcQueue = 0;
            if (queue != null && queue.length() > 0) {
                rpcQueue = Integer.parseInt(queue);
            }
            if (clientType >= 0 && rpcQueue > 0) {
                newMap.put(clientType, rpcQueue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getRpcQueueByClientType(int clientType) {
        int rst = 0;
        if (this.theMapping.containsKey(clientType)) {
            rst = this.theMapping.get(clientType);
        }
        return rst;
    }

    public boolean isEmpty() {
        return this.theMapping.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.theMapping == null ? 0 : this.theMapping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientTypeRpcQueueMapping other = (ClientTypeRpcQueueMapping)obj;
        return !(this.theMapping == null ? other.theMapping != null : !this.theMapping.equals(other.theMapping));
    }
}

