/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.arxdrenc.ArXdrUnXdrBufferStream;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.KeyExchangeEncryption;
import com.bmc.arsys.arencrypt.NetworkDataEncryption;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LogBytes;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

abstract class ARRpcKeyExchangeBase {
    private static Logger logger = Logger.getLogger(ARRpcKeyExchangeBase.class);
    private boolean debug = logger.isDebugEnabled();

    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    protected ARRpcKeyExchangeBase() {
    }

    protected byte[] xdrAndEncrypPreMasterKey(ARPPKey arPPKey, byte[] preMasterKey) throws IOException, OncRpcException, AREncryptionException {
        byte[] xdrPreMasterKey = ArXdrUnXdrBufferStream.xdrBytes(preMasterKey);
        if (this.debug) {
            LogBytes.printByteArray(xdrPreMasterKey, "ArKeyExchange.xdrPreMasterKey bytes ");
        }
        KeyExchangeEncryption svrPublicKeyEncryptor = new KeyExchangeEncryption(arPPKey);
        return svrPublicKeyEncryptor.encrypt(xdrPreMasterKey);
    }

    protected int unxdrAndDecryptSessionId(ARDataKey arDataKey, byte[] encSessionId) throws IOException, OncRpcException, AREncryptionException {
        int sessionId = 0;
        if (encSessionId == null) {
            return sessionId;
        }
        byte[] sessionIdBytesToXdrDecode = this.decryptDataBytes(arDataKey, encSessionId);
        if (this.debug) {
            LogBytes.printByteArrayAsHex(sessionIdBytesToXdrDecode, "ArKeyExchange.decryptSessionId sessionIdBytesToXdrDecode hex ");
        }
        if (sessionIdBytesToXdrDecode != null && sessionIdBytesToXdrDecode.length > 0) {
            sessionId = ArXdrUnXdrBufferStream.unXdrInt(sessionIdBytesToXdrDecode);
        }
        if (this.debug) {
            logger.debug("unxdrAndDecryptSessionId(ARDataKey, byte[]) - decrypted sessionId = " + sessionId);
        }
        return sessionId;
    }

    protected byte[] xdrAndEncryptSessionId(ARDataKey arDataKey, int sessionId) throws IOException, OncRpcException, AREncryptionException {
        byte[] xdredBytes = ArXdrUnXdrBufferStream.xdrInt(sessionId);
        return this.encryptDataBytes(arDataKey, xdredBytes);
    }

    protected byte[] unxdrAndDecryptPreMasterkey(AREncryptAPISessionNodeBase encSessionNode, ARPPKey arPPKey, byte[] databytes) throws IOException, OncRpcException, AREncryptionException {
        KeyExchangeEncryption svrPublicKeyEncryptor = new KeyExchangeEncryption(arPPKey);
        byte[] dataTounxdr = svrPublicKeyEncryptor.decrypt(databytes);
        return ArXdrUnXdrBufferStream.unXdrBytes(dataTounxdr);
    }

    private byte[] encryptDataBytes(ARDataKey arDataKey, byte[] dataBytesToEncrypt) throws AREncryptionException {
        if (this.debug) {
            LogBytes.printByteArrayAsHex(dataBytesToEncrypt, "ArKeyExchange.decryptDataBytes hex ");
            LogBytes.printByteArray(dataBytesToEncrypt, "ArKeyExchange.decryptDataBytes bytes ");
        }
        NetworkDataEncryption dataEncryptor = new NetworkDataEncryption(false, this.debug);
        return dataEncryptor.encryptData(arDataKey, dataBytesToEncrypt);
    }

    private byte[] decryptDataBytes(ARDataKey arDataKey, byte[] encryptedDataBytes) throws AREncryptionException {
        if (this.debug) {
            LogBytes.printByteArrayAsHex(encryptedDataBytes, "ArKeyExchange.decryptDataBytes hex ");
            LogBytes.printByteArray(encryptedDataBytes, "ArKeyExchange.decryptDataBytes bytes ");
        }
        NetworkDataEncryption dataEncryptor = new NetworkDataEncryption(false, this.debug);
        return dataEncryptor.decryptData(arDataKey, encryptedDataBytes);
    }

    abstract void keyExchangeHandler() throws OncRpcException, IOException, ARException, AREncryptionException;
}

