/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiProxyType;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiCMTKey;
import com.bmc.arsys.apitransport.connection.ApiCMTObject;
import com.bmc.arsys.apitransport.connection.ApiCMTProxyHolder;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ApiCMTProxyPool {
    private static Logger logger = Logger.getLogger(ApiCMTProxyPool.class);
    private static ConcurrentHashMap<ApiCMTKey, ApiCMTObject> cmtPool;
    static final ReentrantLock poolLock;

    ApiCMTProxyPool() {
        cmtPool = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiCMTKey getApiCMTProxyType(String mTransactionHandle, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        ApiCMTKey key = null;
        Set keys = null;
        if (mTransactionHandle == null || cmtPool == null) {
            logger.error("not a valid CMT transactioin =" + mTransactionHandle);
            throw new ARException(2, 898);
        }
        if (proxyType == null) {
            proxyType = new ApiProxyType(1);
        }
        boolean found = false;
        poolLock.lock();
        try {
            if (!cmtPool.isEmpty() && (keys = cmtPool.keySet()) != null) {
                Iterator it = keys.iterator();
                while (it.hasNext() && !found) {
                    key = (ApiCMTKey)it.next();
                    if (!mTransactionHandle.equals(key.getTransactionHandle())) continue;
                    found = true;
                }
            }
            if (!found) {
                key = new ApiCMTKey(mTransactionHandle);
                if (logger.isDebugEnabled()) {
                    logger.debug("created new ApiCMTProxyType with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                }
            }
        }
        finally {
            poolLock.unlock();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCMTProxyInCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        if (apiProxyI == null) {
            logger.error("not a valid proxy =" + apiProxyI);
            throw new ARException(2, 898);
        }
        poolLock.lock();
        try {
            ApiCMTKey key = this.getApiCMTProxyType(mTransactionHandle, apiUserContextI, arProxyName, cmd, proxyType);
            if (key != null && apiProxyI != null && !cmtPool.containsKey(key) && apiProxyI instanceof ApiProxyBase && !cmtPool.containsKey(key)) {
                key.setAssigned(false);
                key.setTransactionHandle(mTransactionHandle);
                key.setCmtLastUsed(System.currentTimeMillis());
                ARServerContext svrCtx = ProxyManager.getARServerContext(apiUserContextI.getServer(), apiUserContextI.getPort());
                key.setCmtTimeoutSetting(svrCtx.getServerCmtTimeout());
                Object sharedSocket = ((ApiProxyBase)apiProxyI).getSocket(apiUserContextI);
                ApiCMTObject cmtObj = new ApiCMTObject(apiUserContextI, (ApiProxyBase)apiProxyI, sharedSocket, arProxyName, proxyType);
                cmtPool.put(key, cmtObj);
                if (logger.isDebugEnabled()) {
                    logger.debug("add proxy " + apiProxyI + " into CMT pool in cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                }
            }
        }
        finally {
            if (poolLock.getHoldCount() > 0) {
                poolLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCMTProxyFromCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        boolean cmtProxyRemoved;
        block8: {
            cmtProxyRemoved = false;
            poolLock.lock();
            try {
                ApiCMTKey key = this.getApiCMTProxyType(mTransactionHandle, apiUserContextI, arProxyName, cmd, proxyType);
                if (key != null && cmtPool.containsKey(key)) {
                    if (cmtPool.containsKey(key)) {
                        key.setAssigned(false);
                        this.releaseCMTProxyBackInCMTPool(mTransactionHandle, apiProxyI, apiUserContextI, arProxyName, cmd, proxyType);
                        if (logger.isDebugEnabled()) {
                            logger.debug("release proxy " + apiProxyI + " back to CMT pool in cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                        }
                        ApiCMTObject cmtObj = cmtPool.get(key);
                        cmtProxyRemoved = this.releaseCMTHoldProxiesToNormalPool(cmtObj);
                        if (logger.isDebugEnabled()) {
                            logger.debug("release proxy " + cmtObj.getCMTHoldProxy().getProxy() + " from CMT pool back to normal pool in cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + cmtObj.getCMTHoldProxy().getRpcType());
                        }
                        cmtObj.clean();
                        cmtPool.remove(key);
                    }
                    break block8;
                }
                logger.error("not a valid CMT transactioin =" + mTransactionHandle);
                throw new ARException(2, 898);
            }
            finally {
                if (poolLock.getHoldCount() > 0) {
                    poolLock.unlock();
                }
            }
        }
        return cmtProxyRemoved;
    }

    private boolean releaseCMTHoldProxiesToNormalPool(ApiCMTObject cmtObj) {
        boolean cmtProxyRemoved = false;
        if (cmtObj.getCurARProxy() != null) {
            try {
                cmtObj.getCurARProxy().unparkSocket();
            }
            catch (ARException e) {
                logger.error("releaseCMTHoldProxiesToNormalPool failed for ARProxy", e);
            }
        }
        if (cmtObj.getCurCMDBProxy() != null) {
            try {
                cmtObj.getCurCMDBProxy().unparkSocket();
            }
            catch (ARException e) {
                logger.error("releaseCMTHoldProxiesToNormalPool failed for CMDB Proxy", e);
            }
        }
        if (cmtObj.getCurARProxy() != null) {
            this.releaseCMTUsedProxyToNormalPool(cmtObj.getCurARProxy());
        }
        if (cmtObj.getCurCMDBProxy() != null) {
            this.releaseCMTUsedProxyToNormalPool(cmtObj.getCurCMDBProxy());
        }
        cmtProxyRemoved = true;
        return cmtProxyRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiProxyI getCMTProxyFromCMTPool(String mTransactionHandle, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) throws ARException {
        ApiProxyI proxy = null;
        poolLock.lock();
        try {
            ApiCMTKey key = this.getApiCMTProxyType(mTransactionHandle, apiUserContextI, arProxyName, cmd, proxyType);
            if (key != null && cmtPool.containsKey(key)) {
                key.setAssigned(true);
                key.setCmtLastUsed(System.currentTimeMillis());
                ApiCMTObject cmtObj = null;
                cmtObj = cmtPool.get(key);
                if (cmtObj.getCurARProxy() != null && proxyType.equals(cmtObj.getCurARProxy().getRpcType())) {
                    proxy = cmtObj.getCurARProxy().getProxy();
                    if (logger.isDebugEnabled()) {
                        logger.debug("get proxy " + proxy + " from CMT pool for cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                    }
                } else if (cmtObj.getCurCMDBProxy() != null && proxyType.equals(cmtObj.getCurCMDBProxy().getRpcType())) {
                    proxy = cmtObj.getCurCMDBProxy().getProxy();
                    if (logger.isDebugEnabled()) {
                        logger.debug("get proxy " + proxy + " from CMT pool for cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                    }
                } else {
                    boolean orgIgnoreCMTHandleFlag = ApiThreadLocalStorageBlock.getTLB().isIgnoreCMTHandle();
                    ApiThreadLocalStorageBlock.getTLB().setIgnoreCMTHandle(false);
                    proxy = this.getKnownRpcTypeProxyFromNormalPool(apiUserContextI);
                    ApiThreadLocalStorageBlock.getTLB().setIgnoreCMTHandle(orgIgnoreCMTHandleFlag);
                    ApiCMTProxyHolder curProxyHolder = new ApiCMTProxyHolder(apiUserContextI, (ApiProxyBase)proxy, arProxyName, proxyType);
                    curProxyHolder.parkSocket(cmtObj.getSharedSocket());
                    if (proxyType.getProxyType() == 1) {
                        cmtObj.setCurARProxy(curProxyHolder);
                    } else if (proxyType.getProxyType() == 3) {
                        cmtObj.setCurCMDBProxy(curProxyHolder);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("get proxy " + proxy + " from CMT pool for cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("not a valid CMT transactioin =" + mTransactionHandle);
            }
        }
        finally {
            if (poolLock.getHoldCount() > 0) {
                poolLock.unlock();
            }
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseCMTProxyBackInCMTPool(String mTransactionHandle, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, String arProxyName, String cmd, ApiProxyType proxyType) {
        boolean releaseIt = true;
        ApiCMTKey key = null;
        poolLock.lock();
        try {
            try {
                key = this.getApiCMTProxyType(mTransactionHandle, apiUserContextI, arProxyName, cmd, proxyType);
            }
            catch (ARException e) {
                logger.debug(e.getLocalizedMessage());
            }
            if (key != null && cmtPool.containsKey(key) && apiProxyI instanceof ApiProxyBase) {
                releaseIt = false;
                key.setAssigned(false);
                key.setCmtLastUsed(System.currentTimeMillis());
                if (logger.isDebugEnabled()) {
                    logger.debug("released proxy " + apiProxyI + " back to CMT pool for cmd=" + cmd + " with mTransactionHandle=" + mTransactionHandle + "; proxyType=" + proxyType);
                }
            }
        }
        finally {
            if (poolLock.getHoldCount() > 0) {
                poolLock.unlock();
            }
        }
        return releaseIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpTimeoutCMTFromCMTPool() {
        if (cmtPool == null || cmtPool.isEmpty()) {
            return;
        }
        HashMap<ApiCMTKey, ApiCMTObject> removeCandidate = new HashMap<ApiCMTKey, ApiCMTObject>();
        if (poolLock.tryLock()) {
            try {
                Set keys = cmtPool.keySet();
                for (ApiCMTKey key : keys) {
                    ApiCMTObject cmtObj;
                    if (key.isAssigned() || (cmtObj = cmtPool.get(key)) == null || !key.checkIfCmtTimedOut()) continue;
                    key.setAssigned(false);
                    key.setTransactionHandle(null);
                    removeCandidate.put(key, cmtObj);
                }
                if (!removeCandidate.isEmpty()) {
                    Iterator itC = removeCandidate.keySet().iterator();
                    if (itC.hasNext()) {
                        ApiCMTKey key2 = (ApiCMTKey)itC.next();
                        ApiCMTObject cmtObj = (ApiCMTObject)removeCandidate.get(key2);
                        if (cmtObj != null) {
                            this.releaseCMTHoldProxiesToNormalPool(cmtObj);
                            if (logger.isDebugEnabled()) {
                                logger.debug("cleanUpTimeoutCMTFromCMTPool releaed proxy " + cmtObj.getCMTHoldProxy().getProxy() + " from CMT pool back to normal pool with mTransactionHandle=" + key2.getTransactionHandle());
                            }
                            cmtObj.clean();
                        }
                        cmtPool.remove(key2);
                    }
                    removeCandidate.clear();
                }
            }
            finally {
                if (poolLock.getHoldCount() > 0) {
                    poolLock.unlock();
                }
            }
        }
    }

    private ApiProxyI getKnownRpcTypeProxyFromNormalPool(ApiUserContextI context) throws ARException {
        return ProxyManager.getProxyManager().getProxy(context);
    }

    private void releaseCMTUsedProxyToNormalPool(ApiCMTProxyHolder proxyholder) {
        if (proxyholder != null) {
            String cmd = "releaseCMTUsedProxyToNormalPool";
            ApiThreadLocalStorageBlock.getTLB().setIgnoreCMTHandle(true);
            if (logger.isDebugEnabled()) {
                logger.debug("proxy " + proxyholder.getProxy() + " " + proxyholder.getParkedSocket() + " will be released back to normal pool");
            }
            ProxyManager.getProxyManager().releaseProxy((ApiProxyI)proxyholder.getProxy(), proxyholder.getContext(), proxyholder.getProxyJrpcClassName(), cmd, proxyholder.getRpcType());
            ApiThreadLocalStorageBlock.getTLB().setIgnoreCMTHandle(false);
        }
    }

    boolean isCmtPoolEmpty() {
        return cmtPool.isEmpty();
    }

    static {
        poolLock = new ReentrantLock();
    }
}

