/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.Config;
import com.bmc.arsys.utils.ProcessUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ApiCMTKey {
    private static Logger logger = Logger.getLogger(ApiCMTKey.class);
    private String mTransactionHandle;
    private boolean assigned;
    long serverCmtTimeout = 600000L;
    long cmtStartTime;
    long cmtLastUsed;
    boolean cmtAlreadyTimedOut;

    ApiCMTKey(String mTransactionHandle) {
        this.mTransactionHandle = mTransactionHandle;
        this.cmtStartTime = System.currentTimeMillis();
    }

    String getTransactionHandle() {
        return this.mTransactionHandle;
    }

    void setTransactionHandle(String mTransactionHandle) {
        this.mTransactionHandle = mTransactionHandle;
    }

    boolean isAssigned() {
        return this.assigned;
    }

    void setAssigned(boolean assigned) {
        this.assigned = assigned;
    }

    long getCmtTimeoutSetting() {
        return this.serverCmtTimeout;
    }

    void setCmtTimeoutSetting(long cmtTimeoutSetting) {
        this.serverCmtTimeout = cmtTimeoutSetting;
    }

    long getCmtStartTime() {
        return this.cmtStartTime;
    }

    void setCmtStartTime(long lastTransactionTime) {
        this.cmtStartTime = lastTransactionTime;
    }

    boolean isCmtAlreadyTimedOut() {
        return this.cmtAlreadyTimedOut;
    }

    void setCmtAlreadyTimedOut(boolean cmtTimedout) {
        this.cmtAlreadyTimedOut = cmtTimedout;
    }

    long getCmtLastUsed() {
        return this.cmtLastUsed;
    }

    void setCmtLastUsed(long cmtLastUsed) {
        this.cmtLastUsed = cmtLastUsed;
    }

    boolean checkIfCmtTimedOut() {
        if (!this.isCmtAlreadyTimedOut() && this.getCmtTimeoutSetting() > 0L) {
            boolean flag;
            long timeoutMS = this.getCmtTimeoutSetting() + 120000L;
            long idle = System.currentTimeMillis() - this.getCmtLastUsed();
            boolean bl = flag = idle > timeoutMS;
            if (logger.isTraceEnabled()) {
                String msg = "CMT " + this.mTransactionHandle + ", been idle for " + ProcessUtil.getElapsedTimeToFormatedString(idle) + "; API CMT timeout in " + ProcessUtil.getElapsedTimeToFormatedString(timeoutMS);
                if (flag) {
                    logger.trace("Timeout " + msg);
                } else {
                    logger.trace("Evaluated " + msg);
                }
            }
            this.setCmtAlreadyTimedOut(flag);
        }
        return this.isCmtAlreadyTimedOut();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiCMTKey)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ApiCMTKey rhs = (ApiCMTKey)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.mTransactionHandle, rhs.mTransactionHandle).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.mTransactionHandle).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("mTransactionHandle", this.mTransactionHandle).toString();
    }
}

