/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkArrayBuffer;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorBase;
import com.bmc.arsys.apitransport.chunking.IARChunkReceivable;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import java.util.zip.DataFormatException;
import org.apache.log4j.Logger;

public abstract class ARChunkReceiveProcessor
extends ARChunkProcessorBase
implements IARChunkReceivable {
    private static Logger logger = Logger.getLogger(ARChunkArrayBuffer.class);

    @Override
    public void retrieveChunkingData(ArRpcXdrOut out) throws ARException {
        if (out.getControl().getDone().value == 1) {
            this.setChunkingDone(true);
        }
    }

    @Override
    public void postProcess(ArRpcXdrOut out) throws ARException {
    }

    byte[] inflateBytes(byte[] compressedBytes) throws ARException {
        byte[] output = null;
        if (compressedBytes != null) {
            ARDecompressor decompresser = new ARDecompressor();
            decompresser.setInput(compressedBytes);
            try {
                output = decompresser.inflate();
            }
            catch (DataFormatException e) {
                logger.error("inflateBytes: received DataFormatException: " + e.getMessage());
                throw new ARException(2, 160, e.getMessage());
            }
            finally {
                decompresser.end();
                decompresser = null;
            }
        }
        return output;
    }
}

