/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.apitransport.chunking.ARChunkProcessorBase;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARChunkProcessorFactory {
    private static Logger logger = Logger.getLogger(ARChunkProcessorFactory.class);
    protected static List<Integer> receiveChunkingOnOutputParamCallList = new ArrayList<Integer>();
    protected static List<Integer> sendChunkingOnInputParamCallList = new ArrayList<Integer>();
    protected static Map<Integer, Class<?>> registry = new HashMap();

    public static IARChunkable createProcessor(int procedureNumber) {
        if (registry.containsKey(procedureNumber)) {
            Class<?> clazz = registry.get(procedureNumber);
            ARChunkProcessorBase processor = null;
            try {
                processor = (ARChunkProcessorBase)clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("API procedure " + procedureNumber + " is not supprted for chunking.", e);
            }
            catch (IllegalAccessException e) {
                logger.error("API procedure " + procedureNumber + " chunking processor does not have public constructor.", e);
            }
            return processor;
        }
        logger.error("API procedure " + procedureNumber + " is not supprted for chunking.");
        throw new NullPointerException();
    }

    public static boolean isChunkingSupportedCall(int procedureNumber) {
        return receiveChunkingOnOutputParamCallList.contains(procedureNumber) || sendChunkingOnInputParamCallList.contains(procedureNumber);
    }

    public static boolean isSendChunkingOnInputParamCall(int procedureNumber) {
        return sendChunkingOnInputParamCallList.contains(procedureNumber);
    }

    public static boolean isReceiveChunkingOnOutputParamCall(int procedureNumber) {
        return receiveChunkingOnOutputParamCallList.contains(procedureNumber);
    }
}

