/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.session;

import com.bmc.arsys.api.session.RpcMapperV12;
import com.bmc.arsys.arrpc.ArAccessNameType;
import com.bmc.arsys.arrpc.ArControlStruct11;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArCreateFilter11In;
import com.bmc.arsys.arrpc.ArCreateFilter12In;
import com.bmc.arsys.arrpc.ArGetFilter11Out;
import com.bmc.arsys.arrpc.ArGetFilter12Out;
import com.bmc.arsys.arrpc.ArGetServerInfo11In;
import com.bmc.arsys.arrpc.ArGetServerInfo11Out;
import com.bmc.arsys.arrpc.ArGetServerInfo12In;
import com.bmc.arsys.arrpc.ArGetServerInfo12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin11In;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin11Out;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12In;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal11In;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal11Out;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12In;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12Out;
import com.bmc.arsys.arrpc.ArNameMask11In;
import com.bmc.arsys.arrpc.ArNameMask12In;
import com.bmc.arsys.arrpc.ArNameType;
import com.bmc.arsys.arrpc.ArPasswordTypePre12;
import com.bmc.arsys.arrpc.ArSetFilter11In;
import com.bmc.arsys.arrpc.ArSetFilter12In;
import com.bmc.arsys.arrpc.ArStatusOnly11Out;
import com.bmc.arsys.arrpc.ArStatusOnly12Out;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.arrpc.xdr.DecoratedArRpcXdrOut;
import com.bmc.arsys.utils.StringByteUtil;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;

class RpcMapperV11
extends RpcMapperV12 {
    RpcMapperV11() {
    }

    @Override
    public XdrAble map(int rpcNum, XdrAble in) throws OncRpcException {
        XdrAble v12 = super.map(rpcNum, in);
        XdrAble v11 = null;
        switch (rpcNum) {
            case 23: {
                v11 = this.mapArCreateFilterInToV11((ArCreateFilter12In)v12);
                break;
            }
            case 22: {
                v11 = this.mapArSetFilterInToV11((ArSetFilter12In)v12);
                break;
            }
            case 21: {
                v11 = this.mapArNameMaskInToV11((ArNameMask12In)v12);
                break;
            }
            case 95: {
                v11 = this.mapArKeyExchangeBeginInToV11((ArKeyExchangeBegin12In)v12);
                break;
            }
            case 96: {
                v11 = this.mapArKeyExchangeFinalInToV11((ArKeyExchangeFinal12In)v12);
                break;
            }
            case 36: 
            case 97: {
                v11 = this.mapArGetServerInfoInToV11((ArGetServerInfo12In)v12);
                break;
            }
            case 136: {
                throw new OncRpcException(10);
            }
            default: {
                v11 = v12;
            }
        }
        return v11;
    }

    @Override
    public ArRpcXdrOut map(int rpcNum, ArRpcXdrOut out) {
        switch (rpcNum) {
            case 21: {
                return new ArGetFilter11Out();
            }
            case 22: 
            case 23: {
                return new ArStatusOnly11Out();
            }
            case 36: 
            case 97: {
                return new ArGetServerInfo11Out();
            }
            case 95: {
                return new ArKeyExchangeBegin11Out();
            }
            case 96: {
                return new ArKeyExchangeFinal11Out();
            }
        }
        return super.map(rpcNum, out);
    }

    @Override
    public void map(int rpcNum, ArRpcXdrOut v11, DecoratedArRpcXdrOut out) throws OncRpcException {
        ArRpcXdrOut v12 = super.map(rpcNum, out);
        switch (rpcNum) {
            case 21: {
                this.mapArGetFilterOutToV12((ArGetFilter11Out)v11, (ArGetFilter12Out)v12);
                break;
            }
            case 36: 
            case 97: {
                this.mapArGetServerInfoOutToV12((ArGetServerInfo11Out)v11, (ArGetServerInfo12Out)v12);
                break;
            }
            case 95: {
                this.mapArKeyExchangeBeginOutToV12((ArKeyExchangeBegin11Out)v11, (ArKeyExchangeBegin12Out)v12);
                break;
            }
            case 96: {
                this.mapArKeyExchangeFinalOutToV12((ArKeyExchangeFinal11Out)v11, (ArKeyExchangeFinal12Out)v12);
                break;
            }
            case 22: 
            case 23: {
                this.mapArStatusOnlyOutToV12((ArStatusOnly11Out)v11, (ArStatusOnly12Out)v12);
                break;
            }
            default: {
                v12 = v11;
            }
        }
        super.map(rpcNum, v12, out);
    }

    private void mapArControlStructToV12(ArControlStruct11 v11, ArControlStruct12 v12) {
        v12.cacheId = v11.cacheId;
        v12.operationTime = v11.operationTime;
        v12.user = new String(v11.user.value).trim();
        v12.password = null;
        v12.authString = v11.authString;
        v12.impersonation = new String(v11.impersonation.value).trim();
        v12.localeInfo = v11.localeInfo;
        v12.logMask = v11.logMask;
        v12.vuiType = v11.vuiType;
        v12.apiClientType = v11.apiClientType;
        v12.timeout = v11.timeout;
        v12.reservedPropList = v11.reservedPropList;
        v12.operationTimeMicro = v11.operationTimeMicro;
        v12.clientIPAddr = v11.clientIPAddr;
        v12.processID = v11.processID;
        v12.threadID = v11.threadID;
        v12.maxResponse = v11.maxResponse;
        v12.requestId = v11.requestId;
        v12.done = v11.done;
    }

    private ArNameType mapToArNameTypeFromString(String in) {
        return new ArNameType(StringByteUtil.resizeByteArray(in.getBytes(), 31));
    }

    private ArControlStruct11 mapArControlStructToV11(ArControlStruct12 v12) {
        return new ArControlStruct11(v12.cacheId, v12.operationTime, this.mapToArNameTypeFromString(v12.user), new ArPasswordTypePre12(), v12.authString, this.mapToArNameTypeFromString(v12.impersonation), v12.localeInfo, v12.logMask, v12.vuiType, v12.apiClientType, v12.timeout, v12.reservedPropList, v12.operationTimeMicro, v12.clientIPAddr, v12.processID, v12.threadID, v12.maxResponse, v12.requestId, v12.done);
    }

    private void mapArStatusOnlyOutToV12(ArStatusOnly11Out v11, ArStatusOnly12Out v12) {
        this.mapArControlStructToV12(v11.control, v12.control);
        v12.status = v11.status;
    }

    private void mapArGetFilterOutToV12(ArGetFilter11Out v11, ArGetFilter12Out v12) {
        this.mapArControlStructToV12(v11.control, v12.control);
        v12.order = v11.order;
        v12.workflowConnect = v11.workflowConnect;
        v12.opSet = v11.opSet;
        v12.enable = v11.enable;
        v12.query = v11.query;
        v12.actionList = v11.actionList;
        v12.elseList = v11.elseList;
        v12.helpText = v11.helpText;
        v12.timestamp = v11.timestamp;
        v12.owner = new ArAccessNameType(v11.owner.value);
        v12.lastChanged = new ArAccessNameType(v11.lastChanged.value);
        v12.changeDiary = v11.changeDiary;
        v12.objPropList = v11.objPropList;
        v12.status = v11.status;
    }

    private void mapArKeyExchangeFinalOutToV12(ArKeyExchangeFinal11Out v11, ArKeyExchangeFinal12Out v12) {
        this.mapArControlStructToV12(v11.control, v12.control);
        v12.encSessionId = v11.encSessionId;
        v12.status = v11.status;
    }

    private void mapArKeyExchangeBeginOutToV12(ArKeyExchangeBegin11Out v11, ArKeyExchangeBegin12Out v12) {
        this.mapArControlStructToV12(v11.control, v12.control);
        v12.serverRandBytes = v11.serverRandBytes;
        v12.sessionId = v11.sessionId;
        v12.status = v11.status;
    }

    private void mapArGetServerInfoOutToV12(ArGetServerInfo11Out v11, ArGetServerInfo12Out v12) {
        this.mapArControlStructToV12(v11.control, v12.control);
        v12.serverInfoList = v11.serverInfoList;
        v12.status = v11.status;
    }

    private ArCreateFilter11In mapArCreateFilterInToV11(ArCreateFilter12In in) {
        return new ArCreateFilter11In(this.mapArControlStructToV11(in.control), in.name, in.order, in.workflowConnect, in.opSet, in.enable, in.query, in.actionList, in.elseList, in.helpText, in.owner, in.changeDiary, in.objPropList);
    }

    private ArSetFilter11In mapArSetFilterInToV11(ArSetFilter12In in) {
        return new ArSetFilter11In(this.mapArControlStructToV11(in.control), in.name, in.mask, in.newName, in.order, in.workflowConnect, in.opSet, in.enable, in.query, in.actionList, in.elseList, in.helpText, in.owner, in.changeDiary, in.objPropList);
    }

    private ArNameMask11In mapArNameMaskInToV11(ArNameMask12In v12) {
        return new ArNameMask11In(this.mapArControlStructToV11(v12.control), v12.name, v12.mask);
    }

    private ArKeyExchangeBegin11In mapArKeyExchangeBeginInToV11(ArKeyExchangeBegin12In in) {
        return new ArKeyExchangeBegin11In(this.mapArControlStructToV11(in.control), in.clientRandBytes);
    }

    private ArKeyExchangeFinal11In mapArKeyExchangeFinalInToV11(ArKeyExchangeFinal12In in) {
        return new ArKeyExchangeFinal11In(this.mapArControlStructToV11(in.control), in.sessionId, in.getEncPreMasterKey());
    }

    private ArGetServerInfo11In mapArGetServerInfoInToV11(ArGetServerInfo12In in) {
        return new ArGetServerInfo11In(this.mapArControlStructToV11(in.control), in.requestList);
    }
}

