/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class MacAddressUtil {
    private static Logger LOGGER = Logger.getLogger(MacAddressUtil.class);
    private static String MAC_ADDRESS = null;

    public static String getMacAddress() {
        if (MAC_ADDRESS == null) {
            MAC_ADDRESS = MacAddressUtil.getMacAddressByOS();
        }
        return MAC_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getMacAddressByOS() {
        String macAddress;
        block17: {
            Process process = null;
            BufferedReader bufferedReader = null;
            InputStreamReader inputStreamReader = null;
            InputStream inputStream = null;
            macAddress = null;
            try {
                String osname = System.getProperty("os.name", "");
                if (osname.startsWith("Windows")) {
                    process = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                } else if (osname.startsWith("Solaris") || osname.startsWith("SunOS")) {
                    String hostName = MacAddressUtil.getFirstLineOfCommand("uname", "-n");
                    if (hostName != null) {
                        process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", hostName}, null);
                    }
                } else if (new File("/usr/sbin/lanscan").exists()) {
                    process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
                } else if (new File("/sbin/ifconfig").exists()) {
                    process = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                }
                if (process != null) {
                    inputStream = process.getInputStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader, 128);
                    String lineReturnFromCommand = null;
                    while ((lineReturnFromCommand = bufferedReader.readLine()) != null) {
                        macAddress = MacAddressUtil.parse(lineReturnFromCommand);
                        if ((macAddress = MacAddressUtil.getHexCharsOnly(macAddress)) == null) continue;
                    }
                }
                MacAddressUtil.closeInputStream(inputStream);
            }
            catch (SecurityException ex) {
                LOGGER.warn("Fail to read Mac address from OS");
                break block17;
            }
            catch (IOException ex2) {
                LOGGER.warn("Fail to read Mac address from OS");
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                MacAddressUtil.closeInputStream(inputStream);
                MacAddressUtil.closeProccess(process, bufferedReader, inputStreamReader);
            }
            MacAddressUtil.closeProccess(process, bufferedReader, inputStreamReader);
        }
        return macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstLineOfCommand(String ... commands) throws IOException {
        String string;
        Process process = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        InputStream inputStream = null;
        try {
            process = Runtime.getRuntime().exec(commands);
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader, 128);
            string = bufferedReader.readLine();
        }
        catch (Throwable throwable) {
            MacAddressUtil.closeInputStream(inputStream);
            MacAddressUtil.closeProccess(process, bufferedReader, inputStreamReader);
            throw throwable;
        }
        MacAddressUtil.closeInputStream(inputStream);
        MacAddressUtil.closeProccess(process, bufferedReader, inputStreamReader);
        return string;
    }

    static String parse(String lineReturnFromCommand) {
        String out = lineReturnFromCommand;
        int hexStart = out.indexOf("0x");
        if (hexStart != -1 && out.indexOf("ETHER") != -1) {
            int hexEnd = out.indexOf(32, hexStart);
            if (hexEnd > hexStart + 2) {
                out = out.substring(hexStart, hexEnd);
            }
        } else {
            int lastIndex;
            int octets = 0;
            if (out.indexOf(45) > -1) {
                out = out.replace('-', ':');
            }
            if ((lastIndex = out.lastIndexOf(58)) > out.length() - 2) {
                out = null;
            } else {
                int end = Math.min(out.length(), lastIndex + 3);
                ++octets;
                int old = lastIndex;
                while (octets != 5 && lastIndex != -1 && lastIndex > 1) {
                    --lastIndex;
                    if (old - (lastIndex = out.lastIndexOf(58, lastIndex)) != 3 && old - lastIndex != 2) continue;
                    ++octets;
                    old = lastIndex;
                }
                out = octets == 5 && lastIndex > 1 ? out.substring(lastIndex - 2, end).trim() : null;
            }
        }
        if (out != null && out.startsWith("0x")) {
            out = out.substring(2);
        }
        return out;
    }

    public static String getHexCharsOnly(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c) && !Character.isLetter(c)) continue;
            builder.append(c);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    private static void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Fail to close process InputStream()", ex);
        }
    }

    private static void closeProccess(Process process, BufferedReader bufferedReader, InputStreamReader inputStreamReader) {
        if (process != null) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Fail to close BufferedReader", ex);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Fail to close InputStreamReader", ex);
                }
            }
            try {
                process.getErrorStream().close();
            }
            catch (IOException ex) {
                LOGGER.warn("Fail to close process ErrorStream", ex);
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException ex) {
                LOGGER.warn("Fail to close process OutputStream()", ex);
            }
            try {
                process.getInputStream().close();
            }
            catch (IOException ex) {
                LOGGER.warn("Fail to close process InputStream()", ex);
            }
            process.destroy();
        }
    }
}

