/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.internal;

import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.regex.Pattern;

public final class ConversionUtil {
    static Method decimalToPlainStringMethod;

    public static boolean getBooleanValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String strVal = ConversionUtil.getStringValue(obj);
        if (strVal.compareToIgnoreCase("true") == 0) {
            return true;
        }
        if (strVal.compareToIgnoreCase("false") == 0) {
            return false;
        }
        return ConversionUtil.getIntValue(obj) != 0;
    }

    public static char getCharValue(Object obj) {
        if (obj == null) {
            return '\u0000';
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof Number) {
            return (char)((Number)obj).intValue();
        }
        String strVal = ConversionUtil.getStringValue(obj);
        if (strVal != null && strVal.length() > 0) {
            return strVal.charAt(0);
        }
        return '\u0000';
    }

    public static byte getByteValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        return (byte)ConversionUtil.getIntValue(obj);
    }

    public static short getShortValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Short) {
            return (short)((Short)obj).intValue();
        }
        return (short)ConversionUtil.getIntValue(obj);
    }

    public static int getIntValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof Character) {
            return Character.getNumericValue(((Character)obj).charValue());
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof Time) {
            return (int)((Time)obj).getValue();
        }
        if (obj instanceof DateInfo) {
            return ((DateInfo)obj).getValue();
        }
        if (obj instanceof Timestamp) {
            return (int)((Timestamp)obj).getValue();
        }
        String strVal = null;
        int val = 0;
        if (obj instanceof Array) {
            strVal = ConversionUtil.getStringValue(obj);
        } else if (obj instanceof String) {
            strVal = (String)obj;
        }
        if (strVal != null) {
            try {
                val = Integer.parseInt(strVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return val;
        }
        if (obj instanceof Void) {
            return 0;
        }
        return 0;
    }

    public static long getLongValue(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        String strVal = null;
        long val = 0L;
        if (obj instanceof Array) {
            strVal = ConversionUtil.getStringValue(obj);
        } else if (obj instanceof String) {
            strVal = (String)obj;
        }
        if (strVal != null) {
            try {
                val = Long.parseLong(strVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return val;
        }
        return ConversionUtil.getIntValue(obj);
    }

    public static float getFloatValue(Object obj) {
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        String strVal = null;
        float val = 0.0f;
        if (obj instanceof Array) {
            strVal = ConversionUtil.getStringValue(obj);
        } else if (obj instanceof String) {
            strVal = (String)obj;
        }
        if (strVal != null) {
            try {
                val = Float.parseFloat(strVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return val;
        }
        return ConversionUtil.getIntValue(obj);
    }

    private static boolean isValidDouble(String strVal) {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", strVal);
    }

    public static double getDoubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        String strVal = null;
        double val = 0.0;
        if (obj instanceof Array) {
            strVal = ConversionUtil.getStringValue(obj);
        } else if (obj instanceof String) {
            strVal = (String)obj;
        }
        if (strVal != null && ConversionUtil.isValidDouble(strVal)) {
            val = Double.parseDouble(strVal);
            return val;
        }
        return ConversionUtil.getIntValue(obj);
    }

    public static BigDecimal getBigDecimalValue(Object obj) {
        if (obj == null) {
            return new BigDecimal(0);
        }
        if (obj instanceof Double) {
            return new BigDecimal(ConversionUtil.getDoubleValue(obj));
        }
        BigDecimal val = new BigDecimal(0);
        String strVal = null;
        if (obj instanceof Array) {
            strVal = ConversionUtil.getStringValue(obj);
        } else if (obj instanceof String) {
            strVal = (String)obj;
        }
        if (strVal != null && strVal.length() > 0) {
            try {
                val = new BigDecimal(strVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return val;
    }

    private static String decimalToString(BigDecimal val) {
        if (decimalToPlainStringMethod != null) {
            try {
                return (String)decimalToPlainStringMethod.invoke((Object)val, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return val.toString();
    }

    public static String getStringValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Array) {
            Object elem = Array.get(obj, 0);
            if (elem instanceof Character) {
                return new String((char[])obj);
            }
            if (elem instanceof Byte) {
                return new String((byte[])obj);
            }
        } else if (obj instanceof BigDecimal) {
            return ConversionUtil.decimalToString((BigDecimal)obj);
        }
        return obj.toString();
    }

    public static int getARTimestamp(Timestamp timestamp) {
        int retVal = 0;
        if (timestamp != null) {
            retVal = (int)timestamp.getValue();
        }
        return retVal;
    }

    public static int getARTimestamp(Date val) {
        int retVal = 0;
        if (val != null) {
            retVal = (int)(val.getTime() / 1000L);
        }
        return retVal;
    }

    public static Date getSqlDateValue(long elapsedSeconds) {
        if (elapsedSeconds > 0L) {
            return new Date(elapsedSeconds * 1000L);
        }
        return new Date(0L);
    }

    public static Date getSqlDateValue(Object val) {
        return ConversionUtil.getSqlDateValue(ConversionUtil.getIntValue(val));
    }

    public static Date getSqlDateValue(int aryear, int armonth, int arday) {
        if (aryear < 0 || armonth < 0 || arday <= 0) {
            return ConversionUtil.getSqlDateValue(0L);
        }
        return new Date(aryear, armonth, arday);
    }

    static {
        try {
            decimalToPlainStringMethod = BigDecimal.class.getMethod("toPlainString", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

