/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.apiconverter;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorFactory;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.ARFileHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;

public class ArAttachmentInfo
extends AttachmentValue {
    private static final long serialVersionUID = 6908983855912202231L;
    public static int NO_ACTION = 0;
    public static int COMPRESS = 1;
    public static int UNCOMPRESS = 2;
    public static int CONVERT_CHARSET = 3;
    private int _fileAction = NO_ACTION;

    public ArAttachmentInfo(AttachmentValue attInfo, int compressAction) throws ARException {
        this(attInfo, "utf-8", compressAction);
    }

    public ArAttachmentInfo(AttachmentValue attInfo, int procedureNumber, String serverCharSetName) throws ARException {
        this(attInfo, serverCharSetName, ARChunkProcessorFactory.isChunkingSupportedCall(procedureNumber) ? UNCOMPRESS : COMPRESS);
    }

    public ArAttachmentInfo(AttachmentValue attInfo, String serverCharSetName, int compressAction) throws ARException {
        this._fileAction = compressAction;
        this.setName(attInfo.getName());
        if (this._fileAction == COMPRESS) {
            if (attInfo.getValueFileName() != null) {
                this.compress(attInfo.getValueFileName());
            } else {
                this.compress(attInfo.getValue());
            }
            this.setOriginalSize(attInfo.getOriginalSize());
        } else if (this._fileAction == UNCOMPRESS) {
            if (attInfo.getValueFileName() != null) {
                this.decompress(attInfo.getValueFileName());
                attInfo.setName(attInfo.getValueFileName());
            } else {
                this.decompress(attInfo.getValue());
            }
        } else if (attInfo.getValueFileName() != null) {
            this.processAttachmentFile(serverCharSetName);
        }
    }

    public ArAttachmentInfo(String name, long nOrigSize, long nCompSize, byte[] byteloc, int compressionAction) throws ARException {
        super(name, byteloc);
        this._fileAction = compressionAction;
        if (compressionAction == COMPRESS) {
            this.compress(byteloc);
        } else if (compressionAction == UNCOMPRESS) {
            this.decompress(byteloc);
        }
    }

    public ArAttachmentInfo(String name, long nOrigSize, long nCompSize, String fileloc, int compressAction) throws ARException, IOException {
        super(name, fileloc);
        this._fileAction = compressAction;
        if (compressAction == COMPRESS) {
            this.compress(fileloc);
        } else if (compressAction == UNCOMPRESS) {
            this.decompress(fileloc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(byte[] input) {
        ARCompressor compresser = new ARCompressor();
        ARByteArrayBuffer buf = new ARByteArrayBuffer();
        try {
            compresser.setInput(input);
            int len = compresser.deflate(buf);
            this.setValue(buf.getBuffer());
            this.setCompressedSize(len);
        }
        finally {
            buf.setBuffer(null);
            buf = null;
            compresser = null;
        }
    }

    private void decompress(byte[] input) throws ARException {
        ARDecompressor decompresser = new ARDecompressor();
        try {
            decompresser.setInput(input);
            byte[] output = decompresser.inflate();
            this.setValue(output);
        }
        catch (DataFormatException e) {
            throw new ARException(2, 160, e.getMessage());
        }
        finally {
            decompresser.end();
            decompresser = null;
        }
    }

    private void compress(String ifilename) throws ARException {
        ARCompressor compresser = new ARCompressor();
        File orgFile = new File(ifilename);
        ARByteArrayBuffer buf = new ARByteArrayBuffer();
        try {
            compresser.setInput(orgFile);
            int len = compresser.deflate(buf);
            this.setValue(buf.getBuffer());
            this.setCompressedSize(len);
        }
        catch (IOException e) {
            throw new ARException(2, 8936, e.getMessage());
        }
        finally {
            buf.setBuffer(null);
            buf = null;
            compresser = null;
        }
    }

    private void decompress(String ofileloc) throws ARException {
        ARDecompressor decompresser = new ARDecompressor();
        File oFile = new File(ofileloc);
        try {
            decompresser.setInput(this.getValue());
            decompresser.inflate(oFile);
        }
        catch (DataFormatException e) {
            throw new ARException(2, 160, e.getMessage());
        }
        catch (IOException e) {
            throw new ARException(2, 301, e.getMessage());
        }
        finally {
            decompresser.end();
            decompresser = null;
        }
    }

    private void processAttachmentFile(String serverCharSetName) throws ARException {
        if (this.getValue() != null) {
            this.saveToFile();
        } else if (CONVERT_CHARSET == this._fileAction) {
            this.readAndConvertTextFile(serverCharSetName);
        } else {
            this.readFromFile();
        }
    }

    private void saveToFile() throws ARException {
        if (this.getValue() != null) {
            try {
                ARFileHandler.writeBytesIntoFile(this.getValue(), this.getValueFileName());
            }
            catch (IOException e) {
                throw new ARException(2, 301, e.getMessage());
            }
        }
    }

    private void readAndConvertTextFile(String serverCharSet) throws ARException {
        try {
            this.setValue(ARFileHandler.readAndConvertTextFile(this.getValueFileName(), serverCharSet));
        }
        catch (UnsupportedEncodingException e1) {
            throw new ARException(2, 450, e1.getMessage());
        }
        catch (IOException e) {
            throw new ARException(2, 451, e.getMessage());
        }
    }

    private void readFromFile() throws ARException {
        try {
            this.setValue(ARFileHandler.readBytesFromFile(this.getValueFileName()));
        }
        catch (IOException e1) {
            throw new ARException(2, 450, e1.getMessage());
        }
    }
}

