/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.apitransport.ApiValueBase;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Value
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8176908615342565971L;
    protected DataType _dataType;
    protected Object _value;

    public Value() {
        this._value = null;
        this._dataType = DataType.NULL;
    }

    public Value(String stringRepresentation, DataType valueType) {
        switch (valueType.toInt()) {
            case 2: {
                this._value = new Integer(stringRepresentation.trim());
                this._dataType = DataType.INTEGER;
                break;
            }
            case 3: {
                this._value = new Double(stringRepresentation.trim());
                this._dataType = DataType.REAL;
                break;
            }
            case 4: {
                this._value = stringRepresentation;
                this._dataType = DataType.CHAR;
                break;
            }
            case 7: {
                long l = ConversionUtil.getLongValue(stringRepresentation);
                this._value = new Timestamp(l);
                this._dataType = DataType.TIME;
                break;
            }
            case 8: {
                this._value = new Long(stringRepresentation);
                this._dataType = DataType.BITMASK;
                break;
            }
            case 14: {
                this._value = new Time(stringRepresentation);
                this._dataType = DataType.TIME_OF_DAY;
                break;
            }
            case 10: {
                if (".".equals(stringRepresentation)) {
                    stringRepresentation = "0";
                }
                this._value = new BigDecimal(stringRepresentation);
                this._dataType = DataType.DECIMAL;
                break;
            }
            case 40: {
                this._value = new Long(stringRepresentation.trim());
                this._dataType = DataType.ULONG;
                break;
            }
            case 6: {
                this._value = new Integer(stringRepresentation.trim());
                this._dataType = DataType.ENUM;
                break;
            }
            case 42: {
                this._value = stringRepresentation;
                this._dataType = DataType.VIEW;
                break;
            }
            case 43: {
                this._value = stringRepresentation;
                this._dataType = DataType.DISPLAY;
                break;
            }
            case 13: {
                this._value = new DateInfo(stringRepresentation);
                this._dataType = DataType.DATE;
                break;
            }
            case 12: {
                this._value = new CurrencyValue(stringRepresentation);
                this._dataType = DataType.CURRENCY;
                break;
            }
            case 33: {
                this._value = new Integer(stringRepresentation.trim());
                this._dataType = DataType.INTEGER;
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by this method. The datatype is " + valueType.toInt());
            }
        }
    }

    public Value(Keyword v) {
        this._value = v;
        this._dataType = DataType.KEYWORD;
    }

    public Value(int v) {
        this._value = new Integer(v);
        this._dataType = DataType.INTEGER;
    }

    public Value(double v) {
        this._value = new Double(v);
        this._dataType = DataType.REAL;
    }

    public Value(String v) {
        this._value = v;
        this._dataType = DataType.CHAR;
    }

    public Value(DiaryListValue v) {
        this._value = v;
        this._dataType = DataType.DIARY;
    }

    public Value(long l) {
        this._value = new Long(l);
        this._dataType = DataType.ULONG;
    }

    public Value(ByteListValue b) {
        this._value = b;
        this._dataType = DataType.BYTES;
    }

    public Value(Timestamp v) {
        this._value = v;
        this._dataType = DataType.TIME;
    }

    public Value(Time v) {
        this._value = v;
        this._dataType = DataType.TIME_OF_DAY;
    }

    public Value(BigDecimal bd) {
        this._value = bd;
        this._dataType = DataType.DECIMAL;
    }

    public Value(CurrencyValue c) {
        this._value = c;
        this._dataType = DataType.CURRENCY;
    }

    public Value(DateInfo d) {
        this._value = d;
        this._dataType = DataType.DATE;
    }

    public Value(AttachmentValue v) {
        this._value = v;
        this._dataType = DataType.ATTACHMENT;
    }

    public Value(List<CoordinateInfo> v) {
        this._value = v;
        this._dataType = DataType.COORDS;
    }

    Value(ApiValueBase v) {
        this._value = v.getValue();
        this._dataType = v.getDataType();
    }

    Value(int nType, long l) {
        this(l, DataType.toDataType(nType));
    }

    Value(int nType, String str) {
        DataType dataType = DataType.toDataType(nType);
        if (!(dataType.equals(DataType.DECIMAL) || dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY))) {
            throw new IllegalArgumentException("datatype should be decimal, view or display");
        }
        if (dataType.equals(DataType.DECIMAL)) {
            if (".".equals(str)) {
                str = "0";
            }
            this._value = new BigDecimal(str);
        } else if (dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY)) {
            this._value = str;
        }
        this._dataType = DataType.toDataType(nType);
    }

    void setKeyword(int n) {
        this._dataType = DataType.KEYWORD;
        this._value = Keyword.toKeyword(n);
    }

    public Object getValue() {
        return this._value;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    int getType() {
        return this._dataType.toInt();
    }

    public int getIntValue() {
        return ((Number)this._value).intValue();
    }

    int getKeywordValue() {
        return ((Keyword)this._value).toInt();
    }

    public double getDoubleValue() {
        return ((Number)this._value).doubleValue();
    }

    long getLongValue() {
        return ((Number)this._value).longValue();
    }

    int getEnumValue() {
        return ((Number)this._value).intValue();
    }

    long getTimestampValue() {
        return ((Timestamp)this._value).getValue();
    }

    long getTimeValue() {
        return ((Time)this._value).getValue();
    }

    int getDateValue() {
        return ((DateInfo)this._value).getValue();
    }

    String getDiaryValue() {
        if (this._value instanceof DiaryListValue) {
            return ((DiaryListValue)this._value).toString();
        }
        if (this._value instanceof String) {
            return (String)this._value;
        }
        return this._value != null ? this._value.toString() : null;
    }

    String getDecimalStringValue() {
        return ConversionUtil.getStringValue((BigDecimal)this._value);
    }

    public String getCurrencyValue() {
        return ((CurrencyValue)this._value).getValue().toString();
    }

    public String toString() {
        if (null == this._value) {
            return null;
        }
        return this._value.toString();
    }

    public Value(Object val, DataType dt) {
        this._value = this.changeEnumValueIfNeeded(val, dt);
        this._dataType = dt;
    }

    private Object changeEnumValueIfNeeded(Object l, DataType dt) {
        Object v = dt.equals(DataType.ENUM) && l instanceof Number && !(l instanceof Integer) ? new Integer(((Number)l).intValue()) : l;
        return v;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Value otherValue = (Value)obj;
        if (this._dataType == null && otherValue.getDataType() != null || this._dataType != null && otherValue.getDataType() == null) {
            return false;
        }
        if (this._dataType == null && otherValue.getDataType() == null) {
            return this._value == null ? otherValue.getValue() == null : this._value.equals(otherValue.getValue());
        }
        if (this._dataType != null && !this._dataType.equals(otherValue.getDataType())) {
            return false;
        }
        switch (this._dataType.toInt()) {
            case 0: {
                return true;
            }
            default: {
                return this._value.equals(otherValue.getValue());
            }
            case 6: {
                return this._value.equals(new Integer(ConversionUtil.getIntValue(otherValue.getValue())));
            }
            case 2: {
                return this._value.equals(ConversionUtil.getIntValue(otherValue.getValue()));
            }
            case 4: 
            case 5: {
                return this._value == null ? otherValue.getValue() == null : this._value.equals(otherValue.getValue());
            }
            case 10: 
        }
        return ((BigDecimal)this._value).compareTo((BigDecimal)otherValue.getValue()) == 0;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append(this._dataType);
        builder.append(this._value);
        return builder.toHashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        Value val = (Value)super.clone();
        switch (this.getDataType().toInt()) {
            case 1: {
                val.setValue(this._value);
                break;
            }
            case 2: {
                val.setValue(new Integer(this.getIntValue()));
                break;
            }
            case 3: {
                val.setValue(new Double(this.getDoubleValue()));
                break;
            }
            case 4: {
                val.setValue(this._value);
                break;
            }
            case 5: {
                if (this._value == null) break;
                if (this._value instanceof DiaryListValue) {
                    val.setValue(((DiaryListValue)this._value).clone());
                    break;
                }
                if (!(this._value instanceof String)) break;
                val.setValue(this._value);
                break;
            }
            case 6: {
                val.setValue(new Integer(this.getIntValue()));
                break;
            }
            case 7: {
                if (this._value == null) break;
                val.setValue(((Timestamp)this._value).clone());
                break;
            }
            case 8: {
                val.setValue(new Long(this.getLongValue()));
                break;
            }
            case 9: {
                if (this._value == null) break;
                val.setValue(((ByteListValue)this._value).clone());
                break;
            }
            case 10: {
                val.setValue(new BigDecimal(((BigDecimal)this._value).toString()));
                break;
            }
            case 11: {
                if (this._value == null) break;
                val.setValue(((AttachmentValue)this._value).clone());
                break;
            }
            case 12: {
                if (this._value == null) break;
                val.setValue(((CurrencyValue)this._value).clone());
                break;
            }
            case 13: {
                if (this._value == null) break;
                val.setValue(((DateInfo)this._value).clone());
                break;
            }
            case 14: {
                if (this._value == null) break;
                val.setValue(((Time)this._value).clone());
                break;
            }
            case 40: {
                val.setValue(new Long(this.getLongValue()));
                break;
            }
            case 41: {
                if (this._value == null) break;
                ArrayList<CoordinateInfo> vnew = new ArrayList<CoordinateInfo>(((List)this._value).size());
                List current = (List)this._value;
                for (int iLoop = 0; iLoop < current.size(); ++iLoop) {
                    CoordinateInfo element = (CoordinateInfo)current.get(iLoop);
                    vnew.add(iLoop, (CoordinateInfo)element.clone());
                }
                val.setValue(vnew);
                break;
            }
            case 42: {
                val.setValue(this._value);
                break;
            }
            case 43: {
                val.setValue(this._value);
                break;
            }
            default: {
                val.setValue(null);
            }
        }
        return val;
    }

    private void setDataType(DataType dt) {
        this._dataType = dt;
    }

    private void setValue(Object obj) {
        this._value = obj;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        DataType typ = DataType.toDataType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0)));
        this.setDataType(typ);
        Object val = ARTypeMgr.GetAt((Object)rawData, 1);
        switch (typ.toInt()) {
            case 0: {
                break;
            }
            case 2: 
            case 6: {
                this._value = ConversionUtil.getIntValue(val);
                break;
            }
            case 3: {
                this._value = ConversionUtil.getDoubleValue(val);
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                this._value = val;
                break;
            }
            case 5: {
                String strValue = ConversionUtil.getStringValue(val);
                if (strValue != null && strValue.length() > 0) {
                    try {
                        this._value = DiaryListValue.decode(strValue);
                    }
                    catch (ARException e) {
                        this._value = val;
                    }
                    break;
                }
                this._value = val;
                break;
            }
            case 13: {
                int intValue = ConversionUtil.getIntValue(val);
                this._value = new DateInfo(intValue);
                break;
            }
            case 7: {
                long l = ConversionUtil.getLongValue(val);
                this._value = new Timestamp(l);
                break;
            }
            case 8: {
                long l = ConversionUtil.getLongValue(val);
                this._value = new Long(l);
                break;
            }
            case 14: {
                long l = ConversionUtil.getLongValue(val);
                this._value = new Time(l);
                break;
            }
            case 10: {
                this._value = new BigDecimal(val.toString());
                break;
            }
            case 40: {
                this._value = ConversionUtil.getLongValue(val);
                break;
            }
            case 12: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(CurrencyValue.class, val, ctx);
                break;
            }
            case 1: {
                this._value = Keyword.toKeyword(ConversionUtil.getIntValue(val));
                break;
            }
            case 11: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(AttachmentValue.class, val, ctx);
                break;
            }
            case 41: {
                this._value = ARTypeMgr.getInstance().ObjectListFromVariant(CoordinateInfo.class, val, ctx);
                break;
            }
            case 9: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(ByteListValue.class, val, ctx);
                break;
            }
            case 33: {
                this._value = val;
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by this method");
            }
        }
    }

    static Value createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        Value obj = new Value();
        if (rawData.length == 2 && rawData[0] != null) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[2];
        int typ = this.getDataType().toInt();
        var[0] = new Integer(typ);
        var[1] = typ == 1 ? new Integer(this.getKeywordValue()) : ARTypeMgr.getInstance().ObjectToVariant(this._value, ctx);
        return var;
    }

    private static int getARTimestamp(java.util.Date date) {
        return (int)(date.getTime() / 1000L);
    }

    private static java.util.Date getDateTime(int arTime) {
        Date date = new Date(arTime * 1000);
        return date;
    }

    private static boolean isKeyword(int val) {
        return val != 53;
    }

    private static int toKeyword(String str) {
        int keyword = 53;
        if (str.startsWith("$-") && str.endsWith("$")) {
            String kwPartStr = str.substring(2, str.length() - 3);
            keyword = ConversionUtil.getIntValue(kwPartStr);
        }
        return keyword;
    }

    public static Object ConvertToARValue(Object val) {
        Object[] arVal = new Object[2];
        if (val instanceof Object[] && ((Object[])val).length == 2) {
            arVal[0] = ((Object[])val)[0];
            arVal[1] = ((Object[])val)[1];
            if (arVal[1] instanceof java.util.Date) {
                arVal[1] = Value.getARTimestamp((java.util.Date)arVal[1]);
            } else if (arVal[1] instanceof BigDecimal) {
                arVal[1] = arVal[1].toString();
            } else if (arVal[1] instanceof AttachmentValue) {
                arVal[0] = 11;
                Object temp = ARTypeMgr.getInstance().ObjectToVariant(arVal[1], null);
                byte[] content = ((AttachmentValue)arVal[1]).getContent();
                ((Object[])temp)[3] = new Object[]{2, new Object[]{content.length, content}};
                arVal[1] = temp;
            } else if (arVal[1] instanceof CurrencyValue) {
                arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(arVal[1], null);
            } else if (arVal[1] instanceof DiaryListValue) {
                arVal[1] = ((DiaryListValue)arVal[1]).encode();
            } else if (arVal[1] instanceof StatusHistoryValue) {
                arVal[0] = 4;
                arVal[1] = ((StatusHistoryValue)arVal[1]).encode();
            } else if (arVal[1] instanceof ByteListValue) {
                arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(arVal[1], null);
            }
        } else if (val instanceof Integer) {
            arVal[0] = 2;
            arVal[1] = val;
        } else if (val instanceof String) {
            int keyword = Value.toKeyword((String)val);
            if (Value.isKeyword(keyword)) {
                arVal[0] = 1;
                arVal[1] = keyword;
            } else {
                arVal[0] = 4;
                arVal[1] = val;
            }
        } else if (val instanceof Double) {
            arVal[0] = 3;
            arVal[1] = val;
        } else if (val instanceof java.util.Date) {
            arVal[0] = 7;
            arVal[1] = Value.getARTimestamp((java.util.Date)val);
        } else if (val instanceof BigDecimal) {
            arVal[0] = 10;
            arVal[1] = val.toString();
        } else if (val instanceof AttachmentValue) {
            arVal[0] = 11;
            arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(val, null);
            byte[] content = ((AttachmentValue)val).getContent();
            ((Object[])arVal[1])[3] = new Object[]{2, new Object[]{content.length, content}};
        } else if (val instanceof CurrencyValue) {
            arVal[0] = 12;
            arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(val, null);
        } else if (val instanceof DiaryListValue) {
            arVal[0] = 5;
            arVal[1] = ((DiaryListValue)val).encode();
        } else if (val instanceof StatusHistoryValue) {
            arVal[0] = 4;
            arVal[1] = ((StatusHistoryValue)val).encode();
        } else if (val instanceof ByteListValue) {
            arVal[0] = 9;
            arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(val, null);
        } else if (val instanceof byte[] && ((byte[])val).length > 0) {
            arVal[0] = 9;
            arVal[1] = val;
        } else if (val instanceof Long) {
            arVal[0] = 40;
            arVal[1] = val;
        } else if (val instanceof ArrayList && ((ArrayList)val).size() > 0 && ((ArrayList)val).get(0) instanceof CoordinateInfo) {
            arVal[0] = 41;
            arVal[1] = ARTypeMgr.getInstance().ObjectToVariant(val, null);
        } else {
            arVal[0] = 0;
            arVal[1] = null;
        }
        return arVal;
    }

    public static int getARValueType(Object val) {
        int arTyp = 0;
        arTyp = val instanceof Object[] && ((Object[])val).length == 2 ? ConversionUtil.getIntValue(((Object[])val)[0]) : (val instanceof Integer ? 2 : (val instanceof String ? (Value.isKeyword(Value.toKeyword((String)val)) ? 1 : 4) : (val instanceof Double ? 3 : (val instanceof java.util.Date ? 7 : (val instanceof BigDecimal ? 10 : (val instanceof Long ? 40 : (val instanceof AttachmentValue ? 11 : (val instanceof ArrayList && ((ArrayList)val).get(0) instanceof CoordinateInfo ? 41 : (val instanceof CurrencyValue ? 12 : (val instanceof DiaryListValue ? 5 : (val instanceof byte[] ? 9 : 0)))))))))));
        return arTyp;
    }

    public static Object convertFromARValue(Object[] arValue, boolean isStatusHistory, boolean preserveEnumTypeInfo) {
        if (arValue == null || arValue.length < 2) {
            return null;
        }
        int arTyp = Value.getARValueType(arValue);
        switch (arTyp) {
            case 0: {
                return null;
            }
            case 1: {
                return String.format("$-%d$", ConversionUtil.getIntValue(arValue[1]));
            }
            case 2: {
                return ConversionUtil.getIntValue(arValue[1]);
            }
            case 3: {
                return ConversionUtil.getDoubleValue(arValue[1]);
            }
            case 4: {
                if (isStatusHistory) {
                    try {
                        return StatusHistoryValue.decode(arValue[1].toString().trim());
                    }
                    catch (ARException e) {
                        return arValue[1].toString();
                    }
                }
                return arValue[1].toString();
            }
            case 5: {
                try {
                    DiaryListValue diaryList = DiaryListValue.decode(arValue[1].toString());
                    return diaryList;
                }
                catch (ARException e) {
                    return arValue[1];
                }
            }
            case 6: {
                if (preserveEnumTypeInfo) {
                    return arValue;
                }
                return ConversionUtil.getIntValue(arValue[1]);
            }
            case 7: {
                if (arValue[1] instanceof java.util.Date) {
                    return arValue[1];
                }
                return Value.getDateTime(ConversionUtil.getIntValue(arValue[1]));
            }
            case 8: {
                return arValue[1];
            }
            case 9: {
                return ARTypeMgr.getInstance().ObjectFromVariant(ByteListValue.class, arValue[1], null);
            }
            case 10: {
                return ConversionUtil.getBigDecimalValue(arValue[1]);
            }
            case 11: {
                if (arValue[1] instanceof AttachmentValue) {
                    return arValue[1];
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(AttachmentValue.class, arValue[1], null);
            }
            case 12: {
                if (arValue[1] instanceof CurrencyValue) {
                    return arValue[1];
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(CurrencyValue.class, arValue[1], null);
            }
            case 13: {
                if (arValue[1] instanceof Date) {
                    Date date = (Date)arValue[1];
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    return DateInfo.dateToJulianDate(cal.get(1), cal.get(2), cal.get(6));
                }
                return ConversionUtil.getIntValue(arValue[1]);
            }
            case 14: {
                return ConversionUtil.getIntValue(arValue[1]);
            }
            case 33: {
                return arValue;
            }
            case 40: {
                return ConversionUtil.getLongValue(arValue[1]);
            }
            case 41: {
                return ARTypeMgr.getInstance().ObjectListFromVariant(CoordinateInfo.class, arValue[1], null);
            }
            case 42: 
            case 43: {
                return arValue;
            }
        }
        return null;
    }

    protected String valueToString() throws ARException {
        if (this.getValue() == null) {
            return new String();
        }
        switch (this.getType()) {
            case 0: {
                return new String();
            }
            case 2: 
            case 3: 
            case 6: {
                return Integer.valueOf(this.getIntValue()).toString();
            }
            case 4: 
            case 5: 
            case 10: {
                return this.getValue().toString();
            }
            case 7: {
                return Long.valueOf(this.getTimestampValue()).toString();
            }
            case 13: {
                return ((DateInfo)this._value).toString();
            }
            case 14: {
                return ((Time)this._value).toString();
            }
            case 12: {
                CurrencyValue cur = (CurrencyValue)this.getValue();
                return new String(cur.getValueString() + " " + cur.getCurrencyCode());
            }
        }
        return new String();
    }

    static Value deserializeFromBytesBuffer(byte[] buffer, int beginIndex, int length, int dataType, String serverCharSetName, OutputInteger javaLen) throws ARException {
        Value value;
        String valueStr = null;
        if (serverCharSetName == null) {
            serverCharSetName = "utf-8";
        }
        try {
            valueStr = new String(buffer, beginIndex, length, serverCharSetName);
            if (serverCharSetName.equals("EUC_JP")) {
                valueStr = new String(valueStr.getBytes("SJIS"), "windows-31j");
            }
            if (javaLen != null) {
                javaLen.setValue(valueStr.length());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ARException(2, 9062, e.getMessage());
        }
        switch (dataType) {
            case 12: {
                value = new Value(CurrencyValue.deserializeFromObjectStr(valueStr), DataType.toDataType(dataType));
                break;
            }
            case 3: {
                value = new Value(RealField.deserializeFromObjectStr(valueStr), DataType.toDataType(dataType));
                break;
            }
            case 11: {
                value = new Value(AttachmentValue.deserializeFromObjectStr(valueStr), DataType.toDataType(dataType));
                break;
            }
            case 9: {
                value = new Value(ByteListValue.deserializeFromObjectStr(valueStr));
                break;
            }
            case 5: {
                try {
                    value = new Value(DiaryListValue.decode(valueStr));
                }
                catch (ARException ex) {
                    value = new Value((Object)valueStr, DataType.DIARY);
                }
                break;
            }
            default: {
                value = new Value(valueStr, DataType.toDataType(dataType));
            }
        }
        return value;
    }
}

