/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.File;
import java.io.Serializable;

public class SupportFile
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8203462388188648918L;
    private SupportFileKey m_key;
    private Timestamp m_lastUpdateTime;
    private String m_fileNameWithPath;

    public SupportFile() {
        this.m_lastUpdateTime = new Timestamp();
    }

    public SupportFile(int fileType, String name, int fieldId, int fileId, String fileNameWithPath, long lastUpdateTime) {
        this.setFilePath(fileNameWithPath);
        this.setKey(new SupportFileKey(fileType, name, fieldId, fileId));
        this.m_lastUpdateTime = new Timestamp(lastUpdateTime);
    }

    public SupportFileKey getKey() {
        return this.m_key;
    }

    public void setKey(SupportFileKey key) {
        this.m_key = key;
    }

    public String getFilePath() {
        return this.m_fileNameWithPath;
    }

    public void setFilePath(String fileNameWithPath) {
        this.m_fileNameWithPath = fileNameWithPath;
    }

    public Timestamp getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    public Object clone() throws CloneNotSupportedException {
        SupportFile obj = (SupportFile)super.clone();
        if (this.m_key != null) {
            obj.setKey((SupportFileKey)this.m_key.clone());
        }
        obj.m_fileNameWithPath = this.m_fileNameWithPath;
        if (this.m_lastUpdateTime != null) {
            obj.m_lastUpdateTime = (Timestamp)this.m_lastUpdateTime.clone();
        }
        return obj;
    }

    public void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        SupportFileKey key = new SupportFileKey();
        key.setFileType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        key.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        key.setFieldId(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 5)));
        key.setFileId(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 6)));
        this.setKey(key);
        this.m_lastUpdateTime = new Timestamp(ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)rawData, 8)));
    }

    public static String checkAndFillFilePath(ARServerUser ctx, int fileId, String filePath) {
        if (filePath == null || filePath.length() == 0) {
            filePath = String.format("%s%sSupportFile%d.sfl", ctx.getDefaultOutputDirectory() != null ? ctx.getDefaultOutputDirectory() : ".", File.separator, fileId);
        }
        return filePath;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Key", this.m_key).append("Last Update Time", this.m_lastUpdateTime).append("File Name With Path", this.m_fileNameWithPath).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_key).append(this.m_lastUpdateTime).append(this.m_fileNameWithPath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SupportFile)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SupportFile rhs = (SupportFile)obj;
        return new EqualsBuilder().append(this.m_key, rhs.m_key).append(this.m_lastUpdateTime, rhs.m_lastUpdateTime).append(this.m_fileNameWithPath, rhs.m_fileNameWithPath).isEquals();
    }
}

