/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import java.util.Hashtable;

public class Session {
    private String _primaryServerName;
    private String _secondaryServerName;
    private int _currentObjectType;
    private String _currentLocalForm;
    private String _currentRemoteForm;
    private int _currentActionIndex;
    private Hashtable<String, ARServerUser> _currentOpenWindowSampleServerForms;
    private int _currentFieldId;
    private Hashtable<String, ARServerUser> m_servers = new Hashtable();
    private static Session _defaultSession;

    public Session() {
        if (_defaultSession == null) {
            _defaultSession = this;
        }
    }

    public static Session getDefaultSession() {
        if (_defaultSession == null) {
            _defaultSession = new Session();
        }
        return _defaultSession;
    }

    static String makeServerName(String serverName, int tcpPort) {
        return String.format("%s%s%s", serverName, tcpPort != 0 ? ":" : "", tcpPort != 0 ? Integer.toString(tcpPort) : "");
    }

    public ARServerUser connectToServer(String serverName, int tcpPort, String authString, String user, String password, boolean ensureAdmin, boolean lockToadminQueue) throws ARException {
        String key = Session.makeServerName(serverName, tcpPort);
        if (!this.m_servers.containsKey(key)) {
            ARServerUser s = new ARServerUser(user, password, authString, "", serverName);
            s.setPort(tcpPort);
            s.login();
            if (lockToadminQueue) {
                s.useAdminRpcQueue();
            }
            boolean isAdmin = s.isAdministrator();
            if (ensureAdmin && !isAdmin) {
                throw new ARException(2, 304, "Not an administrator. Excepted Administrator user account.");
            }
            this.addServer(s);
        }
        return this.m_servers.get(key);
    }

    void addServer(ARServerUser server) {
        String key = Session.makeServerName(server.getServer(), server.getPort());
        if (this.m_servers.size() == 0) {
            this._primaryServerName = key;
        }
        this.m_servers.put(key, server);
        server.setSession(this);
    }

    void removeServer(ARServerUser server) {
        server.logout();
        String key = Session.makeServerName(server.getServer(), server.getPort());
        this.m_servers.remove(key);
        if (key.equals(this._primaryServerName)) {
            assert (this.m_servers.size() == 0) : "Possible Error : Primary server should be disconnected last.";
            this._primaryServerName = null;
        }
    }

    public void disconnectFromServer(String serverName, int tcpPort) {
        String key = Session.makeServerName(serverName, tcpPort);
        if (!this.m_servers.containsKey(key)) {
            return;
        }
        this.removeServer(this.m_servers.get(key));
    }

    public int count() {
        return this.m_servers.size();
    }

    public Hashtable getServers() {
        return this.m_servers;
    }

    public ARServerUser getServer(String serverName, int tcpPort, String authString, String user, String password, boolean ensureAdmin, boolean lockToadminQueue) throws ARException {
        if (serverName == null || serverName.equals(this._primaryServerName) || serverName.equals("@") || serverName.equals("*")) {
            return this.m_servers.get(this._primaryServerName);
        }
        String key = Session.makeServerName(serverName, tcpPort);
        if (!this.m_servers.containsKey(key)) {
            this.connectToServer(serverName, tcpPort, authString, user, password, ensureAdmin, lockToadminQueue);
        }
        return this.m_servers.get(key);
    }

    public ARServerUser getServer(String serverName, int tcpPort, String authString, boolean ensureAdmin, boolean lockToadminQueue) throws ARException {
        if (this._primaryServerName == null) {
            this._primaryServerName = serverName;
        }
        ARServerUser primary = this.m_servers.get(this._primaryServerName);
        return this.getServer(serverName, tcpPort, authString, primary.getUser(), primary.getPassword(), ensureAdmin, lockToadminQueue);
    }

    public ARServerUser getServer(String serverName, int tcpPort, String authString) throws ARException {
        return this.getServer(serverName, tcpPort, authString, false, false);
    }

    public ARServerUser getServer(String serverName, int tcpPort) throws ARException {
        return this.getServer(serverName, tcpPort, "", false, false);
    }

    public ARServerUser getServer(String serverName) throws ARException {
        return this.getServer(serverName, 0);
    }

    int getCurrentObjectType() {
        return this._currentObjectType;
    }

    void setCurrentObjectType(int value) {
        this._currentObjectType = value;
    }

    String getCurrentLocalForm() {
        return this._currentLocalForm;
    }

    void setCurrentLocalForm(String value) {
        this._currentLocalForm = value;
    }

    String getCurrentRemoteForm() {
        return this._currentRemoteForm == null ? this.getCurrentLocalForm() : this._currentRemoteForm;
    }

    void setCurrentRemoteForm(String form) {
        this.setCurrentRemoteForm(form, null);
    }

    void setCurrentRemoteForm(String form, String sampleForm) {
        String value = form;
        if (value != null && value.startsWith("$") && value.endsWith("$")) {
            value = sampleForm;
        }
        if (value != null && (value.equals("@") || value.equals("*") || value.equals("*"))) {
            value = this.getCurrentLocalForm();
        }
        this._currentRemoteForm = value;
    }

    Hashtable<String, ARServerUser> getCurrentOpenWindowSampleServerForms() {
        return this._currentOpenWindowSampleServerForms;
    }

    void setCurrentOpenWindowSampleServerForms(Hashtable<String, ARServerUser> value) {
        this._currentOpenWindowSampleServerForms = value;
    }

    int getCurrentActionIndex() {
        return this._currentActionIndex;
    }

    void getCurrentActionIndex(int value) {
        this._currentActionIndex = value;
    }

    int getCurrentFieldId() {
        return this._currentFieldId;
    }

    void setCurrentFieldId(int value) {
        this._currentFieldId = value;
    }

    String getPrimaryServerName() {
        return this._primaryServerName;
    }

    void setPrimaryServerName(String value) {
        this._primaryServerName = value;
    }

    String getSecondaryServerName() {
        return this._secondaryServerName;
    }

    void setSecondaryServerName(String server) {
        this.setSecondaryServerName(server, null);
    }

    void setSecondaryServerName(String server, String sampleServer) {
        String value = server;
        if (value != null && value.startsWith("$") && value.endsWith("$")) {
            value = sampleServer;
        }
        if (value != null && (value.equals("@") || value.equals("*") || value.equals("CURRENT SCREEN") || value.equals("CURRENT TRANSACTION"))) {
            value = this.getPrimaryServerName();
        }
        this._secondaryServerName = value;
    }
}

