/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PushFieldsAction
extends Action
implements ActiveLinkAction,
FilterAction,
Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(PushFieldsAction.class);
    private static final long serialVersionUID = 4474139863731533387L;
    private String pushToServer;
    private String pushToForm;
    private QualifierInfo pushIfQualification;
    private String pushIfQualificationAsString;
    private int noMatchOption;
    private int multiMatchOption;
    private List<PushFieldsInfo> m_pushFieldsList;
    private String m_sampleServer;
    private String m_sampleForm;

    public PushFieldsAction() {
    }

    public PushFieldsAction(String sampleForm, String sampleServer, List<PushFieldsInfo> pushFieldsList) {
        this.m_sampleForm = sampleForm;
        this.m_sampleServer = sampleServer;
        this.m_pushFieldsList = pushFieldsList;
    }

    public String getSampleForm() {
        return this.m_sampleForm;
    }

    public void setSampleForm(String sampleForm) {
        this.m_sampleForm = sampleForm;
    }

    public String getSampleServer() {
        return this.m_sampleServer;
    }

    public void setSampleServer(String sampleServer) {
        this.m_sampleServer = sampleServer;
    }

    public List<PushFieldsInfo> getPushFieldsList() {
        return this.m_pushFieldsList;
    }

    public void setPushFieldsList(List<PushFieldsInfo> pushFieldsList) {
        this.m_pushFieldsList = pushFieldsList;
    }

    public boolean isAssignmentByMatchingIds() {
        List<PushFieldsInfo> list = this.getPushFieldsList();
        if (list == null || list.size() <= 0) {
            return false;
        }
        PushFieldsInfo marker = list.get(0);
        if (marker == null) {
            return false;
        }
        AssignFieldInfo targetField = marker.getField();
        AssignInfo assignInfo = marker.getAssignment();
        return targetField != null && targetField.getFieldId() == 98 && marker.getAssignmentType() == 2 && assignInfo != null && assignInfo.getField().getFieldId() == 98;
    }

    public void setAssignmentByMatchingIds(boolean byMatchingIds) {
        if (byMatchingIds) {
            PushFieldsInfo marker = PushFieldsInfo.getMarkerForAssignmentByMatchingIds(this.getPushToServer(), this.getPushToForm(), this.getPushIfQualification(), this.getNoMatchOption(), this.getMultiMatchOption());
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            list.add(marker);
            this.setPushFieldsList(list);
        } else if (this.isAssignmentByMatchingIds()) {
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            this.setPushFieldsList(list);
        }
    }

    public boolean isAssignmentToDefaults() {
        List<PushFieldsInfo> list = this.getPushFieldsList();
        if (list == null || list.size() <= 0) {
            return false;
        }
        PushFieldsInfo marker = list.get(0);
        if (marker == null) {
            return false;
        }
        AssignFieldInfo targetField = marker.getField();
        AssignInfo assignInfo = marker.getAssignment();
        return targetField.getFieldId() == 97 && marker.getAssignmentType() == 2 && assignInfo != null && assignInfo.getField().getFieldId() == 97;
    }

    public void setAssignmentToDefaults(boolean isSetToDefaults) {
        if (isSetToDefaults) {
            PushFieldsInfo marker = PushFieldsInfo.getMarkerForAssignmentToDefaults(this.getPushToServer(), this.getPushToForm(), this.getPushIfQualification(), this.getNoMatchOption(), this.getMultiMatchOption());
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            list.add(marker);
            this.setPushFieldsList(list);
        } else if (this.isAssignmentToDefaults()) {
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            this.setPushFieldsList(list);
        }
    }

    private final void prepareFieldAssignments(Object[] rawData, ARServerUser ctx, List<PushFieldsInfo> pushFields) throws ARException {
        if (pushFields == null || pushFields.size() <= 0) {
            return;
        }
        PushFieldsInfo pfiOne = pushFields.get(0);
        if (pfiOne == null) {
            return;
        }
        AssignFieldInfo afiOne = pfiOne.getField();
        if (afiOne == null) {
            return;
        }
        String pushToServer = afiOne.getServer();
        this.setPushToServer(pushToServer);
        if (pushToServer.startsWith("$") && pushToServer.endsWith("$")) {
            pushToServer = this.getSampleServer();
        }
        if (!(pushToServer.trim().equals("") || pushToServer.equals("*") || pushToServer.equals("@") || pushToServer.equals(ctx.getServer()))) {
            try {
                ctx = ctx.getSession().getServer(pushToServer);
            }
            catch (ARException e) {
                logger.error("prepareFieldAssignments, pushToServer=" + pushToServer, e);
                return;
            }
        }
        String pushToForm = afiOne.getForm();
        ctx.getSession().setCurrentRemoteForm(pushToForm);
        this.setPushToForm(pushToForm);
        if (pushToForm.startsWith("$") && pushToForm.endsWith("$")) {
            pushToForm = this.getSampleForm();
        }
        if (pushToForm != null && (pushToForm.equals("@") || pushToForm.equals("*") || pushToForm.equals("CURRENT SCREEN") || pushToForm.equals("CURRENT TRANSACTION"))) {
            pushToForm = ctx.getSession().getCurrentLocalForm();
        }
        String qualString = null;
        QualifierInfo pushIfQualification = afiOne.getQualifier();
        if (pushIfQualification != null) {
            this.setPushIfQualification(pushIfQualification);
            if (Config.getInstance().isStringizeSetIfQualification()) {
                try {
                    qualString = ctx.formatSetIfQualification(ctx.getSession().getCurrentRemoteForm(), ctx.getSession().getCurrentLocalForm(), pushIfQualification);
                    this.setPushIfQualificationAsString(this.pushIfQualificationAsString);
                }
                catch (ARException e) {
                    logger.error("prepareFieldAssignments", e);
                }
            }
        }
        this.setPushIfQualificationAsString(qualString);
        this.setNoMatchOption(afiOne.getNoMatchOption());
        this.setMultiMatchOption(afiOne.getMultiMatchOption());
        for (PushFieldsInfo pfi : pushFields) {
            AssignFieldInfo field = pfi.getField();
            AssignInfo assignInfo = pfi.getAssignment();
            int fieldId = field.getFieldId();
            if (fieldId == 98 || fieldId == 97) break;
            assignInfo.prepareAssignmentString(ctx, pushToForm, field.getFieldId(), ctx.getSession().getCurrentLocalForm());
        }
    }

    final void prepareFieldAssignments(ARServerUser ctx) {
        String origCurrentLocalForm = ctx.getSession().getCurrentLocalForm();
        String origCurrentRemoteForm = ctx.getSession().getCurrentRemoteForm();
        ctx.getSession().setCurrentLocalForm(origCurrentRemoteForm);
        ctx.getSession().setCurrentRemoteForm(origCurrentLocalForm);
        List<PushFieldsInfo> pushFields = this.getPushFieldsList();
        Object[] rawData = (Object[])ARTypeMgr.getInstance().ObjectListToVariant(pushFields, ctx);
        try {
            this.prepareFieldAssignments(rawData, ctx, pushFields);
        }
        catch (ARException e) {
            logger.error("prepareFieldAssignments", e);
        }
    }

    void fixFieldAssignments(ARServerUser ctx) {
        if (this.isAssignmentByMatchingIds()) {
            PushFieldsInfo marker = PushFieldsInfo.getMarkerForAssignmentByMatchingIds(this.getPushToServer(), this.getPushToForm(), this.getPushIfQualification(), this.getNoMatchOption(), this.getMultiMatchOption());
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            list.add(marker);
            this.setPushFieldsList(list);
        } else if (this.isAssignmentToDefaults()) {
            PushFieldsInfo marker = PushFieldsInfo.getMarkerForAssignmentToDefaults(this.getPushToServer(), this.getPushToForm(), this.getPushIfQualification(), this.getNoMatchOption(), this.getMultiMatchOption());
            ArrayList<PushFieldsInfo> list = new ArrayList<PushFieldsInfo>();
            list.add(marker);
            this.setPushFieldsList(list);
        } else {
            PushFieldsInfo.fixARAssignFieldStruct(this.getPushFieldsList(), this.getPushToServer(), this.getPushToForm(), this.getPushIfQualification(), "", "", this.getNoMatchOption(), this.getMultiMatchOption(), ctx);
        }
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_pushFieldsList = ARTypeMgr.getInstance().ObjectListFromVariant(PushFieldsInfo.class, ARTypeMgr.GetAt((Object)rawData, 0), ctx);
        this.m_sampleServer = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
        this.m_sampleForm = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 2));
    }

    @Override
    Object toVariant(ARServerUser ctx) {
        Object[] var = (Object[])super.toVariant(ctx);
        var[1] = new Object[]{ARTypeMgr.getInstance().ObjectListToVariant(this.m_pushFieldsList, ctx), this.m_sampleServer, this.m_sampleForm};
        return var;
    }

    static PushFieldsAction createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        PushFieldsAction obj = new PushFieldsAction();
        if (rawData.length == 3) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PushFieldsAction obj = (PushFieldsAction)super.clone();
        if (this.m_sampleForm != null) {
            obj.m_sampleForm = this.m_sampleForm;
        }
        if (this.m_sampleServer != null) {
            obj.m_sampleServer = this.m_sampleServer;
        }
        if (this.m_pushFieldsList != null) {
            int nLen = this.m_pushFieldsList.size();
            obj.m_pushFieldsList = new ArrayList<PushFieldsInfo>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.m_pushFieldsList.add((PushFieldsInfo)this.m_pushFieldsList.get(i).clone());
            }
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PushFieldsAction)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PushFieldsAction rhs = (PushFieldsAction)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_pushFieldsList, rhs.m_pushFieldsList).append(this.m_sampleServer, rhs.m_sampleServer).append(this.m_sampleForm, rhs.m_sampleForm).isEquals();
    }

    @Override
    public boolean equals(Object anObject, String lhsServer, String lhsForm, String rhsServer, String rhsForm) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || !(anObject instanceof PushFieldsAction)) {
            return false;
        }
        PushFieldsAction rhs = (PushFieldsAction)anObject;
        return (this.m_sampleForm == null ? rhs.m_sampleForm == null : this.m_sampleForm.equals(rhs.m_sampleForm)) && (this.m_sampleServer == null ? rhs.m_sampleServer == null : this.m_sampleServer.equals(rhs.m_sampleServer)) && Util.equals(this.m_pushFieldsList, rhs.m_pushFieldsList, lhsServer, lhsForm, rhsServer, rhsForm);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_pushFieldsList).append(this.m_sampleServer).append(this.m_sampleForm).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Push Fields List", this.m_pushFieldsList).append("Sample Server", this.m_sampleServer).append("Sample Form", this.m_sampleForm).toString();
    }

    public int getMultiMatchOption() {
        return this.multiMatchOption;
    }

    public void setMultiMatchOption(int multiMatchOption) {
        this.multiMatchOption = multiMatchOption;
    }

    public int getNoMatchOption() {
        return this.noMatchOption;
    }

    public void setNoMatchOption(int noMatchOption) {
        this.noMatchOption = noMatchOption;
    }

    public QualifierInfo getPushIfQualification() {
        return this.pushIfQualification;
    }

    public void setPushIfQualification(QualifierInfo pushIfQualification) {
        this.pushIfQualification = pushIfQualification;
    }

    public String getPushIfQualificationAsString() {
        return this.pushIfQualificationAsString;
    }

    public void setPushIfQualificationAsString(String pushIfQualificationAsString) {
        this.pushIfQualificationAsString = pushIfQualificationAsString;
    }

    public String getPushToForm() {
        return this.pushToForm;
    }

    public void setPushToForm(String pushToForm) {
        this.pushToForm = pushToForm;
    }

    public String getPushToServer() {
        return this.pushToServer;
    }

    public void setPushToServer(String pushToServer) {
        this.pushToServer = pushToServer;
    }
}

