/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.COMMethodInfo;
import com.bmc.arsys.api.COMMethodParmInfo;
import com.bmc.arsys.api.COMValueInfo;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.CaseOperandInfo;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CloseWindowAction;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CommitChangesAction;
import com.bmc.arsys.api.ComplexSortInfo;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DataDictionaryMenu;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateOnlyFieldLimit;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DirectSqlAction;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.DisplayPropertyMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EscalationInterval;
import com.bmc.arsys.api.EscalationTime;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExitGuideAction;
import com.bmc.arsys.api.ExternalReference;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.FieldOperandInfo;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterMessageAction;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.FunctionOperandInfo;
import com.bmc.arsys.api.GotoAction;
import com.bmc.arsys.api.GotoGuideLabelAction;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.JoinFieldMapping;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ListMenu;
import com.bmc.arsys.api.LogAction;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.NotifyAction;
import com.bmc.arsys.api.OleAutomationAction;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.OverlaidInfo;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.PropertyMap;
import com.bmc.arsys.api.PushFieldsAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifiedCaseOperandInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.QuerySourceForm;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RecursiveComplexQuery;
import com.bmc.arsys.api.RecursiveQuery;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.RegularComplexQuery;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RunMacroAction;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.ServiceAction;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SwitchCaseOperandInfo;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewFieldMapping;
import com.bmc.arsys.api.WaitAction;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParameterValidator {
    private static Logger logger = Logger.getLogger(ParameterValidator.class);
    private String svrCharSet;

    public ParameterValidator() {
        this("utf-8");
    }

    public ParameterValidator(String serverCharSetName) {
        this.svrCharSet = serverCharSetName != null ? serverCharSetName : "utf-8";
    }

    public final void validateARForm(Form object, boolean createForm) throws ARException {
        this.validateARNameType(object.getName(), false);
        this.validateARFormType(object, !createForm);
        this.validateARPermissionList(object.getPermissions());
        this.validateAREntryListFieldInfo(object.getEntryListFieldInfo());
        this.validateARSortList(object.getSortInfo());
        this.validateARIndexList(object.getIndexInfo());
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
    }

    public final void validateARView(View object) throws ARException {
        this.validateARNameType(object.getFormName(), false);
        this.validateARNameType(object.getName(), true);
        this.validateARLocaleType(object.getLocale(), true);
        this.validateARPropList(object.getDisplayProperties(), true);
        this.validateARAccessNameType(object.getOwner(), true);
    }

    public final void validateARServerInfoRequestList2(int[] requestList) throws ARException {
        if (requestList == null || requestList.length == 0) {
            this.throwValidationException(2, 122);
        } else {
            for (int i = 0; i < requestList.length; ++i) {
                if (requestList[i] != 0 && requestList[i] <= 76) continue;
                this.throwValidationException(2, 256);
            }
        }
    }

    public final void validateAREntryListFieldList(List<EntryListFieldInfo> entryListFields) throws ARException {
        if (entryListFields == null || entryListFields.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryListFields.size(); ++i) {
            if ((long)entryListFields.get(i).getFieldId() == 99L || (long)entryListFields.get(i).getFieldId() != 0L && entryListFields.get(i).getColumnWidth() != 0 && entryListFields.get(i).getSeparator().length() <= 10) continue;
            this.throwValidationException(2, 214);
        }
    }

    public final void validateAREntryIdListList(List<String> entryIds, boolean nullOk) throws ARException {
        if (entryIds == null || entryIds.isEmpty()) {
            if (!nullOk) {
                this.throwValidationException(2, 106);
            }
        } else {
            for (int i = 0; i < entryIds.size(); ++i) {
                this.validateAREntryIdList(entryIds.get(i), false);
            }
        }
    }

    public final void validateAREntryIdList(String value, boolean nullOk) throws ARException {
        if (value == null || value.length() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 106);
            }
        } else {
            String[] entryIds = Entry.splitEntryId(value);
            int numIds = 0;
            for (int i = 0; i < entryIds.length; ++i) {
                try {
                    this.validateARStringType(entryIds[i], 15, false);
                }
                catch (ARException ex) {
                    List<StatusInfo> status = ex.getLastStatus();
                    if (status.size() == 1 && status.get(0).getMessageNum() == 102L) continue;
                    this.throwValidationException(2, 121);
                }
                ++numIds;
            }
            if (numIds == 0) {
                this.throwValidationException(2, 100);
            }
        }
    }

    public final void validateAREntry(Entry value, boolean nullOk) throws ARException {
        if (value == null || value.size() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 104);
            }
        } else {
            for (Integer key : value.keySet()) {
                this.validateARValueInfo((Value)value.get(key));
            }
        }
    }

    public final void validateARCommand(String arg1) throws ARException {
        this.validateARStringType(arg1, 0, 117);
    }

    public final void validateARSqlCommand(String arg1) throws ARException {
        this.validateARStringType(arg1, 0, 261);
    }

    public final void validateARFieldValueOrArithInfo(ArithmeticOrRelationalOperand arg1, boolean nullOk) throws ARException {
        if (arg1 == null || arg1.getType().toInt() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 147);
            } else {
                return;
            }
        }
        int arithType = arg1.getType().toInt();
        switch (arithType) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                break;
            }
            case 2: {
                this.validateARValueInfo((Value)arg1.getValue());
                break;
            }
            case 3: {
                this.validateARArithOpInfo((ArithmeticOperationInfo)arg1.getValue());
                break;
            }
            case 4: {
                StatusHistoryValueIndicator statHist = (StatusHistoryValueIndicator)arg1.getValue();
                if (statHist.isUser() || statHist.isTime()) break;
                this.throwValidationException(2, 170);
                break;
            }
            case 5: {
                this.validateARValueList((List)arg1.getValue());
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                CurrencyPartInfo cInfo = (CurrencyPartInfo)arg1.getValue();
                if (cInfo.getPartTag() != 0 && cInfo.getPartTag() != 1 && cInfo.getPartTag() != 2 && cInfo.getPartTag() != 3 && cInfo.getPartTag() != 4) {
                    this.throwValidationException(2, 8733);
                    break;
                }
                if (cInfo.getPartTag() != 4 || cInfo.getCurrencyCode().length() == 3) break;
                this.throwValidationException(2, 8734);
                break;
            }
            case 52: {
                if ((Integer)arg1.getValue() <= 10) break;
                this.throwValidationException(2, 220);
                break;
            }
            case 53: {
                this.validateARQueryValueInfo((QueryInfo)arg1.getValue());
                break;
            }
            case 7: {
                this.validateARValueSetQuery((ValueSetQuery)arg1.getValue());
                break;
            }
            case 9: {
                this.validateARFunctionOperand((FunctionOperandInfo)arg1.getValue());
                break;
            }
            case 10: {
                this.validateARCaseOperand((CaseOperandInfo)arg1.getValue());
                break;
            }
            default: {
                if (arithType >= 13 && arithType <= 26) break;
                this.throwValidationException(2, 148);
            }
        }
    }

    private void validateARCaseOperand(CaseOperandInfo caseOperand) throws ARException {
        if (caseOperand == null) {
            this.throwValidationException(2, 893);
        } else if (caseOperand instanceof SwitchCaseOperandInfo) {
            this.validateARSwitchCaseOperand((SwitchCaseOperandInfo)caseOperand);
        } else if (caseOperand instanceof QualifiedCaseOperandInfo) {
            this.validateARQualifiedCaseOperand((QualifiedCaseOperandInfo)caseOperand);
        }
        this.validateARFieldValueOrArithInfo(caseOperand.getElse(), true);
    }

    private void validateARQualifiedCaseOperand(QualifiedCaseOperandInfo qualifiedCaseOperand) throws ARException {
        Map<QualifierInfo, ArithmeticOrRelationalOperand> whenThenList = qualifiedCaseOperand.getWhenThenList();
        if (whenThenList == null || whenThenList.isEmpty()) {
            this.throwValidationException(2, 894);
        }
        for (Map.Entry<QualifierInfo, ArithmeticOrRelationalOperand> whenThen : whenThenList.entrySet()) {
            this.validateARQualifierInfo(whenThen.getKey(), false);
            this.validateARFieldValueOrArithInfo(whenThen.getValue(), false);
        }
    }

    private void validateARSwitchCaseOperand(SwitchCaseOperandInfo switchCaseOperand) throws ARException {
        this.validateARFieldValueOrArithInfo(switchCaseOperand.getSwitch(), false);
        Map<ArithmeticOrRelationalOperand, ArithmeticOrRelationalOperand> whenThenList = switchCaseOperand.getWhenThenList();
        if (whenThenList == null || whenThenList.isEmpty()) {
            this.throwValidationException(2, 894);
        }
        for (Map.Entry<ArithmeticOrRelationalOperand, ArithmeticOrRelationalOperand> whenThen : whenThenList.entrySet()) {
            this.validateARFieldValueOrArithInfo(whenThen.getKey(), false);
            this.validateARFieldValueOrArithInfo(whenThen.getValue(), false);
        }
    }

    private void validateARFunctionOperand(FunctionOperandInfo function) throws ARException {
        if (function == null) {
            this.throwValidationException(2, 229);
        } else if (function.getFunctionCode() == null || function.getFunctionCode().intValue() == 0) {
            this.throwValidationException(2, 230);
        } else if (function.getParameterList() != null) {
            for (ArithmeticOrRelationalOperand parameter : function.getParameterList()) {
                this.validateARFieldValueOrArithInfo(parameter, false);
            }
        }
    }

    public final void validateARQueryValueInfo(QueryInfo qf) throws ARException {
        if (qf == null) {
            this.throwValidationException(2, 221);
        } else {
            this.validateARStringType(qf.getFormID(), 254, 222);
            this.validateARStringType(qf.getServerName(), 64, 222);
            try {
                this.validateARQualifierInfo(qf.getQualifierInfo(), true);
            }
            catch (ARException e) {
                this.throwValidationException(2, 222);
            }
            if (qf.getFieldID() == 0) {
                this.throwValidationException(2, 222);
            }
            if (qf.getMatchMode() < 1 || qf.getMatchMode() > 3) {
                this.throwValidationException(2, 223);
            }
        }
    }

    public final void validateARArithOpInfo(ArithmeticOperationInfo arthOp) throws ARException {
        if (arthOp == null) {
            this.throwValidationException(2, 145);
        } else if (arthOp.getOperation() < 1 || arthOp.getOperation() > 6) {
            this.throwValidationException(2, 146);
        } else if (arthOp.getOperation() != 6) {
            this.validateARFieldValueOrArithInfo(arthOp.getLeftOperand(), false);
            this.validateARFieldValueOrArithInfo(arthOp.getRightOperand(), false);
        }
    }

    public final void validateARRelOpInfo(RelationalOperationInfo relOp) throws ARException {
        if (relOp == null) {
            this.throwValidationException(2, 143);
        } else if (relOp.getOperation() < 1 || relOp.getOperation() > 9) {
            this.throwValidationException(2, 144);
        } else {
            this.validateARFieldValueOrArithInfo(relOp.getLeftOperand(), false);
            this.validateARFieldValueOrArithInfo(relOp.getRightOperand(), false);
        }
    }

    public final void validateARStatistic(int statistic) throws ARException {
        if (statistic < 1 || statistic > 5) {
            this.throwValidationException(2, 126);
        }
    }

    public final void validateBuffer(String buffer) throws ARException {
        this.validateARStringType(buffer, 0, 156);
    }

    public final void validateARStructItemList(List<StructItemInfo> items, boolean importFlag) throws ARException {
        if (items == null || items.size() == 0) {
            if (importFlag) {
                return;
            }
            this.throwValidationException(2, 132);
        } else {
            for (int i = 0; i < items.size(); ++i) {
                int itemType = items.get(i).getType();
                if ((itemType & 0x20000000) != 0) {
                    itemType &= 0xDFFFFFFF;
                }
                if ((itemType & 0x40000000) != 0) {
                    itemType &= 0xBFFFFFFF;
                }
                if (itemType < 1 || itemType > 20 && itemType != 103 && itemType != 30 && itemType != 18 || importFlag && (itemType == 2 || itemType == 4 || itemType == 103)) {
                    this.throwValidationException(2, 133);
                }
                try {
                    this.validateARNameType(items.get(i).getName(), false);
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 134);
                }
            }
        }
    }

    public boolean validatePasswordFieldsInServerInfoList(ServerInfoMap srvInfoMap) {
        return srvInfoMap.containsKey(151) || srvInfoMap.containsKey(153) || srvInfoMap.containsKey(154) || srvInfoMap.containsKey(161) || srvInfoMap.containsKey(164);
    }

    public Value encryptValue(String charSet, Value argValue) {
        byte[] encPass = null;
        Value retValue = new Value();
        retValue._dataType = DataType.NULL;
        retValue._value = null;
        PasswordEncryption pwdEnc = new PasswordEncryption(0, false);
        try {
            encPass = pwdEnc.encryptPasswordEx(argValue.toString().getBytes(charSet));
        }
        catch (UnsupportedEncodingException e) {
            encPass = null;
        }
        catch (AREncryptionException e) {
            encPass = null;
        }
        if (encPass != null && encPass.length > 0) {
            retValue = new Value(new String(encPass));
        }
        return retValue;
    }

    public final void validateARServerInfoList(ServerInfoMap serverInfoMap) throws ARException {
        if (serverInfoMap == null || serverInfoMap.size() == 0) {
            this.throwValidationException(2, 216);
        } else {
            Set keys = serverInfoMap.keySet();
            StringBuilder invalidTags = new StringBuilder();
            block7: for (Integer key : keys) {
                Value val = (Value)serverInfoMap.get(key);
                DataType dataType = val != null ? val.getDataType() : DataType.NULL;
                switch (key) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 18: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 35: 
                    case 36: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 91: 
                    case 101: 
                    case 116: 
                    case 127: 
                    case 138: 
                    case 139: 
                    case 149: 
                    case 150: 
                    case 177: 
                    case 178: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 198: 
                    case 200: 
                    case 201: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 209: 
                    case 222: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 283: 
                    case 312: {
                        invalidTags.append(key.toString());
                        invalidTags.append(",");
                        continue block7;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 15: 
                    case 19: 
                    case 20: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 32: 
                    case 33: 
                    case 37: 
                    case 45: 
                    case 50: 
                    case 56: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 88: 
                    case 92: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 99: 
                    case 100: 
                    case 102: 
                    case 103: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 136: 
                    case 137: 
                    case 140: 
                    case 142: 
                    case 143: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 166: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 175: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 194: 
                    case 195: 
                    case 197: 
                    case 199: 
                    case 204: 
                    case 207: 
                    case 208: 
                    case 210: 
                    case 211: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 218: 
                    case 220: 
                    case 221: 
                    case 223: 
                    case 224: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 230: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 262: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 306: 
                    case 307: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 313: 
                    case 314: 
                    case 319: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 385: 
                    case 393: 
                    case 396: 
                    case 399: 
                    case 400: 
                    case 405: 
                    case 417: 
                    case 419: 
                    case 420: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 434: 
                    case 437: 
                    case 438: 
                    case 439: 
                    case 440: 
                    case 441: 
                    case 442: 
                    case 443: {
                        if (DataType.INTEGER.equals(dataType) || DataType.NULL.equals(dataType)) continue block7;
                        invalidTags.append(key.toString());
                        invalidTags.append(",");
                        continue block7;
                    }
                    case 10: 
                    case 16: 
                    case 17: 
                    case 21: 
                    case 22: 
                    case 31: 
                    case 34: 
                    case 46: 
                    case 47: 
                    case 57: 
                    case 59: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 93: 
                    case 97: 
                    case 98: 
                    case 104: 
                    case 105: 
                    case 114: 
                    case 123: 
                    case 126: 
                    case 135: 
                    case 141: 
                    case 144: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 167: 
                    case 169: 
                    case 174: 
                    case 176: 
                    case 179: 
                    case 189: 
                    case 193: 
                    case 196: 
                    case 202: 
                    case 217: 
                    case 219: 
                    case 225: 
                    case 229: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 238: 
                    case 251: 
                    case 256: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 308: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 320: 
                    case 336: 
                    case 341: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 350: 
                    case 351: 
                    case 357: 
                    case 358: 
                    case 374: 
                    case 380: 
                    case 394: 
                    case 395: 
                    case 397: 
                    case 398: 
                    case 401: 
                    case 402: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 416: 
                    case 418: 
                    case 425: 
                    case 426: 
                    case 432: 
                    case 433: 
                    case 435: 
                    case 60073: {
                        if (DataType.CHAR.equals(dataType) || DataType.NULL.equals(dataType)) continue block7;
                        invalidTags.append(key.toString());
                        invalidTags.append(",");
                        continue block7;
                    }
                    case 327: 
                    case 328: 
                    case 329: {
                        if (DataType.REAL.equals(dataType) || DataType.NULL.equals(dataType)) continue block7;
                        invalidTags.append(key.toString());
                        invalidTags.append(",");
                        continue block7;
                    }
                    case 410: {
                        if (DataType.INTEGER.equals(dataType) || DataType.REAL.equals(dataType) || DataType.NULL.equals(dataType)) continue block7;
                        invalidTags.append(key.toString());
                        invalidTags.append(",");
                        continue block7;
                    }
                }
                invalidTags.append(key.toString());
                invalidTags.append(",");
            }
            String appendMsg = invalidTags.toString();
            if (appendMsg.length() > 0) {
                appendMsg = appendMsg.substring(0, appendMsg.length() - 1);
                this.throwValidationException(2, 123, appendMsg);
            }
        }
    }

    public final void validateARServerInfoRequestList(int[] arg1) throws ARException {
        if (arg1.length == 0) {
            this.throwValidationException(2, 122);
        } else {
            for (int i = 0; i < arg1.length; ++i) {
                if (arg1[i] == 0) {
                    this.throwValidationException(2, 123);
                    continue;
                }
                if (arg1[i] != 10) continue;
                this.throwValidationException(2, 218);
            }
        }
    }

    public final void validateARContainerOwnerObjList(List<ContainerOwner> containerOwner) throws ARException {
        if (containerOwner == null || containerOwner.isEmpty()) {
            return;
        }
        for (int i = 0; i < containerOwner.size(); ++i) {
            this.validateARContainerOwnerObj(containerOwner.get(i));
        }
    }

    public final void validateARContainerOwnerObj(ContainerOwner containerOwner) throws ARException {
        if (containerOwner != null && containerOwner.getType() != 0 && containerOwner.getType() != 1) {
            try {
                this.validateARNameType(containerOwner.getName(), false);
            }
            catch (ARException e) {
                this.throwValidationException(2, 8800);
            }
        }
    }

    public final void validateARReferenceList(List<Reference> references) throws ARException {
        if (references != null && !references.isEmpty()) {
            for (int i = 0; i < references.size(); ++i) {
                this.validateARReferenceInfo(references.get(i));
            }
        }
    }

    public final void validateARReferenceInfo(Reference references) throws ARException {
        if (references == null) {
            this.throwValidationException(2, 8801);
        } else if (references.getLabel() == null) {
            this.throwValidationException(2, 8802);
        } else if (references.getDescription() == null) {
            this.throwValidationException(2, 8803);
        } else if (references.getReferenceType().toInt() == 0) {
            this.validateARNameType(references.getName(), false);
        } else if (references.getReferenceType().toInt() == 1) {
            ExternalReference extRef = (ExternalReference)references;
            this.validateARExtReferenceInfo(extRef);
        }
    }

    public final void validateARExtReferenceInfo(ExternalReference extRef) throws ARException {
        if (extRef == null) {
            this.throwValidationException(2, 8801);
        } else {
            this.validateARValueInfo(extRef.getValue());
        }
    }

    public final void validateEscalationTm(EscalationTimeCriteria escalationTm) throws ARException {
        if (escalationTm instanceof EscalationInterval) {
            EscalationInterval EscIntv = (EscalationInterval)escalationTm;
            if (EscIntv.getValue() <= 0L) {
                this.throwValidationException(2, 247);
            }
        } else if (escalationTm instanceof EscalationTime) {
            EscalationTime EscTime = (EscalationTime)escalationTm;
            if (EscTime.getMonthDayMask() == 0 && EscTime.getWeekDayMask() == 0) {
                this.throwValidationException(2, 248);
            }
            if (EscTime.getHourMask() == 0) {
                this.throwValidationException(2, 249);
            }
            if (EscTime.getMinute() < 0 || EscTime.getMinute() > 59) {
                this.throwValidationException(2, 250);
            }
        }
    }

    public final void validateARFilterActionList(List<FilterAction> actionList, boolean esclFlag, boolean elseFlag, boolean nullOk) throws ARException {
        if (actionList == null || actionList.size() == 0) {
            if (!nullOk) {
                int errNum = esclFlag ? 284 : 116;
                this.throwValidationException(2, errNum);
            }
        } else if (actionList.size() > 25) {
            this.throwValidationException(2, 182);
        } else {
            for (int i = 0; i < actionList.size(); ++i) {
                this.validateARFilterActionInfo(actionList.get(i), esclFlag, elseFlag);
            }
        }
    }

    public final void validateARActiveLinkActionList(List<ActiveLinkAction> actionList, boolean nullOk) throws ARException {
        if (actionList == null || actionList.size() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 189);
            }
        } else if (actionList.size() > 25) {
            this.throwValidationException(2, 182);
        } else {
            for (int i = 0; i < actionList.size(); ++i) {
                this.validateARActiveLinkActionInfo(actionList.get(i));
            }
        }
    }

    public final void validateARActiveLinkActionInfo(ActiveLinkAction action) throws ARException {
        if (action == null) {
            this.throwValidationException(2, 189);
        } else if (action instanceof RunMacroAction) {
            RunMacroAction rma = (RunMacroAction)action;
            this.validateARStringType(rma.getMacroName(), 0, 196);
            this.validateARStringType(rma.getMacroText(), 0, 196);
            for (Map.Entry<String, String> e : rma.getMacroParms().entrySet()) {
                String value = e.getValue();
                this.validateARStringType(value, 255, 199, 200, false);
            }
        } else if (action instanceof SetFieldsAction) {
            this.validateARSetFieldsAction((SetFieldsAction)action);
        } else if (action instanceof RunProcessAction) {
            try {
                this.validateARStringType(((RunProcessAction)action).getCommandLine(), 4096, false);
            }
            catch (ARException ex) {
                this.throwValidationException(2, 117);
            }
        } else if (action instanceof MessageAction) {
            MessageAction msa = (MessageAction)action;
            if (msa.getMessageType() > 2 && msa.getMessageType() != 5 && msa.getMessageType() != 6 && msa.getMessageType() != 7) {
                this.throwValidationException(2, 137);
            } else if (msa.getMessageNum() >= 0 && msa.getMessageNum() <= 9999) {
                this.throwValidationException(2, 138);
            }
            this.validateARStringType(msa.getMessageText(), 4095, 291);
        } else if (action instanceof DDEAction) {
            this.validateARDDEInfo((DDEAction)action);
        } else if (action instanceof PushFieldsAction) {
            this.validateARPushFieldsAction((PushFieldsAction)action);
        } else if (action instanceof DirectSqlAction) {
            this.validateARSQLInfo((DirectSqlAction)action);
        } else if (action instanceof OleAutomationAction) {
            this.validateARAutomationInfo((OleAutomationAction)action);
        } else if (action instanceof OpenWindowAction) {
            this.validateAROpenDlgInfo((OpenWindowAction)action);
        } else if (!(action instanceof CommitChangesAction) && !(action instanceof CloseWindowAction)) {
            if (action instanceof CallGuideAction) {
                this.validateARCallGuide((CallGuideAction)action, 6);
            } else if (!(action instanceof ExitGuideAction)) {
                if (action instanceof GotoGuideLabelAction) {
                    this.validateARGotoGuideLabel((GotoGuideLabelAction)action);
                } else if (action instanceof WaitAction) {
                    this.validateARWait((WaitAction)action);
                } else if (action instanceof GotoAction) {
                    this.validateARGotoActionInfo((GotoAction)action);
                }
            }
        }
    }

    public final void validateARWait(WaitAction wa) throws ARException {
        try {
            this.validateARStringType(wa.getContinueButtonTitle(), 64, false);
        }
        catch (ARException ex) {
            this.throwValidationException(2, 8725);
        }
    }

    public final void validateAROpenDlgInfo(OpenWindowAction owA) throws ARException {
        if (owA == null) {
            this.throwValidationException(2, 8720);
        }
        this.validateARServerNameType(owA.getServerName(), false);
        this.validateARNameType(owA.getFormName(), false);
        this.validateARQualifierInfo(owA.getQuery(), true);
        this.validateARFieldAssignList(owA.getInputValueFieldPairs(), true);
        this.validateARFieldAssignList(owA.getOutputValueFieldPairs(), true);
        this.validateARSortList(owA.getSortOrderList());
        MessageAction msg = owA.getMsg();
        if (msg != null) {
            if (msg.getMessageType() > 5) {
                this.throwValidationException(2, 137);
            }
            try {
                this.validateARStringType(msg.getMessageText(), 255, true);
            }
            catch (ARException ex) {
                this.throwValidationException(2, 137);
            }
        }
        if (owA.getPollinginterval() < 0) {
            this.throwValidationException(2, 110);
        } else if (owA.getWindowMode() < 0 || owA.getWindowMode() > 20) {
            this.throwValidationException(2, 118);
        }
    }

    public final void validateARAutomationInfo(OleAutomationAction olaa) throws ARException {
        if (olaa == null) {
            this.throwValidationException(2, 8704);
        }
        try {
            this.validateARStringType(olaa.getAutoServerName(), 64, true);
        }
        catch (ARException ex) {
            this.throwValidationException(2, 8707);
        }
        try {
            this.validateARStringType(olaa.getAction(), 2000, true);
        }
        catch (ARException ex) {
            this.throwValidationException(2, 8715);
        }
        try {
            this.validateARStringType(olaa.getClsId(), 128, true);
        }
        catch (ARException ex) {
            this.throwValidationException(2, 8708);
        }
        this.validateARCOMMethodList(olaa.getMethodList(), false);
    }

    public final void validateARFilterActionInfo(FilterAction action, boolean esclFlag, boolean elseFlag) throws ARException {
        if (action == null) {
            int errNum = esclFlag ? 284 : 116;
            this.throwValidationException(2, errNum);
        } else if (action instanceof NotifyAction) {
            NotifyAction nta = (NotifyAction)action;
            if (nta.getNotifyMechanism() < 1 || nta.getNotifyMechanism() > 99) {
                this.throwValidationException(2, 136);
            } else if (nta.getNotifyPriority() > 10) {
                this.throwValidationException(2, 204);
            } else if (nta.getFieldIdListType() > 3) {
                this.throwValidationException(2, 163);
            } else if (nta.getFieldIdListType() == 0 && nta.getFieldIdList() != null) {
                nta.getFieldIdList().clear();
            }
            this.validateARStringType(nta.getUser(), 255, 0, 202, true);
            this.validateARStringType(nta.getNotifyText(), 0, 162);
            this.validateARStringType(nta.getSubjectText(), 255, 0, 254, true);
        } else if (action instanceof FilterMessageAction) {
            FilterMessageAction fma = (FilterMessageAction)action;
            if (esclFlag) {
                this.throwValidationException(2, 46);
            } else if (fma.getMessageType() > 2) {
                this.throwValidationException(2, 137);
            } else if (fma.getMessageNum() >= 0 && fma.getMessageNum() <= 9999) {
                this.throwValidationException(2, 138);
            }
            this.validateARStringType(fma.getMessageText(), 255, 291);
        } else if (action instanceof LogAction) {
            LogAction lga = (LogAction)action;
            if (esclFlag && elseFlag) {
                this.throwValidationException(2, 46);
            }
            this.validateARStringType(lga.getFilePath(), 255, 0, 109, true);
        } else if (action instanceof SetFieldsAction) {
            this.validateARSetFieldsAction((SetFieldsAction)action);
        } else if (action instanceof RunProcessAction) {
            RunProcessAction rpa = (RunProcessAction)action;
            this.validateARStringType(rpa.getCommandLine(), 4096, 117);
        } else if (action instanceof PushFieldsAction) {
            this.validateARPushFieldsAction((PushFieldsAction)action);
        } else if (action instanceof DirectSqlAction) {
            this.validateARSQLInfo((DirectSqlAction)action);
        } else if (action instanceof GotoAction) {
            this.validateARGotoActionInfo((GotoAction)action);
        } else if (action instanceof CallGuideAction) {
            if (esclFlag) {
                this.throwValidationException(2, 422);
            } else {
                this.validateARCallGuide((CallGuideAction)action, 5);
            }
        } else if (action instanceof ExitGuideAction) {
            if (esclFlag) {
                this.throwValidationException(2, 422);
            }
        } else if (action instanceof GotoGuideLabelAction) {
            if (esclFlag) {
                this.throwValidationException(2, 422);
            } else {
                this.validateARGotoGuideLabel((GotoGuideLabelAction)action);
            }
        } else if (action instanceof ServiceAction) {
            this.validateARService((ServiceAction)action);
        } else {
            int errNum = esclFlag ? 422 : 135;
            this.throwValidationException(2, errNum);
        }
    }

    public final void validateARService(ServiceAction svc) throws ARException {
        if (svc == null) {
            this.throwValidationException(2, 135);
        }
        this.validateARFieldAssignList(svc.getInputFieldMapping(), true);
        this.validateARFieldAssignList(svc.getOutputFieldMapping(), true);
    }

    public final void validateARCOMMethodList(List<COMMethodInfo> methodList, boolean nullOk) throws ARException {
        if ((methodList == null || methodList.isEmpty()) && !nullOk) {
            this.throwValidationException(2, 8705);
        } else {
            for (int i = 0; i < methodList.size(); ++i) {
                try {
                    this.validateARCOMMethodInfo(methodList.get(0), false);
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 8709);
                }
            }
        }
    }

    public final void validateARCOMMethodInfo(COMMethodInfo cmi, boolean nullOk) throws ARException {
        if (cmi == null) {
            if (!nullOk) {
                this.throwValidationException(2, 8711);
            }
        } else {
            this.validateARStringType(cmi.getMethodName(), 128, 8710);
            this.validateARStringType(cmi.getMethodIId(), 128, 8708);
            try {
                this.validateARCOMValueInfo(cmi.getMethodValue(), false);
            }
            catch (ARException e) {
                this.throwValidationException(2, 8706);
            }
            this.validateARCOMMethodParmList(cmi.getParameterList(), true);
        }
    }

    public final void validateARCOMMethodParmList(List<COMMethodParmInfo> parameterList, boolean nullOk) throws ARException {
        if ((parameterList == null || parameterList.isEmpty()) && !nullOk) {
            this.throwValidationException(2, 8712);
        } else {
            for (int i = 0; i < parameterList.size(); ++i) {
                try {
                    this.validateARCOMMethodParmInfo(parameterList.get(i), false);
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 8714);
                }
            }
        }
    }

    public final void validateARCOMMethodParmInfo(COMMethodParmInfo cmpi, boolean nullOk) throws ARException {
        if (cmpi == null) {
            if (!nullOk) {
                this.throwValidationException(2, 8713);
            }
        } else {
            this.validateARStringType(cmpi.getParmName(), 64, 8707);
            try {
                this.validateARCOMValueInfo(cmpi.getParmValue(), false);
            }
            catch (ARException e) {
                this.throwValidationException(2, 8706);
            }
        }
    }

    public final void validateARCOMValueInfo(COMValueInfo cvi, boolean nullOk) throws ARException {
        this.validateARStringType(cvi.getValueIId(), 128, 0, 8708, true);
        switch (cvi.getValueType()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.validateARValueInfo(cvi.getValue());
                break;
            }
            default: {
                this.throwValidationException(2, 8706);
            }
        }
    }

    public final void validateARGotoGuideLabel(GotoGuideLabelAction gtla) throws ARException {
        this.validateARStringType(gtla.getLabel(), 128, 8723);
    }

    public final void validateARCallGuide(CallGuideAction cga, int itemFilter) throws ARException {
        if (cga == null) {
            this.throwValidationException(2, 8721);
        }
        boolean nullServerOk = true;
        if (itemFilter == 6) {
            nullServerOk = false;
        } else if (itemFilter == 5 && (cga.getServerName() == null || cga.getServerName().length() == 0)) {
            cga.setServerName("@");
        }
        this.validateARServerNameType(cga.getServerName(), nullServerOk);
        this.validateARStringType(cga.getGuideName(), 254, 8722, 0, false);
        this.validateARServerNameType(cga.getSampleServer(), true);
        this.validateARNameType(cga.getSampleGuide(), true);
        this.validateARFieldAssignList(cga.getInputValueFieldPairs(), true);
        this.validateARFieldAssignList(cga.getOutputValueFieldPairs(), true);
    }

    public final void validateARGotoActionInfo(GotoAction gta) throws ARException {
        if (gta == null) {
            this.throwValidationException(2, 195);
        }
        if (gta.getTag() < 1 || gta.getTag() > 4) {
            this.throwValidationException(2, 8724);
        }
        if (gta.getTag() == 1 && gta.getFieldIdOrValue() == 0) {
            this.throwValidationException(2, 195);
        }
    }

    public final void validateARSQLInfo(DirectSqlAction dsqa) throws ARException {
        if (dsqa == null) {
            this.throwValidationException(2, 195);
        }
        this.validateARStringType(dsqa.getCommand(), 0, 261);
    }

    public final void validateARPushFieldsAction(PushFieldsAction pfa) throws ARException {
        this.validateARPushFieldsList(pfa.getPushFieldsList());
        this.validateARNameType(pfa.getSampleForm(), true);
        this.validateARServerNameType(pfa.getSampleServer(), true);
    }

    public final void validateARPushFieldsList(List<PushFieldsInfo> pfI) throws ARException {
        if (pfI == null || pfI.size() == 0) {
            this.throwValidationException(2, 192);
        } else {
            for (int i = 0; i < pfI.size(); ++i) {
                try {
                    this.validateARAssignFieldInfo(pfI.get(i).getField());
                }
                catch (ARException e) {
                    this.throwValidationException(2, 193);
                }
                try {
                    this.validateARAssignInfo(pfI.get(i).getAssignment());
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 193);
                }
            }
        }
    }

    public final void validateARSetFieldsAction(SetFieldsAction sfa) throws ARException {
        this.validateARFieldAssignList(sfa.getSetFieldsList(), false);
        this.validateARNameType(sfa.getSampleForm(), true);
        this.validateARServerNameType(sfa.getSampleServer(), true);
    }

    public final void validateARFieldAssignList(List<FieldAssignInfo> fieldList, boolean nullOK) throws ARException {
        if (fieldList == null || fieldList.size() == 0) {
            if (!nullOK) {
                this.throwValidationException(2, 192);
            }
        } else {
            for (int i = 0; i < fieldList.size(); ++i) {
                try {
                    this.validateARAssignInfo(fieldList.get(i).getAssignment());
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 193);
                }
            }
        }
    }

    public final void validateARAssignInfo(AssignInfo assignment) throws ARException {
        switch (assignment.getAssignType()) {
            case 1: {
                this.validateARValueInfo(assignment.getValue());
                break;
            }
            case 2: {
                this.validateARAssignFieldInfo(assignment.getField());
                break;
            }
            case 3: {
                this.validateARStringType(assignment.getProcess(), 255, 117);
                break;
            }
            case 4: {
                this.validateARArithOpAssignInfo(assignment.getArithOp());
                break;
            }
            case 5: {
                this.validateARFunctionAssignInfo(assignment.getFunction());
                break;
            }
            case 6: {
                this.validateARDDEInfo(assignment.getDde());
                break;
            }
            case 7: {
                this.validateARAssignSQLInfo(assignment.getSql());
                break;
            }
            case 8: {
                this.validateARAssignFilterApiInfo(assignment.getFilterApi());
                break;
            }
            default: {
                this.throwValidationException(2, 191);
            }
        }
    }

    public final void validateARArithOpAssignInfo(ArithOpAssignInfo arithOp) throws ARException {
        if (arithOp == null) {
            this.throwValidationException(2, 145);
        } else if (arithOp.getOperation() < 1 || arithOp.getOperation() > 6) {
            this.throwValidationException(2, 146);
        } else {
            if (arithOp.getOperation() == 6) {
                arithOp.getOperandLeft().setAssignType(0);
            } else {
                this.validateARAssignInfo(arithOp.getOperandLeft());
            }
            this.validateARAssignInfo(arithOp.getOperandRight());
        }
    }

    public final void validateARFunctionAssignInfo(FunctionAssignInfo function) throws ARException {
        if (function == null) {
            this.throwValidationException(2, 229);
        } else if (function.getFunctionCode() == 0 || function.getFunctionCode() > 67) {
            this.throwValidationException(2, 230);
        } else if (function.getNumItems() != 0 && function.getParameterList() == null) {
            this.throwValidationException(2, 231);
        } else {
            for (int i = 0; i < function.getNumItems(); ++i) {
                this.validateARAssignInfo(function.getParameterList().get(i));
            }
        }
    }

    public final void validateARDDEInfo(DDEAction dde) throws ARException {
        if (dde == null) {
            this.throwValidationException(2, 243);
        }
        this.validateARStringType(dde.getServiceName(), 64, 237);
        this.validateARStringType(dde.getTopic(), 64, 237);
        this.validateARStringType(dde.getItem(), Short.MAX_VALUE, 0, 238, true);
        this.validateARStringType(dde.getPathToProgram(), 255, 0, 109, true);
        if (dde.getAction() < 1 || dde.getAction() > 3) {
            this.throwValidationException(2, 239);
        }
        if (dde.getCommand() == null && dde.getAction() != 3) {
            this.throwValidationException(2, 117);
        } else {
            this.validateARStringType(dde.getCommand(), 255, 0, 117, true);
        }
        if (dde.getItem() == null) {
            dde.setItem("");
        }
        if (dde.getCommand() == null) {
            dde.setCommand("");
        }
    }

    public final void validateARAssignSQLInfo(AssignSQLInfo sql) throws ARException {
        if (sql == null) {
            this.throwValidationException(2, 195);
        }
        this.validateARStringType(sql.getSqlCommand(), 0, 261);
        if (sql.getNoMatchOption() < 1 || sql.getNoMatchOption() > 2) {
            this.throwValidationException(2, 259);
        }
        if (sql.getMultiMatchOption() < 1 || sql.getMultiMatchOption() > 4) {
            this.throwValidationException(2, 260);
        }
    }

    public final void validateARAssignFilterApiInfo(AssignFilterApiInfo filterApi) throws ARException {
        if (filterApi != null) {
            this.validateARNameType(filterApi.getService(), false);
            if (filterApi.getInputValues() != null) {
                for (int i = 0; i < filterApi.getInputValues().size(); ++i) {
                    try {
                        this.validateARAssignInfo(filterApi.getInputValues().get(i));
                        continue;
                    }
                    catch (ARException e) {
                        this.throwValidationException(2, 8757);
                    }
                }
            }
        }
    }

    public final void validateARAssignFieldInfo(AssignFieldInfo field) throws ARException {
        if (field == null) {
            this.throwValidationException(2, 195);
        }
        this.validateARQualifierInfo(field.getQualifier(), true);
        if (field.getTag() != 1 && field.getTag() != 4 && field.getTag() != 6) {
            this.throwValidationException(2, 194);
        } else if (field.getTag() == 4 && !field.getStatHistory().isUser() && !field.getStatHistory().isTime()) {
            this.throwValidationException(2, 170);
        } else if (field.getNoMatchOption() < 1 || field.getNoMatchOption() > 4) {
            this.throwValidationException(2, 259);
        } else if (field.getMultiMatchOption() < 1 || field.getMultiMatchOption() > 7) {
            this.throwValidationException(2, 260);
        }
    }

    public final void validateARNameList(List<String> formList, boolean nullOk) throws ARException {
        if (formList == null || formList.size() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 113);
            }
        } else {
            for (int i = 0; i < formList.size(); ++i) {
                try {
                    this.validateARNameType(formList.get(i), false);
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 114);
                }
            }
        }
    }

    public final void validateARDisplayInstanceList(DisplayInstanceMap dInstanceList, boolean nullOk) throws ARException {
        if (dInstanceList == null || dInstanceList.size() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 212);
            }
        } else {
            for (Map.Entry e : dInstanceList.entrySet()) {
                if (e == null) continue;
                DisplayPropertyMap dpm = (DisplayPropertyMap)e.getValue();
                this.validateARPropList(dpm, true);
            }
        }
    }

    public final void validateOneField(Field fieldObj, boolean createField) throws ARException {
        int fieldOpt;
        this.validateARNameType(fieldObj.getForm(), false);
        if (createField) {
            this.validateARNameType(fieldObj.getName(), false);
        } else {
            this.validateARNameType(fieldObj.getName(), true);
        }
        this.validateARFieldDefaultValue(fieldObj);
        this.validateARFieldMapping(fieldObj, true);
        this.validateARPermissionList(fieldObj.getPermissions());
        this.validateARFieldLimitInfo(fieldObj);
        this.validateARDisplayInstanceList(fieldObj.getDisplayInstance(), true);
        this.validateARAccessNameType(fieldObj.getOwner(), true);
        if ((createField || fieldObj.getChangeFlags().getParameters()[10]) && ((fieldOpt = fieldObj.getFieldOption()) < 1 || fieldOpt > 4)) {
            this.throwValidationException(2, 118, fieldObj.getName());
        }
        if ((createField || fieldObj.getChangeFlags().getParameters()[11]) && fieldObj.getCreateMode() != 1 && fieldObj.getCreateMode() != 2) {
            this.throwValidationException(2, 119, fieldObj.getName());
        }
        if (createField && (fieldObj.getDataType() < 2 || fieldObj.getDataType() > 43)) {
            this.throwValidationException(2, 110, fieldObj.getName());
        }
    }

    public final void validateARFieldDefaultValue(Field arg1) throws ARException {
        Value defaultVal = arg1.getDefaultValue();
        if (defaultVal == null) {
            return;
        }
        DataType defValDataType = defaultVal.getDataType();
        int dataType = arg1.getDataType();
        if (dataType == 11 || dataType == 33 || dataType == 34 || dataType == 42) {
            if (!DataType.NULL.equals(defValDataType)) {
                this.throwValidationException(2, 111, arg1.getName());
            }
        } else {
            try {
                this.validateARValueInfo(defaultVal);
            }
            catch (ARException e) {
                this.throwValidationException(2, 111, arg1.getName());
            }
        }
        if (DataType.CHAR.equals(defValDataType)) {
            this.validateARStringType((String)defaultVal.getValue(), 255, 0, 180, true);
        }
        if (defValDataType.toInt() != dataType && !DataType.NULL.equals(defValDataType) && !DataType.KEYWORD.equals(defValDataType)) {
            this.throwValidationException(2, 166, arg1.getName());
        }
    }

    public final void validateARFieldLimitInfo(Field field) throws ARException {
        FieldLimit fml = field.getFieldLimit();
        if (fml == null) {
            return;
        }
        int dataType = fml.getDataType();
        switch (dataType) {
            case 0: {
                break;
            }
            case 2: {
                IntegerFieldLimit ifml = (IntegerFieldLimit)fml;
                if (ifml.getLowRange() <= ifml.getHighRange()) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 3: {
                RealFieldLimit rfl = (RealFieldLimit)fml;
                if (!(rfl.getLowRange() > rfl.getHighRange()) && (rfl.getPrecision() >= 0 || rfl.getPrecision() == -1)) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 4: {
                CharacterFieldLimit cfml = (CharacterFieldLimit)fml;
                if (cfml.getMenuStyle() < 1 || (cfml.getFullTextOption() & 0xFFFFFFF8) != 0 || cfml.getMenuStyle() > 2 || cfml.getQBEMatch() < 1 || cfml.getQBEMatch() > 3) {
                    this.throwValidationException(2, 129, field.getName());
                } else if (cfml.getPattern() == null) {
                    cfml.setPattern("");
                }
                this.validateARStringType(cfml.getCharMenu(), 254, 0, 129, true);
                this.validateARStringType(cfml.getPattern(), 255, 0, 129, true);
                break;
            }
            case 5: {
                DiaryFieldLimit dfml = (DiaryFieldLimit)fml;
                if ((dfml.getFullTextOption() & 0xFFFFFFFA) == 0) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 14: {
                break;
            }
            case 11: {
                AttachmentFieldLimit afml = (AttachmentFieldLimit)fml;
                if ((long)afml.getMaxSize() > Integer.MAX_VALUE) {
                    this.throwValidationException(2, 129, field.getName());
                }
                if (afml.getAttachType() != 1) {
                    this.throwValidationException(2, 129, field.getName());
                }
                if ((afml.getFullTextOption() & 0xFFFFFFFA) == 0) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 33: {
                TableFieldLimit tfml = (TableFieldLimit)fml;
                try {
                    this.validateARNameType(tfml.getForm(), false);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 129, field.getName());
                }
                this.validateARServerNameType(tfml.getServer(), false);
                this.validateARQualifierInfo(tfml.getQualifier(), true);
                if (tfml.getMaxRetrieve() > 9999 || tfml.getMaxRetrieve() < 0) {
                    this.throwValidationException(2, 129, field.getName());
                }
                this.validateARNameType(tfml.getSampleForm(), true);
                this.validateARServerNameType(tfml.getSampleServer(), true);
                break;
            }
            case 34: {
                ColumnFieldLimit clfml = (ColumnFieldLimit)fml;
                if (clfml.getColumnLength() > 255 || clfml.getColumnLength() < 0) {
                    this.throwValidationException(2, 129, field.getName());
                }
                if (clfml.getDataSource() <= 4) break;
                this.throwValidationException(2, 118, field.getName());
                break;
            }
            case 10: {
                DecimalFieldLimit dcfml = (DecimalFieldLimit)fml;
                if (dcfml.getHighRange() != null && dcfml.getHighRange().toString().length() != 0 && dcfml.getLowRange() != null && dcfml.getLowRange().toString().length() != 0 && dcfml.getPrecision() >= 0) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 12: {
                CurrencyFieldLimit crfml = (CurrencyFieldLimit)fml;
                if (crfml.getHighRange() != null && crfml.getHighRange().toString().length() != 0 && crfml.getLowRange() != null && crfml.getLowRange().toString().length() != 0 && crfml.getPrecision() >= 0) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 13: {
                DateOnlyFieldLimit dtfml = (DateOnlyFieldLimit)fml;
                if (dtfml.getMinDate() <= dtfml.getMaxDate()) break;
                this.throwValidationException(2, 129, field.getName());
                break;
            }
            default: {
                this.throwValidationException(2, 129, field.getName());
            }
        }
    }

    public final void validateMenuInfo(Menu arg1, boolean nullOk) throws ARException {
        if (arg1 == null && !nullOk) {
            this.throwValidationException(2, 112);
        }
        switch (arg1.getMenuType()) {
            case 0: {
                break;
            }
            case 1: {
                ListMenu lm = (ListMenu)arg1;
                this.validateARCharMenuList(lm, 0);
                break;
            }
            case 2: {
                QueryMenu qm = (QueryMenu)arg1;
                try {
                    this.validateARNameType(qm.getForm(), false);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                try {
                    this.validateARServerNameType(qm.getServer(), false);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                try {
                    this.validateARQualifierInfo(qm.getQualification(), true);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                if (qm.getLabelField().get(0) == 0) {
                    this.throwValidationException(2, 130);
                } else if (qm.getValueField() == 0) {
                    this.throwValidationException(2, 130);
                }
                try {
                    this.validateARNameType(qm.getSampleForm(), true);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                try {
                    this.validateARServerNameType(qm.getSampleServer(), true);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                break;
            }
            case 3: {
                FileMenu fm = (FileMenu)arg1;
                if (fm.getLocation() != 1 && fm.getLocation() != 2) {
                    this.throwValidationException(2, 208);
                }
                this.validateARStringType(fm.getFileName(), 255, 209);
                break;
            }
            case 4: {
                SqlMenu sm = (SqlMenu)arg1;
                try {
                    this.validateARServerNameType(sm.getServer(), false);
                    this.validateARNameType(sm.getName(), false);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                DataDictionaryMenu ddm = (DataDictionaryMenu)arg1;
                try {
                    this.validateARServerNameType(ddm.getServer(), false);
                }
                catch (ARException e) {
                    this.throwValidationException(2, 130);
                }
                if (ddm.getStructType() != 1 && ddm.getStructType() != 2) {
                    this.throwValidationException(2, 130);
                    break;
                }
                if (ddm.getStructType() != 2) break;
                FieldDataDictionaryMenu fddm = (FieldDataDictionaryMenu)ddm;
                this.validateARStringType(fddm.getForm(), 254, 130);
                break;
            }
            default: {
                if (nullOk && arg1.getMenuType() == 0) break;
                this.throwValidationException(2, 206);
            }
        }
    }

    public final void validateARFieldMapping(Field field, boolean nullOk) throws ARException {
        FieldMapping fmp = field.getFieldMap();
        if (fmp == null || fmp.getMappingType() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 270, field.getName());
            }
        } else {
            int fieldType = fmp.getMappingType();
            if (fieldType != 1) {
                if (fieldType == 2) {
                    JoinFieldMapping jfp = (JoinFieldMapping)fmp;
                    if (jfp.getIndex() != 0 && jfp.getIndex() != 1) {
                        this.throwValidationException(2, 271, field.getName());
                    }
                } else if (fieldType == 3) {
                    ViewFieldMapping vwfp = (ViewFieldMapping)fmp;
                    try {
                        this.validateARNameType(vwfp.getFieldName(), false);
                    }
                    catch (ARException e) {
                        this.throwValidationException(2, 272, field.getName());
                    }
                } else if (fieldType == 4) {
                    VendorFieldMapping vnfp = (VendorFieldMapping)fmp;
                    try {
                        this.validateARNameType(vnfp.getFieldName(), false);
                    }
                    catch (ARException e) {
                        this.throwValidationException(2, 8727, field.getName());
                    }
                } else {
                    this.throwValidationException(2, 273, field.getName());
                }
            }
        }
    }

    public final void validateARFormType(Form form, boolean nullOk) throws ARException {
        if (!(form != null && form.getFormType() != 0 || nullOk)) {
            this.throwValidationException(2, 265);
        } else if (form.getFormType() == 2) {
            JoinForm jF = (JoinForm)form;
            String memberA = jF.getMemberA();
            String memberB = jF.getMemberB();
            try {
                this.validateARNameType(memberA, nullOk);
            }
            catch (ARException e) {
                this.throwValidationException(2, 266);
            }
            try {
                this.validateARNameType(memberB, nullOk);
            }
            catch (ARException e) {
                this.throwValidationException(2, 266);
            }
            QualifierInfo qf = jF.getJoinQualification();
            try {
                this.validateARQualifierInfo(qf, false);
            }
            catch (ARException e) {
                this.throwValidationException(2, 267);
            }
        }
    }

    public final void validateARLocaleType(String locale, boolean nullOk) throws ARException {
        this.validateARStringType(locale, 254, 0, 0, nullOk);
    }

    public final void validateARPropList(PropertyMap objPropList, boolean nullOk) throws ARException {
        if (objPropList == null || objPropList.size() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, 212);
            }
        } else {
            for (Map.Entry e : objPropList.entrySet()) {
                if (e == null) continue;
                Value value = (Value)e.getValue();
                this.validateARValueInfo(value);
            }
        }
    }

    public final void validateARValueList(List<Value> values) throws ARException {
        for (int i = 0; i < values.size(); ++i) {
            this.validateARValueInfo(values.get(i));
        }
    }

    public final void validateARValueInfo(Value value) throws ARException {
        int keyNum;
        if (value == null) {
            return;
        }
        Object dataValue = value.getValue();
        int dataType = value.getDataType().toInt();
        if (dataType == 1 && dataValue != null && (keyNum = ((Keyword)dataValue).toInt()) > 53) {
            this.throwValidationException(2, 197);
        }
        if (dataType == 11 && dataValue != null) {
            this.validateARStringType(((AttachmentValue)dataValue).getName(), 255, 0, 109, false);
        }
    }

    public final void validateARIndexList(List<IndexInfo> indexInfo) throws ARException {
        if (indexInfo == null || indexInfo.size() == 0) {
            return;
        }
        for (int i = 0; i < indexInfo.size(); ++i) {
            if (indexInfo.get(i).getIndexFields().size() != 0 && indexInfo.get(i).getIndexFields().size() <= 16) continue;
            this.throwValidationException(2, 211);
        }
    }

    public final void validateARCharMenuList(ListMenu lm, int level) throws ARException {
        if (lm == null || lm.getItems().size() == 0) {
            this.throwValidationException(2, 112);
        } else if (lm.getItems().size() > 199) {
            this.throwValidationException(2, 357);
        } else {
            for (int i = 0; i < lm.getItems().size(); ++i) {
                this.validateARCharMenuItemInfo(lm.getContent().get(i), level);
            }
        }
    }

    public final void validateARCharMenuItemInfo(MenuItem item, int level) throws ARException {
        if (item == null) {
            this.throwValidationException(2, 112);
        }
        if (level > 15) {
            this.throwValidationException(2, 321);
        }
        String menuLabel = item.getLabel();
        int menuType = item.getType();
        String value = item.getValue();
        try {
            this.validateARNameType(menuLabel, false);
        }
        catch (ARException e) {
            this.throwValidationException(2, 130);
        }
        switch (menuType) {
            case 1: {
                this.validateARStringType(value, 255, 130);
                break;
            }
            case 2: {
                List<MenuItem> subMenu = item.getSubMenu();
                for (int i = 0; i < subMenu.size(); ++i) {
                    this.validateARCharMenuItemInfo(subMenu.get(i), level + 1);
                }
                break;
            }
            default: {
                this.throwValidationException(2, 131);
            }
        }
    }

    public final void validateARSortList(List<? extends SortInfo> sortInfo) throws ARException {
        if (sortInfo == null || sortInfo.size() == 0) {
            return;
        }
        for (int i = 0; i < sortInfo.size(); ++i) {
            if (sortInfo.get(i).getSortOrder() == 1 || sortInfo.get(i).getSortOrder() == 2) continue;
            this.throwValidationException(2, 152);
        }
    }

    public final void validateAREntryListFieldInfo(List<EntryListFieldInfo> getListFields) throws ARException {
        if (getListFields == null || getListFields.size() == 0) {
            return;
        }
        for (int i = 0; i < getListFields.size(); ++i) {
            if ((long)getListFields.get(i).getFieldId() == 99L) continue;
            if (getListFields.get(i).getFieldId() == 0 || getListFields.get(i).getColumnWidth() == 0) {
                this.throwValidationException(2, 214);
            }
            this.validateARStringType(getListFields.get(i).getSeparator(), 10, 0, 214, true);
        }
    }

    public final void validateARPermissionList(List<PermissionInfo> permissionList) throws ARException {
        if (permissionList == null) {
            return;
        }
        for (int i = 0; i < permissionList.size(); ++i) {
            if (permissionList.get(i).getPermissionValue() <= 2) continue;
            this.throwValidationException(2, 128);
        }
    }

    public final void validateARQualifierInfo(QualifierInfo qf, boolean nullOk) throws ARException {
        if (qf == null) {
            return;
        }
        int operation = qf.getOperation();
        switch (operation) {
            case 0: {
                if (nullOk) break;
                this.throwValidationException(2, 141);
                break;
            }
            case 1: 
            case 2: {
                if (qf.getLeftOperand() != null && qf.getRightOperand() != null) {
                    this.validateARQualifierInfo(qf.getLeftOperand(), false);
                    this.validateARQualifierInfo(qf.getRightOperand(), false);
                    break;
                }
                this.throwValidationException(2, 141);
                break;
            }
            case 3: {
                if (qf.getNotOperand() != null) {
                    this.validateARQualifierInfo(qf.getNotOperand(), false);
                    break;
                }
                this.throwValidationException(2, 141);
                break;
            }
            case 4: {
                if (qf.getRelationalOperationInfo() == null) break;
                this.validateARRelOpInfo(qf.getRelationalOperationInfo());
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.throwValidationException(2, 142);
            }
        }
    }

    public final void validateARQualifierInfoList(List<QualifierInfo> qfList, boolean nullOk) throws ARException {
        if (qfList == null) {
            return;
        }
        for (int i = 0; i < qfList.size(); ++i) {
            this.validateARQualifierInfo(qfList.get(i), nullOk);
        }
    }

    public final void validateSupportFileType(int fileType) throws ARException {
        if (fileType < 0 || fileType > 1) {
            this.throwValidationException(2, 296);
        }
    }

    public final void validateARNameType(String name, boolean nullOk) throws ARException {
        this.validateARStringType(name, 254, nullOk);
    }

    public final void validateARAccessNameType(String name, boolean nullOk) throws ARException {
        this.validateARStringType(name, 254, nullOk);
    }

    public final void validateARServerNameType(String serverName, boolean nullOk) throws ARException {
        this.validateARStringType(serverName, 64, nullOk);
    }

    public final void validateARStringType(String arString, int maxLen, boolean nullOk) throws ARException {
        this.validateARStringType(arString, maxLen, 0, 0, nullOk);
    }

    public final void validateARStringType(String arString, int maxLen, int errorCode) throws ARException {
        this.validateARStringType(arString, maxLen, errorCode, errorCode, false);
    }

    public final void validateARStringType(String arString, int maxLen, int emptyError, int tooLongError, boolean nullOk) throws ARException {
        if (emptyError == 0) {
            emptyError = 102;
        }
        if (tooLongError == 0) {
            tooLongError = 103;
        }
        if (arString == null || arString.length() == 0) {
            if (!nullOk) {
                this.throwValidationException(2, emptyError);
            }
        } else if (maxLen != 0) {
            try {
                if (arString.getBytes(this.svrCharSet).length > maxLen) {
                    this.throwValidationException(2, tooLongError);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e);
                this.throwValidationException(2, 9062, e.getLocalizedMessage());
            }
        }
    }

    public final void validateRegularQuery(RegularQuery query) throws ARException {
        if (query == null) {
            this.throwValidationException(2, 9984);
        }
        this.validateQuerySources(query.getFromSources());
        this.validateQueryFormFields(query.getFromFields());
        this.validateARQualifierInfo(query.getQualifier(), true);
        List<SortInfo> sortInfoList = query.getSortBy();
        this.validateARSortList(sortInfoList);
        if (query.getSortBy() != null) {
            for (int i = 0; i < sortInfoList.size(); ++i) {
                if (sortInfoList.get(i).getFieldID() != 0 && sortInfoList.get(i).getSource() != null) continue;
                this.throwValidationException(2, 152);
            }
        }
    }

    public final void validateComplexRegularQuery(RegularComplexQuery query) throws ARException {
        if (query == null) {
            this.throwValidationException(2, 9984);
        }
        this.validateQuerySources(query.getFromSources());
        this.validateSelectionList(query.getSelectionList());
        this.validateARQualifierInfo(query.getQualifier(), true);
        List<ComplexSortInfo> sortInfoList = query.getSortBy();
        this.validateARSortList(sortInfoList);
        if (query.getSortBy() != null) {
            for (int i = 0; i < sortInfoList.size(); ++i) {
                try {
                    ArithmeticOrRelationalOperand sortOperand = sortInfoList.get(i).getSortOperand();
                    this.validateARFieldValueOrArithInfo(sortOperand, false);
                    this.verifyQuerySourceForFieldOperand(sortOperand, null);
                    continue;
                }
                catch (ARException e) {
                    this.throwValidationException(2, 152, e.getMessage());
                }
            }
        }
    }

    private void validateSelectionList(List<ArithmeticOrRelationalOperand> selectionList) throws ARException {
        for (ArithmeticOrRelationalOperand operand : selectionList) {
            this.validateARFieldValueOrArithInfo(operand, false);
            this.verifyQuerySourceForFieldOperand(operand, null);
        }
    }

    public final void validateQuerySources(List<IQuerySource> querySources) throws ARException {
        if (querySources == null || querySources.size() == 0) {
            this.throwValidationException(2, 9985);
        }
        if (querySources.get(0) != null && (querySources.get(0).getJoinQualifier() != null || querySources.get(0).getJoinedWith() != null)) {
            this.throwValidationException(2, 9993);
        }
        for (int i = 0; i < querySources.size(); ++i) {
            this.validateQuerySource(querySources.get(i));
        }
    }

    public final void validateQuerySource(IQuerySource querySource) throws ARException {
        if (querySource instanceof QuerySourceForm) {
            this.validateARStringType(((QuerySourceForm)querySource).getName(), 254, false);
        } else if (querySource instanceof RecursiveQuery) {
            this.validateRecursiveQuery((RecursiveQuery)querySource);
        } else if (querySource instanceof RecursiveComplexQuery) {
            // empty if block
        }
        this.validateQueryJoin(querySource);
    }

    public final void validateQueryJoin(IQuerySource querySource) throws ARException {
        if (querySource.getJoinQualifier() != null && querySource.getJoinType() == -1 || querySource.getJoinType() < -1 || querySource.getJoinType() > 2) {
            this.throwValidationException(2, 9981);
        }
        if (querySource.getJoinQualifier() != null && querySource.getJoinedWith() == null) {
            this.throwValidationException(2, 9986);
        }
    }

    public final void validateQueryFormFields(List<QueryFormField> queryFields) throws ARException {
        for (int i = 0; i < queryFields.size(); ++i) {
            this.validateQueryFormField(queryFields.get(i));
        }
    }

    public final void validateQueryFormField(QueryFormField queryField) throws ARException {
        if (queryField.getSource() == null || queryField.getFieldId() <= 0) {
            this.throwValidationException(2, 9987);
        }
    }

    public final void validateRecursiveQuery(RecursiveQuery recQuery) throws ARException {
        boolean recQueryValid;
        block7: {
            block6: {
                if (recQuery == null) {
                    this.throwValidationException(2, 9988);
                }
                this.validateQueryFormFields(recQuery.getFromFields());
                this.validateQuerySources(recQuery.getFromSources());
                if (recQuery.getRecursionQualifier() == null) {
                    this.throwValidationException(2, 9975);
                }
                for (int i = 0; i < recQuery.getFromSources().size(); ++i) {
                    IQuerySource querySource = recQuery.getFromSources().get(i);
                    if (querySource instanceof QuerySourceForm) continue;
                    this.throwValidationException(2, 9976);
                }
                recQueryValid = false;
                if (recQuery.getRecursiveForm() != null && recQuery.getRecursiveForm().getName().length() != 0) break block6;
                if (recQuery.getFromSources().size() != 1) break block7;
                recQuery.setRecursiveForm((QuerySourceForm)recQuery.getFromSources().get(0));
                recQueryValid = true;
                break block7;
            }
            for (int i = 0; i < recQuery.getFromSources().size(); ++i) {
                IQuerySource querySource = recQuery.getFromSources().get(i);
                if (!recQuery.getRecursiveForm().equals(querySource)) continue;
                recQueryValid = true;
                break;
            }
        }
        if (!recQueryValid) {
            this.throwValidationException(2, 9980);
        }
        for (int i = 0; i < recQuery.getFromFields().size(); ++i) {
            QueryFormField field = recQuery.getFromFields().get(i);
            if (field.getSource().equals(recQuery.getRecursiveForm())) continue;
            this.throwValidationException(2, 9979);
        }
        this.validateARQualifierInfo(recQuery.getRecursionQualifier(), true);
        this.validateARQualifierInfo(recQuery.getQualifier(), true);
        this.validateARQualifierInfo(recQuery.getJoinQualifier(), true);
    }

    public final void validateRecursiveCompelxQuery(RecursiveComplexQuery recQuery) throws ARException {
        boolean recQueryValid;
        block7: {
            block6: {
                if (recQuery == null) {
                    this.throwValidationException(2, 9988);
                }
                this.validateSelectionList(recQuery.getSelectionList());
                this.validateQuerySources(recQuery.getFromSources());
                if (recQuery.getRecursionQualifier() == null) {
                    this.throwValidationException(2, 9975);
                }
                for (int i = 0; i < recQuery.getFromSources().size(); ++i) {
                    IQuerySource querySource = recQuery.getFromSources().get(i);
                    if (querySource instanceof QuerySourceForm) continue;
                    this.throwValidationException(2, 9976);
                }
                recQueryValid = false;
                if (recQuery.getRecursiveForm() != null && recQuery.getRecursiveForm().getName().length() != 0) break block6;
                if (recQuery.getFromSources().size() != 1) break block7;
                recQuery.setRecursiveForm((QuerySourceForm)recQuery.getFromSources().get(0));
                recQueryValid = true;
                break block7;
            }
            for (int i = 0; i < recQuery.getFromSources().size(); ++i) {
                IQuerySource querySource = recQuery.getFromSources().get(i);
                if (!recQuery.getRecursiveForm().equals(querySource)) continue;
                recQueryValid = true;
                break;
            }
        }
        if (!recQueryValid) {
            this.throwValidationException(2, 9980);
        }
        for (int i = 0; i < recQuery.getSelectionList().size(); ++i) {
            this.verifyQuerySourceForFieldOperand(recQuery.getSelectionList().get(i), recQuery.getRecursiveForm());
        }
        this.validateARQualifierInfo(recQuery.getRecursionQualifier(), true);
        this.validateARQualifierInfo(recQuery.getQualifier(), true);
        this.validateARQualifierInfo(recQuery.getJoinQualifier(), true);
    }

    private void verifyQuerySourceForFieldOperand(ArithmeticOrRelationalOperand selectionOperand, QuerySourceForm recursiveForm) throws ARException {
        if (selectionOperand == null || selectionOperand.getType().toInt() == 0) {
            this.throwValidationException(2, 147);
        }
        int arithType = selectionOperand.getType().toInt();
        switch (arithType) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                FieldOperandInfo field = (FieldOperandInfo)selectionOperand.getValue();
                if (field.getQuerySource() == null || field.getFieldId() <= 0) {
                    this.throwValidationException(2, 9987);
                }
                if (recursiveForm == null || field.getQuerySource().equals(recursiveForm)) break;
                this.throwValidationException(2, 9979);
                break;
            }
            case 3: {
                ArithmeticOperationInfo arithOp = (ArithmeticOperationInfo)selectionOperand.getValue();
                if (arithOp.getOperation() == 6) break;
                this.verifyQuerySourceForFieldOperand(arithOp.getLeftOperand(), recursiveForm);
                this.verifyQuerySourceForFieldOperand(arithOp.getRightOperand(), recursiveForm);
                break;
            }
            case 9: {
                FunctionOperandInfo function = (FunctionOperandInfo)selectionOperand.getValue();
                for (ArithmeticOrRelationalOperand parameter : function.getParameterList()) {
                    this.verifyQuerySourceForFieldOperand(parameter, recursiveForm);
                }
                break;
            }
            case 10: {
                CaseOperandInfo caseOperand = (CaseOperandInfo)selectionOperand.getValue();
                ArithmeticOrRelationalOperand elseOperand = caseOperand.getElse();
                if (elseOperand != null) {
                    this.verifyQuerySourceForFieldOperand(elseOperand, recursiveForm);
                }
                if (caseOperand instanceof SwitchCaseOperandInfo) {
                    SwitchCaseOperandInfo switchCaseOperand = (SwitchCaseOperandInfo)caseOperand;
                    this.verifyQuerySourceForFieldOperand(switchCaseOperand.getSwitch(), recursiveForm);
                    for (Map.Entry<ArithmeticOrRelationalOperand, ArithmeticOrRelationalOperand> whenThen : switchCaseOperand.getWhenThenList().entrySet()) {
                        this.verifyQuerySourceForFieldOperand(whenThen.getKey(), recursiveForm);
                        this.verifyQuerySourceForFieldOperand(whenThen.getValue(), recursiveForm);
                    }
                } else {
                    if (!(caseOperand instanceof QualifiedCaseOperandInfo)) break;
                    QualifiedCaseOperandInfo qualifiedCaseOperand = (QualifiedCaseOperandInfo)caseOperand;
                    for (Map.Entry<QualifierInfo, ArithmeticOrRelationalOperand> whenThen : qualifiedCaseOperand.getWhenThenList().entrySet()) {
                        this.verifyQuerySourceForFieldOperand(whenThen.getValue(), recursiveForm);
                    }
                }
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 52: 
            case 53: {
                break;
            }
        }
    }

    public final void validateARValueSetQuery(ValueSetQuery valueSetQuery) throws ARException {
        this.validateQuerySources(valueSetQuery.getFromSources());
        if (valueSetQuery.getFromFields().size() != 1) {
            this.throwValidationException(2, 9990);
        }
        this.validateQueryFormFields(valueSetQuery.getFromFields());
        this.validateARQualifierInfo(valueSetQuery.getQualifier(), true);
    }

    private void throwValidationException(int returnCode, int errorCode) throws ARException {
        this.throwValidationException(returnCode, errorCode, null);
    }

    private void throwValidationException(int returnCode, int errorCode, String appendMsg) throws ARException {
        throw new ARException(returnCode, errorCode, appendMsg);
    }

    public final void validateAROverlaidInfo(OverlaidInfo overlaidInfo) throws ARException {
        int objectType;
        if (overlaidInfo.getObjType() != 15 && overlaidInfo.getObjType() != 14) {
            this.validateARNameType(overlaidInfo.getName(), false);
            if (overlaidInfo.getName().contains("__o")) {
                this.throwValidationException(2, 8858);
            }
        }
        if ((objectType = overlaidInfo.getObjType()) != 5 && objectType != 6 && objectType != 9 && objectType != 12 && objectType != 1 && objectType != 15 && objectType != 14 && objectType != 8 && objectType != 17 && objectType != 20) {
            this.throwValidationException(2, 8857);
        }
        if (objectType == 15 || objectType == 14) {
            this.validateARNameType(overlaidInfo.getFormName(), false);
        }
    }
}

