/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@ARStructTypeInfo(Name="AROpenDlgStruct", NumberOfMembers=15)
public class OpenWindowAction
extends Action
implements ActiveLinkAction,
Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(OpenWindowAction.class);
    private static final long serialVersionUID = -3655981239731786982L;
    private String m_sampleForm;
    private String m_sampleServer;
    @ARStructMemTypeInfo(Name="serverName", Offset=0)
    private String m_serverName;
    @ARStructMemTypeInfo(Name="formName", Offset=1)
    private String m_formName;
    @ARStructMemTypeInfo(Name="vuiLabel", Offset=2)
    private String m_vuiLabel;
    @ARStructMemTypeInfo(Name="closeBox", Offset=3)
    private boolean m_closeBox;
    @ARStructMemTypeInfo(Name="inputValueFieldPairs", Offset=4)
    private List<FieldAssignInfo> m_inputValueFieldPairs;
    @ARStructMemTypeInfo(Name="outputValueFieldPairs", Offset=5)
    private List<FieldAssignInfo> m_outputValueFieldPairs;
    @ARStructMemTypeInfo(Name="windowMode", Offset=6)
    private int m_windowMode;
    @ARStructMemTypeInfo(Name="targetLocation", Offset=7)
    private String m_targetLocation;
    @ARStructMemTypeInfo(Name="query", Offset=8)
    private QualifierInfo m_query;
    @ARStructMemTypeInfo(Name="noMatchContinue", Offset=9)
    private boolean m_noMatchContinue;
    @ARStructMemTypeInfo(Name="suppressEmptyLst", Offset=10)
    private boolean m_suppressEmptyLst;
    @ARStructMemTypeInfo(Name="msg", Offset=11)
    private MessageAction m_msg;
    @ARStructMemTypeInfo(Name="pollinginterval", Offset=12)
    private int m_pollinginterval;
    @ARStructMemTypeInfo(Name="sortOrderList", Offset=14)
    private List<SortInfo> m_sortOrderList;
    private ReportInfo m_report;

    public OpenWindowAction() {
    }

    public OpenWindowAction(String serverName, String formName, String vuiLabel, boolean closeBox, List<FieldAssignInfo> inputValueFieldPairs, List<FieldAssignInfo> outputValueFieldPairs, int windowMode, QualifierInfo query, boolean noMatchContinue, MessageAction msg, int pollinginterval, ReportInfo reportInfo, List<SortInfo> sortOrderList, String targetLocation, boolean suppressEmptyLst) {
        this.m_serverName = serverName;
        this.m_formName = formName;
        this.m_vuiLabel = vuiLabel;
        this.m_closeBox = closeBox;
        this.m_inputValueFieldPairs = inputValueFieldPairs;
        this.m_outputValueFieldPairs = outputValueFieldPairs;
        this.m_windowMode = windowMode;
        this.m_query = query;
        this.m_noMatchContinue = noMatchContinue;
        this.m_msg = msg;
        this.m_pollinginterval = pollinginterval;
        this.setReportInfo(reportInfo);
        this.m_sortOrderList = sortOrderList;
        this.m_targetLocation = targetLocation;
        this.m_suppressEmptyLst = suppressEmptyLst;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public void setServerName(String serverName) {
        this.m_serverName = serverName;
    }

    public String getFormName() {
        return this.m_formName;
    }

    public void setFormName(String formName) {
        this.m_formName = formName;
    }

    public String getVuiLabel() {
        return this.m_vuiLabel;
    }

    public void setVuiLabel(String vuiLabel) {
        this.m_vuiLabel = vuiLabel;
    }

    public boolean isCloseBox() {
        return this.m_closeBox;
    }

    public void setCloseBox(boolean closeBox) {
        this.m_closeBox = closeBox;
    }

    public List<FieldAssignInfo> getInputValueFieldPairs() {
        return this.m_inputValueFieldPairs;
    }

    public void setInputValueFieldPairs(List<FieldAssignInfo> inputValueFieldPairs) {
        this.m_inputValueFieldPairs = inputValueFieldPairs;
    }

    public List<FieldAssignInfo> getOutputValueFieldPairs() {
        return this.m_outputValueFieldPairs;
    }

    public void setOutputValueFieldPairs(List<FieldAssignInfo> outputValueFieldPairs) {
        this.m_outputValueFieldPairs = outputValueFieldPairs;
    }

    public int getWindowMode() {
        return this.m_windowMode;
    }

    public void setWindowMode(int windowMode) {
        this.m_windowMode = windowMode;
    }

    public QualifierInfo getQuery() {
        return this.m_query;
    }

    public void setQuery(QualifierInfo query) {
        this.m_query = query;
    }

    public boolean isNoMatchContinue() {
        return this.m_noMatchContinue;
    }

    public void setNoMatchContinue(boolean noMatchContinue) {
        this.m_noMatchContinue = noMatchContinue;
    }

    public MessageAction getMsg() {
        return this.m_msg;
    }

    public void setMsg(MessageAction msg) {
        this.m_msg = msg;
    }

    public int getPollinginterval() {
        return this.m_pollinginterval;
    }

    public void setPollinginterval(int pollinginterval) {
        this.m_pollinginterval = pollinginterval;
    }

    public String getReportString() {
        return OpenWindowAction.buildReportString(this.m_report);
    }

    public ReportInfo getReportInfo() {
        return this.m_report;
    }

    public void setReportInfo(ReportInfo report) {
        this.m_report = report;
    }

    public List<SortInfo> getSortOrderList() {
        return this.m_sortOrderList;
    }

    public void setSortOrderList(List<SortInfo> sortOrderList) {
        this.m_sortOrderList = sortOrderList;
    }

    public String getTargetLocation() {
        return this.m_targetLocation;
    }

    public void setTargetLocation(String targetLocation) {
        this.m_targetLocation = targetLocation;
    }

    public boolean isSuppressEmptyLst() {
        return this.m_suppressEmptyLst;
    }

    public void setSuppressEmptyLst(boolean suppressEmptyLst) {
        this.m_suppressEmptyLst = suppressEmptyLst;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        int nLen;
        OpenWindowAction obj = (OpenWindowAction)super.clone();
        if (this.m_inputValueFieldPairs != null) {
            nLen = this.m_inputValueFieldPairs.size();
            obj.m_inputValueFieldPairs = new ArrayList<FieldAssignInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_inputValueFieldPairs.add((FieldAssignInfo)this.m_inputValueFieldPairs.get(i).clone());
            }
        }
        if (this.m_outputValueFieldPairs != null) {
            nLen = this.m_outputValueFieldPairs.size();
            obj.m_outputValueFieldPairs = new ArrayList<FieldAssignInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_outputValueFieldPairs.add((FieldAssignInfo)this.m_outputValueFieldPairs.get(i).clone());
            }
        }
        if (this.m_query != null) {
            obj.m_query = (QualifierInfo)this.m_query.clone();
        }
        if (this.m_msg != null) {
            obj.m_msg = (MessageAction)this.m_msg.clone();
        }
        if (this.m_sortOrderList != null) {
            nLen = this.m_sortOrderList.size();
            obj.m_sortOrderList = new ArrayList<SortInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_sortOrderList.add((SortInfo)this.m_sortOrderList.get(i).clone());
            }
        }
        if (this.m_report != null) {
            obj.m_report = (ReportInfo)this.m_report.clone();
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OpenWindowAction)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OpenWindowAction rhs = (OpenWindowAction)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_serverName, rhs.m_serverName).append(this.m_formName, rhs.m_formName).append(this.m_vuiLabel, rhs.m_vuiLabel).append(this.m_closeBox, rhs.m_closeBox).append(this.m_inputValueFieldPairs, rhs.m_inputValueFieldPairs).append(this.m_outputValueFieldPairs, rhs.m_outputValueFieldPairs).append(this.m_windowMode, rhs.m_windowMode).append(this.m_targetLocation, rhs.m_targetLocation).append(this.m_query, rhs.m_query).append(this.m_noMatchContinue, rhs.m_noMatchContinue).append(this.m_suppressEmptyLst, rhs.m_suppressEmptyLst).append(this.m_msg, rhs.m_msg).append(this.m_pollinginterval, rhs.m_pollinginterval).append(this.m_report, rhs.m_report).append(this.m_sortOrderList, rhs.m_sortOrderList).isEquals();
    }

    @Override
    public boolean equals(Object anObject, String lhsServer, String lhsForm, String rhsServer, String rhsForm) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || !(anObject instanceof OpenWindowAction)) {
            return false;
        }
        OpenWindowAction rhs = (OpenWindowAction)anObject;
        return (this.m_serverName == null ? rhs.m_serverName == null : this.m_serverName.equals(rhs.m_serverName)) && (this.m_formName == null ? rhs.m_formName == null : this.m_formName.equals(rhs.m_formName)) && (this.m_vuiLabel == null ? rhs.m_vuiLabel == null : this.m_vuiLabel.equals(rhs.m_vuiLabel)) && this.m_closeBox == rhs.m_closeBox && Util.equalsFieldAssignInfo(this.m_inputValueFieldPairs, rhs.m_inputValueFieldPairs, lhsServer, lhsForm, rhsServer, rhsForm) && Util.equalsFieldAssignInfo(this.m_outputValueFieldPairs, rhs.m_outputValueFieldPairs, lhsServer, lhsForm, rhsServer, rhsForm) && this.m_windowMode == rhs.m_windowMode && (this.m_query == null ? rhs.m_query == null : this.m_query.equals(rhs.m_query)) && this.m_noMatchContinue == rhs.m_noMatchContinue && (this.m_msg == null ? rhs.m_msg == null : this.m_msg.equals(rhs.m_msg)) && this.m_pollinginterval == rhs.m_pollinginterval && (this.m_report == null ? rhs.m_report == null : this.m_report.equals(rhs.m_report)) && Util.equals(this.m_sortOrderList, rhs.m_sortOrderList) && (this.m_targetLocation == null ? rhs.m_targetLocation == null : this.m_targetLocation.equals(rhs.m_targetLocation)) && this.m_suppressEmptyLst == rhs.m_suppressEmptyLst;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_serverName).append(this.m_formName).append(this.m_vuiLabel).append(this.m_closeBox).append(this.m_inputValueFieldPairs).append(this.m_outputValueFieldPairs).append(this.m_windowMode).append(this.m_targetLocation).append(this.m_query).append(this.m_noMatchContinue).append(this.m_suppressEmptyLst).append(this.m_msg).append(this.m_pollinginterval).append(this.m_report).append(this.m_sortOrderList).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Server Name", this.m_serverName).append("Form Name", this.m_formName).append("Vui Label", this.m_vuiLabel).append("Close Box", this.m_closeBox).append("Input Value Field Pairs", this.m_inputValueFieldPairs).append("Output Value Field Pairs", this.m_outputValueFieldPairs).append("Window Mode", this.m_windowMode).append("Target Location", this.m_targetLocation).append("Query", this.m_query).append("No Match Continue", this.m_noMatchContinue).append("Suppress Empty Lst", this.m_suppressEmptyLst).append("Msg", this.m_msg).append("Pollinginterval", this.m_pollinginterval).append("Report String", this.m_report).append("Sort Order List", this.m_sortOrderList).toString();
    }

    public String getSampleForm() {
        return this.m_sampleForm;
    }

    public String getSampleServer() {
        return this.m_sampleServer;
    }

    public void setSampleForm(String sampleForm) {
        this.m_sampleForm = sampleForm;
    }

    public void setSampleServer(String sampleServer) {
        this.m_sampleServer = sampleServer;
    }

    public boolean isInputDefault() {
        List<FieldAssignInfo> fieldAssignList = this.getInputValueFieldPairs();
        if (fieldAssignList == null || fieldAssignList.size() <= 0) {
            return false;
        }
        FieldAssignInfo marker = fieldAssignList.get(0);
        if (marker == null) {
            return false;
        }
        return marker.getFieldId() == 97 && marker.getAssignmentType() == 1 && marker.getAssignment() != null && marker.getAssignment().getValue() != null && marker.getAssignment().getValue().toString().equals("@");
    }

    public void setInputDefault(boolean isInputDefault) {
        if (isInputDefault) {
            FieldAssignInfo marker = new FieldAssignInfo();
            marker.setFieldId(97);
            AssignInfo assignInfo = new AssignInfo();
            assignInfo.setAssignType(1);
            assignInfo.setValue(new Value("@"));
            marker.setAssignment(assignInfo);
            ArrayList<FieldAssignInfo> fieldAssignList = new ArrayList<FieldAssignInfo>();
            fieldAssignList.add(marker);
            this.setInputValueFieldPairs(fieldAssignList);
        } else if (this.isInputDefault()) {
            ArrayList<FieldAssignInfo> fieldAssignList = new ArrayList<FieldAssignInfo>();
            this.setInputValueFieldPairs(fieldAssignList);
        }
    }

    private static final void prepareFieldAssignments(ARServerUser ctx, List<FieldAssignInfo> fieldAssignList, OutputInteger isByMatchingIds, OutputInteger isDefault) {
        int fieldId;
        isByMatchingIds.setValue(0);
        isDefault.setValue(0);
        int n = fieldId = fieldAssignList.size() > 0 ? fieldAssignList.get(0).getFieldId() : 0;
        if (fieldId == 98) {
            isByMatchingIds.setValue(1);
            return;
        }
        if (fieldId == 97) {
            isDefault.setValue(1);
            return;
        }
        if (Config.getInstance().isStringizeFieldAssignments()) {
            try {
                FieldAssignInfo.buildFieldAssignmentList(ctx.getSession().getServer(ctx.getSession().getSecondaryServerName()), ctx.getSession().getCurrentLocalForm(), ctx.getSession().getCurrentRemoteForm(), isByMatchingIds, isDefault, fieldAssignList);
            }
            catch (ARException e) {
                logger.error("buildFieldAssignmentList failed", e);
            }
        }
    }

    final void prepareFieldAssignments(ARServerUser ctx) {
        ctx.getSession().setSecondaryServerName(this.getServerName(), this.getSampleServer());
        ctx.getSession().setCurrentRemoteForm(this.getFormName(), this.getSampleForm());
        String origCurrentLocalForm = ctx.getSession().getCurrentLocalForm();
        String origCurrentRemoteForm = ctx.getSession().getCurrentRemoteForm();
        ctx.getSession().setCurrentLocalForm(origCurrentRemoteForm);
        ctx.getSession().setCurrentRemoteForm(origCurrentLocalForm);
        List<FieldAssignInfo> fieldAssignList = this.getInputValueFieldPairs();
        OutputInteger isByMatchingIds = new OutputInteger(0);
        OutputInteger isDefault = new OutputInteger(0);
        OpenWindowAction.prepareFieldAssignments(ctx, fieldAssignList, isByMatchingIds, isDefault);
        this.setInputDefault(isDefault.intValue() != 0);
        ctx.getSession().setCurrentLocalForm(origCurrentLocalForm);
        ctx.getSession().setCurrentRemoteForm(origCurrentRemoteForm);
        fieldAssignList = this.getOutputValueFieldPairs();
        OpenWindowAction.prepareFieldAssignments(ctx, fieldAssignList, isByMatchingIds, isDefault);
    }

    static String buildReportString(ReportInfo reportInfo) {
        if (reportInfo == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("\nReport: ");
        sb.append("\u000121=" + reportInfo.getType());
        sb.append("\u000122=" + (reportInfo.getReportFileId() != 0 ? "!" + reportInfo.getReportFileId() + "!" : "") + reportInfo.getName());
        sb.append("\u000129=" + reportInfo.getOperation());
        sb.append("\u000127=" + reportInfo.getEntryIds());
        sb.append("\u000128=" + reportInfo.getQueryOverride());
        sb.append("\u000124=" + reportInfo.getFormName());
        sb.append("\u000125=" + reportInfo.getServerName());
        sb.append("\u000126=" + reportInfo.getQuery());
        sb.append("\u000130=" + reportInfo.getLocation());
        sb.append("\u000131=" + reportInfo.getCharacterEncoding());
        sb.append("\u000132=" + reportInfo.isInlineForm());
        sb.append("\u0001\n" + reportInfo.getDestination() + "\n");
        return sb.toString();
    }

    static ReportInfo parseReportString(String reportString, int windowMode) {
        if (reportString == null || !reportString.startsWith("\nReport: ")) {
            return null;
        }
        ReportInfo reportInfo = null;
        String[] reportInfoMembers = reportString.split("\u0001");
        String[] subTokens = null;
        String[] reportNameSubTokens = null;
        if (reportInfoMembers != null) {
            reportInfo = new ReportInfo();
            block13: for (String token : reportInfoMembers) {
                subTokens = token.split("=");
                if (subTokens == null || subTokens.length != 2) continue;
                switch (Integer.parseInt(subTokens[0].trim())) {
                    case 21: {
                        reportInfo.setType(subTokens[1]);
                        continue block13;
                    }
                    case 22: {
                        reportNameSubTokens = subTokens[1].split("!");
                        if (reportNameSubTokens != null && reportNameSubTokens.length == 3) {
                            reportInfo.setReportFileId(Integer.parseInt(reportNameSubTokens[1].trim()));
                            reportInfo.setName(reportNameSubTokens[2]);
                            continue block13;
                        }
                        reportInfo.setName(subTokens[1]);
                        continue block13;
                    }
                    case 30: {
                        reportInfo.setLocation(Integer.parseInt(subTokens[1].trim()), windowMode);
                        continue block13;
                    }
                    case 27: {
                        reportInfo.setEntryIds(subTokens[1]);
                        continue block13;
                    }
                    case 28: {
                        reportInfo.setQueryOverride(subTokens[1]);
                        continue block13;
                    }
                    case 31: {
                        reportInfo.setCharacterEncoding(subTokens[1]);
                        continue block13;
                    }
                    case 29: {
                        reportInfo.setOperation(subTokens[1]);
                        continue block13;
                    }
                    case 26: {
                        reportInfo.setQuery(subTokens[1]);
                        continue block13;
                    }
                    case 24: {
                        reportInfo.setFormName(subTokens[1]);
                        continue block13;
                    }
                    case 25: {
                        reportInfo.setServerName(subTokens[1]);
                        continue block13;
                    }
                    case 32: {
                        reportInfo.setInlineForm(Boolean.parseBoolean(subTokens[1]));
                        continue block13;
                    }
                }
            }
            reportInfoMembers = reportString.split("\n");
            if (reportInfoMembers != null && reportInfo != null && reportInfoMembers.length == 3) {
                reportInfo.setDestination(reportInfoMembers[2]);
            }
            if (windowMode == 9) {
                ReportInfo.checkIfNeedsFix(reportInfo);
            }
        }
        return reportInfo;
    }

    void updateReportFileInServer(ARServerUser context, String activeLink) throws ARException {
        if (this.m_report != null && this.m_report.doesNeedFix()) {
            if (this.m_report.getLocation() == 0) {
                SupportFile supportFile = new SupportFile(1, activeLink, 0, this.m_report.getReportFileId(), this.m_report.getName(), 0L);
                context.setSupportFile(supportFile);
            } else if (this.m_report.getLocation() != 0) {
                SupportFileKey fileKey = new SupportFileKey(1, activeLink, 0, this.m_report.getFileIdToDelete());
                context.deleteSupportFile(fileKey);
            }
            this.m_report.setNeedFix(false);
        }
    }

    public static class ReportInfo
    implements Serializable,
    Cloneable {
        static final String REPORT_BEGIN_IDENTIFIER = "\nReport: ";
        static final String REPORT_SEPARATOR = "\u0001";
        static final String REPORT_NAME_FILEID_SEPARATOR = "!";
        static final long serialVersionUID = -3655981239731786983L;
        private String name = "";
        private String type = "AR System";
        private int location = 0;
        private int reportFileId = 0;
        private int fileIdToDelete = 0;
        private boolean needFix = false;
        private String destination = "to-screen: ";
        private String operation = "";
        private String entryIds = "";
        private String queryOverride;
        private String characterEncoding = "";
        private String formName = "";
        private String serverName = "";
        private String query = "";
        private boolean inlineForm = false;

        public int getReportFileId() {
            return this.reportFileId;
        }

        private void setReportFileId(int reportFileId) {
            this.reportFileId = reportFileId;
        }

        private int getFileIdToDelete() {
            return this.fileIdToDelete;
        }

        public String getCharacterEncoding() {
            return this.characterEncoding;
        }

        public void setCharacterEncoding(String characterEncoding) {
            this.characterEncoding = characterEncoding;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public String getEntryIds() {
            return this.entryIds;
        }

        public void setEntryIds(String entryIds) {
            this.entryIds = entryIds;
        }

        public int getLocation() {
            return this.location;
        }

        public void setLocation(int locationType) {
            this.location = locationType;
            ReportInfo.checkIfNeedsFix(this);
        }

        public void setLocation(int locationType, int windowMode) {
            this.location = locationType;
            if (windowMode == 9) {
                ReportInfo.checkIfNeedsFix(this);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getQueryOverride() {
            return this.queryOverride;
        }

        public void setQueryOverride(String queryOverride) {
            this.queryOverride = queryOverride;
        }

        public String getFormName() {
            return this.formName;
        }

        public void setFormName(String formName) {
            this.formName = formName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String string) {
            this.query = string;
        }

        private boolean doesNeedFix() {
            return this.needFix;
        }

        public void setInlineForm(boolean inlineForm) {
            this.inlineForm = inlineForm;
        }

        public boolean isInlineForm() {
            return this.inlineForm;
        }

        private void setNeedFix(boolean needFix) {
            if (needFix && this.reportFileId != 0) {
                this.fileIdToDelete = this.reportFileId;
            } else if (!needFix) {
                this.fileIdToDelete = 0;
            }
            this.needFix = needFix;
        }

        private static void checkIfNeedsFix(ReportInfo reportInfo) {
            if (reportInfo.getLocation() == 0 && reportInfo.getReportFileId() == 0 || reportInfo.getLocation() != 0 && reportInfo.getReportFileId() != 0) {
                reportInfo.setNeedFix(true);
            } else {
                reportInfo.setNeedFix(false);
            }
        }

        int selfRepair(int fileId) {
            int nextFileId = fileId;
            if (this.doesNeedFix()) {
                if (this.getLocation() == 0) {
                    this.setReportFileId(fileId);
                    ++nextFileId;
                } else if (this.getLocation() != 0) {
                    this.setReportFileId(0);
                }
            }
            return nextFileId;
        }

        public Object clone() throws CloneNotSupportedException {
            ReportInfo obj = (ReportInfo)super.clone();
            return obj;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReportInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            ReportInfo rhs = (ReportInfo)obj;
            return new EqualsBuilder().append(this.name, rhs.name).append(this.type, rhs.type).append(this.location, rhs.location).append(this.reportFileId, rhs.reportFileId).append(this.fileIdToDelete, rhs.fileIdToDelete).append(this.needFix, rhs.needFix).append(this.destination, rhs.destination).append(this.operation, rhs.operation).append(this.entryIds, rhs.entryIds).append(this.queryOverride, rhs.queryOverride).append(this.characterEncoding, rhs.characterEncoding).append(this.formName, rhs.formName).append(this.serverName, rhs.serverName).append(this.query, rhs.query).append(this.inlineForm, rhs.inlineForm).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.name).append(this.type).append(this.location).append(this.reportFileId).append(this.fileIdToDelete).append(this.needFix).append(this.destination).append(this.operation).append(this.entryIds).append(this.queryOverride).append(this.characterEncoding).append(this.formName).append(this.serverName).append(this.query).append(this.inlineForm).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Name", this.name).append("Type", this.type).append("Location", this.location).append("Report File Id", this.reportFileId).append("File Id To Delete", this.fileIdToDelete).append("Need Fix", this.needFix).append("Destination", this.destination).append("Operation", this.operation).append("Entry Ids", this.entryIds).append("Query Override", this.queryOverride).append("Character Encoding", this.characterEncoding).append("Form Name", this.formName).append("Server Name", this.serverName).append("Query", this.query).append("inlineForm", this.inlineForm).toString();
        }
    }
}

