/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class NativeLibraryLoader {
    private static volatile String libraryLastAttempted = null;
    private static Logger logger = Logger.getLogger(NativeLibraryLoader.class);

    public static synchronized boolean load(Class clazz, String library) {
        boolean nativeLibraryExists = false;
        if (library == null || library.equals(libraryLastAttempted)) {
            logger.debug("attempt to load null native library");
            return nativeLibraryExists;
        }
        logger.debug("attempt to load native library " + library);
        try {
            String methodName = "IsNativeMethodAccessible";
            Class[] parameterTypes = new Class[]{};
            Method method = clazz.getMethod(methodName, parameterTypes);
            method.invoke(null, (Object[])null);
            nativeLibraryExists = true;
            libraryLastAttempted = "<already resident, no library name used>";
            logger.debug("native library already loaded " + library);
            return nativeLibraryExists;
        }
        catch (Throwable methodName) {
            libraryLastAttempted = library;
            try {
                System.loadLibrary(library);
                nativeLibraryExists = true;
                logger.debug("successfully loaded native library " + library);
            }
            catch (Error err) {
                logger.error("Could not load native library", err);
                nativeLibraryExists = false;
            }
            return nativeLibraryExists;
        }
    }
}

