/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class MenuItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8218361475056612432L;
    private String m_label;
    private MENUTYPE m_type;
    private String value;
    private List<MenuItem> subMenu;
    public static String AR_DEF_MENU_DELIMITER = "\\\\";
    public static char AR_DEF_MENU_COMMENT = (char)35;
    public static char AR_DEF_MENU_LINE_INDENT = (char)9;
    public static String AR_DEF_MENU_KEYWORD_ESCAPE = "$\\";
    public static String AR_DEF_MENU_KEYWORD_NO_ESCAPE = "$_SLASH";

    public MenuItem() {
    }

    public MenuItem(String label, String menuItem) {
        this.m_type = MENUTYPE.Value;
        this.m_label = label;
        this.value = menuItem;
    }

    public MenuItem(String label, List<MenuItem> childMenu) {
        this.m_type = MENUTYPE.SubMenu;
        this.m_label = label;
        this.subMenu = childMenu;
    }

    public Object clone() throws CloneNotSupportedException {
        MenuItem item = null;
        item = (MenuItem)super.clone();
        if (this.m_type == MENUTYPE.SubMenu && this.subMenu != null) {
            item.subMenu = new ArrayList<MenuItem>();
            int count = this.subMenu.size();
            for (int i = 0; i < count; ++i) {
                item.subMenu.add((MenuItem)this.subMenu.get(i).clone());
            }
        }
        return item;
    }

    public int getType() {
        if (this.m_type == MENUTYPE.Value) {
            return 1;
        }
        if (this.m_type == MENUTYPE.SubMenu) {
            return 2;
        }
        return 0;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public Object getContent() {
        if (this.m_type == MENUTYPE.Value) {
            return this.getValue();
        }
        if (this.m_type == MENUTYPE.SubMenu) {
            return this.getSubMenu();
        }
        return null;
    }

    public List<MenuItem> getSubMenu() {
        return this.subMenu;
    }

    public void setSubMenu(List<MenuItem> subMenu) {
        this.m_type = MENUTYPE.SubMenu;
        this.value = null;
        this.subMenu = subMenu;
    }

    public void setSubMenu(MenuItem menuItem) {
        if (this.m_type == MENUTYPE.SubMenu) {
            this.subMenu.add(menuItem);
        } else {
            this.m_type = MENUTYPE.SubMenu;
            this.subMenu = new ArrayList<MenuItem>();
            this.subMenu.add(menuItem);
            this.value = null;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.m_type = MENUTYPE.Value;
        this.subMenu = null;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MenuItem)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MenuItem rhs = (MenuItem)obj;
        return new EqualsBuilder().append(this.m_label, rhs.m_label).append((Object)this.m_type, (Object)rhs.m_type).append(this.value, rhs.value).append(this.subMenu, rhs.subMenu).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_label).append((Object)this.m_type).append(this.value).append(this.subMenu).toHashCode();
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{this.getLabel(), new Integer(this.getType()), this.m_type == MENUTYPE.SubMenu ? new Object[]{1, ARTypeMgr.getInstance().ObjectToVariant(this.getContent(), ctx)} : ARTypeMgr.getInstance().ObjectToVariant(this.getContent(), ctx)};
        return var;
    }

    public static List<MenuItem> decode(String encoded) throws ARException {
        if (encoded == null) {
            return new ArrayList<MenuItem>();
        }
        Scanner scanBuffer = new Scanner(encoded);
        List<MenuItem> menuItemList = MenuItem.bufferToMenuItemList(scanBuffer);
        scanBuffer.close();
        return menuItemList;
    }

    public static List<MenuItem> bufferToMenuItemList(Scanner scanBuffer) throws ARException {
        ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
        int lineNumber = 0;
        while (scanBuffer.hasNextLine()) {
            String str = scanBuffer.nextLine();
            ++lineNumber;
            if (str.length() > 0 && str.charAt(0) == AR_DEF_MENU_COMMENT) continue;
            int level = 0;
            while (str.length() > 0 && str.charAt(0) == AR_DEF_MENU_LINE_INDENT) {
                ++level;
                str = str.substring(1);
            }
            if (level > 15) {
                throw new ARException(2, 321, null);
            }
            str = str.replace(AR_DEF_MENU_KEYWORD_ESCAPE, AR_DEF_MENU_KEYWORD_NO_ESCAPE);
            Scanner line = new Scanner(str).useDelimiter(AR_DEF_MENU_DELIMITER);
            if (str.length() == 0 || !line.hasNext()) continue;
            if (menuItemList.isEmpty() && level != 0) {
                String appendMsg = "at line " + lineNumber;
                throw new ARException(2, 130, appendMsg);
            }
            String label = line.next();
            String value = new String();
            if (line.hasNext()) {
                value = line.next();
            }
            if (value.equals("")) {
                value = label;
            }
            value = value.replace(AR_DEF_MENU_KEYWORD_NO_ESCAPE, AR_DEF_MENU_KEYWORD_ESCAPE);
            MenuItem menuItem = new MenuItem(label, value);
            if (level == 0) {
                menuItemList.add(menuItem);
                continue;
            }
            MenuItem prevLevelMenuItem = MenuItem.getMenuItemFromList(menuItemList, level - 1);
            if (prevLevelMenuItem == null) continue;
            prevLevelMenuItem.setSubMenu(menuItem);
        }
        return menuItemList;
    }

    private static MenuItem getMenuItemFromList(List<MenuItem> menuItemList, int level) {
        MenuItem menuItem = menuItemList.get(menuItemList.size() - 1);
        if (level == 0) {
            return menuItem;
        }
        return menuItem.getSubMenu() == null ? null : MenuItem.getMenuItemFromList(menuItem.getSubMenu(), level - 1);
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Label", this.m_label).append("Type", (Object)this.m_type).append("Value", this.value).append("Sub Menu", this.subMenu).toString();
    }

    public static enum MENUTYPE {
        None,
        Value,
        SubMenu;

    }
}

