/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DataDictionaryMenu;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.FormDataDictionaryMenu;
import com.bmc.arsys.api.ListMenu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QualifierProcessor;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.ServerSideMenu;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class Menu
extends ObjectBase
implements Cloneable {
    private static final long serialVersionUID = -8163368685419565407L;
    private int m_refreshCode;
    private ObjectPropertyMap m_objPropList;
    private List<MenuItem> content;

    public Menu() {
        this.createChangeFlags();
        this.hashValues = new Integer[11];
        this.content = new ArrayList<MenuItem>();
        this.calculateHashCode();
    }

    public Menu(String menuName) {
        this();
        this.setName(menuName);
    }

    @Override
    protected void createChangeFlags() {
        this.m_changeFlags = new MenuCriteria();
    }

    public void setRefreshCode(int refreshCode) {
        this.m_refreshCode = refreshCode;
        this.m_changeFlags.setParameter(8L, true);
    }

    public int getRefreshCode() {
        return this.m_refreshCode;
    }

    public ObjectPropertyMap getProperties() {
        return this.m_objPropList;
    }

    public void setProperties(ObjectPropertyMap props) {
        this.m_objPropList = props;
        this.m_changeFlags.setParameter(7L, true);
    }

    public String getKey() {
        return this.getName();
    }

    public void setKey(String key) {
        this.setName(key);
    }

    public List<MenuItem> getContent() {
        return this.content;
    }

    public void setContent(List<MenuItem> content) {
        this.content = content;
        this.m_changeFlags.setParameter(9L, true);
    }

    public int getMenuType() {
        if (this instanceof ListMenu) {
            return 1;
        }
        if (this instanceof QueryMenu) {
            return 2;
        }
        if (this instanceof FileMenu) {
            return 3;
        }
        if (this instanceof SqlMenu) {
            return 4;
        }
        if (this instanceof FormDataDictionaryMenu) {
            return 6;
        }
        if (this instanceof FieldDataDictionaryMenu) {
            return 6;
        }
        if (this instanceof ServerSideMenu) {
            return 5;
        }
        return 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Menu menu = null;
        menu = (Menu)super.clone();
        if (this.m_objPropList != null) {
            menu.m_objPropList = new ObjectPropertyMap();
            Set keys = this.m_objPropList.keySet();
            for (Integer key : keys) {
                menu.m_objPropList.put(key, (Value)((Value)this.m_objPropList.get(key)).clone());
            }
        }
        if (this.content != null) {
            menu.content = new ArrayList<MenuItem>(this.content.size());
            for (int i = 0; i < this.content.size(); ++i) {
                menu.content.add((MenuItem)this.content.get(i).clone());
            }
        }
        if (this.m_changeFlags != null) {
            menu.m_changeFlags = (MenuCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return menu;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Menu)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Menu rhs = (Menu)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_refreshCode, rhs.m_refreshCode).append(this.m_objPropList, rhs.m_objPropList).append(this.content, rhs.content).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_refreshCode).append(this.m_objPropList).append(this.content).toHashCode();
    }

    protected static List<MenuItem> BuildExpMenuResponse(Object rawData) {
        int menuType;
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        if (rawData instanceof Object[] && (menuType = ConversionUtil.getIntValue(ARTypeMgr.GetAt(rawData, 0))) == 1) {
            int count;
            Object[] menuItems = (Object[])ARTypeMgr.GetAt(rawData, 1);
            int n = count = menuItems != null ? menuItems.length : 0;
            for (int i = 0; i < count; ++i) {
                Object[] cur = (Object[])menuItems[i];
                int innerType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)cur, 1));
                if (innerType == 1) {
                    arrayList.add(new MenuItem(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)cur, 0)), ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)cur, 2))));
                    continue;
                }
                arrayList.add(new MenuItem(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)cur, 0)), Menu.BuildExpMenuResponse(ARTypeMgr.GetAt((Object)cur, 2))));
            }
        }
        return arrayList;
    }

    private void fromVariantDuringGet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setRefreshCode(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 6)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 7)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 8)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 9)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 10)));
        this.setProperties(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        if (ctx.getCurrentOp().equals("ARGetCharMenu")) {
            this.fromVariantDuringGet(rawData, ctx);
        }
    }

    Object menuDefnToVariant(ARServerUser ctx, Entry keywordList, Entry parameterList) throws ARException {
        Object[] var = new Object[2];
        if (this instanceof ListMenu) {
            var[0] = 1;
            var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.getContent(), ctx);
        } else if (this instanceof FileMenu) {
            FileMenu fileMenu = (FileMenu)this;
            var[0] = 3;
            var[1] = new Object[]{fileMenu.getLocation(), fileMenu.getFileName()};
        } else if (this instanceof QueryMenu) {
            QueryMenu queryMenu = (QueryMenu)this;
            var[0] = 2;
            QualifierInfo origQual = queryMenu.getQualification();
            QualifierProcessor processor = new QualifierProcessor(origQual, keywordList, parameterList);
            QualifierInfo newQual = processor.getQualInfo();
            var[1] = new Object[]{queryMenu.getForm(), queryMenu.getServer(), ARTypeMgr.getInstance().ObjectToVariant(newQual, ctx), ARTypeMgr.getInstance().ObjectToVariant(queryMenu.getLabelField(), ctx), queryMenu.getValueField(), queryMenu.isSortOnLabel(), queryMenu.getSampleForm(), queryMenu.getSampleServer()};
        } else if (this instanceof SqlMenu) {
            SqlMenu sqlMenu = (SqlMenu)this;
            var[0] = 5;
            var[1] = new Object[]{sqlMenu.getName(), ARTypeMgr.getInstance().ObjectToVariant(keywordList, ctx), ARTypeMgr.getInstance().ObjectToVariant(parameterList, ctx), sqlMenu.getServer(), null};
        } else if (this instanceof DataDictionaryMenu) {
            DataDictionaryMenu ddMenu = (DataDictionaryMenu)this;
            var[0] = 6;
            var[1] = new Object[]{ddMenu.getServer(), ddMenu.getNameType(), ddMenu.getValueFormat(), this instanceof FormDataDictionaryMenu ? 1 : 2, new Object[2]};
            Object[] ddDefn = (Object[])ARTypeMgr.GetAt((Object)var, new int[]{1, 4});
            if (this instanceof FormDataDictionaryMenu) {
                FormDataDictionaryMenu formDDMenu = (FormDataDictionaryMenu)this;
                ddDefn[0] = formDDMenu.getFormType();
                ddDefn[1] = formDDMenu.isIncludeHidden();
            } else if (this instanceof FieldDataDictionaryMenu) {
                FieldDataDictionaryMenu fieldDDMenu = (FieldDataDictionaryMenu)this;
                ddDefn[0] = fieldDDMenu.getFieldType();
                ddDefn[1] = fieldDDMenu.getForm();
            }
        } else if (this instanceof ServerSideMenu) {
            ServerSideMenu ssMenu = (ServerSideMenu)this;
            var[0] = 5;
            var[1] = new Object[]{ssMenu.getMenuName(), ARTypeMgr.getInstance().ObjectToVariant(ssMenu.getKeywordList(), ctx), ARTypeMgr.getInstance().ObjectToVariant(ssMenu.getParameterList(), ctx), ssMenu.getServer(), null};
        }
        return var;
    }

    static Menu createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        Menu obj = null;
        int MenuType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, new int[]{5, 0}));
        switch (MenuType) {
            case 2: {
                obj = ARTypeMgr.getInstance().NewObject(QueryMenu.class, ctx);
                break;
            }
            case 3: {
                obj = ARTypeMgr.getInstance().NewObject(FileMenu.class, ctx);
                break;
            }
            case 4: {
                obj = ARTypeMgr.getInstance().NewObject(SqlMenu.class, ctx);
                break;
            }
            case 6: {
                int ddType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, new int[]{5, 1, 3}));
                if (ddType == 1) {
                    obj = ARTypeMgr.getInstance().NewObject(FormDataDictionaryMenu.class, ctx);
                    break;
                }
                obj = ARTypeMgr.getInstance().NewObject(FieldDataDictionaryMenu.class, ctx);
                break;
            }
            default: {
                obj = ARTypeMgr.getInstance().NewObject(ListMenu.class, ctx);
            }
        }
        obj.fromVariant(rawData, ctx);
        return obj;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Refresh Code", this.m_refreshCode).append("Obj Prop List", this.m_objPropList).append("Content", this.content).toString();
    }

    @Override
    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        super.calculateHashCode();
        this.hashValues[9] = this.content != null && !this.content.isEmpty() ? Integer.valueOf(this.content.hashCode()) : null;
        this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(this.m_objPropList.hashCode()) : null;
    }

    @Override
    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        super.calculateHashCodeOnGet(criteria == null ? new MenuCriteria() : criteria);
    }

    @Override
    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        super.calculateChangeFlagsOnSet();
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[9]) {
            if (this.content != null && !this.content.isEmpty()) {
                hashCode = this.content.hashCode();
                if (this.hashValues[9] == null || hashCode != this.hashValues[9]) {
                    this.m_changeFlags.setParameter(9L, true);
                }
                this.hashValues[9] = this.content != null && !this.content.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[9] != null) {
                this.m_changeFlags.setParameter(9L, true);
                this.hashValues[9] = null;
            }
        }
        if (!changeFlags[7]) {
            if (this.m_objPropList != null && !this.m_objPropList.isEmpty()) {
                hashCode = this.m_objPropList.hashCode();
                if (this.hashValues[7] == null || hashCode != this.hashValues[7]) {
                    this.m_changeFlags.setParameter(7L, true);
                }
                this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[7] != null) {
                this.m_changeFlags.setParameter(7L, true);
                this.hashValues[7] = null;
            }
        }
    }
}

