/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.codec.binary.Hex;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;

public class ImageData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5279098984194437218L;
    private byte[] m_bytes;

    protected ImageData() {
    }

    public ImageData(String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        try {
            FileImageInputStream inp = new FileImageInputStream(f);
            int dataLen = (int)inp.length();
            this.m_bytes = new byte[dataLen];
            inp.read(this.m_bytes, 0, dataLen);
            inp.close();
        }
        catch (Exception e) {
            System.out.print(e.getLocalizedMessage());
        }
    }

    public ImageData(byte[] byteArray) {
        this.m_bytes = byteArray;
    }

    public Object clone() throws CloneNotSupportedException {
        ImageData obj = (ImageData)super.clone();
        if (this.m_bytes != null) {
            obj.m_bytes = (byte[])this.m_bytes.clone();
        }
        return obj;
    }

    public byte[] getValue() {
        return this.m_bytes;
    }

    public void setValue(byte[] val) {
        this.m_bytes = val;
    }

    public int getSize() {
        return this.m_bytes.length;
    }

    public void writeToFile(String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        try {
            FileImageOutputStream out = new FileImageOutputStream(f);
            out.write(this.m_bytes, 0, this.getSize());
            out.close();
        }
        catch (Exception e) {
            System.out.print(e.getLocalizedMessage());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageData)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ImageData rhs = (ImageData)obj;
        return new EqualsBuilder().append(this.m_bytes, rhs.m_bytes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_bytes).toHashCode();
    }

    private static String byteArrayToHexString(byte[] in, int start, int end) {
        byte[] buf;
        if (in == null) {
            return null;
        }
        int len = in.length;
        if (len <= 0 || len < start) {
            return null;
        }
        if (end < start || end > len) {
            end = len;
        }
        if (in != null && (start != 0 || end != len)) {
            buf = new byte[end - start];
            System.arraycopy(in, start, buf, 0, end - start);
        } else {
            buf = in;
        }
        StringBuffer out = new StringBuffer((end - start + 1) * 2);
        if (start > 0) {
            out.append("...");
        }
        out.append(Hex.encodeHex(buf));
        if (end < len) {
            out.append("...");
        }
        String rslt = new String(out);
        return rslt;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("bytes", ImageData.byteArrayToHexString(this.m_bytes, 0, 64)).toString();
    }
}

