/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ARStructTypeInfo(Name="ARFunctionAssignStruct", NumberOfMembers=2)
public class FunctionAssignInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7629523292918012006L;
    @ARStructMemTypeInfo(Name="functionCode", Offset=0)
    private int m_functionCode;
    @ARStructMemTypeInfo(Name="parameterList", Offset=1)
    private List<AssignInfo> m_parameterList;
    protected static final String[] _funcNames = new String[]{"DATE", "TIME", "MONTH", "DAY", "YEAR", "WEEKDAY", "HOUR", "MINUTE", "SECOND", "TRUNC", "ROUND", "CONVERT", "LENGTH", "UPPER", "LOWER", "SUBSTR", "LEFT", "RIGHT", "LTRIM", "RTRIM", "LPAD", "RPAD", "REPLACE", "STRSTR", "MIN", "MAX", "COLSUM", "COLCOUNT", "COLAVG", "COLMIN", "COLMAX", "DATEADD", "DATEDIFF", "DATENAME", "DATENUM", "CURRCONVERT", "CURRSETDATE", "CURRSETTYPE", "CURRSETVALUE", "LENGTHC", "LEFTC", "RIGHTC", "LPADC", "RPADC", "STRSTRC", "SUBSTRC", "ENCRYPT", "DECRYPT", "HOVER", "TEMPLATE", "SELECTEDROWCOUNT", "DROPPEDROWINDEX", "DROPPEDCOLUMNINDEX", "MAPGET", "LISTGET", "LISTSIZE", "STRIPHTML", "VISIBLEROWS"};
    protected static final int[] _funcCodes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58};
    protected static final int[][] _functionDatatypes = new int[][]{{7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {7, 0, 0}, {3, 0, 0}, {3, 0, 0}, {3, 2, 0}, {4, 0, 0}, {4, 0, 0}, {4, 0, 0}, {4, 2, 2}, {4, 2, 0}, {4, 2, 0}, {4, 0, 0}, {4, 0, 0}, {4, 2, 4}, {4, 2, 4}, {4, 4, 4}, {4, 4, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {4, 2, 13}, {4, 13, 13}, {4, 13, 0}, {4, 13, 0}, {12, 4, 7}, {12, 7, 0}, {12, 4, 0}, {12, 10, 0}, {4, 0, 0}, {4, 2, 0}, {4, 2, 0}, {4, 2, 4}, {4, 2, 4}, {4, 4, 0}, {4, 2, 2}, {4, 4, 0}, {4, 4, 0}, {2, 0, 0}, {4, 4, 4}, {0, 0, 0}, {2, 0, 0}, {2, 0, 0}, {2, 4, 0}, {2, 2, 0}, {2, 0, 0}, {4, 0, 0}, {2, 0, 0}};

    public FunctionAssignInfo() {
    }

    public FunctionAssignInfo(int functionCode, List<AssignInfo> parameterList) {
        this.m_functionCode = functionCode;
        this.m_parameterList = parameterList;
    }

    public int getFunctionCode() {
        return this.m_functionCode;
    }

    public void setFunctionCode(int functionCode) {
        this.m_functionCode = functionCode;
    }

    public int getNumItems() {
        if (this.m_parameterList != null) {
            return this.m_parameterList.size();
        }
        return 0;
    }

    public void setNumItems(int numItems) {
    }

    public List<AssignInfo> getParameterList() {
        return this.m_parameterList;
    }

    public void setParameterList(List<AssignInfo> parameterList) {
        this.m_parameterList = parameterList;
    }

    public Object clone() throws CloneNotSupportedException {
        FunctionAssignInfo obj = (FunctionAssignInfo)super.clone();
        if (this.m_parameterList != null) {
            int nLen = this.m_parameterList.size();
            obj.m_parameterList = new ArrayList<AssignInfo>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.m_parameterList.add((AssignInfo)this.m_parameterList.get(i).clone());
            }
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionAssignInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FunctionAssignInfo rhs = (FunctionAssignInfo)obj;
        return new EqualsBuilder().append(this.m_functionCode, rhs.m_functionCode).append(this.m_parameterList, rhs.m_parameterList).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_functionCode).append(this.m_parameterList).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Function Code", this.m_functionCode).append("Parameter List", this.m_parameterList).toString();
    }

    public static int toFuncCode(String function) {
        int indx = -1;
        for (String name : _funcNames) {
            ++indx;
            if (!function.equals(name)) continue;
            return indx + 1;
        }
        return -1;
    }

    public static String toFuncName(int code) throws ARException {
        return _funcNames[code - 1];
    }

    public static int getParamType(int funcCode, int paramIndx) {
        return _functionDatatypes[funcCode - 1][paramIndx];
    }

    public static int getParamType(String function, int paramIndx) {
        return _functionDatatypes[FunctionAssignInfo.toFuncCode(function) - 1][paramIndx];
    }
}

