/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ExtendedClassCallbackHandler;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExtendedClassRegistry {
    private Map _map = new Hashtable();

    public boolean isExtendingClassRegistered(Class c) {
        return this._map.containsKey(c);
    }

    public void registerExtendedClass(Class<?> clazz, Class<?> extendedClazz) throws IllegalArgumentException {
        Class k = clazz;
        if (this._map.containsKey(k)) {
            k = (Class)this._map.get(k);
        }
        if (extendedClazz.equals(k)) {
            throw new IllegalArgumentException("Extended class already registered.");
        }
        if (!extendedClazz.equals(k) && extendedClazz.asSubclass(k) != null) {
            this._map.put(clazz, extendedClazz);
        }
    }

    protected <T> T newInstance(Class<T> clazz, Class[] parameterTypes, Object ... initargs) {
        Class targetClazz = clazz;
        if (this._map.containsKey(clazz)) {
            targetClazz = (Class)this._map.get(clazz);
        }
        T cur = null;
        if (initargs == null || initargs.length == 0) {
            try {
                cur = clazz.cast(targetClazz.newInstance());
                return cur;
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        try {
            Constructor ctr = targetClazz.getConstructor(parameterTypes);
            cur = clazz.cast(ctr.newInstance(initargs));
            return cur;
        }
        catch (Throwable e) {
            System.err.println(e);
            try {
                Constructor ctr = clazz.getConstructor(parameterTypes);
                cur = clazz.cast(ctr.newInstance(initargs));
                cur = this.newInstance(cur);
                return cur;
            }
            catch (Throwable e2) {
                System.err.println(e2);
                return null;
            }
        }
    }

    public static <T> T[] newInstanceArray(ExtendedClassRegistry ecr, Class<T> clazz, int size) throws IllegalAccessException, InstantiationException {
        if (ecr != null) {
            return ecr.newInstanceArray(clazz, size);
        }
        return (Object[])Array.newInstance(clazz, size);
    }

    public <T> T[] newInstanceArray(Class<T> clazz, int size) throws IllegalAccessException, InstantiationException {
        Class targetClazz = clazz;
        if (this._map.containsKey(clazz)) {
            targetClazz = (Class)this._map.get(clazz);
        }
        Object[] cur = (Object[])Array.newInstance(targetClazz, size);
        return cur;
    }

    public static <T> T newInstance(ExtendedClassRegistry ecr, Class<T> clazz) {
        try {
            if (ecr != null) {
                return (T)ecr.newInstance((T)clazz);
            }
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public <T> T newInstance(Class<T> clazz) {
        try {
            Class targetClazz = clazz;
            if (this._map.containsKey(clazz)) {
                targetClazz = (Class)this._map.get(clazz);
            }
            T cur = clazz.cast(targetClazz.newInstance());
            return cur;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public <T> T newInstance(T src) {
        try {
            Class<?> dest = this.newInstance((T)src.getClass());
            this.copy(src.getClass(), dest, src);
            if (dest instanceof ExtendedClassCallbackHandler) {
                ExtendedClassCallbackHandler ecch = (ExtendedClassCallbackHandler)((Object)dest);
                ecch.afterInstanceConstructed();
            }
            return (T)dest;
        }
        catch (Throwable e) {
            return src;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void copy(Class clazz, T dest, T src) {
        try {
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                ExtendedClassCallbackHandler ecch;
                if (dest instanceof ExtendedClassCallbackHandler) {
                    ecch = (ExtendedClassCallbackHandler)dest;
                    ecch.beforeFieldsSet(superClazz);
                }
                this.copy(superClazz, dest, src);
                if (dest instanceof ExtendedClassCallbackHandler) {
                    ecch = (ExtendedClassCallbackHandler)dest;
                    ecch.afterFieldsSet(superClazz);
                }
            }
            Field[] fieldlist = clazz.getDeclaredFields();
            for (int i = 0; i < fieldlist.length; ++i) {
                Field fld = fieldlist[i];
                int mod = fld.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                if (dest instanceof ExtendedClassCallbackHandler) {
                    ExtendedClassCallbackHandler ecch = (ExtendedClassCallbackHandler)dest;
                    ecch.beforeFieldSet(fld);
                }
                fld.setAccessible(true);
                Object val = fld.get(src);
                try {
                    Class<?> fc = fld.getType();
                    if (val == null || fc.isPrimitive() || fc.equals(String.class)) {
                        fld.set(dest, val);
                    } else if (fc.isArray()) {
                        Object array = val;
                        if (array == null || Array.getLength(array) <= 0 || Array.get(array, 0).getClass().isPrimitive()) {
                            fld.set(dest, array);
                            continue;
                        }
                        fld.set(dest, this.copyArray((Object[])array, false));
                    } else if (List.class.isAssignableFrom(fc)) {
                        List list = (List)val;
                        if (list == null) {
                            fld.set(dest, null);
                            continue;
                        }
                        fld.set(dest, this.copyList(list, false));
                    } else if (Map.class.isAssignableFrom(fc)) {
                        Map map = (Map)val;
                        if (map == null) {
                            fld.set(dest, null);
                            continue;
                        }
                        fld.set(dest, this.copyMap(map, false));
                    } else {
                        boolean primitive;
                        boolean bl = primitive = val.getClass().isPrimitive() || val.getClass().equals(String.class);
                        if (primitive) {
                            fld.set(dest, val);
                        } else {
                            Object newVal = this.newInstance(val);
                            fld.set(dest, newVal);
                        }
                    }
                }
                catch (Throwable e) {
                    fld.set(dest, val);
                }
                finally {
                    fld.setAccessible(false);
                }
                if (!(dest instanceof ExtendedClassCallbackHandler)) continue;
                ExtendedClassCallbackHandler ecch = (ExtendedClassCallbackHandler)dest;
                ecch.afterFieldSet(fld);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public <T> Object copyArray(T[] array, boolean onlyIfExtended) {
        if (array == null || array.length <= 0) {
            return array;
        }
        Class elemClass = array[0].getClass();
        if (onlyIfExtended && !this.isExtendingClassRegistered(elemClass)) {
            return array;
        }
        Class targetFieldClass = this.isExtendingClassRegistered(elemClass) ? (Class)this._map.get(elemClass) : elemClass;
        int count = array.length;
        Object newArray = Array.newInstance(targetFieldClass, count);
        boolean primitive = targetFieldClass.isPrimitive() || targetFieldClass.equals(String.class);
        for (int j = 0; j < count; ++j) {
            if (primitive) {
                Array.set(newArray, j, Array.get(array, j));
                continue;
            }
            Object curItem = this.newInstance(Array.get(array, j));
            Array.set(newArray, j, curItem);
        }
        return newArray;
    }

    public <T> Object copyList(List<T> list, boolean onlyIfExtended) {
        if (list == null || list.size() <= 0) {
            return list;
        }
        int count = list.size();
        Class elemClass = list.get(0).getClass();
        if (onlyIfExtended && !this.isExtendingClassRegistered(elemClass)) {
            return list;
        }
        Class targetFieldClass = this.isExtendingClassRegistered(elemClass) ? (Class)this._map.get(elemClass) : elemClass;
        ArrayList<T> newList = new ArrayList<T>(count);
        boolean primitive = targetFieldClass.isPrimitive() || targetFieldClass.equals(String.class);
        for (int j = 0; j < count; ++j) {
            if (primitive) {
                newList.add(list.get(j));
                continue;
            }
            T curItem = this.newInstance(list.get(j));
            newList.add(curItem);
        }
        return newList;
    }

    public <K, V> Object copyMap(Map<K, V> map, boolean onlyIfExtended) throws IllegalAccessException, InstantiationException {
        if (map == null || map.size() <= 0) {
            return map;
        }
        Class<?> keyClass = map.keySet().toArray()[0].getClass();
        Class<?> valClass = map.values().toArray()[0].getClass();
        if (onlyIfExtended && !this.isExtendingClassRegistered(keyClass) && !this.isExtendingClassRegistered(valClass)) {
            return map;
        }
        Map newMap = (Map)((Object)this.newInstance((Object)map.getClass()));
        boolean primitiveK = keyClass.isPrimitive() || keyClass.equals(String.class);
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        for (Map.Entry<K, V> curPair : entrySet) {
            K k = primitiveK ? curPair.getKey() : this.newInstance(curPair.getKey());
            V v = primitiveK ? curPair.getValue() : this.newInstance(curPair.getValue());
            newMap.put(k, v);
        }
        return newMap;
    }
}

