/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class EscalationInterval
implements EscalationTimeCriteria,
Cloneable,
Serializable {
    public static final int MAX_DAYS = 24855;
    private static final long serialVersionUID = -8699130908029048067L;
    private long value;

    public EscalationInterval() {
    }

    public EscalationInterval(long value) {
        this.value = value;
    }

    public int getDays() {
        return (int)(this.value / 86400L);
    }

    public void setDays(int days) {
        if (days < 0 || days > 24855) {
            throw new IllegalArgumentException(String.format("Days value must be between 0-%d", 24855));
        }
        int hours = this.getHours();
        int minutes = this.getMinutes();
        this.value = days * 24 * 60 * 60 + hours * 60 * 60 + minutes * 60;
    }

    public int getHours() {
        return (int)(this.value % 86400L) / 3600;
    }

    public void setHours(int hours) {
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Hours value must be between 0-23");
        }
        int days = this.getDays();
        int minutes = this.getMinutes();
        this.value = days * 24 * 60 * 60 + hours * 60 * 60 + minutes * 60;
    }

    public int getMinutes() {
        return (int)(this.value % 86400L % 3600L) / 60;
    }

    public void setMinutes(int minutes) {
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Minutes value must be between 0-59");
        }
        int days = this.getDays();
        int hours = this.getHours();
        this.value = days * 24 * 60 * 60 + hours * 60 * 60 + minutes * 60;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be between 0-%d", Integer.MAX_VALUE));
        }
        this.value = value;
    }

    public Object clone() throws CloneNotSupportedException {
        EscalationTimeCriteria obj = (EscalationTimeCriteria)super.clone();
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EscalationInterval)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EscalationInterval rhs = (EscalationInterval)obj;
        return new EqualsBuilder().append(this.value, rhs.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.value).toHashCode();
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.value = ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)rawData, 0));
    }

    Object toVariant(ARServerUser ctx) {
        Object[] rawData = new Object[]{1, new Long(this.getValue())};
        return rawData;
    }

    static EscalationInterval createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        EscalationInterval obj = new EscalationInterval();
        if (rawData.length == 1) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Value", this.value).toString();
    }
}

