/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.DisplayPropertyMap;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ARStructMapTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

@ARStructMapTypeInfo(KeyType="java.lang.Integer", KeyIndex={0}, ValueType="com.bmc.arsys.api.DisplayPropertyMap", ValueIndex={1})
public class DisplayInstanceMap
extends TreeMap<Integer, DisplayPropertyMap>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 745438683816293244L;
    private static Logger logger = Logger.getLogger(DisplayInstanceMap.class);
    private static Map<Integer, String> DPROP_TYPE_MAP = new HashMap<Integer, String>();

    public Value getProperty(int vuiId, Integer tag) {
        DisplayPropertyMap di = (DisplayPropertyMap)this.get(new Integer(vuiId));
        if (di != null) {
            return (Value)di.get(new Integer(tag));
        }
        return null;
    }

    public void setProperty(int viewId, int propertyId, Value value) {
        DisplayPropertyMap di = (DisplayPropertyMap)this.get(viewId);
        if (di != null) {
            di.put(propertyId, value);
        }
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Object clone() {
        DisplayInstanceMap result = new DisplayInstanceMap();
        for (Integer key : this.keySet()) {
            DisplayPropertyMap property = (DisplayPropertyMap)this.get(key);
            DisplayPropertyMap clonedProperty = null;
            if (property != null) {
                clonedProperty = (DisplayPropertyMap)property.clone();
            }
            result.put(new Integer(key), clonedProperty);
        }
        return result;
    }

    static Value fixARDisplayPropValue(Integer key, Value val) {
        Value newVal;
        if (val == null) {
            return val;
        }
        if (!DPROP_TYPE_MAP.containsKey(key)) {
            return val;
        }
        String propTypStr = DPROP_TYPE_MAP.get(key);
        if (logger.isTraceEnabled()) {
            logger.trace("fixARDisplayProp for key: " + key + " with propTypStr: " + propTypStr + " value: " + val.toString());
        }
        if (propTypStr.equals("INTEGER")) {
            newVal = new Value(ConversionUtil.getIntValue(val.getValue()));
            if (logger.isTraceEnabled()) {
                logger.trace("to be int value: " + newVal.toString() + " from dataType: " + val.getDataType());
            }
        } else if (propTypStr.equals("BITMASK")) {
            newVal = new Value(8, val.getLongValue());
            if (logger.isTraceEnabled()) {
                logger.trace("to be BITMASK value: " + newVal.toString() + " from dataType: " + val.getDataType());
            }
        } else if (propTypStr.equals("ULONG")) {
            newVal = new Value(40, val.getLongValue());
            if (logger.isTraceEnabled()) {
                logger.trace("to be ULONG value: " + newVal.toString() + " from dataType: " + val.getDataType());
            }
        } else {
            newVal = val;
        }
        return newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fixARDisplayProps(DisplayPropertyMap map) {
        if (map == null) {
            return;
        }
        DisplayPropertyMap displayPropertyMap = map;
        synchronized (displayPropertyMap) {
            for (Map.Entry entry : map.entrySet()) {
                Value newVal;
                Value val = (Value)entry.getValue();
                if (val.equals(newVal = DisplayInstanceMap.fixARDisplayPropValue((Integer)entry.getKey(), val))) continue;
                entry.setValue(DisplayInstanceMap.fixARDisplayPropValue((Integer)entry.getKey(), val));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fixARDisplayProps(DisplayInstanceMap map) {
        if (map == null) {
            return;
        }
        DisplayInstanceMap displayInstanceMap = map;
        synchronized (displayInstanceMap) {
            for (Integer key : map.keySet()) {
                DisplayPropertyMap curDPMap = (DisplayPropertyMap)map.get(key);
                DisplayInstanceMap.fixARDisplayProps(curDPMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisplayPropertyMap remove(Object key) {
        DisplayPropertyMap obj;
        DisplayInstanceMap displayInstanceMap = this;
        synchronized (displayInstanceMap) {
            obj = (DisplayPropertyMap)super.remove(key);
        }
        return obj;
    }

    static void fixDisplayPropsForAR(String typeStr, Object rawData) {
        block12: {
            block10: {
                Object val;
                String propTypStr;
                block13: {
                    block11: {
                        if (rawData == null) {
                            return;
                        }
                        if (!typeStr.equals("DisplayProperty")) break block10;
                        Object[] array = (Object[])rawData;
                        if (array == null || array.length != 2) {
                            return;
                        }
                        Integer key = ConversionUtil.getIntValue(array[0]);
                        if (!DPROP_TYPE_MAP.containsKey(key)) {
                            return;
                        }
                        propTypStr = DPROP_TYPE_MAP.get(key);
                        val = ARTypeMgr.GetAt((Object)array, new int[]{1, 1});
                        if (!propTypStr.equals("ENUM")) break block11;
                        array[1] = new Object[]{6, ConversionUtil.getIntValue(val)};
                        break block12;
                    }
                    if (!propTypStr.equals("BITMASK")) break block13;
                    array[1] = new Object[]{8, ConversionUtil.getLongValue(val)};
                    break block12;
                }
                if (!propTypStr.equals("ULONG")) break block12;
                array[1] = new Object[]{40, ConversionUtil.getLongValue(val)};
                break block12;
            }
            if (typeStr.equals("DisplayPropertyMap")) {
                Object[] array = (Object[])((Object[])rawData)[1];
                if (array == null || array.length == 0) {
                    return;
                }
                for (Object item : array) {
                    DisplayInstanceMap.fixDisplayPropsForAR("DisplayProperty", item);
                }
            } else if (typeStr.equals("DisplayInstanceMap")) {
                Object[] array = (Object[])rawData;
                if (array == null || array.length == 0) {
                    return;
                }
                for (Object item : array) {
                    DisplayInstanceMap.fixDisplayPropsForAR("DisplayPropertyMap", item);
                }
            }
        }
    }

    static {
        DPROP_TYPE_MAP.put(0, "NULL");
        DPROP_TYPE_MAP.put(1, "ENUM");
        DPROP_TYPE_MAP.put(2, "BITMASK");
        DPROP_TYPE_MAP.put(3, "COORDS");
        DPROP_TYPE_MAP.put(4, "ENUM");
        DPROP_TYPE_MAP.put(5, "ENUM");
        DPROP_TYPE_MAP.put(6, "CHAR");
        DPROP_TYPE_MAP.put(7, "ULONG");
        DPROP_TYPE_MAP.put(8, "CHAR");
        DPROP_TYPE_MAP.put(9, "ENUM");
        DPROP_TYPE_MAP.put(10, "ULONG");
        DPROP_TYPE_MAP.put(11, "CHAR");
        DPROP_TYPE_MAP.put(12, "CHAR");
        DPROP_TYPE_MAP.put(13, "CHAR");
        DPROP_TYPE_MAP.put(14, "ULONG");
        DPROP_TYPE_MAP.put(20, "CHAR");
        DPROP_TYPE_MAP.put(21, "COORDS");
        DPROP_TYPE_MAP.put(22, "CHAR");
        DPROP_TYPE_MAP.put(23, "ULONG");
        DPROP_TYPE_MAP.put(24, "CHAR");
        DPROP_TYPE_MAP.put(25, "ENUM");
        DPROP_TYPE_MAP.put(26, "ENUM");
        DPROP_TYPE_MAP.put(27, "BITMASK");
        DPROP_TYPE_MAP.put(28, "ENUM");
        DPROP_TYPE_MAP.put(29, "ENUM");
        DPROP_TYPE_MAP.put(30, "CHAR");
        DPROP_TYPE_MAP.put(31, "CHAR");
        DPROP_TYPE_MAP.put(40, "COORDS");
        DPROP_TYPE_MAP.put(41, "ULONG");
        DPROP_TYPE_MAP.put(42, "CHAR");
        DPROP_TYPE_MAP.put(43, "ENUM");
        DPROP_TYPE_MAP.put(44, "ENUM");
        DPROP_TYPE_MAP.put(45, "ENUM");
        DPROP_TYPE_MAP.put(60, "ULONG");
        DPROP_TYPE_MAP.put(61, "ULONG");
        DPROP_TYPE_MAP.put(62, "ENUM");
        DPROP_TYPE_MAP.put(63, "ENUM");
        DPROP_TYPE_MAP.put(64, "ENUM");
        DPROP_TYPE_MAP.put(65, "COORDS");
        DPROP_TYPE_MAP.put(66, "COORDS");
        DPROP_TYPE_MAP.put(67, "ENUM");
        DPROP_TYPE_MAP.put(80, "CHAR");
        DPROP_TYPE_MAP.put(81, "CHAR");
        DPROP_TYPE_MAP.put(82, "ULONG");
        DPROP_TYPE_MAP.put(83, "CHAR");
        DPROP_TYPE_MAP.put(84, "CHAR");
        DPROP_TYPE_MAP.put(90, "ENUM");
        DPROP_TYPE_MAP.put(91, "ENUM");
        DPROP_TYPE_MAP.put(100, "BYTES");
        DPROP_TYPE_MAP.put(101, "BYTES");
        DPROP_TYPE_MAP.put(110, "CHAR");
        DPROP_TYPE_MAP.put(111, "ENUM");
        DPROP_TYPE_MAP.put(112, "ENUM");
        DPROP_TYPE_MAP.put(113, "ENUM");
        DPROP_TYPE_MAP.put(114, "ENUM");
        DPROP_TYPE_MAP.put(120, "CHAR");
        DPROP_TYPE_MAP.put(121, "ULONG");
        DPROP_TYPE_MAP.put(122, "ENUM");
        DPROP_TYPE_MAP.put(123, "ULONG");
        DPROP_TYPE_MAP.put(124, "CHAR");
        DPROP_TYPE_MAP.put(130, "CHAR");
        DPROP_TYPE_MAP.put(131, "ULONG");
        DPROP_TYPE_MAP.put(132, "ENUM");
        DPROP_TYPE_MAP.put(133, "CHAR");
        DPROP_TYPE_MAP.put(140, "ENUM");
        DPROP_TYPE_MAP.put(141, "COORDS");
        DPROP_TYPE_MAP.put(142, "CHAR");
        DPROP_TYPE_MAP.put(143, "ULONG");
        DPROP_TYPE_MAP.put(144, "ENUM");
        DPROP_TYPE_MAP.put(145, "ENUM");
        DPROP_TYPE_MAP.put(150, "ULONG");
        DPROP_TYPE_MAP.put(151, "COORDS");
        DPROP_TYPE_MAP.put(160, "COORDS");
        DPROP_TYPE_MAP.put(161, "ENUM");
        DPROP_TYPE_MAP.put(162, "INTEGER");
        DPROP_TYPE_MAP.put(163, "INTEGER");
        DPROP_TYPE_MAP.put(164, "INTEGER");
        DPROP_TYPE_MAP.put(165, "INTEGER");
        DPROP_TYPE_MAP.put(166, "CHAR");
        DPROP_TYPE_MAP.put(167, "BYTELIST");
        DPROP_TYPE_MAP.put(168, "ULONG");
        DPROP_TYPE_MAP.put(169, "ULONG");
        DPROP_TYPE_MAP.put(170, "ULONG");
        DPROP_TYPE_MAP.put(180, "ULONG");
        DPROP_TYPE_MAP.put(190, "ENUM");
        DPROP_TYPE_MAP.put(191, "ENUM");
        DPROP_TYPE_MAP.put(192, "ULONG");
        DPROP_TYPE_MAP.put(200, "BYTELIST");
        DPROP_TYPE_MAP.put(201, "INTEGER");
        DPROP_TYPE_MAP.put(202, "INTEGER");
        DPROP_TYPE_MAP.put(203, "ULONG");
        DPROP_TYPE_MAP.put(204, "ULONG");
        DPROP_TYPE_MAP.put(205, "ULONG");
        DPROP_TYPE_MAP.put(206, "CHAR");
        DPROP_TYPE_MAP.put(207, "CHAR");
        DPROP_TYPE_MAP.put(208, "CHAR");
        DPROP_TYPE_MAP.put(209, "CHAR");
        DPROP_TYPE_MAP.put(210, "CHAR");
        DPROP_TYPE_MAP.put(211, "CHAR");
        DPROP_TYPE_MAP.put(212, "CHAR");
        DPROP_TYPE_MAP.put(213, "CHAR");
        DPROP_TYPE_MAP.put(214, "ENUM");
        DPROP_TYPE_MAP.put(215, "ULONG");
        DPROP_TYPE_MAP.put(216, "CHAR");
        DPROP_TYPE_MAP.put(220, "ULONG");
        DPROP_TYPE_MAP.put(221, "ULONG");
        DPROP_TYPE_MAP.put(222, "ULONG");
        DPROP_TYPE_MAP.put(223, "ENUM");
        DPROP_TYPE_MAP.put(224, "ULONG");
        DPROP_TYPE_MAP.put(225, "ENUM");
        DPROP_TYPE_MAP.put(226, "ENUM");
        DPROP_TYPE_MAP.put(227, "ENUM");
        DPROP_TYPE_MAP.put(228, "ULONG");
        DPROP_TYPE_MAP.put(229, "ULONG");
        DPROP_TYPE_MAP.put(230, "CHAR");
        DPROP_TYPE_MAP.put(231, "ENUM");
        DPROP_TYPE_MAP.put(232, "CHAR");
        DPROP_TYPE_MAP.put(233, "CHAR");
        DPROP_TYPE_MAP.put(234, "CHAR");
        DPROP_TYPE_MAP.put(235, "CHAR");
        DPROP_TYPE_MAP.put(236, "CHAR");
        DPROP_TYPE_MAP.put(237, "CHAR");
        DPROP_TYPE_MAP.put(238, "CHAR");
        DPROP_TYPE_MAP.put(239, "ENUM");
        DPROP_TYPE_MAP.put(240, "ULONG");
        DPROP_TYPE_MAP.put(241, "CHAR");
        DPROP_TYPE_MAP.put(242, "CHAR");
        DPROP_TYPE_MAP.put(243, "ENUM");
        DPROP_TYPE_MAP.put(244, "CHAR");
        DPROP_TYPE_MAP.put(245, "CHAR");
        DPROP_TYPE_MAP.put(246, "INTEGER");
        DPROP_TYPE_MAP.put(247, "INTEGER");
        DPROP_TYPE_MAP.put(248, "INTEGER");
        DPROP_TYPE_MAP.put(249, "ULONG");
        DPROP_TYPE_MAP.put(250, "ENUM");
        DPROP_TYPE_MAP.put(251, "ENUM");
        DPROP_TYPE_MAP.put(252, "ENUM");
        DPROP_TYPE_MAP.put(253, "CHAR");
        DPROP_TYPE_MAP.put(254, "ENUM");
        DPROP_TYPE_MAP.put(255, "ENUM");
        DPROP_TYPE_MAP.put(256, "CHAR");
        DPROP_TYPE_MAP.put(257, "ULONG");
        DPROP_TYPE_MAP.put(258, "CHAR");
        DPROP_TYPE_MAP.put(259, "ENUM");
        DPROP_TYPE_MAP.put(260, "CHAR");
        DPROP_TYPE_MAP.put(261, "ENUM");
        DPROP_TYPE_MAP.put(262, "ENUM");
        DPROP_TYPE_MAP.put(263, "ENUM");
        DPROP_TYPE_MAP.put(264, "ENUM");
        DPROP_TYPE_MAP.put(265, "CHAR");
        DPROP_TYPE_MAP.put(266, "CHAR");
        DPROP_TYPE_MAP.put(267, "CHAR");
        DPROP_TYPE_MAP.put(268, "ULONG");
        DPROP_TYPE_MAP.put(5001, "ENUM");
        DPROP_TYPE_MAP.put(5003, "ENUM");
        DPROP_TYPE_MAP.put(5004, "ENUM");
        DPROP_TYPE_MAP.put(5005, "INTEGER");
        DPROP_TYPE_MAP.put(5006, "CHAR");
        DPROP_TYPE_MAP.put(5007, "CHAR");
        DPROP_TYPE_MAP.put(5008, "CHAR");
        DPROP_TYPE_MAP.put(5009, "CHAR");
        DPROP_TYPE_MAP.put(5010, "CHAR");
        DPROP_TYPE_MAP.put(5011, "ENUM");
        DPROP_TYPE_MAP.put(5012, "ENUM");
        DPROP_TYPE_MAP.put(5013, "CHAR");
        DPROP_TYPE_MAP.put(5014, "CHAR");
        DPROP_TYPE_MAP.put(5015, "CHAR");
        DPROP_TYPE_MAP.put(5016, "CHAR");
        DPROP_TYPE_MAP.put(5017, "CHAR");
        DPROP_TYPE_MAP.put(5018, "CHAR");
        DPROP_TYPE_MAP.put(5019, "CHAR");
        DPROP_TYPE_MAP.put(5020, "CHAR");
        DPROP_TYPE_MAP.put(5021, "ENUM");
        DPROP_TYPE_MAP.put(5022, "CHAR");
        DPROP_TYPE_MAP.put(5023, "ENUM");
        DPROP_TYPE_MAP.put(5024, "ENUM");
        DPROP_TYPE_MAP.put(5025, "ENUM");
        DPROP_TYPE_MAP.put(5026, "CHAR");
        DPROP_TYPE_MAP.put(5027, "CHAR");
        DPROP_TYPE_MAP.put(5058, "ENUM");
        DPROP_TYPE_MAP.put(5066, "CHAR");
        DPROP_TYPE_MAP.put(5060, "CHAR");
        DPROP_TYPE_MAP.put(271, "CHAR");
        DPROP_TYPE_MAP.put(269, "CHAR");
        DPROP_TYPE_MAP.put(270, "INTEGER");
        DPROP_TYPE_MAP.put(5061, "CHAR");
        DPROP_TYPE_MAP.put(5062, "CHAR");
        DPROP_TYPE_MAP.put(5063, "INT");
        DPROP_TYPE_MAP.put(5064, "ULONG");
        DPROP_TYPE_MAP.put(5065, "INT");
        DPROP_TYPE_MAP.put(5204, "INT");
        DPROP_TYPE_MAP.put(5205, "INT");
    }
}

