/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5288743276281910663L;
    private int m_numberOfDays;
    private final int GREGORGIAN_CHANGEOVER = 2299161;

    public DateInfo() {
        this.m_numberOfDays = 0;
    }

    public DateInfo(int num_of_days) {
        this.m_numberOfDays = num_of_days;
    }

    public DateInfo(String num_of_days) {
        this.m_numberOfDays = Integer.parseInt(num_of_days);
    }

    public DateInfo(int year, int month, int day) {
        this.setDate(year, month, day);
    }

    public void setValue(int num_of_days) {
        this.m_numberOfDays = num_of_days;
    }

    public void setValue(DateInfo dt) {
        this.m_numberOfDays = dt.getValue();
    }

    public int getValue() {
        return this.m_numberOfDays;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DateInfo rhs = (DateInfo)obj;
        return new EqualsBuilder().append(this.m_numberOfDays, rhs.m_numberOfDays).append(2299161, rhs.GREGORGIAN_CHANGEOVER).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        DateInfo obj = (DateInfo)super.clone();
        return obj;
    }

    public String toString() {
        SimpleDateFormat simpleFormat;
        String pattern;
        GregorianCalendar gregCal = this.GetDate();
        DateFormat dateFormatter = DateFormat.getDateInstance(3);
        if (dateFormatter instanceof SimpleDateFormat && !(pattern = (simpleFormat = (SimpleDateFormat)dateFormatter).toPattern()).contains("yyyy")) {
            pattern = pattern.replaceAll("yy", "yyyy");
            simpleFormat.applyPattern(pattern);
            dateFormatter = simpleFormat;
        }
        String formatted = dateFormatter.format(gregCal.getTime());
        return formatted;
    }

    public GregorianCalendar GetDate() {
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        int m = 0;
        if (this.m_numberOfDays < 2299161) {
            c = this.m_numberOfDays + 32082;
        } else {
            a = this.m_numberOfDays + 32044;
            b = (4 * a + 3) / 146097;
            c = a - b * 146097 / 4;
        }
        d = (4 * c + 3) / 1461;
        e = c - 1461 * d / 4;
        m = (5 * e + 2) / 153;
        GregorianCalendar calendar = new GregorianCalendar();
        int year = b * 100 + d - 4800 + m / 10;
        int month = m + 3 - 12 * (m / 10);
        int day = e - (153 * m + 2) / 5 + 1;
        calendar.set(year, month - 1, day);
        return calendar;
    }

    public void setDate(int year, int month, int day) {
        this.m_numberOfDays = DateInfo.dateToJulianDate(year, month, day);
    }

    public boolean validateDate() {
        int[] monthDays = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        GregorianCalendar calendar = this.GetDate();
        int year = calendar.get(1);
        int month = calendar.get(2);
        ++month;
        int day = calendar.get(5);
        if (year < -4712 || year > 9999) {
            return false;
        }
        if (month < 1 || day < 1) {
            return false;
        }
        if (month > 12 || day > 31) {
            return false;
        }
        if (year == 1582 && month == 8 && day > 4 && day < 15) {
            return false;
        }
        if (month == 2) {
            if (this.isLeapYear(year, month, day)) {
                return day <= 29;
            }
            return day <= 28;
        }
        return day <= monthDays[month];
    }

    public static int dateToJulianDate(int year, int month, int day) {
        int a = 0;
        int y = 0;
        int m = 0;
        int jd = 0;
        a = (14 - month) / 12;
        y = year + 4800 - a;
        m = month + 12 * a - 3;
        jd = year < 1582 || year == 1582 && month < 10 || year == 1582 && month == 10 && day <= 4 ? day + (153 * m + 2) / 5 + y * 365 + y / 4 - 32083 : day + (153 * m + 2) / 5 + y * 365 + y / 4 - y / 100 + y / 400 - 32045;
        return jd;
    }

    public static int dateToJulianDate(String pattern, String date_str) throws ARException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            Date date = formatter.parse(date_str);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return DateInfo.dateToJulianDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        catch (ParseException e) {
            throw new ARException(2, 8957, date_str);
        }
    }

    private boolean isLeapYear(int year, int month, int day) {
        if (year >= 1582 && month >= 10 && day >= 15) {
            return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        }
        return year % 4 == 0 && year % 100 != 0;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_numberOfDays).append(2299161).toHashCode();
    }
}

