/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class CurrencyFieldLimit
extends FieldLimit
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -304428784705749402L;
    protected BigDecimal m_lowRange;
    protected BigDecimal m_highRange;
    protected int m_precision;
    protected List<CurrencyDetail> m_functional;
    protected List<CurrencyDetail> m_allowable;

    public CurrencyFieldLimit() {
        this.m_functional = null;
        this.m_allowable = null;
        this.m_lowRange = null;
        this.m_highRange = null;
        this.m_precision = 0;
    }

    public CurrencyFieldLimit(String lowLimit, String highLimit, int precision) {
        this.m_lowRange = new BigDecimal(lowLimit);
        this.m_highRange = new BigDecimal(highLimit);
        this.m_precision = precision;
        this.m_functional = null;
        this.m_allowable = null;
    }

    public CurrencyFieldLimit(BigDecimal lowLimit, BigDecimal highLimit, int precision) {
        this.m_lowRange = lowLimit;
        this.m_highRange = highLimit;
        this.m_precision = precision;
        this.m_functional = null;
        this.m_allowable = null;
    }

    public CurrencyFieldLimit(String lowLimit, String highLimit, int precision, List<CurrencyDetail> functional, List<CurrencyDetail> allowable) {
        this.m_lowRange = new BigDecimal(lowLimit);
        this.m_highRange = new BigDecimal(highLimit);
        this.m_precision = precision;
        this.m_functional = functional;
        this.m_allowable = allowable;
    }

    public CurrencyFieldLimit(BigDecimal lowLimit, BigDecimal highLimit, int precision, List<CurrencyDetail> functional, List<CurrencyDetail> allowable) {
        this.m_lowRange = lowLimit;
        this.m_highRange = highLimit;
        this.m_precision = precision;
        this.m_functional = functional;
        this.m_allowable = allowable;
    }

    public void setLowRange(BigDecimal lowLimit) {
        this.m_lowRange = lowLimit;
    }

    public void setHighRange(BigDecimal highLimit) {
        this.m_highRange = highLimit;
    }

    public void setPrecision(int precision) {
        this.m_precision = precision;
    }

    public BigDecimal getLowRange() {
        return this.m_lowRange;
    }

    public BigDecimal getHighRange() {
        return this.m_highRange;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public List<CurrencyDetail> getAllowable() {
        return this.m_allowable;
    }

    public List<CurrencyDetail> getFunctional() {
        return this.m_functional;
    }

    @Override
    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        super.fromVariant(rawData, ctx);
        rawData = (Object[])ARTypeMgr.GetAt((Object)rawData, new int[]{1});
        this.m_lowRange = BigDecimal.valueOf(ConversionUtil.getDoubleValue(ARTypeMgr.GetAt((Object)rawData, 0)));
        this.m_highRange = BigDecimal.valueOf(ConversionUtil.getDoubleValue(ARTypeMgr.GetAt((Object)rawData, 1)));
        this.m_precision = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 2));
        this.m_functional = ARTypeMgr.getInstance().ObjectListFromVariant(CurrencyDetail.class, ARTypeMgr.GetAt((Object)rawData, 3), ctx);
        this.m_allowable = ARTypeMgr.getInstance().ObjectListFromVariant(CurrencyDetail.class, ARTypeMgr.GetAt((Object)rawData, 4), ctx);
    }

    @Override
    Object toVariant(ARServerUser ctx) {
        Object[] varInner;
        Object[] var = (Object[])super.toVariant(ctx);
        var[1] = varInner = new Object[]{ConversionUtil.getStringValue(this.m_lowRange), ConversionUtil.getStringValue(this.m_highRange), this.m_precision, ARTypeMgr.getInstance().ObjectListToVariant(this.m_functional, ctx), ARTypeMgr.getInstance().ObjectListToVariant(this.m_allowable, ctx)};
        return var;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        CurrencyFieldLimit limit = (CurrencyFieldLimit)super.clone();
        if (this.m_functional != null) {
            limit.m_functional = new ArrayList<CurrencyDetail>(this.m_functional.size());
            for (i = 0; i < this.m_functional.size(); ++i) {
                limit.m_functional.add((CurrencyDetail)this.m_functional.get(i).clone());
            }
        }
        if (this.m_allowable != null) {
            limit.m_allowable = new ArrayList<CurrencyDetail>(this.m_allowable.size());
            for (i = 0; i < this.m_allowable.size(); ++i) {
                limit.m_allowable.add((CurrencyDetail)this.m_allowable.get(i).clone());
            }
        }
        return limit;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Low Range", this.m_lowRange).append("High Range", this.m_highRange).append("Precision", this.m_precision).append("Functional", this.m_functional).append("Allowable", this.m_allowable).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_lowRange).append(this.m_highRange).append(this.m_precision).append(this.m_functional).append(this.m_allowable).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CurrencyFieldLimit)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CurrencyFieldLimit rhs = (CurrencyFieldLimit)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_lowRange, rhs.m_lowRange).append(this.m_highRange, rhs.m_highRange).append(this.m_precision, rhs.m_precision).append(this.m_functional, rhs.m_functional).append(this.m_allowable, rhs.m_allowable).isEquals();
    }
}

