/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AlertCallbackHandler;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.AlertMessageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class AlertReceiver {
    private static Logger log = Logger.getLogger(AlertReceiver.class);
    private ServerSocket serverSocket = null;
    private int alertPort = 0;
    private Thread workerThread = null;
    private AlertCallbackHandler callbackHandler;

    public AlertReceiver(AlertCallbackHandler callbackHandler) throws IOException {
        this(callbackHandler, 0);
    }

    public AlertReceiver(AlertCallbackHandler callbackHandler, int port) throws IOException {
        this.callbackHandler = callbackHandler;
        this.serverSocket = new ServerSocket(port);
        this.alertPort = this.serverSocket.getLocalPort();
    }

    public boolean beginReceive(ARServerUser context) throws ARException {
        int registrationFlags = 0;
        context.registerForAlerts(this.alertPort, registrationFlags);
        log.debug("Server registered for alerts: " + context.getServer() + " on port: " + this.alertPort);
        if (this.workerThread == null) {
            this.workerThread = new Thread(new ClientWorker());
            this.workerThread.setPriority(1);
            this.workerThread.start();
        }
        return true;
    }

    public void stopReceive(ARServerUser context) throws ARException {
        context.deregisterForAlerts(this.alertPort);
        log.debug("Server deregistered for alerts: " + context.getServer());
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    class ClientWorker
    implements Runnable {
        ClientWorker() {
        }

        @Override
        public void run() {
            Socket clientSocket = null;
            try {
                while (true) {
                    AlertMessageInfo result;
                    clientSocket = AlertReceiver.this.serverSocket.accept();
                    if (log.isDebugEnabled()) {
                        boolean isIPv6 = false;
                        if (clientSocket.getInetAddress() instanceof Inet6Address) {
                            isIPv6 = true;
                        }
                        if (isIPv6) {
                            log.debug("New connection accepted [" + clientSocket.getInetAddress() + "]:" + clientSocket.getPort());
                        } else {
                            log.debug("New connection accepted " + clientSocket.getInetAddress() + ":" + clientSocket.getPort());
                        }
                    }
                    if ((result = this.readAlertMessage(clientSocket)).getSourceType() != 3) {
                        AlertReceiver.this.callbackHandler.onAlertRecieved(result);
                    }
                    clientSocket.close();
                }
            }
            catch (Exception e) {
                log.error(e);
                return;
            }
        }

        private AlertMessageInfo readAlertMessage(Socket clientSocket) throws IOException, ARException {
            byte[] bytes = new byte[1024];
            int numBytes = 0;
            InputStream in = clientSocket.getInputStream();
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            while ((numBytes = in.available()) == 0) {
            }
            numBytes = in.read(bytes);
            this.sendAcknowledgement(out);
            log.debug(" numBytes received is " + numBytes);
            AlertMessageInfo alertMsg = AlertMessageInfo.DecodeAlertMessage(new AlertMessageCriteria(), bytes, numBytes);
            log.debug(" AlertSourceType : " + alertMsg.getSourceType());
            log.debug(" AlertText : " + alertMsg.getAlertText());
            log.debug(" from server : " + alertMsg.getServerAddr());
            in.close();
            out.close();
            return alertMsg;
        }

        private void sendAcknowledgement(PrintWriter out) {
            out.println("ack");
        }
    }
}

