/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.StatusInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ARException
extends Exception {
    private static final long serialVersionUID = -1213686155764416279L;
    private List<StatusInfo> m_lastStatus;

    public ARException() {
    }

    public ARException(List<StatusInfo> lastStatus) {
        this.setLastStatus(lastStatus);
    }

    public ARException(int returnCode, int errorCode) {
        this.setStatus(returnCode, errorCode, null);
    }

    public ARException(int returnCode, int errorCode, String appendMsg) {
        this.setStatus(returnCode, errorCode, appendMsg);
    }

    public ARException(int returnCode, int errorCode, String appendMsg, Locale locale) {
        this.setStatus(returnCode, errorCode, appendMsg, locale);
    }

    public List<StatusInfo> getLastStatus() {
        if (this.m_lastStatus == null) {
            return null;
        }
        return Collections.unmodifiableList(this.m_lastStatus);
    }

    public void setLastStatus(List<StatusInfo> lastStatus) {
        this.m_lastStatus = lastStatus;
    }

    @Override
    public String toString() {
        int count;
        String msg = null;
        StringBuffer msgb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        List<StatusInfo> lastStatusList = this.getLastStatus();
        int n = count = lastStatusList != null ? lastStatusList.size() : 0;
        for (int i = 0; i < count; ++i) {
            msgb.append(lastStatusList.get(i).toString());
            if (i + 1 >= count) continue;
            msgb.append(lineSeparator);
        }
        msg = msgb.toString();
        return msg;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public void clear() {
        this.m_lastStatus = null;
    }

    public boolean canErrorBeIgnored(int[] ignoredErrors) {
        List<StatusInfo> statusList = this.getLastStatus();
        if (statusList != null && statusList.size() > 0) {
            if (ignoredErrors == null || ignoredErrors.length == 0) {
                return false;
            }
            boolean ignored = false;
            for (int i = 0; i < statusList.size(); ++i) {
                for (int j = 0; j < ignoredErrors.length; ++j) {
                    if (statusList.get(i).getMessageNum() != (long)ignoredErrors[j]) continue;
                    ignored = true;
                    break;
                }
                if (ignored) continue;
                return false;
            }
            return ignored;
        }
        return true;
    }

    private void setStatus(int returnCode, int errorCode, String appendMsg) {
        StatusInfo status = new StatusInfo(returnCode, errorCode, appendMsg);
        this.m_lastStatus = new ArrayList<StatusInfo>();
        this.m_lastStatus.add(status);
    }

    private void setStatus(int returnCode, int errorCode, String appendMsg, Locale locale) {
        StatusInfo status = new StatusInfo(errorCode, locale);
        status.setMessageType(returnCode);
        if (appendMsg != null) {
            status.setAppendedText(appendMsg);
        }
        this.m_lastStatus = new ArrayList<StatusInfo>();
        this.m_lastStatus.add(status);
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }
}

