/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.ARExternalProcessUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static boolean _speedTest = false;
    private static boolean _speedTestDisplayLast = false;
    private static int testLoop = 1;
    private static Collection<String> apiRunOnce = new HashSet<String>();
    private static final ProcessUtil _instance = new ProcessUtil();
    private static Logger log = Logger.getLogger(ProcessUtil.class);

    private ProcessUtil() {
    }

    public static ProcessUtil getInstance() {
        return _instance;
    }

    public boolean hasApiRunOnce(String apiName) {
        return apiRunOnce.contains(apiName);
    }

    public void updateAPIRunSet(String apiName) {
        if (!apiRunOnce.contains(apiName)) {
            apiRunOnce.add(apiName);
        }
    }

    public void PrintProcessTime(long start, String leadingMsg) {
        long finish = System.currentTimeMillis();
        long elapsed_time = finish - start;
        log.debug((Object)("\n" + leadingMsg + " takes " + elapsed_time + " milliseconds.\n"));
    }

    public boolean is_speedTest() {
        return _speedTest;
    }

    public boolean is_speedTestDisplayLast() {
        return _speedTestDisplayLast;
    }

    public int getTestLoop() {
        return testLoop;
    }

    public static String getFormatedTimeUsed(long time) {
        SimpleDateFormat df = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
        df.setTimeZone(TimeZone.getDefault());
        return df.format(new Date(time));
    }

    public static String getElapsedTimeToFormatedString(long elapsedTimeMilliSec) {
        return ProcessUtil.getElapsedMiliSecTimeToFormatedString(elapsedTimeMilliSec, false);
    }

    public static String getElapsedMiliSecTimeToFormatedString(long elapsedTimeMilliSec, boolean miliSecFormat) {
        String time;
        if (elapsedTimeMilliSec < 0L) {
            String time2 = "Wrong data: " + elapsedTimeMilliSec + " millisec";
            return time2;
        }
        String days = null;
        long remHours = 0L;
        long remMinutes = 0L;
        long remSeconds = 0L;
        long remMiliSeconds = 0L;
        int day = (int)((float)elapsedTimeMilliSec / 8.64E7f);
        remHours = day > 0 ? elapsedTimeMilliSec - (long)day * 24L * 60L * 60L * 1000L : elapsedTimeMilliSec;
        int hours = (int)((float)remHours / 3600000.0f);
        remMinutes = hours > 0 ? remHours - (long)hours * 60L * 60L * 1000L : remHours;
        int minutes = (int)((float)remMinutes / 60000.0f);
        remSeconds = minutes > 0 ? remMinutes - (long)minutes * 60L * 1000L : remMinutes;
        int seconds = (int)(remSeconds / 1000L);
        remMiliSeconds = seconds > 0 ? remSeconds - (long)seconds * 1000L : remSeconds;
        String format = String.format("%%0%dd", 2);
        String secondsStr = String.format(format, seconds);
        String minutesStr = String.format(format, minutes);
        String hoursStr = String.format(format, hours);
        if (day > 0) {
            String formatDay = String.format("%%0%ddd", 3);
            days = String.format(formatDay, day);
            time = days + " " + hoursStr + ":" + minutesStr + ":" + secondsStr;
        } else if (miliSecFormat) {
            String miliSFormat = String.format("%%0%dd", 3);
            String miliSecondStr = String.format(miliSFormat, remMiliSeconds);
            time = hoursStr + ":" + minutesStr + ":" + secondsStr + ":" + miliSecondStr + " (" + elapsedTimeMilliSec + " miliSec)";
        } else {
            time = hoursStr + ":" + minutesStr + ":" + secondsStr;
        }
        return time;
    }

    public static void callServerProcess(String serverName) {
        ARExternalProcessUtil.runProcess(serverName);
    }
}

