/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncEngineFactory;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.EvpEncryptionBase;
import com.bmc.arsys.utils.LogBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

abstract class SymmetricCipherBase
extends EvpEncryptionBase {
    private transient boolean base64HandlingNeeded = false;
    private static Base64 base64 = new Base64();
    private static Logger logger = Logger.getLogger(SymmetricCipherBase.class);
    protected boolean logFlag = false;

    protected abstract boolean isDebugEnabled();

    protected SymmetricCipherBase(boolean debug) {
        this.setLogFlag(debug);
    }

    protected SymmetricCipherBase(boolean base64EncodeNeeded, boolean debug) {
        this.base64HandlingNeeded = base64EncodeNeeded;
        this.setLogFlag(debug);
    }

    protected boolean setLogFlag(boolean debug) {
        this.logFlag = debug && this.isDebugEnabled();
        return this.logFlag;
    }

    protected byte[] decryptData(ARDataKey dataKey, byte[] encryptedData) throws AREncryptionException {
        byte[] from = this.base64HandlingNeeded ? this.base64Decode(encryptedData) : encryptedData;
        return this.decryptBuffer(dataKey, from);
    }

    protected byte[] encryptData(ARDataKey dataKey, byte[] dataToEncrypt) throws AREncryptionException {
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(dataToEncrypt, "SymmetricCipherBase.encryptData- org data");
        }
        byte[] from = this.encryptBuffer(dataKey, dataToEncrypt);
        byte[] rst = this.base64HandlingNeeded ? this.base64Encode(from) : from;
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] encryptBuffer(ARDataKey dataKey, byte[] data) throws AREncryptionException {
        byte[] encryptedMacVerifier;
        byte[] encryptedCipher;
        ARDataKey encMacKey = new ARDataKey();
        encMacKey.setEncMode(1);
        encMacKey.setEncAlgorithmStr(dataKey.isFIPSAlg() ? "HmacSHA1" : "HmacMD5");
        encMacKey.setEncType("MacGen");
        encMacKey.setMacKey(dataKey.getMacKey());
        encMacKey.setMacMasked(dataKey.isMacMasked());
        if (dataKey.checkValidEncAlgorithm(dataKey.getEncAlgorithm())) {
            encMacKey.setProvider(ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][dataKey.getEncAlgorithm() - 1]);
        }
        byte[] macVerifier = this.genMessageMAC(encMacKey, data);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(macVerifier, "SymmetricCipherBase.EncryptData- macVerifier");
        }
        dataKey.setEncMode(1);
        Cipher cipher = (Cipher)AREncEngineFactory.getInstance().getEncEngineInstance(dataKey.getEncType(), dataKey);
        try {
            AREncEngineFactory.getInstance().initEngine(cipher, dataKey.getEncType(), dataKey);
            encryptedCipher = this.evpEncryptDecrypt(cipher, data);
            if (ARCryptoConstants.OTHER_PROVIDERS[ARCryptoConstants.RSA_JSAFE_PROVIDER_IDX].equals(dataKey.provider) && dataKey.getEncAlgorithm() == 3) {
                AREncEngineFactory.getInstance().initEngine(cipher, dataKey.getEncType(), dataKey);
            }
            encryptedMacVerifier = this.evpEncryptDecrypt(cipher, macVerifier);
        }
        finally {
            AREncEngineFactory.getInstance().releaseEncEngineInstance(dataKey, cipher);
        }
        byte[] rst = StringByteUtil.concatenateByteArrays(encryptedCipher, encryptedMacVerifier);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(encryptedCipher, "SymmetricCipherBase.EncryptData- encryptedCiper");
            LogBytes.printByteArrayAsHex(encryptedMacVerifier, "SymmetricCipherBase.EncryptData- encryptedMacVerifier");
            LogBytes.printByteArrayAsHex(rst, "SymmetricCipherBase.EncryptData- encryptedData");
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decryptBuffer(ARDataKey dataKey, byte[] data) throws AREncryptionException {
        byte[] rst = new byte[]{};
        if (data == null) {
            return rst;
        }
        int encBlockInfoSize = dataKey.getEncBlockInfoSize();
        dataKey.setEncMode(2);
        byte[] encryptedTextToDecrypt = null;
        byte[] encryptedVerifierToDecrypt = null;
        byte[] decryptedMacVerifierToCheck = null;
        byte[] macVerifier = null;
        Cipher cipher = (Cipher)AREncEngineFactory.getInstance().getEncEngineInstance(dataKey.getEncType(), dataKey);
        try {
            AREncEngineFactory.getInstance().initEngine(cipher, dataKey.getEncType(), dataKey);
            int blocksize = cipher.getBlockSize();
            int verifierLen = blocksize > 1 ? encBlockInfoSize / blocksize * blocksize + blocksize : encBlockInfoSize;
            int len = data.length - verifierLen;
            if (len <= 0) {
                throw new AREncryptionException(new InvalidParameterException("Wrong encrypted data bytes to decrypt."), 9004);
            }
            encryptedTextToDecrypt = StringByteUtil.getByteArrays(data, 0, data.length - verifierLen);
            encryptedVerifierToDecrypt = StringByteUtil.getByteArrays(data, data.length - verifierLen, verifierLen);
            rst = this.evpEncryptDecrypt(cipher, encryptedTextToDecrypt);
            if (ARCryptoConstants.OTHER_PROVIDERS[ARCryptoConstants.RSA_JSAFE_PROVIDER_IDX].equals(dataKey.provider) && dataKey.getEncAlgorithm() == 3) {
                AREncEngineFactory.getInstance().initEngine(cipher, dataKey.getEncType(), dataKey);
            }
            decryptedMacVerifierToCheck = this.evpEncryptDecrypt(cipher, encryptedVerifierToDecrypt);
            ARDataKey encMacKey = new ARDataKey();
            encMacKey.setEncMode(2);
            encMacKey.setEncAlgorithmStr(dataKey.isFIPSAlg() ? "HmacSHA1" : "HmacMD5");
            encMacKey.setEncType("MacGen");
            encMacKey.setMacKey(dataKey.getMacKey());
            encMacKey.setMacMasked(dataKey.isMacMasked());
            if (dataKey.checkValidEncAlgorithm(dataKey.getEncAlgorithm())) {
                encMacKey.setProvider(ARCryptoConstants.ENC_CIPHER_PROVIDERS[ARCryptoConstants.JCE_PROVIDER_IDX][dataKey.getEncAlgorithm() - 1]);
            }
            macVerifier = this.genMessageMAC(encMacKey, rst);
        }
        finally {
            AREncEngineFactory.getInstance().releaseEncEngineInstance(dataKey, cipher);
        }
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(encryptedTextToDecrypt, "SymmetricCipherBase.DecryptData- encryptedText-ToDecrypt");
            LogBytes.printByteArrayAsHex(encryptedVerifierToDecrypt, "SymmetricCipherBase.DecryptData- encryptedVerifier-ToDecrypt");
            LogBytes.printByteArrayAsHex(rst, "SymmetricCipherBase.DecryptText before unxdr len : " + rst.length);
            LogBytes.printByteArrayAsHex(decryptedMacVerifierToCheck, "remote macVerifier len : " + decryptedMacVerifierToCheck.length);
            LogBytes.printByteArrayAsHex(macVerifier, "local macVerifier len : " + macVerifier.length);
            boolean expected = Arrays.equals(macVerifier, decryptedMacVerifierToCheck);
            logger.debug((Object)("Decrypted and regenerate local MacVerifier compare with remote one for alg=" + dataKey.getEncAlgorithm() + " " + (expected ? "SUCCEEDED!" : "FAILED!")));
        }
        return rst;
    }

    protected byte[] setUpActualEncryptBuffer(byte[] plainText, int leadPaddingSize) {
        byte[] encryptFrom = null;
        if (leadPaddingSize > 0) {
            byte[] leadPadding = StringByteUtil.generateRandomBytes(leadPaddingSize);
            encryptFrom = StringByteUtil.concatenateByteArrays(leadPadding, plainText, this.getEndingBytes(plainText));
        } else {
            encryptFrom = StringByteUtil.concatenateByteArrays(plainText, this.getEndingBytes(plainText));
        }
        return encryptFrom;
    }

    protected byte[] getPlainText(byte[] decryptedBuffer) throws AREncryptionException {
        int len = this.getDataLen(decryptedBuffer);
        if (len + 4 > decryptedBuffer.length) {
            throw new AREncryptionException(new InvalidParameterException("Encoded buffer size wrong"), 9014);
        }
        byte[] orgData = StringByteUtil.getByteArrays(decryptedBuffer, decryptedBuffer.length - len - 4, len);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(orgData, "SymmetricCipherBase.unsaltData org data");
        }
        return orgData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] saltData(byte[] encryptFrom) throws AREncryptionException {
        ARDataKey encKey = new ARDataKey();
        encKey.setEncMode(1);
        encKey.setEncAlgorithmStr("DES");
        encKey.setEncType("Salt");
        encKey.setEncXForm("DES/CBC/PKCS5Padding");
        encKey.setKey(this.getSaltDataKey());
        this.setSaltDataKeySize(encKey);
        encKey.setIv(this.getSaltIv());
        encKey.setSaltIv(this.getSaltIv());
        encKey.setSaltIvMasked(this.isSaltIvMasked());
        byte[] saltedData = new byte[]{};
        Cipher cipher = (Cipher)AREncEngineFactory.getInstance().getEncEngineInstance(encKey.getEncType(), encKey);
        try {
            AREncEngineFactory.getInstance().initEngine(cipher, encKey.getEncType(), encKey);
            byte[] saltedBuffer = this.evpEncryptDecrypt(cipher, encryptFrom);
            saltedData = StringByteUtil.concatenateByteArrays(saltedBuffer, encKey.getKey());
        }
        finally {
            AREncEngineFactory.getInstance().releaseEncEngineInstance(encKey, cipher);
        }
        return saltedData;
    }

    protected boolean isSaltIvMasked() {
        return false;
    }

    protected void setSaltDataKeySize(AREncKeyBase encKey) {
        encKey.setKeySize(56);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] unsaltData(byte[] fromBuf) throws AREncryptionException {
        byte[] unsaltedBuffer;
        if (fromBuf == null) {
            throw new AREncryptionException(9015);
        }
        int saltedBufLen = fromBuf.length - 8;
        byte[] encrytedSaltedData = StringByteUtil.getByteArrays(fromBuf, 0, saltedBufLen);
        byte[] keyForSaltingData = StringByteUtil.getByteArrays(fromBuf, saltedBufLen, 8);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(keyForSaltingData, "SymmetricCipherBase.unsaltData got keyForSaltingData from encrypted buffer");
        }
        ARDataKey encKey = new ARDataKey();
        encKey.setEncMode(2);
        encKey.setEncAlgorithmStr("DES");
        encKey.setEncType("Salt");
        encKey.setEncXForm("DES/CBC/PKCS5Padding");
        encKey.setKey(keyForSaltingData);
        this.setSaltDataKeySize(encKey);
        encKey.setIv(this.getSaltIv());
        encKey.setSaltIv(this.getSaltIv());
        encKey.setSaltIvMasked(this.isSaltIvMasked());
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(encrytedSaltedData, "SymmetricCipherBase.unsaltData buffer to decrypt using saltKey");
        }
        Cipher cipher = (Cipher)AREncEngineFactory.getInstance().getEncEngineInstance(encKey.getEncType(), encKey);
        try {
            AREncEngineFactory.getInstance().initEngine(cipher, encKey.getEncType(), encKey);
            unsaltedBuffer = this.evpEncryptDecrypt(cipher, encrytedSaltedData);
        }
        finally {
            AREncEngineFactory.getInstance().releaseEncEngineInstance(encKey, cipher);
        }
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(unsaltedBuffer, "SymmetricCipherBase.unsaltData decrypted unsaltedBuffer with padding");
        }
        return unsaltedBuffer;
    }

    protected byte[] getSaltIv() {
        return ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.S, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] genMessageMAC(ARDataKey encDataKey, byte[] dataBytes) throws AREncryptionException {
        byte[] macbytes;
        try {
            Mac mac = (Mac)AREncEngineFactory.getInstance().getEncEngineInstance("MacGen", encDataKey);
            try {
                AREncEngineFactory.getInstance().initEngine(mac, "MacGen", encDataKey);
                macbytes = mac.doFinal(dataBytes);
            }
            finally {
                AREncEngineFactory.getInstance().releaseEncEngineInstance(encDataKey, mac);
            }
        }
        catch (Exception e) {
            if (e instanceof AREncryptionException) {
                throw (AREncryptionException)e;
            }
            throw new AREncryptionException(e, 9007);
        }
        return macbytes;
    }

    private byte[] getSaltDataKey() {
        return StringByteUtil.generateRandomBytes(8);
    }

    protected int getPadSize(int plainTextBufLen) {
        return 0;
    }

    private int getDataLen(byte[] unsaltedBuffer) {
        byte[] padlen = StringByteUtil.getByteArrays(unsaltedBuffer, unsaltedBuffer.length - 4, 4);
        int len = (padlen[0] & 0xFF) + ((padlen[1] & 0xFF) << 8) + ((padlen[2] & 0xFF) << 16) + ((padlen[3] & 0xFF) << 24);
        return len;
    }

    private byte[] getEndingBytes(byte[] org) {
        byte[] ending = new byte[]{(byte)(org.length & 0xFF), (byte)((org.length & 0xFF00) >> 8), (byte)((org.length & 0xFF0000) >> 16), (byte)((org.length & 0xFF000000) >> 24)};
        return ending;
    }

    private byte[] base64Encode(byte[] fromBytes) {
        byte[] rst = new byte[]{};
        if (fromBytes != null) {
            rst = base64.encode(fromBytes);
        }
        return rst;
    }

    private byte[] base64Decode(byte[] fromBytes) {
        byte[] rst = new byte[]{};
        if (fromBytes != null) {
            rst = base64.decode(fromBytes);
        }
        return rst;
    }
}

