/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARFips;
import java.math.BigInteger;
import java.security.Key;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class ARPPKey
extends AREncKeyBase {
    private transient int modulusBitSize;
    private transient String modulusBitSizeStr;
    private transient String exponent = "3";
    protected transient Key encKey;
    protected String keyID = "PPKey";
    protected boolean debug;

    protected ARPPKey() {
        this.setKeyID();
    }

    public void setAlgorithmParam(int encAlgorithm) throws AREncryptionException {
        if (!this.checkValidKeyEncAlgorithm(encAlgorithm)) {
            throw new AREncryptionException(9006);
        }
        this.setEncAlgorithm(encAlgorithm);
        this.setEncAlgorithmStr(ARCryptoConstants.AR_KEY_ENC_ALG_STR[encAlgorithm - 1]);
        this.setModulusBitSize(ARCryptoConstants.AR_ENC_RMOD_MODULUS_BIT_SIZE[encAlgorithm - 4]);
        this.setModulusBitSizeStr(ARCryptoConstants.AR_ENC_RMOD_MODULUS_BIT_SIZE_STR[encAlgorithm - 4]);
        this.setEncXForm("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        this.setEncType(this.getKeyID());
        this.setProvider(ARCryptoConstants.PPK_CIPHER_PROVIDERS[this.getJCEProviderIdx()][encAlgorithm - 4]);
    }

    protected int getJCEProviderIdx() {
        int idx = ARCryptoConstants.JRE_VENDER_IDX > 0 ? ARCryptoConstants.JRE_VENDER_IDX : ARCryptoConstants.JCE_PROVIDER_IDX;
        return idx;
    }

    protected int getModulusBitSize() {
        return this.modulusBitSize;
    }

    protected BigInteger getBigModulus() {
        return new BigInteger(1, this.getKey());
    }

    protected BigInteger getBigExponent() {
        return new BigInteger(this.exponent);
    }

    protected String getBigExponentStr() {
        return this.exponent;
    }

    protected void setBigExponent(String exp) {
        this.exponent = exp;
    }

    protected void setModulusBitSize(int modulus) {
        this.modulusBitSize = modulus;
    }

    protected abstract Key getRsaKey() throws AREncryptionException;

    protected void setModulusBitSizeStr(String modulusBitSizeStr) {
        this.modulusBitSizeStr = modulusBitSizeStr;
    }

    @Override
    protected boolean checkValidKeyEncAlgorithm(int alg) throws AREncryptionException {
        boolean validFlag = false;
        if (arFips != null && 2 == ARFips.currentFipsMode) {
            for (int i = 0; i < ARCryptoConstants.AR_KEY_ENC_FIPS_CAPABLE_RMOD.length; ++i) {
                if (ARCryptoConstants.AR_KEY_ENC_FIPS_CAPABLE_RMOD[i] != alg) continue;
                validFlag = true;
                break;
            }
        } else {
            validFlag = ARPPKey.isValidKeyAlg(alg);
        }
        return validFlag;
    }

    static boolean isValidKeyAlg(int alg) {
        boolean validFlag = false;
        for (int i = 0; i < ARCryptoConstants.AR_KEY_ENC_VALID_RMOD.length; ++i) {
            if (ARCryptoConstants.AR_KEY_ENC_VALID_RMOD[i] != alg) continue;
            validFlag = true;
            break;
        }
        return validFlag;
    }

    protected void setKeyID() {
        this.keyID = "PPKey";
    }

    protected String getKeyID() {
        return this.keyID;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getProvider() != null) {
            sb.append("_P_").append(this.getProvider());
        }
        if (this.modulusBitSizeStr != null) {
            sb.append("_M_").append(this.modulusBitSizeStr);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.modulusBitSizeStr).append((Object)this.keyID).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARPPKey rhs = (ARPPKey)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.modulusBitSizeStr, (Object)rhs.modulusBitSizeStr).append((Object)this.keyID, (Object)rhs.keyID).isEquals();
    }
}

