/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.FileContent;
import com.bmc.arsys.apiext.definition.IFileParser;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.ViewItemData;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileParser
extends DefaultHandler
implements ContentHandler,
IFileParser {
    private FileContent currentContent = null;
    private BaseItemData currentData = null;
    private String currentForm = null;
    private String currentProperty = null;
    private StringBuffer currentToken = null;
    private ViewItemData currentView = null;
    private boolean inLockBlock = false;
    private boolean nonFormParent = false;
    private boolean inObject = false;
    private boolean inTag = false;
    private boolean inView = false;
    private boolean inViewForm = false;
    private XMLReader parser = null;
    private boolean parsingApplications = false;
    private boolean parsingObjects = false;
    private boolean parsingViews = false;
    private boolean parsingObjectsInApplication = false;
    private boolean applicationStarted = false;
    private String appName = null;
    private StringBuffer tagBuffer = null;
    private int tagValue = -1;
    boolean addName = false;

    public XMLFileParser() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        this.parser = new SAXParser();
        this.parser.setFeature("http://xml.org/sax/features/validation", false);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inTag && this.currentToken != null) {
            this.currentToken.append(ch, start, length);
        } else if (this.inTag) {
            this.tagBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parsingViews) {
            if ("formName".equals(localName)) {
                this.currentForm = this.currentToken.toString();
                this.currentToken = null;
            } else if ("view".equals(localName)) {
                if (this.currentContent.get((Object)DefinitionItemType.VIEW) == null) {
                    this.currentContent.put(DefinitionItemType.VIEW, new ArrayList());
                }
                ((List)this.currentContent.get((Object)DefinitionItemType.VIEW)).add(this.currentView);
                this.inView = false;
                this.currentToken = null;
            } else if ("views".equals(localName)) {
                this.inViewForm = false;
                this.currentToken = null;
            }
            if (this.inView) {
                if ("viewName".equals(localName)) {
                    this.currentView.setName(this.currentToken.toString());
                    this.currentToken = null;
                } else if ("viewID".equals(localName)) {
                    try {
                        int viewId = Integer.parseInt(this.currentToken.toString());
                        this.currentView.setViewId(viewId);
                    }
                    catch (NumberFormatException e) {}
                } else if ("vuiType".equals(localName)) {
                    if ("windows".equals(this.currentToken.toString())) {
                        this.currentView.setVuiType(1);
                    } else if ("none".equals(this.currentToken.toString())) {
                        this.currentView.setVuiType(0);
                    } else if ("web".equals(this.currentToken.toString())) {
                        this.currentView.setVuiType(2);
                    } else if ("webFixedPosition".equals(this.currentToken.toString())) {
                        this.currentView.setVuiType(3);
                    } else if ("wireless".equals(this.currentToken.toString())) {
                        this.currentView.setVuiType(4);
                    }
                    this.currentToken = null;
                } else if ("characterValue".equals(localName)) {
                    this.currentProperty = this.currentToken.toString();
                    this.currentToken = null;
                } else if ("tag".equals(localName)) {
                    this.inTag = false;
                    this.tagValue = Integer.parseInt(this.tagBuffer.toString());
                    switch (this.tagValue) {
                        case 20: {
                            this.currentView.setLabel(this.currentProperty);
                            break;
                        }
                    }
                    this.currentToken = null;
                }
            }
        }
        if (this.parsingObjects || this.applicationStarted) {
            if ("lockBlock".equals(localName)) {
                this.inLockBlock = false;
            }
            if ("limits".equals(localName) || "audit".equals(localName) || "archive".equals(localName)) {
                this.nonFormParent = false;
            }
            if (this.inObject) {
                if ("formName".equals(localName)) {
                    if (this.currentData.getType() == DefinitionItemType.FORM && !this.nonFormParent) {
                        this.currentData.setName(this.currentToken.toString());
                    }
                    this.addName = false;
                } else if ("activeLinkName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("menuName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("filterName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("escalationName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("containerName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                } else if ("imageName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("associationName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.addName = false;
                } else if ("containerType".equals(localName)) {
                    if ("activeLinkGuide".equals(this.currentToken.toString())) {
                        this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.ACTIVE_LINK_GUIDE);
                        this.addName = false;
                    } else if ("filterGuide".equals(this.currentToken.toString())) {
                        this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.FILTER_GUIDE);
                        this.addName = false;
                    } else if ("application".equals(this.currentToken.toString())) {
                        this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.APPLICATION);
                        this.addName = false;
                    } else if ("packingList".equals(this.currentToken.toString())) {
                        this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.PACKING_LIST);
                        this.addName = false;
                    } else if ("webService".equals(this.currentToken.toString())) {
                        this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.WEB_SERVICE);
                        this.addName = false;
                    }
                } else if ("distributedMappingName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.DISTRIBUTED_MAPPING);
                    this.addName = false;
                } else if ("distributedPoolName".equals(localName)) {
                    this.currentData.setName(this.currentToken.toString());
                    this.currentContent.updateItemType(this.currentData, this.currentData.getType(), DefinitionItemType.DISTRIBUTED_POOL);
                    this.addName = false;
                } else if ("owner".equals(localName)) {
                    this.currentData.setOwner(this.currentToken.toString());
                    this.currentToken = new StringBuffer();
                } else if ("lastModifiedBy".equals(localName)) {
                    this.currentData.setLastChanged(this.currentToken.toString());
                    this.currentToken = new StringBuffer();
                } else if ("modifiedDate".equals(localName)) {
                    SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssz");
                    try {
                        String parseValue = this.currentToken.toString();
                        int lastIndex = parseValue.lastIndexOf("-");
                        if (lastIndex == parseValue.length() - 6) {
                            this.currentToken.insert(lastIndex, "GMT");
                            parseValue = this.currentToken.toString();
                        } else {
                            lastIndex = parseValue.lastIndexOf("+");
                            if (lastIndex == parseValue.length() - 6) {
                                this.currentToken.insert(lastIndex, "GMT");
                                parseValue = this.currentToken.toString();
                            }
                        }
                        parseValue = parseValue.replaceFirst("T", " ");
                        Date dateValue = simpleFormat.parse(parseValue);
                        if (dateValue != null) {
                            this.currentData.setTimestamp(new Timestamp(dateValue));
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        this.currentData.setTimestamp(null);
                    }
                    this.currentToken = new StringBuffer();
                }
            }
            if ("form".equals(localName)) {
                this.inObject = false;
            }
        }
    }

    @Override
    public FileContent parseApplications(String fileName) throws DefinitionException, IOException {
        FileContent result;
        this.currentContent = result = new FileContent();
        this.parsingApplications = true;
        this.parser.setContentHandler(this);
        try {
            this.parser.parse(new InputSource(this.formatFileName(fileName)));
        }
        catch (SAXException e) {
            throw new DefinitionException("Error encountered during parsing", e);
        }
        result = this.currentContent;
        return result;
    }

    @Override
    public FileContent parseObjectsInApplication(String fileName, String appName) throws DefinitionException, IOException {
        FileContent result;
        this.currentContent = result = new FileContent();
        this.parsingObjectsInApplication = true;
        this.appName = appName;
        this.parser.setContentHandler(this);
        try {
            this.parser.parse(new InputSource(this.formatFileName(fileName)));
        }
        catch (SAXException e) {
            throw new DefinitionException("Error encountered during parsing", e);
        }
        result = this.currentContent;
        return result;
    }

    @Override
    public FileContent parseObjects(String fileName) throws DefinitionException, IOException {
        FileContent result;
        this.currentContent = result = new FileContent();
        this.parsingObjects = true;
        this.parser.setContentHandler(this);
        try {
            this.parser.parse(new InputSource(this.formatFileName(fileName)));
        }
        catch (SAXException e) {
            throw new DefinitionException("Error encountered during parsing", e);
        }
        result = this.currentContent;
        return result;
    }

    @Override
    public FileContent parseViews(String fileName) throws DefinitionException, IOException {
        FileContent result;
        this.currentContent = result = new FileContent();
        this.currentContent.put(DefinitionItemType.VIEW, new ArrayList());
        this.parsingViews = true;
        this.tagBuffer = new StringBuffer();
        this.parser.setContentHandler(this);
        try {
            this.parser.parse(new InputSource(this.formatFileName(fileName)));
        }
        catch (SAXException e) {
            throw new DefinitionException("Error encountered during parsing", e);
        }
        result = this.currentContent;
        return result;
    }

    private String formatFileName(String fileName) {
        return "file:///" + fileName;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ((this.parsingApplications || this.parsingObjectsInApplication) && "application".equals(localName)) {
            if (this.parsingObjectsInApplication) {
                if (this.applicationStarted && !this.appName.equals(atts.getValue("name"))) {
                    this.applicationStarted = false;
                }
                if (!this.applicationStarted && this.appName.equals(atts.getValue("name"))) {
                    this.applicationStarted = true;
                }
            } else {
                this.currentContent.addItem(new DefinitionItemData(DefinitionItemType.APPLICATION, atts.getValue("name"), RelatedType.FULL));
            }
        }
        if (this.parsingViews) {
            if ("formName".equals(localName)) {
                this.inViewForm = true;
                this.currentToken = new StringBuffer();
            } else if (this.inViewForm && "view".equals(localName)) {
                this.inView = true;
                this.currentView = new ViewItemData();
                this.currentView.setForm(this.currentForm);
            } else if (this.inView) {
                if ("viewName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("viewID".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("vuiType".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("characterValue".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("tag".equals(localName)) {
                    this.inTag = true;
                    this.tagBuffer = new StringBuffer();
                }
            }
        }
        if (this.parsingObjects || this.applicationStarted) {
            if ("lockBlock".equals(localName)) {
                this.inLockBlock = true;
            }
            if ("limits".equals(localName) || "audit".equals(localName) || "archive".equals(localName)) {
                this.nonFormParent = true;
            }
            if (this.inLockBlock && "object".equals(localName)) {
                String name = atts.getValue("name");
                String typeString = atts.getValue("type");
                int typeValue = Integer.parseInt(typeString);
                DefinitionItemType type = DefinitionItemType.fromConstant(typeValue -= 0x40000000);
                if (type == DefinitionItemType.CONTAINER) {
                    String subTypeString = atts.getValue("subType");
                    if (name != null && name.length() > 0) {
                        if ("1".equals(subTypeString)) {
                            type = DefinitionItemType.ACTIVE_LINK_GUIDE;
                        } else if ("2".equals(subTypeString)) {
                            type = DefinitionItemType.APPLICATION;
                        } else if ("3".equals(subTypeString)) {
                            type = DefinitionItemType.PACKING_LIST;
                        } else if ("4".equals(subTypeString)) {
                            type = DefinitionItemType.FILTER_GUIDE;
                        } else if ("5".equals(subTypeString)) {
                            type = DefinitionItemType.WEB_SERVICE;
                        }
                    }
                }
                if (type != null && name != null && name.length() > 0) {
                    DefinitionItemData item = new DefinitionItemData();
                    item.setType(type);
                    item.setName(name);
                    item.setLocked(true);
                    this.currentContent.addItem(item);
                }
            }
            if ("form".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.FORM, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("activeLink".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.ACTIVE_LINK, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("menu".equals(localName)) {
                this.currentData = new DefinitionItemData(DefinitionItemType.MENU, null, RelatedType.NONE);
                this.addName = true;
                this.inObject = true;
                this.currentContent.addItem(this.currentData);
            } else if ("filter".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.FILTER, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("escalation".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.ESCALATION, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("container".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.CONTAINER, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("image".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.IMAGE, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("association".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.ASSOCIATION, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("distributedMapping".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.DISTRIBUTED_MAPPING, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            } else if ("distributedPool".equals(localName)) {
                this.addName = true;
                this.inObject = true;
                this.currentData = new DefinitionItemData(DefinitionItemType.DISTRIBUTED_POOL, null, RelatedType.NONE);
                this.currentContent.addItem(this.currentData);
            }
            if (this.inObject) {
                if ("formName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("activeLinkName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("escalationName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("containerName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("containerType".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("imageName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("associationName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("filterName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("menuName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("distributedMappingName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("distributedPoolName".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("owner".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("lastModifiedBy".equals(localName)) {
                    this.currentToken = new StringBuffer();
                } else if ("modifiedDate".equals(localName)) {
                    this.currentToken = new StringBuffer();
                }
            }
        }
    }
}

