/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Association;
import com.bmc.arsys.api.AssociationCriteria;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.ChangeFieldAction;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationCriteria;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterCriteria;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.IndirectAssociation;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.ExpansionEvent;
import com.bmc.arsys.apiext.definition.IDefinitionListener;
import com.bmc.arsys.apiext.definition.RelatedObjects;
import com.bmc.arsys.apiext.definition.RelatedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RelatedExpander {
    private static final int DSO_FROM_FORM = 200;
    private static final int DSO_FROM_SERVER = 201;
    private static final int DSO_TO_FORM = 202;
    private static final int DSO_TO_SERVER = 203;
    private static final int REL_FIELD_RELATIONSHIP_TYPE = 751;
    private static final int REL_FIELD_ACTION_NUMBER = 752;
    private static final int REL_FIELD_OBJECT_TYPE = 753;
    private static final int REL_FIELD_OBJECT_NAME = 754;
    private static final int REL_FIELD_OBJECT_ID = 755;
    private static final int REL_FIELD_RELATED_OBJECT_TYPE = 756;
    private static final int REL_FIELD_RELATED_OBJECT_NAME = 757;
    private static final int REL_FIELD_RELATED_OBJECT_ID = 758;
    private static final int REL_FIELD_FORM_NAME = 759;
    private static final int REL_FIELD_FORM_ID = 760;
    private static final int REL_FIELD_CATEGORY = 768;
    private static final int AR_RESERV_OBJ_REL_OVERLAY_GROUP = 769;
    private ARServerUser context = null;
    private boolean relationshipsEnabled = false;
    private boolean hasRelationOverlayGroupFieldAccess = false;
    private boolean supportsImages = false;
    private final String defaultFormName = "AR System Object Relationships";
    private static final int AR_RETRIEVE_ALL_ENTRIES = 999999999;
    private final List<IDefinitionListener> listeners = new ArrayList<IDefinitionListener>();
    private static final int[] fieldList = new int[]{751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 768};
    private static final int[] MIN_SERVER_VERSION_REQD_FOR_ASSOC = new int[]{9, 0};
    private final RelatedObjects allProcessed = new RelatedObjects();
    private final RelatedObjects formsProcessed = new RelatedObjects();
    private boolean developerCacheMode = false;

    public RelatedExpander(ARServerUser context) {
        this.context = context;
        if (this.context.getServerRpcQueueNumber() != 390600) {
            try {
                this.context.useAdminRpcQueue();
            }
            catch (ARException e) {
                System.out.println("Unable to switch to admin rpc queue, results may be incorrect");
            }
        }
        this.checkRelationShipsEnabled();
        this.parseDeveloperCacheMode();
    }

    public RelatedObjects expandObject(DefinitionItemType type, String name, RelatedType relation) throws ARException {
        if (relation == RelatedType.DIRECTLY) {
            return this.expandDirectlyRelated(type, name);
        }
        if (relation == RelatedType.ALL) {
            return this.expandAllRelated(type, name);
        }
        if (relation == RelatedType.CONTENT) {
            return this.expandContentRelated(type, name);
        }
        if (relation == RelatedType.NONE) {
            RelatedObjects result = new RelatedObjects();
            HashSet<String> names = new HashSet<String>();
            names.add(name);
            result.put(type, names);
            return result;
        }
        return null;
    }

    protected RelatedObjects expandAllRelated(DefinitionItemType type, String name) throws ARException {
        if (this.allProcessed.get((Object)type) == null) {
            this.allProcessed.put(type, new HashSet());
        }
        if (!((Set)this.allProcessed.get((Object)type)).contains(name)) {
            ((Set)this.allProcessed.get((Object)type)).add(name);
            switch (type) {
                case FORM: {
                    return this.getAllRelatedForForm(name);
                }
                case ACTIVE_LINK: {
                    return this.getAllRelatedForActiveLink(name);
                }
                case ACTIVE_LINK_GUIDE: {
                    return this.getAllRelatedForActiveLinkGuide(name);
                }
                case APPLICATION: {
                    return this.getAllRelatedForApplication(name);
                }
                case CONTAINER: {
                    return this.getAllRelatedForLocalApplContainer(name);
                }
                case FILTER: {
                    return this.getAllRelatedForFilter(name);
                }
                case ESCALATION: {
                    return this.getAllRelatedForEscalation(name);
                }
                case FILTER_GUIDE: {
                    return this.getAllRelatedForFilterGuide(name);
                }
                case PACKING_LIST: {
                    return this.getAllRelatedForPackingList(name);
                }
                case MENU: {
                    return this.getAllRelatedForMenu(name);
                }
                case WEB_SERVICE: {
                    return this.getAllRelatedForWebService(name);
                }
                case IMAGE: {
                    return this.getAllRelatedForImage(name);
                }
                case ASSOCIATION: {
                    return this.getAllRelatedForAssociation(name);
                }
            }
        }
        return null;
    }

    protected RelatedObjects expandContentRelated(DefinitionItemType type, String name) throws ARException {
        switch (type) {
            case ACTIVE_LINK_GUIDE: {
                return this.getContentRelatedForActiveLinkGuide(name);
            }
            case APPLICATION: {
                return this.getContentRelatedForApplication(name);
            }
            case FILTER_GUIDE: {
                return this.getContentRelatedForFilterGuide(name);
            }
            case PACKING_LIST: {
                return this.getContentRelatedForPackingList(name);
            }
        }
        return null;
    }

    protected RelatedObjects expandDirectlyRelated(DefinitionItemType type, String name) throws ARException {
        switch (type) {
            case FORM: {
                return this.getDirectlyRelatedForForm(name);
            }
            case ACTIVE_LINK: {
                return this.getDirectlyRelatedForActiveLink(name);
            }
            case ACTIVE_LINK_GUIDE: {
                return this.getDirectlyRelatedForActiveLinkGuide(name);
            }
            case APPLICATION: {
                return this.getDirectlyRelatedForApplication(name);
            }
            case CONTAINER: {
                return this.getDirectlyRelatedForLocalApplicationContainer(name);
            }
            case FILTER: {
                return this.getDirectlyRelatedForFilter(name);
            }
            case FILTER_GUIDE: {
                return this.getDirectlyRelatedForFilterGuide(name);
            }
            case PACKING_LIST: {
                return this.getDirectlyRelatedForPackingList(name);
            }
            case ESCALATION: {
                return this.getDirectlyRelatedForEscalation(name);
            }
            case WEB_SERVICE: {
                return this.getDirectlyRelatedForWebService(name);
            }
            case MENU: {
                return this.getDirectlyRelatedForMenu(name);
            }
            case IMAGE: {
                return this.getDirectlyRelatedForImage(name);
            }
            case ASSOCIATION: {
                return this.getDirectlyRelatedForAssociation(name);
            }
        }
        return null;
    }

    protected Set<String> getFormsForType(DefinitionItemType type, String name) throws ARException {
        switch (type) {
            case FORM: {
                return this.getFormsForForm(name);
            }
            case ACTIVE_LINK: {
                return this.getFormsForActiveLink(name);
            }
            case ACTIVE_LINK_GUIDE: {
                return this.getFormsForActiveLinkGuide(name);
            }
            case APPLICATION: {
                return this.getFormsForApplication(name);
            }
            case FILTER: {
                return this.getFormsForFilter(name);
            }
            case FILTER_GUIDE: {
                return this.getFormsForFilterGuide(name);
            }
            case PACKING_LIST: {
                return this.getFormsForPackingList(name);
            }
            case ESCALATION: {
                return this.getFormsForEscalation(name);
            }
            case ASSOCIATION: {
                return this.getFormsForAssociation(name);
            }
        }
        return null;
    }

    protected Set<String> getActiveLinkGuidesForActiveLink(String name) throws ARException {
        CallGuideAction call;
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(3, name, 7, 2000);
        }
        HashSet<String> result = new HashSet<String>();
        ActiveLinkCriteria criteria = new ActiveLinkCriteria();
        criteria.setPropertiesToRetrieve(ActiveLinkCriteria.ACTION_LIST | ActiveLinkCriteria.ELSE_LIST);
        ActiveLink al = this.context.getActiveLink(name, criteria);
        if (al.getActionList() != null) {
            for (ActiveLinkAction action : al.getActionList()) {
                if (!(action instanceof CallGuideAction) || !(call = (CallGuideAction)action).getServerName().equals(this.context.getServer()) && !call.getServerName().equals("@") || result.contains(call.getGuideName())) continue;
                result.add(call.getGuideName());
            }
        }
        if (al.getElseList() != null) {
            for (ActiveLinkAction action : al.getElseList()) {
                if (!(action instanceof CallGuideAction) || !(call = (CallGuideAction)action).getServerName().equals(this.context.getServer()) && !call.getServerName().equals("@") || result.contains(call.getGuideName())) continue;
                result.add(call.getGuideName());
            }
        }
        return result;
    }

    protected Set<String> getActiveLinkGuidesForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 7, 2002);
        }
        return this.getContainersForForm(1, name);
    }

    protected Set<String> getActiveLinkGuidesForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 7, 2012);
        }
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_GUIDE, name);
    }

    protected Set<String> getActiveLinksForActiveLinkGuide(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(7, name, 3, 2000);
        }
        return this.getActiveLinksForContainer(name);
    }

    protected Set<String> getActiveLinksForApplication(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        Set<String> appALs = this.getActiveLinksForContainer(name);
        for (String al : appALs) {
            if (al == null || al.length() <= 0 || result.contains(al)) continue;
            result.add(al);
        }
        Set<String> forms = this.getFormsForApplication(name);
        for (String form : forms) {
            Set<String> formALs = this.getActiveLinksForForm(form);
            for (String al : formALs) {
                if (al == null || al.length() <= 0 || result.contains(al)) continue;
                result.add(al);
            }
        }
        return result;
    }

    protected Set<String> getActiveLinksForContainer(String name) {
        HashSet<String> result = new HashSet<String>();
        ContainerCriteria criteria = new ContainerCriteria();
        criteria.setPropertiesToRetrieve(ContainerCriteria.REFERENCES);
        try {
            Container arObject = this.context.getContainer(name, criteria);
            if (arObject.getReferences() != null) {
                for (Reference ref : arObject.getReferences()) {
                    if (ref.getReferenceType() != ReferenceType.ACTIVELINK) continue;
                    result.add(ref.getName());
                }
            }
        }
        catch (ARException e) {
            // empty catch block
        }
        return result;
    }

    protected Set<String> getActiveLinksForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 3, 500);
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.context.getListActiveLink(name));
        return result;
    }

    protected Set<String> getActiveLinksForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 3, 2008);
        }
        return this.getReferencesForPackingList(ReferenceType.ACTIVELINK, name);
    }

    protected Set<String> getApplicationsForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 10, 2014);
        }
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_APP, name);
    }

    protected Set<String> getContainersForForm(int type, String name) throws ARException {
        ContainerOwner owner = new ContainerOwner(2, name);
        ArrayList<ContainerOwner> owners = new ArrayList<ContainerOwner>();
        owners.add(owner);
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.context.getListContainer(0L, new int[]{type}, true, owners, null));
        return result;
    }

    protected RelatedObjects getContentRelatedForActiveLinkGuide(String name) throws ARException {
        this.fireExpand(DefinitionItemType.ACTIVE_LINK_GUIDE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> alGuides = new HashSet<String>();
        alGuides.add(name);
        result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, alGuides);
        Set<String> activeLinks = this.getActiveLinksForActiveLinkGuide(name);
        result.put(DefinitionItemType.ACTIVE_LINK, activeLinks);
        return result;
    }

    protected RelatedObjects getContentRelatedForApplication(String name) throws ARException {
        this.fireExpand(DefinitionItemType.APPLICATION, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> apps = new HashSet<String>();
        apps.add(name);
        result.put(DefinitionItemType.APPLICATION, apps);
        Set<String> forms = this.getFormsForApplication(name);
        result.put(DefinitionItemType.FORM, forms);
        return result;
    }

    protected RelatedObjects getContentRelatedForFilterGuide(String name) throws ARException {
        this.fireExpand(DefinitionItemType.FILTER_GUIDE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> alGuides = new HashSet<String>();
        alGuides.add(name);
        result.put(DefinitionItemType.FILTER_GUIDE, alGuides);
        Set<String> activeLinks = this.getFiltersForFilterGuide(name);
        result.put(DefinitionItemType.FILTER, activeLinks);
        return result;
    }

    protected RelatedObjects getContentRelatedForPackingList(String name) throws ARException {
        this.fireExpand(DefinitionItemType.PACKING_LIST, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> packLists = new HashSet<String>();
        packLists.add(name);
        result.put(DefinitionItemType.PACKING_LIST, packLists);
        result.put(DefinitionItemType.FORM, this.getFormsForPackingList(name));
        result.put(DefinitionItemType.ASSOCIATION, this.getAssociationsForPackingList(name));
        result.put(DefinitionItemType.ACTIVE_LINK, this.getActiveLinksForPackingList(name));
        result.put(DefinitionItemType.FILTER, this.getFiltersForPackingList(name));
        result.put(DefinitionItemType.ESCALATION, this.getEscalationsForPackingList(name));
        result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, this.getActiveLinkGuidesForPackingList(name));
        result.put(DefinitionItemType.FILTER_GUIDE, this.getFilterGuidesForPackingList(name));
        result.put(DefinitionItemType.APPLICATION, this.getApplicationsForPackingList(name));
        result.put(DefinitionItemType.IMAGE, this.getImagesForPackingList(name));
        packLists = new HashSet();
        packLists = this.getPackingListsForPackingList(name);
        result.addAll(DefinitionItemType.PACKING_LIST, packLists);
        result.put(DefinitionItemType.MENU, this.getMenusForPackingList(name));
        result.put(DefinitionItemType.GROUPS, this.getGroupsForPackingList(name));
        result.put(DefinitionItemType.DISTRIBUTED_MAPPING, this.getDistributedMappingsForPackingList(name));
        result.put(DefinitionItemType.DISTRIBUTED_POOL, this.getDistributedPoolsForPackingList(name));
        result.put(DefinitionItemType.WEB_SERVICE, this.getWebServicesForPackingList(name));
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForActiveLink(String name) throws ARException {
        this.fireExpand(DefinitionItemType.ACTIVE_LINK, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> activeLinks = new HashSet<String>();
        activeLinks.add(name);
        result.put(DefinitionItemType.ACTIVE_LINK, activeLinks);
        result.put(DefinitionItemType.MENU, new HashSet());
        HashSet<String> alMenus = new HashSet<String>();
        alMenus.addAll(this.getMenusForActiveLinks((Set)result.get((Object)DefinitionItemType.ACTIVE_LINK)));
        ((Set)result.get((Object)DefinitionItemType.MENU)).addAll(alMenus);
        Set<String> alGuides = this.getActiveLinkGuidesForActiveLink(name);
        result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.ACTIVE_LINK_GUIDE)).addAll(alGuides);
        for (String guide : alGuides) {
            if (guide == null || guide.length() <= 0) continue;
            activeLinks = this.getActiveLinksForActiveLinkGuide(guide);
            result.addAll(DefinitionItemType.ACTIVE_LINK, activeLinks);
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForActiveLinkGuide(String name) throws ARException {
        this.fireExpand(DefinitionItemType.ACTIVE_LINK_GUIDE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> alGuides = new HashSet<String>();
        alGuides.add(name);
        result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, alGuides);
        Set<String> activeLinks = this.getActiveLinksForActiveLinkGuide(name);
        result.put(DefinitionItemType.ACTIVE_LINK, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.ACTIVE_LINK)).addAll(activeLinks);
        for (String al : activeLinks) {
            if (al == null || al.length() <= 0) continue;
            RelatedObjects alObjects = this.getDirectlyRelatedForActiveLink(al);
            for (DefinitionItemType type : alObjects.keySet()) {
                result.addAll(type, (Set)alObjects.get((Object)type));
            }
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForApplication(String name) throws ARException {
        this.fireExpand(DefinitionItemType.APPLICATION, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> apps = new HashSet<String>();
        apps.add(name);
        result.put(DefinitionItemType.APPLICATION, apps);
        Set<String> forms = this.getFormsForApplication(name);
        result.put(DefinitionItemType.FORM, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.FORM)).addAll(forms);
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formObjects = this.getDirectlyRelatedForForm(form);
            for (DefinitionItemType type : formObjects.keySet()) {
                result.addAll(type, (Set)formObjects.get((Object)type));
            }
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForLocalApplicationContainer(String name) throws ARException {
        this.fireExpand(DefinitionItemType.CONTAINER, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> apps = new HashSet<String>();
        apps.add(name);
        result.put(DefinitionItemType.CONTAINER, apps);
        Set<String> forms = this.getFormsForApplication(name);
        result.put(DefinitionItemType.FORM, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.FORM)).addAll(forms);
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formObjects = this.getDirectlyRelatedForForm(form);
            for (DefinitionItemType type : formObjects.keySet()) {
                result.addAll(type, (Set)formObjects.get((Object)type));
            }
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForFilter(String name) throws ARException {
        this.fireExpand(DefinitionItemType.FILTER, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> filters = new HashSet<String>();
        filters.add(name);
        result.put(DefinitionItemType.FILTER, filters);
        Set<String> filGuides = this.getFilterGuidesForFilter(name);
        result.put(DefinitionItemType.FILTER_GUIDE, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.FILTER_GUIDE)).addAll(filGuides);
        for (String guide : filGuides) {
            if (guide == null || guide.length() <= 0) continue;
            filters = this.getFiltersForFilterGuide(guide);
            result.addAll(DefinitionItemType.FILTER, filters);
        }
        Set<String> dsoMaps = this.getDistributedMappingsForFilter(name);
        result.put(DefinitionItemType.DISTRIBUTED_MAPPING, dsoMaps);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForEscalation(String name) throws ARException {
        this.fireExpand(DefinitionItemType.ESCALATION, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> escalations = new HashSet<String>();
        escalations.add(name);
        result.put(DefinitionItemType.ESCALATION, escalations);
        Set<String> dsoMaps = this.getDistributedMappingsForEscalation(name);
        result.put(DefinitionItemType.DISTRIBUTED_MAPPING, dsoMaps);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForWebService(String name) throws ARException {
        this.fireExpand(DefinitionItemType.WEB_SERVICE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> items = new HashSet<String>();
        items.add(name);
        result.put(DefinitionItemType.WEB_SERVICE, items);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForMenu(String name) throws ARException {
        this.fireExpand(DefinitionItemType.MENU, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> items = new HashSet<String>();
        items.add(name);
        result.put(DefinitionItemType.MENU, items);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForImage(String name) throws ARException {
        this.fireExpand(DefinitionItemType.IMAGE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> items = new HashSet<String>();
        items.add(name);
        result.put(DefinitionItemType.IMAGE, items);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForAssociation(String name) throws ARException {
        this.fireExpand(DefinitionItemType.ASSOCIATION, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> items = new HashSet<String>();
        items.add(name);
        result.put(DefinitionItemType.ASSOCIATION, items);
        Set<String> forms = this.getDirectlyRelFormsForAssociation(name);
        result.put(DefinitionItemType.FORM, forms);
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForFilterGuide(String name) throws ARException {
        this.fireExpand(DefinitionItemType.FILTER_GUIDE, name, null, null);
        RelatedObjects result = new RelatedObjects();
        HashSet<String> alGuides = new HashSet<String>();
        alGuides.add(name);
        result.put(DefinitionItemType.FILTER_GUIDE, alGuides);
        Set<String> filters = this.getFiltersForFilterGuide(name);
        result.put(DefinitionItemType.FILTER, new HashSet());
        ((Set)result.get((Object)DefinitionItemType.FILTER)).addAll(filters);
        for (String al : filters) {
            if (al == null || al.length() <= 0) continue;
            RelatedObjects alObjects = this.getDirectlyRelatedForFilter(al);
            for (DefinitionItemType type : alObjects.keySet()) {
                result.addAll(type, (Set)alObjects.get((Object)type));
            }
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForForm(String name) throws ARException {
        this.fireExpand(DefinitionItemType.FORM, name, null, null);
        RelatedObjects result = new RelatedObjects();
        Set<String> forms = this.getFormsForForm(name);
        if (!forms.contains(name)) {
            forms.add(name);
        }
        result.put(DefinitionItemType.FORM, forms);
        for (String formName : forms) {
            Set<String> associations;
            Set<String> images;
            Set<String> webServices;
            Set<String> filGuides;
            Set<String> alGuides;
            Set<String> escalations;
            Set<String> filters;
            Set<String> formMenus;
            Set<String> alMenus;
            if (formName == null || formName.length() <= 0) continue;
            Set<String> activeLinks = this.getActiveLinksForForm(formName);
            if (activeLinks != null && !activeLinks.isEmpty()) {
                if (result.get((Object)DefinitionItemType.ACTIVE_LINK) == null) {
                    result.put(DefinitionItemType.ACTIVE_LINK, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.ACTIVE_LINK)).addAll(activeLinks);
            }
            if (activeLinks != null && !activeLinks.isEmpty() && (alMenus = this.getMenusForActiveLinks(activeLinks)) != null && !alMenus.isEmpty()) {
                if (result.get((Object)DefinitionItemType.MENU) == null) {
                    result.put(DefinitionItemType.MENU, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.MENU)).addAll(alMenus);
            }
            if ((formMenus = this.getMenusForForm(formName)) != null && !formMenus.isEmpty()) {
                if (result.get((Object)DefinitionItemType.MENU) == null) {
                    result.put(DefinitionItemType.MENU, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.MENU)).addAll(formMenus);
            }
            if ((filters = this.getFiltersForForm(formName)) != null && !filters.isEmpty()) {
                if (result.get((Object)DefinitionItemType.FILTER) == null) {
                    result.put(DefinitionItemType.FILTER, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.FILTER)).addAll(filters);
            }
            if ((escalations = this.getEscalationsForForm(formName)) != null && !escalations.isEmpty()) {
                if (result.get((Object)DefinitionItemType.ESCALATION) == null) {
                    result.put(DefinitionItemType.ESCALATION, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.ESCALATION)).addAll(escalations);
            }
            if ((alGuides = this.getActiveLinkGuidesForForm(formName)) != null && !alGuides.isEmpty()) {
                if (result.get((Object)DefinitionItemType.ACTIVE_LINK_GUIDE) == null) {
                    result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.ACTIVE_LINK_GUIDE)).addAll(alGuides);
            }
            if ((filGuides = this.getFilterGuidesForForm(formName)) != null && !filGuides.isEmpty()) {
                if (result.get((Object)DefinitionItemType.FILTER_GUIDE) == null) {
                    result.put(DefinitionItemType.FILTER_GUIDE, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.FILTER_GUIDE)).addAll(filGuides);
            }
            if ((webServices = this.getWebServicesForForm(formName)) != null && !webServices.isEmpty()) {
                if (result.get((Object)DefinitionItemType.WEB_SERVICE) == null) {
                    result.put(DefinitionItemType.WEB_SERVICE, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.WEB_SERVICE)).addAll(webServices);
            }
            if ((images = this.getImagesForForm(formName)) != null && !images.isEmpty()) {
                if (result.get((Object)DefinitionItemType.IMAGE) == null) {
                    result.put(DefinitionItemType.IMAGE, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.IMAGE)).addAll(images);
            }
            if (this.areAssociationsSupported() && (associations = this.getAssociationsForForm(formName)) != null && !associations.isEmpty()) {
                if (result.get((Object)DefinitionItemType.ASSOCIATION) == null) {
                    result.put(DefinitionItemType.ASSOCIATION, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.ASSOCIATION)).addAll(associations);
            }
            try {
                Set<String> dsoMaps = this.getDistributedMapsForForm(formName);
                if (dsoMaps == null || dsoMaps.isEmpty()) continue;
                if (result.get((Object)DefinitionItemType.DISTRIBUTED_MAPPING) == null) {
                    result.put(DefinitionItemType.DISTRIBUTED_MAPPING, new HashSet());
                }
                ((Set)result.get((Object)DefinitionItemType.DISTRIBUTED_MAPPING)).addAll(dsoMaps);
            }
            catch (ARException e) {}
        }
        return result;
    }

    protected RelatedObjects getDirectlyRelatedForPackingList(String name) throws ARException {
        RelatedObjects itemRelated;
        this.fireExpand(DefinitionItemType.PACKING_LIST, name, null, null);
        RelatedObjects result = this.getContentRelatedForPackingList(name);
        HashSet<String> packLists = new HashSet<String>();
        packLists.add(name);
        result.put(DefinitionItemType.PACKING_LIST, packLists);
        result.put(DefinitionItemType.FORM, this.getFormsForPackingList(name));
        result.put(DefinitionItemType.ASSOCIATION, this.getAssociationsForPackingList(name));
        result.put(DefinitionItemType.ACTIVE_LINK, this.getActiveLinksForPackingList(name));
        result.put(DefinitionItemType.FILTER, this.getFiltersForPackingList(name));
        result.put(DefinitionItemType.ESCALATION, this.getEscalationsForPackingList(name));
        result.put(DefinitionItemType.ACTIVE_LINK_GUIDE, this.getActiveLinkGuidesForPackingList(name));
        result.put(DefinitionItemType.FILTER_GUIDE, this.getFilterGuidesForPackingList(name));
        result.put(DefinitionItemType.APPLICATION, this.getApplicationsForPackingList(name));
        result.put(DefinitionItemType.IMAGE, this.getImagesForPackingList(name));
        packLists = new HashSet();
        packLists = this.getPackingListsForPackingList(name);
        result.addAll(DefinitionItemType.PACKING_LIST, packLists);
        result.put(DefinitionItemType.MENU, this.getMenusForPackingList(name));
        result.put(DefinitionItemType.GROUPS, this.getGroupsForPackingList(name));
        result.put(DefinitionItemType.DISTRIBUTED_MAPPING, this.getDistributedMappingsForPackingList(name));
        result.put(DefinitionItemType.DISTRIBUTED_POOL, this.getDistributedPoolsForPackingList(name));
        result.put(DefinitionItemType.WEB_SERVICE, this.getWebServicesForPackingList(name));
        ArrayList<RelatedObjects> relatedList = new ArrayList<RelatedObjects>();
        HashSet itemNames = new HashSet();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.FORM));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForForm(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.ASSOCIATION));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForAssociation(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.ACTIVE_LINK));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForActiveLink(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.ACTIVE_LINK_GUIDE));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForActiveLinkGuide(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.APPLICATION));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForApplication(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.FILTER));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForFilter(itemName);
            relatedList.add(itemRelated);
        }
        itemNames.clear();
        itemNames.addAll((Collection)result.get((Object)DefinitionItemType.FILTER_GUIDE));
        for (String itemName : itemNames) {
            if (itemName == null || itemName.length() <= 0) continue;
            itemRelated = this.getDirectlyRelatedForFilterGuide(itemName);
            relatedList.add(itemRelated);
        }
        return result;
    }

    protected Set<String> getDistributedMappingsForFilter(String name) throws ARException {
        Set<String> dsoMaps;
        RunProcessAction process;
        HashSet<String> result = new HashSet<String>();
        FilterCriteria criteria = new FilterCriteria();
        criteria.setPropertiesToRetrieve(FilterCriteria.ACTION_LIST | FilterCriteria.ELSE_LIST);
        Filter fil = this.context.getFilter(name, criteria);
        if (fil.getActionList() != null) {
            for (FilterAction action : fil.getActionList()) {
                if (!(action instanceof RunProcessAction) || (process = (RunProcessAction)action).getCommandLine() == null || process.getCommandLine().length() <= 0 || (dsoMaps = this.getDSOMapsFromRunProcess(process.getCommandLine())) == null || dsoMaps.isEmpty()) continue;
                result.addAll(dsoMaps);
            }
        }
        if (fil.getElseList() != null) {
            for (FilterAction action : fil.getElseList()) {
                if (!(action instanceof RunProcessAction) || (process = (RunProcessAction)action).getCommandLine() == null || process.getCommandLine().length() <= 0 || (dsoMaps = this.getDSOMapsFromRunProcess(process.getCommandLine())) == null || dsoMaps.isEmpty()) continue;
                result.addAll(dsoMaps);
            }
        }
        return result;
    }

    protected Set<String> getDistributedMappingsForEscalation(String name) throws ARException {
        Set<String> dsoMaps;
        RunProcessAction process;
        HashSet<String> result = new HashSet<String>();
        EscalationCriteria criteria = new EscalationCriteria();
        criteria.setPropertiesToRetrieve(EscalationCriteria.ACTION_LIST | EscalationCriteria.ELSE_LIST);
        Escalation fil = this.context.getEscalation(name, criteria);
        if (fil.getActionList() != null) {
            for (FilterAction action : fil.getActionList()) {
                if (!(action instanceof RunProcessAction) || (process = (RunProcessAction)action).getCommandLine() == null || process.getCommandLine().length() <= 0 || (dsoMaps = this.getDSOMapsFromRunProcess(process.getCommandLine())) == null || dsoMaps.isEmpty()) continue;
                result.addAll(dsoMaps);
            }
        }
        if (fil.getElseList() != null) {
            for (FilterAction action : fil.getElseList()) {
                if (!(action instanceof RunProcessAction) || (process = (RunProcessAction)action).getCommandLine() == null || process.getCommandLine().length() <= 0 || (dsoMaps = this.getDSOMapsFromRunProcess(process.getCommandLine())) == null || dsoMaps.isEmpty()) continue;
                result.addAll(dsoMaps);
            }
        }
        return result;
    }

    protected Set<String> getDistributedMappingsForPackingList(String name) throws ARException {
        return this.getReferencesForPackingList(ReferenceType.DISTMAPPING_DATA, name);
    }

    protected Set<String> getDistributedMapsForForm(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        String formName = "Distributed Mapping";
        int[] infoRequest = new int[]{42, 43};
        ServerInfoMap serverInfo = this.context.getServerInfo(infoRequest);
        if (serverInfo != null) {
            Object value = ((Value)serverInfo.get((Object)42)).getValue();
            if (value == null || value != null && ((String)value).length() == 0) {
                return result;
            }
            value = ((Value)serverInfo.get((Object)43)).getValue();
            formName = value != null ? value.toString() : "Distributed Mapping";
        }
        if (formName != null) {
            Value dsoName;
            Entry entry;
            ArithmeticOrRelationalOperand fromLeft = new ArithmeticOrRelationalOperand(200);
            ArithmeticOrRelationalOperand fromRight = new ArithmeticOrRelationalOperand(new Value(name));
            QualifierInfo fromQual = new QualifierInfo(new RelationalOperationInfo(1, fromLeft, fromRight));
            ArithmeticOrRelationalOperand toLeft = new ArithmeticOrRelationalOperand(202);
            ArithmeticOrRelationalOperand toRight = new ArithmeticOrRelationalOperand(new Value(name));
            QualifierInfo toQual = new QualifierInfo(new RelationalOperationInfo(1, fromLeft, fromRight));
            QualifierInfo qualInfo = new QualifierInfo(2, fromQual, toQual);
            List entries = this.context.getListEntry(formName, qualInfo, 0, 1, null, null, false, null);
            if (entries != null && entries.size() > 0 && (entry = this.context.getEntry(formName, ((EntryListInfo)entries.get(0)).getEntryID(), null)) != null && !entry.isEmpty() && (dsoName = (Value)entry.get((Object)CoreFieldId.ShortDescription)) != null && dsoName.getDataType() != DataType.NULL && dsoName.getValue() != null && dsoName.getValue().toString().length() > 0) {
                String toForm;
                Value toFormValue;
                String toServer;
                Value toServerValue;
                String fromForm;
                Value fromFormValue;
                String fromServer;
                Value fromServerValue = (Value)entry.get((Object)201);
                if (fromServerValue != null && fromServerValue.getDataType() != DataType.NULL && ((fromServer = (String)fromServerValue.getValue()).equals(this.context.getServer()) || fromServer.equals("@")) && (fromFormValue = (Value)entry.get((Object)200)) != null && fromFormValue.getDataType() != DataType.NULL && (fromForm = (String)fromFormValue.getValue()) != null && fromForm.length() > 0 && fromForm.equals(name) && !result.contains(dsoName.getValue().toString())) {
                    result.add(dsoName.getValue().toString());
                }
                if ((toServerValue = (Value)entry.get((Object)203)) != null && toServerValue.getDataType() != DataType.NULL && ((toServer = (String)toServerValue.getValue()).equals(this.context.getServer()) || toServer.equals("@")) && (toFormValue = (Value)entry.get((Object)202)) != null && toFormValue.getDataType() != DataType.NULL && (toForm = (String)toFormValue.getValue()) != null && toForm.length() > 0 && toForm.equals(name) && !result.contains(dsoName.getValue().toString())) {
                    result.add(dsoName.getValue().toString());
                }
            }
        }
        return result;
    }

    protected Set<String> getDistributedPoolsForPackingList(String name) throws ARException {
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_DSOPOOL, name);
    }

    protected Set<String> getDSOMapsFromRunProcess(String commandLine) {
        HashSet<String> result = new HashSet<String>();
        String[] sections = commandLine.split(" ");
        for (int i = 0; i < sections.length; ++i) {
            String value = sections[i];
            if (!value.equals("-m") || i >= sections.length + 1) continue;
            result.add(sections[i++]);
            return result;
        }
        return result;
    }

    protected Set<String> getEscalationsForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 5, 506);
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.context.getListEscalation(name));
        return result;
    }

    protected Set<String> getEscalationsForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 5, 2010);
        }
        return this.getReferencesForPackingList(ReferenceType.ESCALATION, name);
    }

    protected Set<String> getFilterGuidesForFilter(String name) throws ARException {
        CallGuideAction call;
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(4, name, 8, 2001);
        }
        HashSet<String> result = new HashSet<String>();
        FilterCriteria criteria = new FilterCriteria();
        criteria.setPropertiesToRetrieve(FilterCriteria.ACTION_LIST | FilterCriteria.ELSE_LIST);
        Filter fil = this.context.getFilter(name, criteria);
        if (fil.getActionList() != null) {
            for (FilterAction action : fil.getActionList()) {
                if (!(action instanceof CallGuideAction) || !(call = (CallGuideAction)action).getServerName().equals(this.context.getServer()) && !call.getServerName().equals("@") || result.contains(call.getGuideName())) continue;
                result.add(call.getGuideName());
            }
        }
        if (fil.getElseList() != null) {
            for (FilterAction action : fil.getElseList()) {
                if (!(action instanceof CallGuideAction) || !(call = (CallGuideAction)action).getServerName().equals(this.context.getServer()) && !call.getServerName().equals("@") || result.contains(call.getGuideName())) continue;
                result.add(call.getGuideName());
            }
        }
        return result;
    }

    protected Set<String> getFilterGuidesForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 8, 2003);
        }
        return this.getContainersForForm(4, name);
    }

    protected Set<String> getFilterGuidesForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 8, 2013);
        }
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_FILTER_GUIDE, name);
    }

    protected Set<String> getFiltersForContainer(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        ContainerCriteria criteria = new ContainerCriteria();
        criteria.setPropertiesToRetrieve(ContainerCriteria.REFERENCES);
        try {
            Container arObject = this.context.getContainer(name, criteria);
            if (arObject.getReferences() != null) {
                for (Reference ref : arObject.getReferences()) {
                    if (ref.getReferenceType() != ReferenceType.FILTER) continue;
                    result.add(ref.getName());
                }
            }
        }
        catch (ARException e) {
            // empty catch block
        }
        return result;
    }

    protected Set<String> getFiltersForFilterGuide(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(8, name, 4, 2001);
        }
        return this.getFiltersForContainer(name);
    }

    protected Set<String> getFiltersForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 4, 503);
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.context.getListFilter(name));
        return result;
    }

    protected Set<String> getFiltersForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 4, 2009);
        }
        return this.getReferencesForPackingList(ReferenceType.FILTER, name);
    }

    protected Set<String> getImagesForPackingList(String name) throws ARException {
        if (this.supportsImages) {
            if (this.relationshipsEnabled) {
                return this.getRelatedNames(11, name, 12, 2016);
            }
            return this.getReferencesForPackingList(ReferenceType.IMAGE, name);
        }
        return new HashSet<String>();
    }

    protected Set<String> getImagesForForm(String name) throws ARException {
        if (this.supportsImages) {
            if (this.relationshipsEnabled) {
                return this.getInverseRelatedNames(1, name, 12, 511);
            }
            HashSet<String> result = new HashSet<String>();
            List images = this.context.getListImageObjects(name);
            for (Image image : images) {
                result.add(image.getName());
            }
            return result;
        }
        return new HashSet<String>();
    }

    protected Set<String> getFormsForImage(String name) throws ARException {
        if (this.supportsImages && this.relationshipsEnabled) {
            return this.getRelatedNames(1, name, 12, 511);
        }
        return new HashSet<String>();
    }

    protected Set<String> getAssociationsForForm(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        List assocList = this.context.getListAssociationObjects(null);
        if (assocList != null && assocList.size() > 0) {
            for (Association assoc : assocList) {
                if ((assoc.getAssociationType() != 2 || !name.equals(((IndirectAssociation)assoc).getAssociationFormName())) && !name.equals(assoc.getSecondaryFormName())) continue;
                result.add(assoc.getName());
            }
        }
        return result;
    }

    protected Set<String> getAssociationsForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 14, 2022);
        }
        return this.getReferencesForPackingList(ReferenceType.ASSOCIATION, name);
    }

    protected Set<String> getFormsForActiveLink(String activeLinkName) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(3, activeLinkName, 1, 500);
        }
        HashSet<String> result = new HashSet<String>();
        ActiveLinkCriteria criteria = new ActiveLinkCriteria();
        criteria.setPropertiesToRetrieve(ActiveLinkCriteria.WORKFLOW_CONNECT);
        ActiveLink arObject = this.context.getActiveLink(activeLinkName, criteria);
        if (arObject.getFormList() != null) {
            result.addAll(arObject.getFormList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRelatedNames(int objectType, String objectName, int relatedType, int relationship) throws ARException {
        HashSet<String> result = new HashSet<String>();
        QualifierInfo overlayGroupInfo = this.getRelationOverlayGruopQualifier();
        QualifierInfo nameInfo = this.getNameQualifier(objectName, 754);
        QualifierInfo typeInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(753), new ArithmeticOrRelationalOperand(new Value(objectType))));
        QualifierInfo relatedTypeInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(756), new ArithmeticOrRelationalOperand(new Value(relatedType))));
        QualifierInfo relationInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(751), new ArithmeticOrRelationalOperand(new Value(relationship))));
        QualifierInfo objectQual = new QualifierInfo(1, nameInfo, typeInfo);
        QualifierInfo relationQual = new QualifierInfo(1, relatedTypeInfo, relationInfo);
        QualifierInfo qualification = new QualifierInfo(1, objectQual, relationQual);
        if (this.hasRelationOverlayGroupFieldAccess) {
            qualification = new QualifierInfo(1, overlayGroupInfo, qualification);
        }
        List entries = null;
        try {
            if (!this.developerCacheMode) {
                this.context.useDefaultRpcQueue();
            }
            entries = this.context.getListEntryObjects(this.getFormName(), qualification, 0, 999999999, null, new int[]{757}, false, null);
        }
        finally {
            if (!this.developerCacheMode) {
                this.context.useAdminRpcQueue();
            }
        }
        if (entries != null && !entries.isEmpty()) {
            for (Entry entry : entries) {
                Value value = (Value)entry.get((Object)757);
                if (value == null || !value.getDataType().equals((Object)DataType.CHAR) || value.toString().length() <= 0) continue;
                result.add(value.toString());
            }
        }
        return result;
    }

    private QualifierInfo getNameQualifier(String objectName, int relField) {
        String overlayGroup = this.context.getOverlayGroup();
        String overlayObjectName = "";
        QualifierInfo nameInfo = null;
        boolean isBaseMode = overlayGroup.equals("-1");
        if (!isBaseMode && this.hasRelationOverlayGroupFieldAccess) {
            overlayObjectName = objectName + "__o";
            QualifierInfo nameInfo1 = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(relField), new ArithmeticOrRelationalOperand(new Value(objectName))));
            QualifierInfo nameInfo2 = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(relField), new ArithmeticOrRelationalOperand(new Value(overlayObjectName))));
            nameInfo = new QualifierInfo(2, nameInfo1, nameInfo2);
        } else {
            nameInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(relField), new ArithmeticOrRelationalOperand(new Value(objectName))));
        }
        return nameInfo;
    }

    private QualifierInfo getRelationOverlayGruopQualifier() {
        if (this.hasRelationOverlayGroupFieldAccess) {
            String overlayGroup = this.context.getOverlayGroup();
            boolean isBaseMode = overlayGroup.equals("-1");
            ArithmeticOrRelationalOperand left = new ArithmeticOrRelationalOperand(769);
            ArithmeticOrRelationalOperand right = new ArithmeticOrRelationalOperand(new Value("-1"));
            QualifierInfo unmodifiedQual = new QualifierInfo(new RelationalOperationInfo(1, left, right));
            left = new ArithmeticOrRelationalOperand(769);
            right = new ArithmeticOrRelationalOperand(new Value(isBaseMode ? "0" : overlayGroup));
            QualifierInfo overlaidOrCustomQual = new QualifierInfo(new RelationalOperationInfo(1, left, right));
            QualifierInfo finalQual = new QualifierInfo(2, unmodifiedQual, overlaidOrCustomQual);
            return finalQual;
        }
        return null;
    }

    private String getFormName() {
        return "AR System Object Relationships";
    }

    private void parseDeveloperCacheMode() {
        try {
            ServerInfoMap devCacheModeResult = this.context.getServerInfo(new int[]{208});
            if (devCacheModeResult != null && devCacheModeResult.size() > 0 && ((Value)devCacheModeResult.get((Object)208)).getValue() != null) {
                Integer cacheMode = (Integer)((Value)devCacheModeResult.get((Object)208)).getValue();
                this.developerCacheMode = cacheMode == 1;
            }
        }
        catch (Exception ex) {
            this.developerCacheMode = false;
        }
    }

    protected Set<String> getFormsForActiveLinkGuide(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(7, name, 1, 2002);
        }
        return this.getFormsForContainer(name, true);
    }

    protected Set<String> getFormsForApplication(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(10, name, 1, 2004);
        }
        return this.getFormsForContainer(name, false);
    }

    protected Set<String> getFormsForContainer(String name, boolean includeOwner) throws ARException {
        HashSet<String> result = new HashSet<String>();
        ContainerCriteria criteria = new ContainerCriteria();
        if (includeOwner) {
            criteria.setPropertiesToRetrieve(ContainerCriteria.REFERENCES | ContainerCriteria.CONTAINER_OWNER);
        } else {
            criteria.setPropertiesToRetrieve(ContainerCriteria.REFERENCES);
        }
        try {
            Container arObject = this.context.getContainer(name, criteria);
            if (includeOwner && arObject.getContainerOwner() != null) {
                for (ContainerOwner owner : arObject.getContainerOwner()) {
                    if (owner.getType() != 2) continue;
                    result.add(owner.getName());
                }
            }
            if (arObject.getReferences() != null) {
                for (Reference ref : arObject.getReferences()) {
                    if (ref.getReferenceType() != ReferenceType.SCHEMA) continue;
                    result.add(ref.getName());
                }
            }
        }
        catch (ARException e) {
            // empty catch block
        }
        return result;
    }

    protected Set<String> getFormsForDSOMap(String name) throws ARException {
        Entry entry;
        ArithmeticOrRelationalOperand right;
        ArithmeticOrRelationalOperand left;
        QualifierInfo qualInfo;
        List entries;
        HashSet<String> result = new HashSet<String>();
        String formName = "Distributed Mapping";
        int[] infoRequest = new int[2];
        infoRequest[0] = 43;
        ServerInfoMap serverInfo = this.context.getServerInfo(infoRequest);
        if (serverInfo != null) {
            Object value = ((Value)serverInfo.get((Object)43)).getValue();
            formName = value != null ? value.toString() : "Distributed Mapping";
        }
        if (formName != null && (entries = this.context.getListEntry(formName, qualInfo = new QualifierInfo(new RelationalOperationInfo(1, left = new ArithmeticOrRelationalOperand(CoreFieldId.ShortDescription.getFieldId()), right = new ArithmeticOrRelationalOperand(new Value(name)))), 0, 1, null, null, false, null)) != null && entries.size() > 0 && (entry = this.context.getEntry(formName, ((EntryListInfo)entries.get(0)).getEntryID(), null)) != null && !entry.isEmpty()) {
            String toForm;
            Value toFormValue;
            String toServer;
            Value toServerValue;
            String fromForm;
            Value fromFormValue;
            String fromServer;
            Value fromServerValue = (Value)entry.get((Object)201);
            if (fromServerValue != null && fromServerValue.getDataType() != DataType.NULL && ((fromServer = (String)fromServerValue.getValue()).equals(this.context.getServer()) || fromServer.equals("@")) && (fromFormValue = (Value)entry.get((Object)200)) != null && fromFormValue.getDataType() != DataType.NULL && (fromForm = (String)fromFormValue.getValue()) != null && fromForm.length() > 0) {
                result.add(fromForm);
            }
            if ((toServerValue = (Value)entry.get((Object)203)) != null && toServerValue.getDataType() != DataType.NULL && ((toServer = (String)toServerValue.getValue()).equals(this.context.getServer()) || toServer.equals("@")) && (toFormValue = (Value)entry.get((Object)202)) != null && toFormValue.getDataType() != DataType.NULL && (toForm = (String)toFormValue.getValue()) != null && toForm.length() > 0) {
                result.add(toForm);
            }
        }
        return result;
    }

    protected Set<String> getFormsForEscalation(String escalationName) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(5, escalationName, 1, 506);
        }
        HashSet<String> result = new HashSet<String>();
        EscalationCriteria criteria = new EscalationCriteria();
        criteria.setPropertiesToRetrieve(EscalationCriteria.WORKFLOW_CONNECT);
        Escalation arObject = this.context.getEscalation(escalationName, criteria);
        if (arObject.getFormList() != null) {
            result.addAll(arObject.getFormList());
        }
        return result;
    }

    protected Set<String> getFormsForFilter(String filterName) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(4, filterName, 1, 503);
        }
        HashSet<String> result = new HashSet<String>();
        FilterCriteria criteria = new FilterCriteria();
        criteria.setPropertiesToRetrieve(FilterCriteria.WORKFLOW_CONNECT | FilterCriteria.ERROR_FILTER_NAME | FilterCriteria.ERROR_FILTER_OPT);
        Filter arObject = this.context.getFilter(filterName, criteria);
        if (arObject.getFormList() != null) {
            String secondaryForm;
            Filter errorFilter;
            String errorHandler;
            result.addAll(arObject.getFormList());
            if (arObject.getErrorFilterOptions() > 0 && (errorHandler = arObject.getErrorHandlingFilter()) != null && errorHandler.length() > 0 && (errorFilter = this.context.getFilter(errorHandler, criteria)) != null && errorFilter.getFormList() != null && errorFilter.getFormList().size() > 1 && (secondaryForm = (String)errorFilter.getFormList().get(1)) != null && !result.contains(secondaryForm)) {
                result.add(secondaryForm);
            }
        }
        return result;
    }

    protected Set<String> getFormsForFilterGuide(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(8, name, 1, 2003);
        }
        return this.getFormsForContainer(name, true);
    }

    protected Set<String> getFormsForForm(String formName) throws ARException {
        HashSet<String> result = new HashSet<String>();
        Form form = this.context.getForm(formName);
        if (form instanceof JoinForm) {
            JoinForm join = (JoinForm)form;
            result.add(join.getMemberA());
            result.add(join.getMemberB());
            Set<String> memberAForms = this.getFormsForForm(join.getMemberA());
            result.addAll(memberAForms);
            Set<String> memberBForms = this.getFormsForForm(join.getMemberB());
            result.addAll(memberBForms);
        }
        if (form.getArchiveInfo() != null && (form.getArchiveInfo().getArchiveType() & 1) == 1) {
            result.add(form.getArchiveInfo().getArchiveDest());
        }
        if (form.getAuditInfo() != null && form.getAuditInfo().getAuditStyle() != 0 && form.getAuditInfo().getAuditStyle() != 3) {
            result.add(form.getAuditInfo().getAuditForm());
        }
        return result;
    }

    protected Set<String> getFormsForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 1, 2007);
        }
        return this.getReferencesForPackingList(ReferenceType.SCHEMA, name);
    }

    protected Set<String> getFormsForWebService(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(13, name, 1, 2018);
        }
        return this.getFormsForContainer(name, true);
    }

    protected Set<String> getFormsForAssociation(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        AssociationCriteria criteria = new AssociationCriteria();
        criteria.setPropertiesToRetrieve(AssociationCriteria.FORMS);
        Association arObject = this.context.getAssociation(name, criteria);
        String formName = null;
        formName = arObject.getAssociationType() == 2 ? ((IndirectAssociation)arObject).getAssociationFormName() : arObject.getSecondaryFormName();
        if (formName != null && formName.trim().length() > 0) {
            result.add(formName);
        }
        return result;
    }

    protected Set<String> getDirectlyRelFormsForAssociation(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        AssociationCriteria criteria = new AssociationCriteria();
        criteria.setPropertiesToRetrieve(AssociationCriteria.FORMS);
        Association assocObject = this.context.getAssociation(name, criteria);
        if (assocObject != null) {
            if (assocObject.getAssociationType() == 2) {
                result.add(((IndirectAssociation)assocObject).getAssociationFormName());
            } else {
                result.add(assocObject.getSecondaryFormName());
            }
        }
        return result;
    }

    protected Set<String> getAllFormsForAssociation(String name) throws ARException {
        HashSet<String> result = new HashSet<String>();
        if (this.relationshipsEnabled) {
            result.addAll(this.getRelatedNames(14, name, 1, 1500));
            result.addAll(this.getRelatedNames(14, name, 1, 1501));
            result.addAll(this.getRelatedNames(14, name, 1, 1502));
        } else {
            AssociationCriteria criteria = new AssociationCriteria();
            criteria.setPropertiesToRetrieve(AssociationCriteria.FORMS);
            Association assocObject = this.context.getAssociation(name, criteria);
            if (assocObject != null) {
                result.add(assocObject.getPrimaryFormName());
                result.add(assocObject.getSecondaryFormName());
                if (assocObject.getAssociationType() == 2) {
                    result.add(((IndirectAssociation)assocObject).getAssociationFormName());
                }
            }
        }
        return result;
    }

    protected Set<String> getGroupsForPackingList(String name) throws ARException {
        return this.getReferencesForPackingList(ReferenceType.GROUP_DATA, name);
    }

    protected Set<String> getMenusForActiveLinks(Set<String> names) throws ARException {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> nameList = new ArrayList<String>(names.size());
        nameList.addAll(names);
        result.addAll(this.context.getListMenu(0L, null, nameList));
        if (result == null) {
            result = new HashSet();
        }
        ActiveLinkCriteria criteria = new ActiveLinkCriteria();
        criteria.setPropertiesToRetrieve(ActiveLinkCriteria.ACTION_LIST | ActiveLinkCriteria.ELSE_LIST);
        List als = this.context.getListActiveLinkObjects(nameList, criteria);
        for (ActiveLink al : als) {
            ChangeFieldAction call;
            if (al.getActionList() != null) {
                for (ActiveLinkAction action : al.getActionList()) {
                    if (!(action instanceof ChangeFieldAction) || (call = (ChangeFieldAction)action).getCharMenu() == null || result.contains(call.getCharMenu())) continue;
                    result.add(call.getCharMenu());
                }
            }
            if (al.getElseList() == null) continue;
            for (ActiveLinkAction action : al.getElseList()) {
                if (!(action instanceof ChangeFieldAction) || (call = (ChangeFieldAction)action).getCharMenu() == null || result.contains(call.getCharMenu())) continue;
                result.add(call.getCharMenu());
            }
        }
        return result;
    }

    protected Set<String> getMenusForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 6, 1003);
        }
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> forms = new ArrayList<String>();
        forms.add(name);
        result = new HashSet();
        result.addAll(this.context.getListMenu(0L, forms, null));
        MenuCriteria criteria = new MenuCriteria();
        criteria.setPropertiesToRetrieve(ObjectBaseCriteria.NAME | MenuCriteria.MENU_DEFINITION);
        List menus = this.context.getListMenuObjects(0L, null, null, criteria);
        block5: for (Menu menu : menus) {
            switch (menu.getMenuType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    QueryMenu qm = (QueryMenu)menu;
                    if (!name.equals(qm.getForm()) || result.contains(menu.getName())) break;
                    result.add(menu.getName());
                    break;
                }
                case 6: {
                    if (!(menu instanceof FieldDataDictionaryMenu)) break;
                    FieldDataDictionaryMenu dm = (FieldDataDictionaryMenu)menu;
                    if (!name.equals(dm.getForm()) || result.contains(menu.getName())) continue block5;
                    result.add(menu.getName());
                    break;
                }
            }
        }
        return result;
    }

    protected Set<String> getMenusForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getRelatedNames(11, name, 6, 2011);
        }
        return this.getReferencesForPackingList(ReferenceType.CHAR_MENU, name);
    }

    protected Set<String> getPackingListsForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(11, name, 11, 2015);
        }
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_PACK, name);
    }

    protected Set<String> getReferencesForPackingList(ReferenceType type, String name) throws ARException {
        HashSet<String> result;
        block5: {
            result = new HashSet<String>();
            ContainerCriteria criteria = new ContainerCriteria();
            criteria.setPropertiesToRetrieve(ContainerCriteria.REFERENCES);
            Container arObject = this.context.getContainer(name, criteria);
            if (arObject.getReferences() == null) break block5;
            if (type == ReferenceType.PACKINGLIST_APP || type == ReferenceType.PACKINGLIST_FILTER_GUIDE || type == ReferenceType.PACKINGLIST_GUIDE || type == ReferenceType.PACKINGLIST_PACK || type == ReferenceType.PACKINGLIST_WEBSERVICE || type == ReferenceType.PACKINGLIST_DSOPOOL) {
                ReferenceType previousReference = null;
                for (Reference ref : arObject.getReferences()) {
                    if (ReferenceType.CONTAINER == ref.getReferenceType() && previousReference == type) {
                        result.add(ref.getName());
                    }
                    previousReference = ref.getReferenceType();
                }
            } else {
                for (Reference ref : arObject.getReferences()) {
                    if (ref.getReferenceType() != type) continue;
                    result.add(ref.getName());
                }
            }
        }
        return result;
    }

    protected Set<String> getWebServicesForForm(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(1, name, 13, 2018);
        }
        return this.getContainersForForm(5, name);
    }

    protected Set<String> getWebServicesForPackingList(String name) throws ARException {
        if (this.relationshipsEnabled) {
            return this.getInverseRelatedNames(11, name, 13, 2017);
        }
        return this.getReferencesForPackingList(ReferenceType.PACKINGLIST_WEBSERVICE, name);
    }

    protected RelatedObjects getAllRelatedForForm(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForForm(name);
        RelatedObjects related = new RelatedObjects();
        for (DefinitionItemType type : result.keySet()) {
            Set itemNames = (Set)result.get((Object)type);
            if (itemNames == null || itemNames.size() <= 0) continue;
            for (String itemName : itemNames) {
                if (itemName == null || itemName.length() <= 0) continue;
                RelatedObjects itemRelated = this.expandAllRelated(type, itemName);
                related.addAll(itemRelated);
            }
        }
        result.addAll(related);
        return result;
    }

    protected RelatedObjects getAllRelatedForActiveLink(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForActiveLink(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForActiveLink(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForActiveLinkGuide(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForActiveLinkGuide(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForActiveLinkGuide(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForApplication(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForApplication(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll((Collection)result.get((Object)DefinitionItemType.FORM));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForLocalApplContainer(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForLocalApplicationContainer(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll((Collection)result.get((Object)DefinitionItemType.FORM));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForFilter(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForFilter(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForFilter(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForEscalation(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForEscalation(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForEscalation(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForWebService(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForWebService(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForWebService(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForMenu(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForMenu(name);
        return result;
    }

    protected RelatedObjects getAllRelatedForImage(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForImage(name);
        return result;
    }

    protected RelatedObjects getAllRelatedForAssociation(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForAssociation(name);
        result.put(DefinitionItemType.FORM, this.getAllFormsForAssociation(name));
        HashSet<String> forms = new HashSet<String>();
        forms.addAll((Collection)result.get((Object)DefinitionItemType.FORM));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    private void processRelatedForms(RelatedObjects result, Set<String> forms) throws ARException {
        HashSet<String> relatedForms = new HashSet<String>();
        for (DefinitionItemType type : result.keySet()) {
            Set itemNames;
            if (this.formsProcessed.get((Object)type) == null) {
                this.formsProcessed.put(type, new HashSet());
            }
            if ((itemNames = (Set)result.get((Object)type)) == null || itemNames.size() <= 0) continue;
            for (String itemName : itemNames) {
                if (itemName == null || itemName.length() <= 0 || ((Set)this.formsProcessed.get((Object)type)).contains(itemName)) continue;
                Set<String> formResult = this.getFormsForType(type, itemName);
                ((Set)this.formsProcessed.get((Object)type)).add(itemName);
                if (formResult == null) continue;
                relatedForms.addAll(formResult);
            }
        }
        for (String form : relatedForms) {
            if (form == null || form.length() <= 0 || forms.contains(form)) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
    }

    protected RelatedObjects getAllRelatedForFilterGuide(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForFilterGuide(name);
        HashSet<String> forms = new HashSet<String>();
        forms.addAll(this.getFormsForFilterGuide(name));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    protected RelatedObjects getAllRelatedForPackingList(String name) throws ARException {
        RelatedObjects result = this.getDirectlyRelatedForPackingList(name);
        HashSet packingLists = new HashSet();
        packingLists.addAll((Collection)result.get((Object)DefinitionItemType.PACKING_LIST));
        for (String listName : packingLists) {
            if (listName == null || listName.length() <= 0 || listName.equals(name)) continue;
            RelatedObjects listRelated = this.getDirectlyRelatedForForm(listName);
            result.addAll(listRelated);
        }
        HashSet<String> forms = new HashSet<String>();
        forms.addAll((Collection)result.get((Object)DefinitionItemType.FORM));
        for (String form : forms) {
            if (form == null || form.length() <= 0) continue;
            RelatedObjects formRelated = this.getDirectlyRelatedForForm(form);
            result.addAll(formRelated);
        }
        this.processRelatedForms(result, forms);
        return result;
    }

    private void fireExpand(DefinitionItemType type, String name, String itemName, RelatedType related) {
        for (IDefinitionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.event(new ExpansionEvent(type, name, related));
        }
    }

    public void addListener(IDefinitionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IDefinitionListener listener) {
        this.listeners.remove(listener);
    }

    private void checkRelationShipsEnabled() {
        block12: {
            try {
                int majorVersion = 0;
                int minorVersion = 0;
                int dotVersion = 0;
                ServerInfoMap result = this.context.getServerInfo(new int[]{4});
                if (((Value)result.get((Object)4)).getValue() != null) {
                    String[] parts = ((Value)result.get((Object)4)).getValue().toString().split(" ");
                    String[] versionParts = parts[0].split("\\.");
                    if (versionParts.length >= 1) {
                        majorVersion = Integer.parseInt(versionParts[0]);
                    }
                    if (versionParts.length >= 2) {
                        minorVersion = Integer.parseInt(versionParts[1]);
                    }
                    if (versionParts.length >= 3) {
                        dotVersion = Integer.parseInt(versionParts[2]);
                    }
                }
                if (majorVersion < 7 || majorVersion == 7 && minorVersion < 5) {
                    this.relationshipsEnabled = false;
                    this.supportsImages = false;
                    return;
                }
                this.supportsImages = true;
                result = this.context.getServerInfo(new int[]{281});
                if (((Value)result.get((Object)281)).getValue() == null) break block12;
                int licInfo = (Integer)((Value)result.get((Object)281)).getValue();
                this.relationshipsEnabled = licInfo == 1;
                Field field = null;
                try {
                    field = this.context.getField(this.getFormName(), 769);
                    if (this.relationshipsEnabled) {
                        this.hasRelationOverlayGroupFieldAccess = true;
                    }
                }
                catch (ARException e) {
                    if (field == null) {
                        if (this.relationshipsEnabled && (majorVersion > 7 || majorVersion == 7 && minorVersion > 6 || majorVersion == 7 && minorVersion == 6 && dotVersion >= 4)) {
                            this.relationshipsEnabled = false;
                        }
                        break block12;
                    }
                    this.relationshipsEnabled = false;
                }
            }
            catch (ARException e) {
                this.relationshipsEnabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getInverseRelatedNames(int objectType, String objectName, int relatedType, int relationship) throws ARException {
        QualifierInfo qualInfo1;
        QualifierInfo relationInfo1;
        QualifierInfo nameInfo1;
        HashSet<String> result = new HashSet<String>();
        QualifierInfo overlayGroupInfo = this.getRelationOverlayGruopQualifier();
        QualifierInfo nameInfo = this.getNameQualifier(objectName, 757);
        QualifierInfo typeInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(756), new ArithmeticOrRelationalOperand(new Value(objectType))));
        QualifierInfo relatedTypeInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(753), new ArithmeticOrRelationalOperand(new Value(relatedType))));
        QualifierInfo relationInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(751), new ArithmeticOrRelationalOperand(new Value(relationship))));
        QualifierInfo objectQual = new QualifierInfo(1, nameInfo, typeInfo);
        QualifierInfo relationQual = new QualifierInfo(1, relatedTypeInfo, relationInfo);
        QualifierInfo qualification = new QualifierInfo(1, objectQual, relationQual);
        QualifierInfo qualInfoFinal = null;
        if (objectType == 1 && relatedType == 12) {
            nameInfo1 = this.getNameQualifier(objectName, 759);
            relationInfo1 = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(751), new ArithmeticOrRelationalOperand(new Value(510))));
            qualInfo1 = new QualifierInfo(1, nameInfo1, relationInfo1);
            qualInfoFinal = new QualifierInfo(2, qualification, qualInfo1);
        }
        if (objectType == 1 && relatedType == 6) {
            nameInfo1 = this.getNameQualifier(objectName, 759);
            relationInfo1 = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(751), new ArithmeticOrRelationalOperand(new Value(1004))));
            qualInfo1 = new QualifierInfo(1, nameInfo1, relationInfo1);
            qualInfoFinal = new QualifierInfo(2, qualification, qualInfo1);
        }
        if (this.hasRelationOverlayGroupFieldAccess) {
            if (qualInfoFinal != null) {
                qualInfoFinal = new QualifierInfo(1, overlayGroupInfo, qualInfoFinal);
            } else {
                qualification = new QualifierInfo(1, overlayGroupInfo, qualification);
            }
        }
        List entries = null;
        try {
            if (!this.developerCacheMode) {
                this.context.useDefaultRpcQueue();
            }
            entries = this.context.getListEntryObjects(this.getFormName(), qualInfoFinal != null ? qualInfoFinal : qualification, 0, 999999999, null, new int[]{754}, false, null);
        }
        finally {
            if (!this.developerCacheMode) {
                this.context.useAdminRpcQueue();
            }
        }
        if (entries != null && !entries.isEmpty()) {
            for (Entry entry : entries) {
                Value value = (Value)entry.get((Object)754);
                if (value == null || !value.getDataType().equals((Object)DataType.CHAR) || value.toString().length() <= 0) continue;
                String[] nodes = value.toString().split("\\__o");
                result.add(nodes[0]);
            }
        }
        return result;
    }

    protected boolean isRelationshipsEnabled() {
        return this.relationshipsEnabled;
    }

    protected void setRelationshipsEnabled(boolean relationshipsEnabled) {
        this.relationshipsEnabled = relationshipsEnabled;
    }

    private boolean areAssociationsSupported() {
        int svrMajorVersion = this.context.getServerVersionMajor();
        int svrMinorVersion = this.context.getServerVersionMinor();
        boolean areAssociationsSupported = svrMajorVersion >= MIN_SERVER_VERSION_REQD_FOR_ASSOC[0] && svrMinorVersion >= MIN_SERVER_VERSION_REQD_FOR_ASSOC[1];
        return areAssociationsSupported;
    }
}

