/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.FileContent;
import com.bmc.arsys.apiext.definition.IFileParser;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.Util;
import com.bmc.arsys.apiext.definition.ViewItemData;
import java.io.BufferedReader;
import java.io.IOException;

public class DefinitionFileParser
implements IFileParser {
    boolean abort = false;

    public boolean isAbort() {
        return this.abort;
    }

    @Override
    public FileContent parseApplications(String fileName) throws DefinitionException, IOException {
        FileContent result = new FileContent();
        BufferedReader fileReader = Util.openFile(fileName, null);
        String line = null;
        int lineNumber = 0;
        String appName = null;
        try {
            while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                ++lineNumber;
                if (!line.startsWith("begin application")) continue;
                line = fileReader.readLine();
                appName = this.getName(line);
                result.addItem(new DefinitionItemData(DefinitionItemType.APPLICATION, appName, RelatedType.FULL));
            }
        }
        catch (Exception e) {
            throw new DefinitionException("Error encountered while parsing definition file for content", e.getCause());
        }
        finally {
            fileReader.close();
        }
        return result;
    }

    @Override
    public FileContent parseObjectsInApplication(String fileName, String applicationName) throws DefinitionException, IOException {
        FileContent result = new FileContent();
        BufferedReader fileReader = Util.openFile(fileName, null);
        String line = null;
        int lineNumber = 0;
        String appName = null;
        boolean applicationStarted = false;
        try {
            while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                ++lineNumber;
                if (this.isAbort()) {
                    break;
                }
                if (line.startsWith("begin application")) {
                    if (applicationStarted) {
                        break;
                    }
                    line = fileReader.readLine();
                    appName = this.getName(line);
                    if (appName.equals(applicationName)) {
                        applicationStarted = true;
                    }
                }
                if (!applicationStarted) continue;
                this.processLine(line, fileReader, result);
            }
        }
        catch (Exception e) {
            throw new DefinitionException("Error encountered while parsing definition file for content", e.getCause());
        }
        finally {
            fileReader.close();
        }
        for (DefinitionItemType type : result.keySet()) {
            if (!type.equals((Object)DefinitionItemType.APPLICATION)) continue;
            result.remove((Object)type);
            break;
        }
        return result;
    }

    @Override
    public FileContent parseObjects(String fileName) throws DefinitionException, IOException {
        FileContent result = new FileContent();
        BufferedReader fileReader = Util.openFile(fileName, null);
        String line = null;
        int lineNumber = 0;
        try {
            while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                ++lineNumber;
                this.processLine(line, fileReader, result);
            }
        }
        catch (Exception e) {
            throw new DefinitionException("Error encountered while parsing definition file for content", e.getCause());
        }
        finally {
            fileReader.close();
        }
        return result;
    }

    private void processLine(String line, BufferedReader fileReader, FileContent result) throws DefinitionException, IOException {
        if (line.startsWith("begin schema data")) {
            line = fileReader.readLine();
            String name = this.getName(line);
            if (name != null) {
                result.addItem(new DefinitionItemData(DefinitionItemType.FORM_DATA, name, RelatedType.NONE));
            }
        } else if (line.startsWith("begin schema")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.FORM, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin active link")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.ACTIVE_LINK, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin char menu")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.MENU, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin container")) {
            DefinitionItemData item = null;
            if ((item = this.extractContainerStructInfo(fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin image")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.IMAGE, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin association")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.ASSOCIATION, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin distributed mapping")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.DISTRIBUTED_MAPPING, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin filter")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.FILTER, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin escalation")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.ESCALATION, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin distributed pool")) {
            DefinitionItemData item = null;
            if ((item = this.extractGenericStructInfo(DefinitionItemType.DISTRIBUTED_POOL, fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin lock block")) {
            StringBuffer nameBuffer = new StringBuffer();
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("  struct-item-list: ")) {
                    nameBuffer.append(line.replace("  struct-item-list: ", ""));
                    fileReader.mark(0);
                    continue;
                }
                try {
                    fileReader.reset();
                }
                catch (IOException io) {
                    // empty catch block
                }
                this.parseLockedBlockContent(nameBuffer, result);
                break;
            }
        } else if (line.startsWith("begin Data Visualization Definition") || line.startsWith("begin Data Visulaization Definition")) {
            DefinitionItemData item = null;
            if ((item = this.extractDataVisualizationStructInfo(fileReader, item)) != null) {
                result.addItem(item);
            }
        } else if (line.startsWith("begin Flashboards") || line.startsWith("begin Flashboards")) {
            DefinitionItemData item = null;
            if ((item = this.extractFlashboardStructInfo(fileReader, item)) != null) {
                result.addItem(item);
            }
        }
    }

    private DefinitionItemData extractFlashboardStructInfo(BufferedReader fileReader, DefinitionItemData item) throws IOException {
        String line;
        boolean structEndFound = false;
        String name = null;
        while ((line = fileReader.readLine()) != null && !this.isAbort()) {
            if (line.startsWith("   name           : ")) {
                name = this.getName(line);
                continue;
            }
            if (!line.startsWith("end")) continue;
            structEndFound = true;
            break;
        }
        if (name != null) {
            item = new DefinitionItemData(DefinitionItemType.FLASHBOARD, name, RelatedType.NONE);
        }
        if (item.getType() != null) {
            return item;
        }
        return null;
    }

    private DefinitionItemData extractDataVisualizationStructInfo(BufferedReader fileReader, DefinitionItemData item) throws IOException {
        String line;
        boolean structEndFound = false;
        String name = null;
        String module = null;
        String subType = null;
        while ((line = fileReader.readLine()) != null && !this.isAbort()) {
            if (line.startsWith("   name           : ")) {
                name = this.getName(line);
                continue;
            }
            if (line.startsWith("   module         : ")) {
                module = this.getModule(line);
                continue;
            }
            if (line.startsWith("   subtype        : ")) {
                subType = this.getSubType(line);
                continue;
            }
            if (!line.startsWith("end")) continue;
            structEndFound = true;
            break;
        }
        if (name != null && module != null && subType != null && "Flashboard".equals(module)) {
            if ("FLASHBOARD".equals(subType)) {
                item = new DefinitionItemData(DefinitionItemType.FLASHBOARD, name, RelatedType.NONE);
            } else if ("VARIABLE".equals(subType)) {
                item = new DefinitionItemData(DefinitionItemType.FLASHBOARD_VARIABLE, name, RelatedType.NONE);
            } else if ("ALARM".equals(subType)) {
                item = new DefinitionItemData(DefinitionItemType.FLASHBOARD_ALARM, name, RelatedType.NONE);
            }
        }
        if (item.getType() != null) {
            return item;
        }
        return null;
    }

    private DefinitionItemData extractContainerStructInfo(BufferedReader fileReader, DefinitionItemData item) throws IOException {
        String line;
        boolean nameFound = false;
        boolean structEndFound = false;
        while ((line = fileReader.readLine()) != null && !this.isAbort()) {
            if (line.startsWith("   name           : ")) {
                nameFound = true;
                break;
            }
            if (!line.startsWith("end")) continue;
            structEndFound = true;
            break;
        }
        String name = null;
        if (nameFound) {
            name = this.getName(line);
        }
        if (name != null) {
            Object type = null;
            item = new DefinitionItemData(null, name, RelatedType.NONE);
            if (!structEndFound) {
                structEndFound = false;
                block8: while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                    if (item.getType() == null && line.startsWith("   type           : ")) {
                        String parseSection = line.substring("   type           : ".length());
                        int typeInt = Integer.parseInt(parseSection);
                        switch (typeInt) {
                            case 2: {
                                item.setType(DefinitionItemType.APPLICATION);
                                continue block8;
                            }
                            case 4: {
                                item.setType(DefinitionItemType.FILTER_GUIDE);
                                continue block8;
                            }
                            case 1: {
                                item.setType(DefinitionItemType.ACTIVE_LINK_GUIDE);
                                continue block8;
                            }
                            case 3: {
                                item.setType(DefinitionItemType.PACKING_LIST);
                                continue block8;
                            }
                            case 5: {
                                item.setType(DefinitionItemType.WEB_SERVICE);
                                continue block8;
                            }
                        }
                        type = null;
                        continue;
                    }
                    if (line.startsWith("   timestamp      : ")) {
                        item.setTimestamp(this.getTimestamp(line));
                        continue;
                    }
                    if (line.startsWith("   owner          : ")) {
                        item.setOwner(this.getOwner(line));
                        continue;
                    }
                    if (line.startsWith("   last-changed   : ")) {
                        item.setLastChanged(this.getLastChanged(line));
                        continue;
                    }
                    if (!line.startsWith("end")) continue;
                    structEndFound = true;
                    break;
                }
            }
        }
        if (item.getType() != null) {
            return item;
        }
        return null;
    }

    private DefinitionItemData extractGenericStructInfo(DefinitionItemType definitionItemType, BufferedReader fileReader, DefinitionItemData item) throws IOException {
        String line;
        boolean nameFound = false;
        boolean structEndFound = false;
        while ((line = fileReader.readLine()) != null && !this.isAbort()) {
            if (line.startsWith("   name           : ")) {
                nameFound = true;
                break;
            }
            if (!line.startsWith("end")) continue;
            structEndFound = true;
            break;
        }
        String name = null;
        if (nameFound) {
            name = this.getName(line);
        }
        if (name != null) {
            item = new DefinitionItemData(definitionItemType, name, RelatedType.NONE);
            if (!structEndFound) {
                structEndFound = false;
                while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                    if (line.startsWith("   timestamp      : ")) {
                        item.setTimestamp(this.getTimestamp(line));
                        continue;
                    }
                    if (line.startsWith("   owner          : ")) {
                        item.setOwner(this.getOwner(line));
                        continue;
                    }
                    if (line.startsWith("   last-changed   : ")) {
                        item.setLastChanged(this.getLastChanged(line));
                        continue;
                    }
                    if (!line.startsWith("end")) continue;
                    structEndFound = true;
                    break;
                }
            }
        }
        return item;
    }

    @Override
    public FileContent parseViews(String fileName) throws DefinitionException, IOException {
        FileContent result = new FileContent();
        BufferedReader fileReader = Util.openFile(fileName, null);
        String line = null;
        int lineNumber = 0;
        String formName = null;
        try {
            while ((line = fileReader.readLine()) != null && !this.isAbort()) {
                ++lineNumber;
                if (line.startsWith("begin vui")) {
                    line = fileReader.readLine();
                    formName = line.substring("   name           : ".length());
                    continue;
                }
                if (line.startsWith("vui  {") && formName != null) {
                    String idString = fileReader.readLine();
                    ++lineNumber;
                    String nameString = fileReader.readLine();
                    ++lineNumber;
                    String labelString = fileReader.readLine();
                    ++lineNumber;
                    String timestampString = fileReader.readLine();
                    ++lineNumber;
                    String localeString = fileReader.readLine();
                    ++lineNumber;
                    String typeString = fileReader.readLine();
                    ++lineNumber;
                    if (formName == null) continue;
                    ViewItemData view = new ViewItemData();
                    view.setName(this.getName(nameString));
                    view.setForm(formName);
                    if (labelString.startsWith("   label          : ")) {
                        view.setLabel(labelString.replace("   label          : ", ""));
                    }
                    if (localeString.startsWith("   vui-locale     : ")) {
                        view.setLocale(localeString.replace("   vui-locale     : ", ""));
                    }
                    if (typeString.startsWith("   vui-type       : ")) {
                        view.setVuiType(Integer.parseInt(typeString.replace("   vui-type       : ", "")));
                    }
                    if (idString.startsWith("   id             : ")) {
                        view.setViewId(Integer.parseInt(idString.replace("   id             : ", "")));
                    }
                    result.addItem(view);
                    continue;
                }
                if (!line.startsWith("end")) continue;
                formName = null;
            }
        }
        catch (Exception e) {
            throw new DefinitionException("Error encountered while parsing definition file for content", e.getCause());
        }
        finally {
            fileReader.close();
        }
        return result;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    private String getLastChanged(String line) {
        String name = null;
        if (line.startsWith("   last-changed   : ")) {
            name = line.replace("   last-changed   : ", "");
        }
        return name;
    }

    private String getModule(String line) {
        String name = null;
        if (line.startsWith("   module         : ")) {
            name = line.replace("   module         : ", "");
        }
        return name;
    }

    private String getName(String line) {
        String name = null;
        if (line.startsWith("   name           : ")) {
            name = line.replace("   name           : ", "");
        }
        return name;
    }

    private String getOwner(String line) {
        String name = null;
        if (line.startsWith("   owner          : ")) {
            name = line.replace("   owner          : ", "");
        }
        return name;
    }

    private String getSubType(String line) {
        String name = null;
        if (line.startsWith("   subtype        : ")) {
            name = line.replace("   subtype        : ", "");
        }
        return name;
    }

    private Timestamp getTimestamp(String line) {
        String value;
        if (line.startsWith("   timestamp      : ") && (value = line.replace("   timestamp      : ", "")) != null) {
            try {
                return new Timestamp(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private void parseLockedBlockContent(StringBuffer block, FileContent content) {
        int index;
        if (block != null && block.length() > 0 && (index = block.indexOf("\\")) > -1) {
            block.delete(0, index + 1);
            index = block.indexOf("\\");
            while (index != -1) {
                int type = Integer.parseInt(block.substring(0, index));
                int subType = -1;
                block.delete(0, index + 1);
                if (type == 12) {
                    index = block.indexOf("\\");
                    if (index == -1) break;
                    subType = Integer.parseInt(block.substring(0, index));
                    block.delete(0, index + 1);
                }
                if ((index = block.indexOf("\\")) == -1) break;
                block.delete(0, index + 1);
                int nameBlockIndex = block.indexOf("\\");
                String name = block.substring(0, nameBlockIndex);
                block.delete(0, nameBlockIndex + 1);
                DefinitionItemType defType = DefinitionItemType.fromConstant(type);
                if (defType == DefinitionItemType.CONTAINER) {
                    switch (subType) {
                        case 1: {
                            defType = DefinitionItemType.ACTIVE_LINK_GUIDE;
                            break;
                        }
                        case 2: {
                            defType = DefinitionItemType.APPLICATION;
                            break;
                        }
                        case 3: {
                            defType = DefinitionItemType.PACKING_LIST;
                            break;
                        }
                        case 4: {
                            defType = DefinitionItemType.FILTER_GUIDE;
                            break;
                        }
                        case 5: {
                            defType = DefinitionItemType.WEB_SERVICE;
                            break;
                        }
                        default: {
                            defType = null;
                        }
                    }
                }
                if (defType != null) {
                    DefinitionItemData data = new DefinitionItemData(defType, name, RelatedType.NONE);
                    data.setLocked(true);
                    content.addItem(data);
                }
                index = block.indexOf("\\");
            }
        }
    }
}

