/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportOptions;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class KeywordExpander {
    private final ImportOptions options;
    private String databaseInfo = null;
    private String lastId = "";

    public KeywordExpander(ImportOptions options) {
        this.options = options;
    }

    public String expandKeyword(Object keyword, FormInformation formInfo, FieldInformation fieldInfo) throws ARException {
        if (keyword instanceof Integer) {
            return null;
        }
        if (keyword instanceof Keyword) {
            if (keyword == Keyword.AR_KEYWORD_CLIENT_TYPE) {
                return this.expandCLIENT_TYPE();
            }
            if (keyword == Keyword.AR_KEYWORD_DATABASE) {
                return this.expandDATABASE();
            }
            if (keyword == Keyword.AR_KEYWORD_DATE_ONLY) {
                return this.expandDATE_ONLY();
            }
            if (keyword == Keyword.AR_KEYWORD_DEFAULT) {
                return this.expandDEFAULT(fieldInfo);
            }
            if (keyword == Keyword.AR_KEYWORD_FIELDID) {
                return this.expandFIELDID(fieldInfo);
            }
            if (keyword == Keyword.AR_KEYWORD_FIELDNAME) {
                return this.expandFIELDNAME(fieldInfo);
            }
            if (keyword == Keyword.AR_KEYWORD_GROUPS) {
                return this.expandGROUPS();
            }
            if (keyword == Keyword.AR_KEYWORD_HARDWARE) {
                return this.expandHARDWARE();
            }
            if (keyword == Keyword.AR_KEYWORD_INBULKTRANS) {
                return this.expandINBULKTRANS();
            }
            if (keyword == Keyword.AR_KEYWORD_LASTCOUNT) {
                return this.expandLASTCOUNT();
            }
            if (keyword == Keyword.AR_KEYWORD_LASTID) {
                return this.expandLASTID();
            }
            if (keyword == Keyword.AR_KEYWORD_LOCALE) {
                return this.expandLOCALE();
            }
            if (keyword == Keyword.AR_KEYWORD_OPERATION) {
                return this.expandOPERATION();
            }
            if (keyword == Keyword.AR_KEYWORD_OS) {
                return this.expandOS();
            }
            if (keyword == Keyword.AR_KEYWORD_SCHEMA) {
                return this.expandSCHEMA(formInfo);
            }
            if (keyword == Keyword.AR_KEYWORD_SERVER) {
                return this.expandSERVER();
            }
            if (keyword == Keyword.AR_KEYWORD_SERVERTIMESTAMP) {
                return this.expandSERVERTIMESTAMP();
            }
            if (keyword == Keyword.AR_KEYWORD_TIME_ONLY) {
                return this.expandTIME_ONLY();
            }
            if (keyword == Keyword.AR_KEYWORD_TIMESTAMP) {
                return this.expandTIMESTAMP();
            }
            if (keyword == Keyword.AR_KEYWORD_USER) {
                return this.expandUSER();
            }
            if (keyword == Keyword.AR_KEYWORD_WEEKDAY) {
                return this.expandWEEKDAY();
            }
            if (keyword == Keyword.AR_KEYWORD_VERSION) {
                return this.expandVERSION();
            }
            return KeywordInfo.fromKeyword((Keyword)keyword).getStringValue();
        }
        if (keyword instanceof String) {
            if (keyword.equals("$NULL$")) {
                return null;
            }
            return this.expandKeyword(KeywordInfo.fromString((String)keyword).getKeyword(), formInfo, fieldInfo);
        }
        return null;
    }

    private String expandVERSION() {
        return "9.0 build001";
    }

    private String expandUSER() {
        return this.options.getContext().getUser();
    }

    private String expandTIMESTAMP() {
        if (this.options.getDataOptions().getDateTimeFormat() != null && this.options.getDataOptions().getDateTimeFormat().length() > 0) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat(this.options.getDataOptions().getDateTimeFormat());
            return simpleFormat.format(new Date());
        }
        DateFormat formatter = DateFormat.getDateTimeInstance();
        return formatter.format(new Date());
    }

    private String expandTIME_ONLY() {
        if (this.options.getDataOptions().getTimeFormat() != null && this.options.getDataOptions().getTimeFormat().length() > 0) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat(this.options.getDataOptions().getTimeFormat());
            return simpleFormat.format(new Date());
        }
        DateFormat formatter = DateFormat.getTimeInstance();
        return formatter.format(new Date());
    }

    private String expandDATE_ONLY() {
        if (this.options.getDataOptions().getDateFormat() != null && this.options.getDataOptions().getDateFormat().length() > 0) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat(this.options.getDataOptions().getDateFormat());
            return simpleFormat.format(new Date());
        }
        DateFormat formatter = DateFormat.getDateInstance();
        return formatter.format(new Date());
    }

    private String expandSCHEMA(FormInformation formInfo) {
        return formInfo.getName();
    }

    private String expandSERVER() {
        return this.options.getContext().getServer();
    }

    private String expandWEEKDAY() {
        String[] dayNames = new DateFormatSymbols().getWeekdays();
        Calendar date = Calendar.getInstance();
        return dayNames[date.get(7)];
    }

    private String expandGROUPS() throws ARException {
        List groupInfo = this.options.getContext().getListGroup(this.options.getContext().getUser(), this.options.getContext().getPassword());
        StringBuffer result = new StringBuffer();
        for (GroupInfo info : groupInfo) {
            result.append(info.getName());
            result.append(" ");
        }
        return result.toString();
    }

    private String expandOPERATION() {
        return "MERGE";
    }

    private String expandDATABASE() throws ARException {
        ServerInfoMap result;
        if (this.databaseInfo == null && (result = this.options.getContext().getServerInfo(new int[]{1})) != null && result.size() > 0) {
            this.databaseInfo = ((Value)result.get((Object)1)).getValue().toString();
        }
        return this.databaseInfo;
    }

    private String expandLASTID() {
        return this.lastId;
    }

    private String expandLASTCOUNT() {
        return KeywordInfo.LASTCOUNT.getStringValue();
    }

    private String expandLOCALE() {
        return this.options.getContext().getLocale();
    }

    private String expandINBULKTRANS() {
        return KeywordInfo.INBULKTRANS.getStringValue();
    }

    private String expandCLIENT_TYPE() {
        return Integer.toString(19);
    }

    private String expandFIELDID(FieldInformation fieldInfo) {
        return Integer.toString(fieldInfo.getFieldId());
    }

    private String expandFIELDNAME(FieldInformation fieldInfo) {
        return fieldInfo.getName();
    }

    private String expandHARDWARE() {
        return System.getProperty("os.arch");
    }

    private String expandOS() {
        return System.getProperty("os.name");
    }

    private String expandSERVERTIMESTAMP() throws ARException {
        if (this.options.getDataOptions().getDateTimeFormat() != null && this.options.getDataOptions().getDateTimeFormat().length() > 0) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat(this.options.getDataOptions().getDateTimeFormat());
            return simpleFormat.format(new Date());
        }
        DateFormat formatter = DateFormat.getDateTimeInstance();
        return formatter.format(new Date());
    }

    private String expandDEFAULT(FieldInformation fieldInfo) {
        return null;
    }

    public String expandAllKeywords(String token, FormInformation targetForm, FieldInformation targetField) throws ARException {
        String with;
        String result = token;
        for (KeywordInfo info : KeywordInfo.values()) {
            if (!result.contains(info.getStringValue())) continue;
            String replace = this.createRegEx(info);
            with = this.expandKeyword(info.getKeyword(), targetForm, targetField);
            result = result.replaceAll(replace, with);
        }
        result = result.replace("$--1$", "");
        for (KeywordInfo info : KeywordInfo.values()) {
            String keywordConstant;
            if (info.getKeyword() == null || !result.contains(keywordConstant = "$-" + info.getKeyword().toInt() + '$')) continue;
            with = this.expandKeyword(info.getKeyword(), targetForm, targetField);
            result = result.replace(keywordConstant, with);
        }
        return result;
    }

    private String createRegEx(KeywordInfo info) {
        String keyword = info.getStringValue();
        return keyword.replace("$", "\\$");
    }

    protected String getLastId() {
        return this.lastId;
    }

    protected void setLastId(String lastId) {
        this.lastId = lastId;
    }

    public static enum KeywordInfo {
        NULL(null, "$NULL$", true),
        DEFAULT(Keyword.AR_KEYWORD_DEFAULT, "$DEFAULT$", true),
        USER(Keyword.AR_KEYWORD_USER, "$USER$", true),
        TIMESTAMP(Keyword.AR_KEYWORD_TIMESTAMP, "$TIMESTAMP$", true),
        TIME_ONLY(Keyword.AR_KEYWORD_TIME_ONLY, "$TIME", true),
        DATE_ONLY(Keyword.AR_KEYWORD_DATE_ONLY, "$DATE$", true),
        SCHEMA(Keyword.AR_KEYWORD_SCHEMA, "$SCHEMA$", true),
        SERVER(Keyword.AR_KEYWORD_SERVER, "$SERVER$", true),
        WEEKDAY(Keyword.AR_KEYWORD_WEEKDAY, "$WEEKDAY$", true),
        GROUPS(Keyword.AR_KEYWORD_GROUPS, "$GROUPS$", true),
        OPERATION(Keyword.AR_KEYWORD_OPERATION, "$OPERATION$", true),
        HARDWARE(Keyword.AR_KEYWORD_HARDWARE, "$HARDWARE$", true),
        OS(Keyword.AR_KEYWORD_OS, "$OS$", true),
        DATABASE(Keyword.AR_KEYWORD_DATABASE, "$DATABASE$", true),
        LASTID(Keyword.AR_KEYWORD_LASTID, "$LASTID$", true),
        LASTCOUNT(Keyword.AR_KEYWORD_LASTCOUNT, "$LASTCOUNT$", true),
        VERSION(Keyword.AR_KEYWORD_VERSION, "$VERSION$", true),
        VUI(Keyword.AR_KEYWORD_VUI, "$VUI$", false),
        GUIDETEXT(Keyword.AR_KEYWORD_GUIDETEXT, "$GUIDETEXT$", false),
        FIELDHELP(Keyword.AR_KEYWORD_FIELDHELP, "$FIELDHELP$", false),
        GUIDE(Keyword.AR_KEYWORD_GUIDE, "$GUIDE$", false),
        APPLICATION(Keyword.AR_KEYWORD_APPLICATION, "$APPLICATION$", false),
        LOCALE(Keyword.AR_KEYWORD_LOCALE, "$LOCALE$", true),
        CLIENT_TYPE(Keyword.AR_KEYWORD_CLIENT_TYPE, "$CLIENT_TYPE$", true),
        SCHEMA_ALIAS(Keyword.AR_KEYWORD_SCHEMA_ALIAS, "$SCHEMA_ALIAS$", false),
        ROWSELECTED(Keyword.AR_KEYWORD_ROWSELECTED, "$ROWSELECTED$", false),
        ROWCHANGED(Keyword.AR_KEYWORD_ROWCHANGED, "$ROWCHANGED$", false),
        BROWSER(Keyword.AR_KEYWORD_BROWSER, "$BROWSER$", false),
        VUI_TYPE(Keyword.AR_KEYWORD_VUI_TYPE, "$VUI_TYPE$", false),
        TCPPORT(Keyword.AR_KEYWORD_TCPPORT, "$TCPPORT$", false),
        HOMEURL(Keyword.AR_KEYWORD_HOMEURL, "$HOMEURL$", false),
        ROLES(Keyword.AR_KEYWORD_ROLES, "$ROLES$", false),
        EVENTTYPE(Keyword.AR_KEYWORD_EVENTTYPE, "$EVENTTYPE$", false),
        EVENTSRCWINID(Keyword.AR_KEYWORD_EVENTSRCWINID, "$EVENTSRCWINID$", false),
        CURRENTWINID(Keyword.AR_KEYWORD_CURRENTWINID, "$CURRENTWINID$", false),
        LASTOPENEDWINID(Keyword.AR_KEYWORD_LASTOPENEDWINID, "$LASTOPENEDWINID$", false),
        INBULKTRANS(Keyword.AR_KEYWORD_INBULKTRANS, "$INBULKTRANS$", true),
        FIELDID(Keyword.AR_KEYWORD_FIELDID, "$FIELDID$", true),
        FIELDNAME(Keyword.AR_KEYWORD_FIELDNAME, "$FIELDNAME$", true),
        FIELDLABEL(Keyword.AR_KEYWORD_FIELDLABEL, "$FIELDLABEL$", false),
        SERVERTIMESTAMP(Keyword.AR_KEYWORD_SERVERTIMESTAMP, "$SERVERTIMESTAMP$", true),
        GROUPIDS(Keyword.AR_KEYWORD_GROUPIDS, "$GROUPIDS$", false),
        EVENTDATA(Keyword.AR_KEYWORD_EVENTDATA, "$EVENTDATA$", false),
        ERRNO(Keyword.AR_KEYWORD_ERRNO, "$ERRNO$", false),
        ERRMSG(Keyword.AR_KEYWORD_ERRMSG, "$ERRMSG$", false),
        ERRAPPENDMSG(Keyword.AR_KEYWORD_ERRAPPENDMSG, "$ERRAPPENDMSG$", false),
        INCLIENTTRANSACTION(Keyword.AR_KEYWORD_INCLNTMANAGEDTRANS, "$INCLIENTTRANSACTION$", false),
        NO(Keyword.AR_KEYWORD_NO, "$NO$", false);

        private final Keyword keyword;
        private final String stringValue;
        private final boolean expansionSupported;

        private KeywordInfo(Keyword keyword, String stringValue, boolean expansionSupported) {
            this.keyword = keyword;
            this.stringValue = stringValue;
            this.expansionSupported = expansionSupported;
        }

        public boolean isExpansionSupported() {
            return this.expansionSupported;
        }

        public Keyword getKeyword() {
            return this.keyword;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public static KeywordInfo fromString(String value) {
            for (KeywordInfo info : KeywordInfo.values()) {
                if (!value.equals(info.getStringValue())) continue;
                return info;
            }
            return NULL;
        }

        public static KeywordInfo fromKeyword(Keyword value) {
            for (KeywordInfo info : KeywordInfo.values()) {
                if (!value.equals((Object)info.getKeyword())) continue;
                return info;
            }
            return NULL;
        }
    }
}

