/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FileOptions;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportResults;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.UserAlertListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ImportOptions {
    private ARServerUser context = null;
    private String overlayGroup = null;
    private FileOptions fileOptions = new FileOptions();
    private SourceType sourceType = SourceType.NONE;
    private DataOptions dataOptions = new DataOptions();
    private ArrayList<String> fileList = new ArrayList();
    private String filePattern = null;
    private boolean isMultiThreaded = false;
    private Map<String, FormInformation> serverForms = new HashMap<String, FormInformation>();
    private Map<String, FormInformation> fileForms = new HashMap<String, FormInformation>();
    private String logFile = null;
    private boolean importAllDataSets = true;
    private final Map<String, Map<String, MappingOptions>> formMappingOptions = new HashMap<String, Map<String, MappingOptions>>();
    private final Map<String, String> formMap = new HashMap<String, String>();
    private boolean fromARM = false;
    private final boolean logCreated = false;
    private final ImportResults results = new ImportResults();
    private Level logLevel = Level.INFO;
    private UserAlertListener userAlertListener = null;
    private LinkedHashMap<String, Logger> loggersList = new LinkedHashMap();
    private boolean isConsoleAppenderOff = false;

    public LinkedHashMap<String, Logger> getLoggersList() {
        return this.loggersList;
    }

    public void setLogersList(LinkedHashMap<String, Logger> logersList) {
        this.loggersList = logersList;
    }

    public String getOverlayGroup() {
        return this.overlayGroup;
    }

    public void setOverlayGroup(String overlayGroup) {
        this.overlayGroup = overlayGroup;
    }

    public ArrayList<String> getFileList() {
        return this.fileList;
    }

    public void setFileList(ArrayList<String> fileList) {
        this.fileList = fileList;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public boolean isMultiThreaded() {
        return this.isMultiThreaded;
    }

    public void setMultiThreaded(boolean isMultiThreaded) {
        this.isMultiThreaded = isMultiThreaded;
    }

    public UserAlertListener getUserAlertListener() {
        return this.userAlertListener;
    }

    public void setUserAlertListener(UserAlertListener userAlertListener) {
        this.userAlertListener = userAlertListener;
    }

    public ARServerUser getContext() {
        if (this.context == null) {
            this.context = new ARServerUser();
            this.context.setLocale(Locale.getDefault().toString());
        }
        return this.context;
    }

    public void setContext(ARServerUser context) {
        this.context = context;
    }

    public DataOptions getDataOptions() {
        return this.dataOptions;
    }

    public void setDataOptions(DataOptions dataOptions) {
        this.dataOptions = dataOptions;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public Map<String, FormInformation> getFileForms() {
        return this.fileForms;
    }

    public void setFileForms(Map<String, FormInformation> fileForms) {
        this.fileForms = fileForms;
    }

    public Map<String, FormInformation> getServerForms() {
        return this.serverForms;
    }

    public void setServerForms(Map<String, FormInformation> serverForms) {
        this.serverForms = serverForms;
    }

    public FileOptions getFileOptions() {
        return this.fileOptions;
    }

    public void setFileOptions(FileOptions fileOptions) {
        this.fileOptions = fileOptions;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void addFileForm(String formName) {
        FormInformation formInfo = this.fileForms.get(formName);
        if (formInfo == null) {
            formInfo = new FormInformation();
            formInfo.setName(formName);
            this.fileForms.put(formName, formInfo);
        }
    }

    public void addServerForm(FormInformation formInfo) {
        this.serverForms.put(formInfo.getName(), formInfo);
    }

    public void addFileForm(FormInformation formInfo) {
        this.fileForms.put(formInfo.getName(), formInfo);
    }

    public FormInformation getFirstFileForm() {
        if (this.fileForms == null || this.fileForms.isEmpty()) {
            return null;
        }
        for (FormInformation formInfo : this.fileForms.values()) {
            if (formInfo == null) continue;
            return formInfo;
        }
        return null;
    }

    public FormInformation getFirstServerForm() {
        if (this.serverForms == null || this.serverForms.isEmpty()) {
            return null;
        }
        for (FormInformation formInfo : this.serverForms.values()) {
            if (formInfo == null) continue;
            return formInfo;
        }
        return null;
    }

    public MappingOptions getMappingOptions(String sourceName, String targetName) {
        Map<String, MappingOptions> target = this.formMappingOptions.get(sourceName);
        if (target != null) {
            return target.get(targetName);
        }
        return null;
    }

    public Map<String, MappingOptions> getMappingOptions(String sourceName) {
        return this.formMappingOptions.get(sourceName);
    }

    public void addMappingOptions(String sourceName, String targetName, MappingOptions mappingOptions) {
        HashMap<String, MappingOptions> target = new HashMap<String, MappingOptions>();
        target.put(targetName, mappingOptions);
        this.formMappingOptions.put(sourceName, target);
    }

    public void removeMappingOptions(String sourceName, String targetName) {
        Map<String, MappingOptions> target = this.formMappingOptions.get(sourceName);
        if (target != null) {
            target.remove(targetName);
        }
    }

    public void removeMappingOptions(String sourceName) {
        this.formMappingOptions.remove(sourceName);
    }

    public boolean isImportAllDataSets() {
        return this.importAllDataSets;
    }

    public void setImportAllDataSets(boolean importAllDataSets) {
        this.importAllDataSets = importAllDataSets;
    }

    public boolean isFromARM() {
        return this.fromARM;
    }

    public void setFromARM(boolean fromARM) {
        this.fromARM = fromARM;
    }

    public Map<String, String> getFormMap() {
        return this.formMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(String message) {
        if (this.getLogFile() != null && this.getLogFile().length() > 0) {
            FileOutputStream outStream = null;
            try {
                OutputStreamWriter writer = null;
                outStream = new FileOutputStream(this.getLogFile(), false);
                writer = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                byte[] x = new byte[]{(byte)Integer.parseInt("EF", 16), (byte)Integer.parseInt("BB", 16), (byte)Integer.parseInt("BF", 16)};
                writer.write(new String(x, "UTF-8"));
                writer.write(message);
                writer.close();
            }
            catch (IOException e) {
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    public Map<String, Map<String, MappingOptions>> getFormMappingOptions() {
        return this.formMappingOptions;
    }

    public ImportResults getResults() {
        return this.results;
    }

    public void setLogLevel(int level) {
        switch (level) {
            case 0: {
                this.logLevel = Level.OFF;
                break;
            }
            case 1: {
                this.logLevel = Level.ERROR;
                break;
            }
            case 2: {
                this.logLevel = Level.WARN;
                break;
            }
            case 3: {
                this.logLevel = Level.INFO;
                break;
            }
            case 4: {
                this.logLevel = Level.DEBUG;
                break;
            }
            case 5: {
                this.logLevel = Level.TRACE;
                break;
            }
            case 6: {
                this.logLevel = Level.ALL;
            }
        }
    }

    public int getLogLevelInt() {
        int debugLevel = 3;
        if (this.logLevel.equals((Object)Level.OFF)) {
            debugLevel = 0;
        } else if (this.logLevel.equals((Object)Level.ERROR)) {
            debugLevel = 1;
        } else if (this.logLevel.equals((Object)Level.WARN)) {
            debugLevel = 2;
        } else if (this.logLevel.equals((Object)Level.INFO)) {
            debugLevel = 3;
        } else if (this.logLevel.equals((Object)Level.DEBUG)) {
            debugLevel = 4;
        } else if (this.logLevel.equals((Object)Level.TRACE)) {
            debugLevel = 5;
        } else if (this.logLevel.equals((Object)Level.ALL)) {
            debugLevel = 6;
        }
        return debugLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public ImportOptions clone() {
        ImportOptions options = new ImportOptions();
        options.context = new ARServerUser();
        try {
            options.context.setServer(this.context.getServer());
            options.context.setAuthentication(this.context.getAuthentication());
            options.context.setUser(this.context.getUser());
            options.context.setPassword(this.context.getPassword());
            options.context.setPort(this.context.getPort());
            options.context.usePrivateRpcQueue(this.context.getServerRpcQueueNumber());
            options.context.setLocale(this.context.getLocale());
            options.context.setTimeoutNormal(this.context.getTimeoutNormal());
            options.context.setTimeoutLong(this.context.getTimeoutLong());
            options.context.setTimeoutXLong(this.context.getTimeoutXLong());
        }
        catch (ARException eAR) {
            eAR.printStackTrace();
        }
        options.fileOptions = this.fileOptions.clone();
        options.fileList = new ArrayList<String>(this.fileList);
        if (this.filePattern != null) {
            options.filePattern = new String(this.filePattern);
        }
        options.isMultiThreaded = this.isMultiThreaded;
        options.sourceType = this.sourceType;
        options.dataOptions = this.dataOptions.clone();
        options.serverForms = new HashMap<String, FormInformation>(this.serverForms);
        options.fileForms = new HashMap<String, FormInformation>(this.fileForms);
        if (this.logFile != null) {
            options.logFile = new String(this.logFile);
        }
        options.importAllDataSets = this.importAllDataSets;
        for (Map.Entry<String, String> entry : this.formMap.entrySet()) {
            options.formMap.put(entry.getKey(), entry.getValue());
        }
        Map<String, MappingOptions> mappings = null;
        for (String srcForm : this.formMappingOptions.keySet()) {
            mappings = this.formMappingOptions.get(srcForm);
            for (String targetForm : mappings.keySet()) {
                options.addMappingOptions(srcForm, targetForm, mappings.get(targetForm));
            }
        }
        options.fromARM = this.fromARM;
        options.logLevel = this.logLevel;
        options.userAlertListener = this.userAlertListener;
        options.overlayGroup = this.overlayGroup;
        if (this.overlayGroup != null) {
            options.context.setOverlayGroup(this.overlayGroup);
        }
        options.setLogersList(this.getLoggersList());
        options.setConsoleAppenderOff(this.isConsoleAppenderOff());
        return options;
    }

    public boolean isConsoleAppenderOff() {
        return this.isConsoleAppenderOff;
    }

    public void setConsoleAppenderOff(boolean isConsoleAppenderOff) {
        this.isConsoleAppenderOff = isConsoleAppenderOff;
    }

    public static enum SourceType {
        NONE,
        FILE,
        SERVER;

    }
}

