/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import java.io.File;

public class FileOptions {
    private String dataFile;
    private String path;
    private String type = null;
    private boolean hasTitles = true;
    private String separator;
    private String charSet = null;

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String fileName) {
        this.dataFile = fileName;
        this.calculatePath(fileName);
    }

    public boolean isHasTitles() {
        return this.hasTitles;
    }

    public void setHasTitles(boolean hasTitles) {
        this.hasTitles = hasTitles;
    }

    public String getSeparator() {
        return this.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeparator(String seperatorIn) {
        StringBuffer strbuff = new StringBuffer();
        this.separator = "";
        char[] sep = seperatorIn.toCharArray();
        try {
            for (int i = 0; i < sep.length; ++i) {
                if (i + 1 == sep.length) {
                    strbuff.append(sep[i]);
                    continue;
                }
                if (sep[i] == '\\' && sep[i + 1] == 'b') {
                    strbuff.append("\b");
                    ++i;
                    continue;
                }
                if (sep[i] == '\\' && sep[i + 1] == 't') {
                    strbuff.append("\t");
                    ++i;
                    continue;
                }
                if (sep[i] == '\\' && sep[i + 1] == 'n') {
                    strbuff.append("\n");
                    ++i;
                    continue;
                }
                if (sep[i] == '\\' && sep[i + 1] == 'f') {
                    strbuff.append("\f");
                    ++i;
                    continue;
                }
                if (sep[i] == '\\' && sep[i + 1] == 'r') {
                    strbuff.append("\r");
                    ++i;
                    continue;
                }
                strbuff.append(sep[i]);
            }
            this.separator = strbuff.toString();
        }
        finally {
            strbuff.delete(0, strbuff.length());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private void calculatePath(String fileName) {
        File file = new File(fileName);
        String absolute = file.getAbsolutePath();
        String name = file.getName();
        this.path = absolute.substring(0, absolute.lastIndexOf(name) - 1);
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public FileOptions clone() {
        FileOptions options = new FileOptions();
        options.dataFile = this.dataFile;
        options.path = this.path;
        options.type = this.type;
        options.hasTitles = this.hasTitles;
        options.separator = this.separator;
        options.charSet = this.charSet;
        return options;
    }

    public static interface FileType {
        public static final String ASCII = "ASC";
        public static final String CSV = "CSV";
        public static final String ARX = "ARX";
        public static final String XML = "XML";
    }
}

