/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.JAXBHandler;
import com.bmc.arsys.apiext.data.JIThreadPoolExecutor;
import com.bmc.arsys.apiext.data.Util;
import com.bmc.arsys.apiext.data.arm.ARMParser;
import com.bmc.arsys.apiext.data.arm.ARMXMLParser;
import com.bmc.arsys.apiext.data.arm.CustomXMLParser;
import com.bmc.arsys.apiext.data.arx.ARXImporter;
import com.bmc.arsys.apiext.data.ascii.ASCIIImporter;
import com.bmc.arsys.apiext.data.csv.CSVImporter;
import com.bmc.arsys.apiext.data.jaxb.options.Command;
import com.bmc.arsys.apiext.data.jaxb.options.Commands;
import com.bmc.arsys.apiext.data.jaxb.options.Global;
import com.bmc.arsys.apiext.data.jaxb.options.Import;
import com.bmc.arsys.apiext.data.jaxb.options.Parameter;
import com.bmc.arsys.apiext.data.jaxb.summary.DataFileList;
import com.bmc.arsys.apiext.data.jaxb.summary.Df;
import com.bmc.arsys.apiext.data.jaxb.summary.ObjectFactory;
import com.bmc.arsys.apiext.data.jaxb.summary.Summary;
import com.bmc.arsys.apiext.data.xml.ARXMLImporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class DataImport {
    public static final String VERSION = "arimportcmd version 9.0 build001";
    public SimpleDateFormat simpleDateFormater = new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS");
    public Date importToolEntryTime = null;
    private ImportOptions options = null;
    private static final String FORMMAP_DELIM = "=";
    private Logger logger = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
    protected boolean commandLine = false;
    private boolean logInitialized = false;
    private Set<IParseListener> parseListeners = null;
    private int poolSize = 50;
    private String optionsFile = null;
    private long keepAliveTime = Long.MAX_VALUE;
    private Import importOption = null;
    private boolean isRIK = false;
    private String debugLogLevel = System.getenv("DEBUG_JIT");

    public int getDebugLogLevel() {
        int debugLevel = 3;
        try {
            if (this.debugLogLevel != null && this.debugLogLevel.length() > 0) {
                debugLevel = Integer.parseInt(this.debugLogLevel.trim());
            }
        }
        catch (NumberFormatException nfe) {
            debugLevel = 3;
        }
        return debugLevel;
    }

    public boolean isRIK() {
        return this.isRIK;
    }

    public void setRIK(boolean isRIK) {
        this.isRIK = isRIK;
    }

    public boolean isLogInitialized() {
        return this.logInitialized;
    }

    public void setLogInitialized(boolean logInitialized) {
        this.logInitialized = logInitialized;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getOptionsFile() {
        return this.optionsFile;
    }

    public void setOptionsFile(String optionsFile) {
        this.optionsFile = optionsFile;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ARException, ARImportException, IOException {
        DataImport instance = new DataImport();
        instance.importToolEntryTime = new Date();
        try {
            instance.commandLine = true;
            instance.doImport(args);
        }
        catch (Throwable e) {
            if (!instance.isLogInitialized()) {
                System.out.println(e);
            } else {
                instance.getLogger().error((Object)e);
            }
        }
        finally {
            if (instance.getOptions() != null && instance.getOptions().getContext() != null) {
                instance.getOptions().getContext().logout();
            }
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportOptions> doImport(String[] args) throws ARException, ARImportException, IOException {
        List<ImportOptions> resultSet;
        block18: {
            resultSet = null;
            try {
                if (args.length < 7) {
                    boolean printVersion = false;
                    for (String string : args) {
                        if (!string.equals("--version")) continue;
                        printVersion = true;
                        System.out.println(VERSION);
                        System.exit(0);
                    }
                    if (!printVersion) {
                        this.printUsage();
                        System.exit(1);
                    }
                    break block18;
                }
                try {
                    this.options = this.parseCommandLine(args);
                }
                catch (NumberFormatException nfe) {
                    throw new ARImportException(MessageFormat.format(ImportErrors.ERROR_PARSING_CMD_ARGS.toDefMsg(), nfe.getMessage()));
                }
                try {
                    resultSet = this.startImport();
                }
                catch (ARImportException eARI) {
                    this.logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), eARI), (Throwable)eARI);
                    if (!this.commandLine) {
                        throw eARI;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    this.logger.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_OPENED.toDefMsg(), this.options.getFileOptions().getDataFile(), fnfe), (Throwable)fnfe);
                    if (!this.commandLine) {
                        throw fnfe;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), e), (Throwable)e);
                    if (!this.commandLine) {
                        throw new ARImportException(e);
                    }
                }
            }
            finally {
                this.logger.removeAllAppenders();
                Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
                allAppenders = null;
                Enumeration currentLogger = LogManager.getLoggerRepository().getCurrentLoggers();
                if (currentLogger != null) {
                    block10: while (currentLogger.hasMoreElements()) {
                        Logger loggerElement = (Logger)currentLogger.nextElement();
                        allAppenders = loggerElement.getAllAppenders();
                        while (allAppenders.hasMoreElements()) {
                            Object appenderElement = allAppenders.nextElement();
                            if (!(appenderElement instanceof ConsoleAppender)) continue;
                            ((ConsoleAppender)appenderElement).setThreshold((Priority)Level.INFO);
                            continue block10;
                        }
                    }
                }
            }
        }
        return resultSet;
    }

    public void applyAPITimeouts() {
        String value = System.getProperty("ARAPITIMEOUTS");
        this.logger.info((Object)("APITIMEOUT from system property : -" + value));
        if (value == null || value.length() == 0) {
            value = System.getenv("ARAPITIMEOUTS");
            this.logger.info((Object)("APITIMEOUT from Environment : -" + value));
        }
        this.logger.debug((Object)MessageFormat.format(ImportErrors.API_TIMEOUTS.toDefMsg(), value));
        if (value != null && value.length() > 0) {
            String[] timeoutVal = value.split(":");
            for (int i = 0; i < timeoutVal.length; ++i) {
                try {
                    if (i == 0) {
                        this.options.getContext().setTimeoutNormal(Integer.parseInt(timeoutVal[i].trim()));
                        continue;
                    }
                    if (i == 1) {
                        this.options.getContext().setTimeoutLong(Integer.parseInt(timeoutVal[i].trim()));
                        continue;
                    }
                    this.options.getContext().setTimeoutXLong(Integer.parseInt(timeoutVal[i].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.warn((Object)ImportErrors.ERROR_APPLY_APITIMEOUT.toDefMsg());
                }
            }
        }
    }

    public List<ImportOptions> startImport() throws ARImportException, IOException, ARException {
        String tmpRIK;
        List<ImportOptions> resultSet = null;
        if (!this.isLogInitialized()) {
            if (this.options.getLogLevelInt() < this.getDebugLogLevel()) {
                this.options.setLogLevel(this.getDebugLogLevel());
            }
            this.initLogging(this.options.getLogFile(), this.options.getLogLevel(), this.options.isConsoleAppenderOff());
            this.options.getLoggersList().put(this.options.getLogFile(), this.logger);
        }
        if ((tmpRIK = System.getProperty("isRik")) != null && tmpRIK.trim().equalsIgnoreCase("1")) {
            this.setRIK(true);
        }
        this.applyAPITimeouts();
        try {
            this.validateOptions();
        }
        catch (ARImportException e) {
            this.logger.error((Object)e);
            if (this.commandLine) {
                return resultSet;
            }
            throw e;
        }
        if (this.getOptions().getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
            boolean noAlert = false;
            if (this.getOptions().getUserAlertListener() == null) {
                noAlert = true;
            }
            if (this.commandLine || noAlert) {
                this.logger.info((Object)ImportErrors.BAD_RECORD_HANDLING_SET_TO_ALERT_USER_NO_WAY_TO_DO.toDefMsg());
                this.getOptions().getDataOptions().setBadRecordHandling(DataOptions.BadRecords.SKIP);
            }
        }
        this.options.getResults().reset();
        try {
            resultSet = this.manageThreads();
        }
        catch (Exception e) {
            throw new ARImportException(e);
        }
        finally {
            this.clearAllLoggers();
        }
        return resultSet;
    }

    private List<ImportOptions> manageThreads() throws ARException, ARImportException, Exception {
        List<ImportOptions> resultSet = new LinkedList<ImportOptions>();
        JIThreadPoolExecutor INSTANCE = JIThreadPoolExecutor.getInstance();
        try {
            if (this.importOption != null) {
                List<Commands> commandsList = this.importOption.getCommands();
                for (Commands commands : commandsList) {
                    ImportOptions optCopy;
                    List<Command> importCommandList;
                    if (commands.isIsSerial()) {
                        this.logger.info((Object)ImportErrors.STARTING_SERIAL_IMPORT.toDefMsg());
                        importCommandList = commands.getCommand();
                        for (Command command : importCommandList) {
                            optCopy = this.options.clone();
                            optCopy = this.populateOptions(optCopy, command.getParameter(), false);
                            this.launchSerialImporter(optCopy, INSTANCE);
                        }
                        this.logger.info((Object)ImportErrors.ENDING_SERIAL_IMPORT.toDefMsg());
                        continue;
                    }
                    this.logger.info((Object)ImportErrors.STARTING_PARALLEL_IMPORT.toDefMsg());
                    INSTANCE.createPool(this.getPoolSize(), this.keepAliveTime, TimeUnit.SECONDS);
                    importCommandList = commands.getCommand();
                    for (Command command : importCommandList) {
                        optCopy = this.options.clone();
                        optCopy = this.populateOptions(optCopy, command.getParameter(), false);
                        this.launchParallelImporter(optCopy, INSTANCE);
                    }
                    INSTANCE.join();
                    INSTANCE.deletePool();
                    this.logger.info((Object)ImportErrors.ENDING_PARALLEL_IMPORT.toDefMsg());
                }
                resultSet = this.generateReports(this.optionsFile, INSTANCE, resultSet);
            } else {
                this.launchSerialImporter(this.options, INSTANCE);
                List<Future<ImportOptions>> listOptions = INSTANCE.getFuture();
                for (Future<ImportOptions> future : listOptions) {
                    ImportOptions opt = future.get();
                    resultSet.add(opt);
                }
            }
        }
        catch (OutOfMemoryError e) {
            this.logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), "Insufficient Java heap space"));
            if (!this.commandLine) {
                throw e;
            }
        }
        catch (InterruptedException ie) {
            throw new ARImportException(ie);
        }
        finally {
            INSTANCE.deleteFuture();
        }
        return resultSet;
    }

    private void clearAllLoggers() {
        this.removeAppendersForAllLoggers();
        this.options.getLoggersList().clear();
        this.options.setLogersList(null);
        this.options.setLogersList(new LinkedHashMap<String, Logger>());
        this.setLogInitialized(false);
    }

    private void removeAppendersForAllLoggers() {
        for (String logFile : this.options.getLoggersList().keySet()) {
            Logger logger;
            if (logFile == null || (logger = this.options.getLoggersList().get(logFile)) == null) continue;
            logger.removeAllAppenders();
        }
    }

    private List<ImportOptions> generateReports(String optionsFile, JIThreadPoolExecutor INSTANCE, List<ImportOptions> resultSet) throws ARImportException {
        Logger reportLogger = null;
        try {
            if (optionsFile != null && optionsFile.length() > 0) {
                String summaryLogFile = new String(optionsFile);
                summaryLogFile = summaryLogFile.replace(".xml", "_summary.log");
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb);
                PatternLayout layout = new PatternLayout();
                reportLogger = this.createLogger(summaryLogFile, Level.INFO, layout);
                List<Future<ImportOptions>> listOptions = INSTANCE.getFuture();
                Future<ImportOptions> tempFuture = listOptions.get(0);
                String dataFileName = tempFuture.get().getFileOptions().getDataFile();
                int fileLength = dataFileName != null ? dataFileName.length() + 100 : 100;
                String formatString = "%-" + fileLength + "s" + " %-15s %-15s %-15s %-15s %-15s ";
                ObjectFactory factory = new ObjectFactory();
                Summary summary = factory.createSummary();
                DataFileList dataFileList = factory.createDataFileList();
                if (!this.isRIK()) {
                    formatString = formatString + "%-50s ";
                }
                if (reportLogger != null) {
                    reportLogger.info((Object)formatter.format(formatString, "Data File", "Record Count", "Success Count", "Error Count", "Skip Count", "Warning Count", "Log File "));
                }
                for (Future<ImportOptions> future : listOptions) {
                    String dupIDs;
                    ImportOptions opt = future.get();
                    resultSet.add(opt);
                    StringBuilder res = new StringBuilder();
                    Formatter resFormatter = new Formatter(res);
                    if (reportLogger != null) {
                        reportLogger.info((Object)resFormatter.format(formatString, opt.getFileOptions().getDataFile(), opt.getResults().getRecordCount(), opt.getResults().getSuccessCount(), opt.getResults().getErrorCount(), opt.getResults().getSkipCount(), opt.getResults().getWarningCount(), opt.getLogFile()));
                    }
                    if (!this.isRIK()) continue;
                    Df df = factory.createDf();
                    if (opt.getDataOptions().getDuplicateFields() != null) {
                        dupIDs = opt.getDataOptions().getDuplicateFields().toString();
                        dupIDs = dupIDs.replace("[", "");
                        dupIDs = dupIDs.replace("]", "").trim();
                    } else {
                        dupIDs = "";
                    }
                    df.setAltfid(dupIDs);
                    String logFile = opt.getLogFile() != null ? opt.getLogFile() : "";
                    df.setLog(logFile);
                    Integer mode = new Integer(opt.getDataOptions().getDuplicateIdHandling().getMergeOption());
                    if (mode == 1 && opt.getDataOptions().isSkipDuplicate()) {
                        mode = 5;
                    }
                    df.setMode(String.valueOf(mode));
                    df.setContent(opt.getFileOptions().getDataFile());
                    dataFileList.getDf().add(df);
                }
                if (this.isRIK()) {
                    summary.setDataFileList(dataFileList);
                    JAXBHandler xmlWriter = new JAXBHandler("com.bmc.arsys.apiext.data.jaxb.summary");
                    File path = new File(optionsFile);
                    String xmlFile = path.getParent();
                    xmlFile = xmlFile + System.getProperty("file.separator") + "DataImportSummary.xml";
                    xmlWriter.setTargetFile(new File(xmlFile));
                    xmlWriter.writeXML(summary);
                }
            }
        }
        catch (Exception e) {
            throw new ARImportException(e);
        }
        finally {
            if (reportLogger != null) {
                reportLogger.removeAllAppenders();
            }
        }
        return resultSet;
    }

    private void launchSerialImporter(ImportOptions options, JIThreadPoolExecutor INSTANCE) throws ARImportException, InterruptedException, IOException, ARException {
        int threadCount = 0;
        List<Callable<ImportOptions>> taskList = this.createImportTaskList(options);
        if (taskList.size() <= 0) {
            Logger logger = options.getLoggersList().get(options.getLogFile());
            if (logger != null) {
                logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED_WITH_NO_TASK_FOUND.toDefMsg(), options.getFileOptions().getDataFile()));
            }
            return;
        }
        threadCount = this.getPoolSize() > taskList.size() ? taskList.size() : this.getPoolSize();
        INSTANCE.createPool(threadCount, this.keepAliveTime, TimeUnit.SECONDS);
        INSTANCE.addMultipleTask(taskList);
        INSTANCE.join();
        INSTANCE.deletePool();
    }

    private void launchParallelImporter(ImportOptions options, JIThreadPoolExecutor INSTANCE) throws ARImportException, InterruptedException, IOException, ARException {
        List<Callable<ImportOptions>> taskList = this.createImportTaskList(options);
        if (taskList.size() <= 0) {
            Logger logger = options.getLoggersList().get(options.getLogFile());
            if (logger != null) {
                logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED_WITH_NO_TASK_FOUND.toDefMsg(), options.getFileOptions().getDataFile()));
            }
            return;
        }
        INSTANCE.addMultipleTask(taskList);
    }

    private List<Callable<ImportOptions>> createImportTaskList(ImportOptions options) throws ARImportException, InterruptedException {
        LinkedList<Callable<ImportOptions>> taskList = new LinkedList<Callable<ImportOptions>>();
        BaseImporter importer = null;
        options = this.createFileImportOptions(options);
        ImportOptions optionsCopy = null;
        if (options.getFileList() != null && options.getFileList().size() > 0) {
            int count = options.getFileList().size();
            for (int i = 0; i < count; ++i) {
                if (options.getFileList().get(i).toUpperCase().endsWith(".ARX")) {
                    options.getFileOptions().setType("ARX");
                } else if (options.getFileList().get(i).toUpperCase().endsWith(".XML")) {
                    options.getFileOptions().setType("XML");
                } else if (options.getFileList().get(i).toUpperCase().endsWith(".CSV")) {
                    options.getFileOptions().setType("CSV");
                } else if (options.getFileList().get(i).toUpperCase().endsWith(".ASC")) {
                    options.getFileOptions().setType("ASC");
                }
                optionsCopy = options.clone();
                optionsCopy.getFileOptions().setDataFile(options.getFileList().get(i));
                if (optionsCopy.getLogFile() == null || optionsCopy.getLogFile().trim().length() == 0) {
                    String logFileName = optionsCopy.getFileOptions().getDataFile();
                    logFileName = logFileName.substring(logFileName.lastIndexOf(System.getProperty("file.separator")) + 1);
                    optionsCopy.setLogFile(logFileName.substring(0, logFileName.lastIndexOf(".")) + ".log");
                    File tempFile = new File(optionsCopy.getLogFile());
                    optionsCopy.setLogFile(tempFile.getAbsolutePath());
                    tempFile = null;
                    if (!optionsCopy.getLoggersList().containsKey(optionsCopy.getLogFile())) {
                        Logger log = this.createLogger(optionsCopy.getLogFile(), optionsCopy.getLogLevel(), null);
                        optionsCopy.getLoggersList().put(optionsCopy.getLogFile(), log);
                    }
                }
                if (optionsCopy.getFileOptions().getType() != null) {
                    if (optionsCopy.getFileOptions().getType().equals("ARX")) {
                        importer = new ARXImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getType().equals("XML")) {
                        importer = new ARXMLImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getType().equals("CSV")) {
                        importer = new CSVImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getType().equals("ASC")) {
                        importer = new ASCIIImporter(optionsCopy);
                    }
                } else if (optionsCopy.getFileOptions().getDataFile() != null) {
                    if (optionsCopy.getFileOptions().getDataFile().toUpperCase().endsWith("ARX")) {
                        importer = new ARXImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getDataFile().toUpperCase().endsWith("XML")) {
                        importer = new ARXMLImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getDataFile().toUpperCase().endsWith("CSV")) {
                        importer = new CSVImporter(optionsCopy);
                    } else if (optionsCopy.getFileOptions().getDataFile().toUpperCase().endsWith("ASC")) {
                        importer = new ASCIIImporter(optionsCopy);
                    }
                }
                if (importer == null) continue;
                if (this.parseListeners != null && importer.getParser() != null) {
                    for (IParseListener listener : this.parseListeners) {
                        if (listener == null) continue;
                        importer.getParser().addListener(listener);
                    }
                }
                taskList.add(importer);
            }
        } else {
            importer = this.getImporter(options);
            if (importer != null) {
                if (this.parseListeners != null && importer.getParser() != null) {
                    for (IParseListener listener : this.parseListeners) {
                        if (listener == null) continue;
                        importer.getParser().addListener(listener);
                    }
                }
                taskList.add(importer);
            }
        }
        return taskList;
    }

    private ImportOptions createFileImportOptions(ImportOptions options) throws ARImportException {
        File file;
        String dataFile = options.getFileOptions().getDataFile();
        if (dataFile != null && dataFile.length() > 0) {
            file = new File(dataFile);
            if (!file.isDirectory()) {
                return options;
            }
        } else {
            return options;
        }
        if (options.getFileList() != null && options.getFileList().size() > 0) {
            for (int i = 0; i < options.getFileList().size(); ++i) {
                String dataFileName = dataFile + System.getProperty("file.separator") + options.getFileList().get(i);
                options.getFileList().set(i, dataFileName);
            }
        } else if (options.getFilePattern() != null && options.getFilePattern().length() > 0) {
            ArrayList<String> listOfFile = new ArrayList<String>();
            try {
                PatternFilter dataFileFilter = new PatternFilter(options.getFilePattern());
                List<String> filesList = Arrays.asList(file.list(dataFileFilter));
                listOfFile.addAll(filesList);
            }
            catch (PatternSyntaxException pse) {
                throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_REGEX_PATTERN_SYNTAX.toDefMsg(), pse.getMessage()));
            }
            int counter = listOfFile.size();
            for (int i = 0; i < counter; ++i) {
                String dataFileName = dataFile + System.getProperty("file.separator") + listOfFile.get(i);
                listOfFile.set(i, dataFileName);
            }
            options.setFileList(listOfFile);
        } else {
            ArrayList<String> listOfFile = new ArrayList<String>();
            FilenameFilter dataFileFilter = new ARXFilter();
            List<String> filesList = Arrays.asList(file.list(dataFileFilter));
            listOfFile.addAll(filesList);
            dataFileFilter = new CSVFilter();
            filesList = Arrays.asList(file.list(dataFileFilter));
            listOfFile.addAll(filesList);
            dataFileFilter = new XMLFilter();
            filesList = Arrays.asList(file.list(dataFileFilter));
            listOfFile.addAll(filesList);
            dataFileFilter = new ASCIIFilter();
            filesList = Arrays.asList(file.list(dataFileFilter));
            listOfFile.addAll(filesList);
            if (listOfFile == null) {
                throw new ARImportException(ImportErrors.IO_ERROR_READING_DIRECTORY.toDefMsg() + dataFile);
            }
            int counter = listOfFile.size();
            for (int i = 0; i < counter; ++i) {
                String dataFileName = dataFile + System.getProperty("file.separator") + listOfFile.get(i);
                listOfFile.set(i, dataFileName);
            }
            options.setFileList(listOfFile);
        }
        if (options.getFileList().size() < 1) {
            throw new ARImportException(MessageFormat.format(ImportErrors.NO_FILE_MATCHED_PATTERN.toDefMsg(), options.getFilePattern()));
        }
        return options;
    }

    private BaseImporter getImporter(ImportOptions options) throws ARImportException {
        if (options.getFileOptions().getType() != null) {
            if (options.getFileOptions().getType().equals("ARX")) {
                return new ARXImporter(options);
            }
            if (options.getFileOptions().getType().equals("XML")) {
                return new ARXMLImporter(options);
            }
            if (options.getFileOptions().getType().equals("CSV")) {
                return new CSVImporter(options);
            }
            if (options.getFileOptions().getType().equals("ASC")) {
                return new ASCIIImporter(options);
            }
        } else if (options.getFileOptions().getDataFile() != null && !new File(options.getFileOptions().getDataFile()).isDirectory()) {
            if (options.getFileOptions().getDataFile().toUpperCase().endsWith(".ARX")) {
                return new ARXImporter(options);
            }
            if (options.getFileOptions().getDataFile().toUpperCase().endsWith(".XML")) {
                return new ARXMLImporter(options);
            }
            if (options.getFileOptions().getDataFile().toUpperCase().endsWith(".CSV")) {
                return new CSVImporter(options);
            }
            if (options.getFileOptions().getDataFile().toUpperCase().endsWith(".ASC")) {
                return new ASCIIImporter(options);
            }
        }
        this.logger.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_EXISTS.toDefMsg(), options.getFileOptions().getDataFile()));
        return null;
    }

    public ImportOptions parseCommandLine(String[] args) throws ARException, ARImportException, NumberFormatException {
        Global globalParameters;
        ImportOptions result = new ImportOptions();
        HashMap<String, String> tempArgs = new HashMap<String, String>();
        String mappingDir = null;
        String mappingName = null;
        String mappingFile = null;
        String customFile = null;
        String server = null;
        String dataFile = null;
        String user = null;
        String password = null;
        String overlayGroup = null;
        int tcpPort = 0;
        int rpcNumber = 0;
        String authentication = null;
        String dataFileType = null;
        for (int iLoop = 0; iLoop < args.length; ++iLoop) {
            String isConsoleAppenderOff;
            String argument = args[iLoop];
            tempArgs.put(argument, argument);
            if (argument.equals("-threads")) {
                String strThreadCount = this.getValue(argument, args, ++iLoop);
                this.setPoolSize(Integer.parseInt(strThreadCount));
                continue;
            }
            if (argument.equals("-z")) {
                this.optionsFile = this.getValue(argument, args, ++iLoop);
                result.setMultiThreaded(true);
                continue;
            }
            if (argument.equals("-og")) {
                overlayGroup = this.getValue(argument, args, ++iLoop);
                result.setOverlayGroup(overlayGroup);
                continue;
            }
            if (argument.equals("-filelist")) {
                String[] files = this.getValue(argument, args, ++iLoop).split(",");
                ArrayList<String> fileList = new ArrayList<String>(files.length);
                for (String file : files) {
                    fileList.add(file.trim());
                }
                result.setFileList(fileList);
                continue;
            }
            if (argument.equals("-pattern")) {
                result.setFilePattern(this.getValue(argument, args, ++iLoop));
                continue;
            }
            if (argument.equals("-custom")) {
                customFile = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-x")) {
                server = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-u")) {
                user = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-p")) {
                password = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-d")) {
                mappingDir = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-m")) {
                mappingName = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-l")) {
                result.setLogFile(this.getValue(argument, args, ++iLoop));
                continue;
            }
            if (argument.equals("-f")) {
                String content;
                int pos;
                if ((pos = (content = this.getValue(argument, args, ++iLoop)).indexOf(FORMMAP_DELIM)) < 0) {
                    result.getFormMap().put("ARImport_Data_Holder", content.substring(0, content.length()));
                    continue;
                }
                String serverForm = content.substring(0, pos);
                String fileForm = content.substring(pos + FORMMAP_DELIM.length(), content.length());
                result.getFormMap().put(fileForm, serverForm);
                continue;
            }
            if (argument.equals("-o")) {
                dataFile = this.getValue(argument, args, ++iLoop);
                result.getFileOptions().setDataFile(dataFile);
                result.setMultiThreaded(new File(dataFile).isDirectory());
                if (result.getFileOptions().getType() != null || new File(dataFile).isDirectory()) continue;
                if (dataFile.toUpperCase().endsWith(".ARX")) {
                    result.getFileOptions().setType("ARX");
                    dataFileType = "ARX";
                    continue;
                }
                if (dataFile.toUpperCase().endsWith(".XML")) {
                    result.getFileOptions().setType("XML");
                    dataFileType = "XML";
                    continue;
                }
                if (dataFile.toUpperCase().endsWith(".CSV")) {
                    result.getFileOptions().setType("CSV");
                    dataFileType = "CSV";
                    continue;
                }
                if (!dataFile.toUpperCase().endsWith(".ASC")) continue;
                result.getFileOptions().setType("ASC");
                dataFileType = "ASC";
                continue;
            }
            if (argument.equals("-M")) {
                mappingFile = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-D")) {
                int duplicateHandling;
                if ((duplicateHandling = Integer.parseInt(this.getValue(argument, args, ++iLoop))) == 5) {
                    result.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(DataOptions.DuplicateHandling.DUP_ERROR.getARMValue()));
                    result.getDataOptions().setSkipDuplicate(true);
                    continue;
                }
                result.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(duplicateHandling));
                continue;
            }
            if (argument.equals("-a")) {
                tcpPort = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                continue;
            }
            if (argument.equals("-r")) {
                rpcNumber = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                continue;
            }
            if (argument.equals("-e")) {
                String eval;
                if ((eval = this.getValue(argument, args, ++iLoop)) == null || eval.trim().length() <= 0) continue;
                if (!eval.contains(";") && !eval.contains(FORMMAP_DELIM)) {
                    String[] fields = eval.split(",");
                    ArrayList<Integer> duplicateFields = new ArrayList<Integer>(fields.length);
                    for (String field : fields) {
                        int fieldId = Integer.parseInt(field.trim());
                        duplicateFields.add(fieldId);
                    }
                    result.getDataOptions().setDuplicateFields(duplicateFields);
                    continue;
                }
                result.getDataOptions().setMultiDuplicateFields(eval);
                continue;
            }
            if (argument.equals("-n")) {
                result.getDataOptions().setSuppressFilters(true);
                continue;
            }
            if (argument.equals("-s")) {
                result.getDataOptions().setSuppressAssociations(true);
                continue;
            }
            if (argument.equals("-v")) {
                result.getContext().setOverridePrevIP(true);
                continue;
            }
            if (argument.equals("-t")) {
                int multiMatchOption = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                result.getDataOptions().setMultiMatch(DataOptions.MultiMatch.fromARMValue(multiMatchOption));
                continue;
            }
            if (argument.equals("-w")) {
                authentication = this.getValue(argument, args, ++iLoop);
                continue;
            }
            if (argument.equals("-q")) {
                String boolString = this.getValue(argument, args, ++iLoop);
                boolean boolValue = false;
                if (boolString.equalsIgnoreCase("1")) {
                    boolValue = true;
                }
                result.getDataOptions().setDisableRequired(boolValue);
                continue;
            }
            if (argument.equals("-c")) {
                String boolString = this.getValue(argument, args, ++iLoop);
                boolean boolValue = false;
                if (boolString.equalsIgnoreCase("1")) {
                    boolValue = true;
                }
                result.getDataOptions().setTruncate(boolValue);
                continue;
            }
            if (argument.equals("-h")) {
                String patternString = this.getValue(argument, args, ++iLoop);
                boolean suppressPattern = false;
                if (patternString.equalsIgnoreCase("1")) {
                    suppressPattern = true;
                }
                result.getDataOptions().setDisablePattern(suppressPattern);
                continue;
            }
            if (argument.equals("-i")) {
                int suppressDefault = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                result.getDataOptions().setSuppressDefaults(suppressDefault);
                continue;
            }
            if (argument.equals("-charset")) {
                String charSet = args[++iLoop];
                result.getFileOptions().setCharSet(charSet);
                continue;
            }
            if (argument.equals("-b")) {
                int transactionSize = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                result.getDataOptions().setTransactionSize(transactionSize);
                continue;
            }
            if (argument.equals("-debug")) {
                int debugLevel;
                try {
                    debugLevel = Integer.parseInt(this.getValue(argument, args, ++iLoop));
                }
                catch (Exception e) {
                    debugLevel = 3;
                }
                result.setLogLevel(debugLevel);
                continue;
            }
            if (argument.equals("-g")) {
                String forceBulkString;
                if (!(forceBulkString = this.getValue(argument, args, ++iLoop)).equalsIgnoreCase("1")) continue;
                result.getDataOptions().setForceBulk(true);
                continue;
            }
            if (!argument.equals("-ca") || !(isConsoleAppenderOff = this.getValue(argument, args, ++iLoop)).equalsIgnoreCase("1")) continue;
            result.setConsoleAppenderOff(true);
        }
        if (result.getLogLevelInt() < this.getDebugLogLevel()) {
            result.setLogLevel(this.getDebugLogLevel());
        }
        Exception exception = null;
        String errorMessage = null;
        if (this.optionsFile != null && this.optionsFile.trim().length() > 0) {
            File optFile = new File(this.optionsFile);
            if (optFile.exists()) {
                try {
                    JAXBHandler xmlReader = new JAXBHandler("com.bmc.arsys.apiext.data.jaxb.options");
                    File xmlFile = new File(this.optionsFile);
                    this.importOption = (Import)xmlReader.readXML(xmlFile);
                }
                catch (Exception e) {
                    exception = e;
                }
            } else {
                errorMessage = MessageFormat.format(ImportErrors.OPTIONS_FILE_NOT_EXISTS.toDefMsg(), this.optionsFile);
            }
        }
        if (this.importOption != null && (globalParameters = this.importOption.getGlobal()) != null) {
            List<Parameter> globalParameterList = globalParameters.getParameter();
            result = this.populateOptions(result, globalParameterList, true);
        }
        if (result.getDataOptions().getDuplicateIdHandling() == DataOptions.DuplicateHandling.DUP_ERROR && result.getDataOptions().isSkipDuplicate()) {
            result.getDataOptions().setTransactionSize(0);
        }
        this.initLogging(result.getLogFile(), result.getLogLevel(), result.isConsoleAppenderOff());
        result.getLoggersList().put(result.getLogFile(), this.logger);
        if (exception != null) {
            this.logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PARSING_OPTIONS_XML_FILE.toDefMsg(), exception.getMessage() == null ? exception.getCause() : exception.getMessage()), (Throwable)exception);
            throw new ARImportException(exception);
        }
        if (errorMessage != null) {
            this.logger.error((Object)errorMessage);
            throw new ARImportException(errorMessage);
        }
        result = this.applyMapping(result, mappingFile, dataFile, mappingName, mappingDir, dataFileType, tempArgs);
        result = this.applyCustomSettings(result, customFile);
        if (server != null) {
            result.getContext().setServer(server);
        }
        if (authentication != null) {
            result.getContext().setAuthentication(authentication);
        }
        if (user != null) {
            result.getContext().setUser(user);
        }
        if (password != null) {
            result.getContext().setPassword(password);
        }
        if (tcpPort != 0) {
            result.getContext().setPort(tcpPort);
        }
        if (rpcNumber != 0) {
            result.getContext().usePrivateRpcQueue(rpcNumber);
        }
        if (overlayGroup != null) {
            result.getContext().setOverlayGroup(overlayGroup);
        }
        return result;
    }

    public ImportOptions populateOptions(ImportOptions result, List<Parameter> parameterList, boolean isGlobal) throws ARException, ARImportException, NumberFormatException {
        String mappingDir = null;
        String mappingName = null;
        String mappingFile = null;
        String customFile = null;
        String server = null;
        String dataFile = null;
        String user = null;
        String password = null;
        String overlayGroup = null;
        int tcpPort = 0;
        int rpcNumber = 0;
        String authentication = null;
        String dataFileType = null;
        for (Parameter parameter : parameterList) {
            String isConsoleAppenderOff;
            String argument = parameter.getName();
            if (argument.equals("threads") && isGlobal) {
                String strThreadCount = parameter.getValue();
                this.setPoolSize(Integer.parseInt(strThreadCount));
                continue;
            }
            if (argument.equals("og")) {
                overlayGroup = parameter.getValue();
                result.setOverlayGroup(overlayGroup);
                continue;
            }
            if (argument.equals("filelist")) {
                String[] files = parameter.getValue().split(",");
                ArrayList<String> fileList = new ArrayList<String>(files.length);
                for (String file : files) {
                    fileList.add(file.trim());
                }
                result.setFileList(fileList);
                continue;
            }
            if (argument.equals("pattern")) {
                result.setFilePattern(parameter.getValue());
                continue;
            }
            if (argument.equals("custom")) {
                customFile = parameter.getValue();
                continue;
            }
            if (argument.equals("x")) {
                server = parameter.getValue();
                continue;
            }
            if (argument.equals("u")) {
                user = parameter.getValue();
                continue;
            }
            if (argument.equals("p")) {
                password = parameter.getValue();
                continue;
            }
            if (argument.equals("d")) {
                mappingDir = parameter.getValue();
                continue;
            }
            if (argument.equals("m")) {
                mappingName = parameter.getValue();
                continue;
            }
            if (argument.equals("l")) {
                result.setLogFile(parameter.getValue());
                continue;
            }
            if (argument.equals("f")) {
                String content = parameter.getValue();
                int pos = content.indexOf(FORMMAP_DELIM);
                if (pos < 0) {
                    result.getFormMap().put("ARImport_Data_Holder", content.substring(0, content.length()));
                    continue;
                }
                String serverForm = content.substring(0, pos);
                String fileForm = content.substring(pos + FORMMAP_DELIM.length(), content.length());
                result.getFormMap().put(fileForm, serverForm);
                continue;
            }
            if (argument.equals("o")) {
                dataFile = parameter.getValue().trim();
                String path = result.getFileOptions().getDataFile();
                if (path != null && path.length() > 0) {
                    dataFile = path.trim() + System.getProperty("file.separator") + dataFile;
                }
                result.getFileOptions().setDataFile(dataFile);
                result.setMultiThreaded(new File(dataFile).isDirectory());
                if (result.getFileOptions().getType() != null || new File(dataFile).isDirectory()) continue;
                if (dataFile.toUpperCase().endsWith(".ARX")) {
                    result.getFileOptions().setType("ARX");
                    dataFileType = "ARX";
                    continue;
                }
                if (dataFile.toUpperCase().endsWith(".XML")) {
                    result.getFileOptions().setType("XML");
                    dataFileType = "XML";
                    continue;
                }
                if (dataFile.toUpperCase().endsWith(".CSV")) {
                    result.getFileOptions().setType("CSV");
                    dataFileType = "CSV";
                    continue;
                }
                if (!dataFile.toUpperCase().endsWith(".ASC")) continue;
                result.getFileOptions().setType("ASC");
                dataFileType = "ASC";
                continue;
            }
            if (argument.equals("M")) {
                mappingFile = parameter.getValue();
                continue;
            }
            if (argument.equals("D")) {
                int duplicateHandling = Integer.parseInt(parameter.getValue());
                if (duplicateHandling == 5) {
                    result.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(DataOptions.DuplicateHandling.DUP_ERROR.getARMValue()));
                    result.getDataOptions().setSkipDuplicate(true);
                    continue;
                }
                result.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(duplicateHandling));
                continue;
            }
            if (argument.equals("a")) {
                tcpPort = Integer.parseInt(parameter.getValue());
                continue;
            }
            if (argument.equals("r")) {
                rpcNumber = Integer.parseInt(parameter.getValue());
                continue;
            }
            if (argument.equals("e")) {
                String eval = parameter.getValue();
                if (!eval.contains(";") && !eval.contains(FORMMAP_DELIM)) {
                    String[] fields = eval.split(",");
                    ArrayList<Integer> duplicateFields = new ArrayList<Integer>(fields.length);
                    for (String field : fields) {
                        int fieldId = Integer.parseInt(field.trim());
                        duplicateFields.add(fieldId);
                    }
                    result.getDataOptions().setDuplicateFields(duplicateFields);
                    continue;
                }
                result.getDataOptions().setMultiDuplicateFields(eval);
                continue;
            }
            if (argument.equals("n")) {
                result.getDataOptions().setSuppressFilters(true);
                continue;
            }
            if (argument.equals("v")) {
                result.getContext().setOverridePrevIP(true);
                continue;
            }
            if (argument.equals("t")) {
                int multiMatchOption = Integer.parseInt(parameter.getValue());
                result.getDataOptions().setMultiMatch(DataOptions.MultiMatch.fromARMValue(multiMatchOption));
                continue;
            }
            if (argument.equals("w")) {
                authentication = parameter.getValue();
                continue;
            }
            if (argument.equals("q")) {
                String boolString = parameter.getValue();
                boolean boolValue = false;
                if (boolString.equalsIgnoreCase("1")) {
                    boolValue = true;
                }
                result.getDataOptions().setDisableRequired(boolValue);
                continue;
            }
            if (argument.equals("c")) {
                String boolString = parameter.getValue();
                boolean boolValue = false;
                if (boolString.equalsIgnoreCase("1")) {
                    boolValue = true;
                }
                result.getDataOptions().setTruncate(boolValue);
                continue;
            }
            if (argument.equals("h")) {
                String patternString = parameter.getValue();
                boolean suppressPattern = false;
                if (patternString.equalsIgnoreCase("1")) {
                    suppressPattern = true;
                }
                result.getDataOptions().setDisablePattern(suppressPattern);
                continue;
            }
            if (argument.equals("i")) {
                int suppressDefault = Integer.parseInt(parameter.getValue());
                result.getDataOptions().setSuppressDefaults(suppressDefault);
                continue;
            }
            if (argument.equals("charset")) {
                String charSet = parameter.getValue();
                result.getFileOptions().setCharSet(charSet);
                continue;
            }
            if (argument.equals("b")) {
                int transactionSize = Integer.parseInt(parameter.getValue());
                result.getDataOptions().setTransactionSize(transactionSize);
                continue;
            }
            if (argument.equals("debug") && isGlobal) {
                int debugLevel;
                try {
                    debugLevel = Integer.parseInt(parameter.getValue());
                }
                catch (Exception e) {
                    debugLevel = 3;
                }
                result.setLogLevel(debugLevel);
                continue;
            }
            if (argument.equals("g")) {
                String forceBulkString = parameter.getValue();
                if (!forceBulkString.equalsIgnoreCase("1")) continue;
                result.getDataOptions().setForceBulk(true);
                continue;
            }
            if (!argument.equals("-ca") || !(isConsoleAppenderOff = parameter.getValue()).equalsIgnoreCase("1")) continue;
            result.setConsoleAppenderOff(true);
        }
        if (!(isGlobal || result.getLogFile() != null && result.getLogFile().trim().length() != 0 || null != result.getFilePattern() && result.getFilePattern().trim().length() != 0)) {
            String logFileName = result.getFileOptions().getDataFile();
            logFileName = logFileName.substring(logFileName.lastIndexOf(System.getProperty("file.separator")) + 1);
            result.setLogFile(logFileName.substring(0, logFileName.lastIndexOf(".")) + ".log");
        }
        if (result.getLogFile() != null && result.getLogFile().trim().length() > 0) {
            File tempFile = new File(result.getLogFile());
            result.setLogFile(tempFile.getAbsolutePath());
            tempFile = null;
            if (!result.getLoggersList().containsKey(result.getLogFile())) {
                Logger log = this.createLogger(result.getLogFile(), result.getLogLevel(), null);
                result.getLoggersList().put(result.getLogFile(), log);
            }
        }
        if (result.getDataOptions().getDuplicateIdHandling() == DataOptions.DuplicateHandling.DUP_ERROR && result.getDataOptions().isSkipDuplicate()) {
            result.getDataOptions().setTransactionSize(0);
        }
        result = this.applyMapping(result, mappingFile, dataFile, mappingName, mappingDir, dataFileType, null);
        result = this.applyCustomSettings(result, customFile);
        if (server != null) {
            result.getContext().setServer(server);
        }
        if (authentication != null) {
            result.getContext().setAuthentication(authentication);
        }
        if (user != null) {
            result.getContext().setUser(user);
        }
        if (password != null) {
            result.getContext().setPassword(password);
        }
        if (tcpPort != 0) {
            result.getContext().setPort(tcpPort);
        }
        if (rpcNumber != 0) {
            result.getContext().usePrivateRpcQueue(rpcNumber);
        }
        if (overlayGroup != null) {
            result.getContext().setOverlayGroup(overlayGroup);
        }
        return result;
    }

    private ImportOptions applyCustomSettings(ImportOptions result, String customFile) throws ARImportException {
        if (customFile != null && customFile.length() > 0) {
            try {
                CustomXMLParser parser = new CustomXMLParser(result);
                parser.parseFile(customFile);
            }
            catch (Exception e) {
                this.logger.warn((Object)MessageFormat.format(ImportErrors.CUSTOM_FILE_NOT_PARSED.toDefMsg(), customFile, e), (Throwable)e);
                throw new ARImportException(e);
            }
        }
        return result;
    }

    private ImportOptions applyMapping(ImportOptions result, String mappingFile, String dataFile, String mappingName, String mappingDir, String dataFileType, Map<String, String> tempArgs) throws ARImportException {
        if (tempArgs == null) {
            tempArgs = new HashMap<String, String>();
        }
        if (mappingFile == null && mappingName != null) {
            try {
                mappingFile = Util.findMappingFile(mappingDir, mappingName, result.getFileOptions().getCharSet());
            }
            catch (IOException e) {
                this.logger.warn((Object)ImportErrors.EXCEPTION_ON_MAPPING_FILE.toDefMsg(), (Throwable)e);
            }
        }
        if (mappingFile != null && mappingFile.length() > 0) {
            try {
                IParser parser;
                if (mappingFile.toUpperCase().endsWith(".ARM")) {
                    parser = new ARMParser(result, tempArgs);
                    ((ARMParser)parser).populateFromARM(result, mappingFile, result.getFileOptions().getCharSet());
                    if (dataFile != null) {
                        result.getFileOptions().setDataFile(dataFile);
                    }
                    if (dataFileType != null) {
                        result.getFileOptions().setType(dataFileType);
                    }
                }
                if (mappingFile.toUpperCase().endsWith(".ARMX")) {
                    parser = new ARMXMLParser(result, tempArgs);
                    ((ARMXMLParser)parser).parseFile(mappingFile);
                    if (dataFile != null) {
                        result.getFileOptions().setDataFile(dataFile);
                    }
                    if (dataFileType != null) {
                        result.getFileOptions().setType(dataFileType);
                    }
                    if ((result.getFileOptions().getSeparator() == null || result.getFileOptions().getSeparator().equals("")) && result.getFileOptions().getType() != null && result.getFileOptions().getType().equals("ASC")) {
                        throw new Exception(ImportErrors.NO_SEPERATOR.toDefMsg());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)MessageFormat.format(ImportErrors.PARSE_MAP_FILE_FAILED.toDefMsg(), mappingFile));
                this.logger.error((Object)ImportErrors.MAPPING_FILE_NOT_PARSED.toDefMsg(), (Throwable)e);
                throw new ARImportException(e);
            }
        }
        return result;
    }

    protected void printUsage() {
        System.out.println("Command Line Options:");
        System.out.println("    -u <user>          : Required login parameter that identifies the user account. ");
        System.out.println("    -p <password>      : Optional login parameter that identifies the password. Omit the option if the user account has no password.");
        System.out.println("    -x <servername>    : Login parameter that specifies the server to log in to. This option overrides the server specified in the mapping. If this option is not specified, the server name in the mapping is used.");
        System.out.println("    -w <authenticator> : Name of an external authentication string or Windows NT domain. This is related to the Login window Authentication field, which is discussed in the Configuring guide.");
        System.out.println("    -r <programnumber> : RPC program number. Private server, for example, if a dedicated import server is available. If not specified, the default is the admin server 390600.");
        System.out.println("    -a <tcpport>       : TCP port number. Port number for the server. This value is especially important in a multiple server environment. The option also identifies a TCP specific port, if chosen.");
        System.out.println("    -l <logfile>       : Full path name of the log file. Use this option to log details of the import execution.");
        System.out.println("    -e <fieldids>      : Duplicate fields. IDs of the fields to check for duplicate data. For example, for the Short Description field, you would enter the value 8. By default, the Request ID field (field ID 1) is used when -e parameter is omitted. Multiple values can be specified by separatng them with commas (2,4,8)");
        System.out.println("    -n <option>        : Suppress filters. When the system is merging entries on forms, this command instructs arimportcmd to suppress the merge filters.");
        System.out.println("    -t <option>        : Multiple match option. Use when more than one entry matches. Enter a value of 3 to affect the first match, and a value of 5 to affect all matches.");
        System.out.println("    -o <filename>      : Data file name. Name of the file containing data to import. If specified, this option overrides the data file specified in the mapping. If not specified, the data file specified in the mapping is used.");
        System.out.println("    -o <directory>     : To use multithreaded data import tool use this option with directory name. All the files under this directory will be imported. All this data will be imported in the schema provided in the command. If mapping file is provided and data dir contains different types of files like .arx,.csv,.xml and .asc then this mapping file should be same for all these files. ");
        System.out.println("    -f <formnames>     : Destination form name. Name of the form to import into. If specified, this option overrides the form specified in the mapping. If not specified, the form specified in the mapping is used.");
        System.out.println("    -v <option>        : Forces override. If the user has logged in from a different IP address, this option tells the server to use the new IP address of the BMC Remedy Import client and invalidates the old IP address.");
        System.out.println("    -i <option>        : Suppress default values. If specified this option is specified import will ignore the default values of fields if the value in the data file is null or not supplied.\n\t\t\t    0 : Do not suppress default values for mapped fields, but ignore non-mapped fields.\n\t\t\t    1 : Suppress default values for mapped fields, but ignore non-mapped fields.\n\t\t\t    2 : Suppress default values for mapped fields, suppress default values for non-mapped fields by explicitly putting NULL value.\n\t\t\t    3 : Do not suppress default values for mapped fields, suppress default values for non-mapped fields by explicitly putting NULL value.");
        System.out.println("    -M <mappingfile>   : Full path name of mapping file. Required fully qualified path name of the mapping file to use.");
        System.out.println("    -D <option>        : Duplicate ID. Defines how to process records that contain request IDs, which duplicate those already in the form. With this option, you must include one of the following numbers:");
        System.out.println("                            0 : Generate new ID for all records");
        System.out.println("                            1 : Reject duplicate records");
        System.out.println("                            2 : Generate new ID for duplicate records");
        System.out.println("                            3 : Replace old record with new record ");
        System.out.println("                            4 : Update old record with new records data (the default)");
        System.out.println("                            5 : Reject duplicate records silently");
        System.out.println("    -q <option>        : Suppresses the required field property for non core fields.");
        System.out.println("    -c <option>        : Truncates character values longer than the field length for character fields.");
        System.out.println("    -h <option>        : Suppresses pattern matching for fields. If supplied the $PATTERN$ field limit is ignored");
        System.out.println("    -charset <name>    : Specifies the character set used in the data file. The character set name must be supplied as listed in the IANA Charset Registry");
        System.out.println("    -b <option>        : Sets the transaction size to use.");
        System.out.println("    -threads <PoolSize>: Sets the Maximum Thread Pool size. This is optional parameter, if not specified then it is set to default value 50");
        System.out.println("    -filelist <files>  : Comma separated list of files(report.arx,test.csv,data.xml). When -o option is data directory then only this option can be used else this is of no use. This is optional and takes precedence over -pattern.");
        System.out.println("    -pattern <string>  : Specifies a pattern for matching file names and import them using multiple threads. When -o option is data directory then only this option can be used else this is of no use. This is optional. ");
        System.out.println("    -custom            : Full path name of the XML file containing user-defined custom options for handling date/time values and real numbers. This is optional.");
        System.out.println("    -z                 : Full path name of the options XML file which contains data import commands with its own Data/File(Import) options. This is optional.");
        System.out.println("    -g <option>        : Forces the bulk transaction to be used with -e option, for which it is switched off by default. This is optional and a value of 1 means enabled.");
        System.out.println("    -og <OverlayGroup> : Sets the Overlay Group. This is optional parameter, if not specified then it is set to default(No overlay group)");
        System.out.println("");
        System.out.println("    -ca <ConsoleAppender> : Turns on(0)/off(1) console appender. This is optional parameter, if not specified then it is set to default(0 : Turn on console appender). This parameter will be applicable only for command line execution of Import Tool.");
        System.out.println("");
        System.out.println("Usage - WITH MAPPING FILE: arimportcmd -x server -u user -p password -M mappingfile -o datafile -f targetform -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username and Password are required.");
        System.out.println("");
        System.out.println("Usage - WITHOUT MAPPING FILE: arimportcmd -x server -u user -p password -o datafile -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username, Password, Server, Datafile  are required.");
        System.out.println("");
        System.out.println("Usage - Multi Threaded Data Import WITH MAPPING FILE: arimportcmd -x server -u user -p password -M mappingfile -o datadir -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues -threads poolSize -filelist files");
        System.out.println("    Values for Username, Password, Datadir  are required. Mapping file should be same for all the data files inside datadir");
        System.out.println("");
        System.out.println("Usage - Multi Threaded Data Import WITHOUT MAPPING FILE: arimportcmd -x server -u user -p password -o datadir -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues -threads poolSize -filelist files");
        System.out.println("    Values for Username, Password, Server, Datadir  are required.");
    }

    public ImportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ImportOptions options) {
        this.options = options;
    }

    protected void initLogging(String fileName, Level level, boolean isConsoleAppenderOff) {
        this.logger.setLevel(level);
        PatternLayout layout = null;
        layout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p [%t] %C (%F:%L) - %m%n") : new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p - %m%n");
        if (fileName != null && fileName.length() > 0) {
            try {
                FileAppender fileAppender = null;
                try {
                    fileAppender = this.commandLine ? new FileAppender((Layout)layout, fileName, false) : new FileAppender((Layout)layout, fileName, true);
                }
                catch (IOException e) {
                    ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
                    this.logger.addAppender((Appender)consoleAppender);
                    this.logger.info((Object)"Unable to create specified log file, import will continue");
                    this.logger.removeAllAppenders();
                    this.logger.setLevel(Level.OFF);
                }
                if (fileAppender != null) {
                    fileAppender.setName("ARIMPORT_FILE_APPENDER");
                    fileAppender.setAppend(true);
                    Util.getInstance().setFileAppender(fileAppender);
                    this.logger.removeAllAppenders();
                    this.logger.addAppender((Appender)fileAppender);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.commandLine && !isConsoleAppenderOff) {
            this.logger.addAppender((Appender)new ConsoleAppender((Layout)layout));
        }
        if (!this.commandLine) {
            this.importToolEntryTime = new Date();
            boolean addConsole = true;
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Object nextElement = allAppenders.nextElement();
                if (!(nextElement instanceof ConsoleAppender)) continue;
                addConsole = false;
                break;
            }
            if (addConsole) {
                allAppenders = null;
                Enumeration currentLogger = LogManager.getLoggerRepository().getCurrentLoggers();
                if (currentLogger != null) {
                    block5: while (currentLogger.hasMoreElements()) {
                        Logger loggerElement = (Logger)currentLogger.nextElement();
                        allAppenders = loggerElement.getAllAppenders();
                        while (allAppenders.hasMoreElements()) {
                            Object appenderElement = allAppenders.nextElement();
                            if (!(appenderElement instanceof ConsoleAppender)) continue;
                            ((ConsoleAppender)appenderElement).setThreshold((Priority)Level.OFF);
                            addConsole = false;
                            continue block5;
                        }
                    }
                }
            }
            if (addConsole && !isConsoleAppenderOff) {
                this.logger.addAppender((Appender)new ConsoleAppender((Layout)layout));
            }
        }
        this.setLogInitialized(true);
        this.logger.info((Object)("AR System Import Tool 9.0 build001 " + this.simpleDateFormater.format(this.importToolEntryTime)));
    }

    public void addParseListener(IParseListener listener) {
        if (this.parseListeners == null) {
            this.parseListeners = new HashSet<IParseListener>();
        }
        this.parseListeners.add(listener);
    }

    public void removeParseListener(IParseListener listener) {
        if (this.parseListeners != null) {
            this.parseListeners.remove(listener);
        }
    }

    public void clearParseListeners() {
        if (this.parseListeners != null) {
            this.parseListeners.clear();
        }
    }

    public Set<IParseListener> getParseListeners() {
        return this.parseListeners;
    }

    public void validateOptions() throws ARImportException {
        File file;
        if (!this.options.isMultiThreaded() && this.getOptions().getFileOptions().getDataFile() == null) {
            throw new ARImportException(ImportErrors.DATA_FILE_NOT_AVAILABLE.toDefMsg());
        }
        if (!this.options.isMultiThreaded() && this.getOptions().getFileOptions().getDataFile().length() == 0) {
            throw new ARImportException(ImportErrors.DATA_FILE_NOT_AVAILABLE.toDefMsg());
        }
        if (!(this.options.isMultiThreaded() || (file = new File(this.getOptions().getFileOptions().getDataFile())).exists() && file.exists())) {
            throw new ARImportException(MessageFormat.format(ImportErrors.DATA_FILE_NOT_EXISTS.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
        }
        if (!this.options.isMultiThreaded() && this.getOptions().getFileOptions().getType() == null) {
            throw new ARImportException(MessageFormat.format(ImportErrors.UNKNOWN_DATA_FILE.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
        }
        if (this.getOptions().getContext().getServer() == null || this.getOptions().getContext().getServer().length() == 0) {
            throw new ARImportException(ImportErrors.SERVER_NOT_SPECIFIED.toDefMsg());
        }
        if (this.getOptions().getContext().getUser() == null || this.getOptions().getContext().getUser().length() == 0) {
            throw new ARImportException(ImportErrors.USER_NOT_SPECIFIED.toDefMsg());
        }
    }

    public Logger createLogger(String logFileName, Level level, PatternLayout layout) {
        if (logFileName == null || logFileName.length() < 0) {
            return null;
        }
        Logger logger = Logger.getLogger((String)logFileName);
        logger.setLevel(level);
        if (layout == null) {
            layout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p [%t] %C (%F:%L) - %m%n") : new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p - %m%n");
        }
        if (logFileName != null && logFileName.length() > 0) {
            try {
                FileAppender fileAppender = new FileAppender((Layout)layout, logFileName, false);
                fileAppender.setName("ARIMPORT_FILE_APPENDER");
                fileAppender.setAppend(true);
                Util.getInstance().setFileAppender(fileAppender);
                logger.removeAllAppenders();
                logger.addAppender((Appender)fileAppender);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("AR System Import Tool 9.0 build001 " + this.simpleDateFormater.format(new Date())));
        return logger;
    }

    private String getValue(String argument, String[] args, int index) throws ARImportException {
        if (args.length <= index) {
            throw new ARImportException(MessageFormat.format(ImportErrors.INAVLID_PARAMETER_VALUE.toDefMsg(), argument));
        }
        return args[index];
    }

    class ASCIIFilter
    implements FilenameFilter {
        ASCIIFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".asc");
        }
    }

    class XMLFilter
    implements FilenameFilter {
        XMLFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".xml");
        }
    }

    class CSVFilter
    implements FilenameFilter {
        CSVFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".csv");
        }
    }

    class ARXFilter
    implements FilenameFilter {
        ARXFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".arx");
        }
    }

    class PatternFilter
    implements FilenameFilter {
        String filePattern = null;

        public PatternFilter(String filePattern) {
            this.filePattern = filePattern;
        }

        @Override
        public boolean accept(File dir, String name) {
            return Pattern.matches(this.filePattern, name);
        }
    }
}

