/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARBulkException;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.EntryFactory;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class BaseImporter
extends BaseObject
implements Callable<ImportOptions> {
    public static final String DATA_FILE_FORM = "ARImport_Data_Holder";
    protected ImportOptions options;
    private IParser parser;
    private EntryFactory entryFactory = null;
    private FormInformation sourceForm = null;
    private FormInformation targetForm = null;
    private String currentSource = null;
    private IParseListener listener;
    private int transactionCount = 0;
    private boolean inTransaction = false;
    private boolean processDataSet = true;
    private String lastId = "";
    private ARServerUser context;
    private DataOptions dataOptions;
    private int mergeOption;
    private final LinkedHashMap<Integer, Entry> entryList = new LinkedHashMap();
    private LinkedList<List<String>> tokenList = new LinkedList();
    private LinkedList<String> lineList = new LinkedList();
    private boolean isBulkCompatible = false;
    private boolean useBulk = false;
    private boolean isCompatibleServer = false;
    public SimpleDateFormat simpleDateFormater = new SimpleDateFormat("MMM d, yyyy HH:mm:ss.S");
    public Date importStartTime;
    public Date importEndTime;
    private int serverMajorVersion;
    private int serverMinorVersion;
    private String serverPatchString;

    public boolean isUseBulk() {
        return this.useBulk;
    }

    public void setUseBulk(boolean useBulk) {
        this.useBulk = useBulk;
    }

    public boolean isBulkCompatible() {
        return this.isBulkCompatible;
    }

    public void setBulkCompatible(boolean isBulkCompatible) {
        this.isBulkCompatible = isBulkCompatible;
    }

    public String getServerPatchString() {
        return this.serverPatchString;
    }

    public void setServerPatchString(String serverPatchString) {
        this.serverPatchString = serverPatchString;
    }

    public int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    public void setServerMajorVersion(int serverMajorVersion) {
        this.serverMajorVersion = serverMajorVersion;
    }

    public int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    public void setServerMinorVersion(int serverMinorVersion) {
        this.serverMinorVersion = serverMinorVersion;
    }

    public boolean isCompatibleServer() {
        return this.isCompatibleServer;
    }

    public void setCompatibleServer(boolean isCompatibleServer) {
        this.isCompatibleServer = isCompatibleServer;
    }

    @Override
    public ImportOptions call() {
        Logger logger = this.options.getLoggersList().get(this.options.getLogFile());
        if (logger == null) {
            logger = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
        }
        ThreadLocalStorage.setLogger(logger);
        try {
            this.startImport();
            String tmpRIK = System.getProperty("isRik");
            if (tmpRIK != null && tmpRIK.trim().equalsIgnoreCase("1")) {
                logger.info((Object)MessageFormat.format(ImportErrors.TOTAL_IMPORT_SUCCESS.toDefMsg(), this.getOptions().getResults().getSuccessCount()));
                logger.info((Object)MessageFormat.format(ImportErrors.TOTAL_IMPORT_FAILURE.toDefMsg(), this.getOptions().getResults().getErrorCount() + this.getOptions().getResults().getSkipCount()));
            }
        }
        catch (ARImportException eARI) {
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), eARI), (Throwable)eARI);
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_OPENED.toDefMsg(), this.options.getFileOptions().getDataFile(), fnfe), (Throwable)fnfe);
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), e), (Throwable)e);
        }
        return this.options;
    }

    public BaseImporter(ImportOptions options) throws ARImportException {
        this.options = options;
        this.context = options.getContext();
        this.dataOptions = options.getDataOptions();
        this.setBulkCompatible(this.calculateBulkCompatibility());
        this.setCompatibleServer(this.isMergeWithQualAvailable());
        this.setUseBulk(this.makeBulkDecision());
        this.mergeOption = this.calculateMergeOption(this.dataOptions.getDuplicateIdHandling().getMergeOption());
        this.createParser();
        this.createListener();
    }

    protected boolean calculateBulkCompatibility() {
        this.setServerMajorVersion(this.context.getServerVersionMajor());
        this.setServerMinorVersion(this.context.getServerVersionMinor());
        this.setServerPatchString(this.context.getServerVersionPatch());
        return this.getServerMajorVersion() >= 7 && (this.getServerMajorVersion() >= 8 || this.getServerMinorVersion() > 0);
    }

    protected abstract IParser createParser() throws ARImportException;

    protected void createListener() {
        this.listener = new IParseListener(){

            @Override
            public void handleEvent(ParseEvent event) throws ARImportException, ARException {
                Logger logger = ThreadLocalStorage.getLogger();
                try {
                    switch (event.getType()) {
                        case 0: {
                            if (!BaseImporter.this.entryList.isEmpty()) {
                                if (BaseImporter.this.getTargetForm() != null) {
                                    BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.entryList.size());
                                }
                                if (BaseImporter.this.isUseBulk()) {
                                    BaseImporter.this.bulkImportEntry(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                                } else {
                                    BaseImporter.this.importEntries(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                                }
                            }
                            if (event.getData() != null && BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.importEndTime = new Date();
                                double importTime = BaseImporter.this.importEndTime.getTime() - BaseImporter.this.importStartTime.getTime();
                                BaseImporter.this.importStartTime = BaseImporter.this.importEndTime;
                                importTime /= 1000.0;
                                if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_STATUS.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), importTime, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                                } else {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_COMPLTED.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), importTime, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                                }
                            }
                            BaseImporter.this.handleNewFormEvent((FormInformation)event.getData());
                            break;
                        }
                        case 1: {
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.getOptions().getResults().incrementRecordCount(BaseImporter.this.getTargetForm().getName());
                            }
                            BaseImporter.this.handleDataEvent((List)event.getData(), event.getLine());
                            if (BaseImporter.this.entryList.isEmpty() || BaseImporter.this.entryList.size() < BaseImporter.this.options.getDataOptions().getTransactionSize()) break;
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.entryList.size());
                            }
                            if (BaseImporter.this.isUseBulk()) {
                                BaseImporter.this.bulkImportEntry(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                                break;
                            }
                            BaseImporter.this.importEntries(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                            break;
                        }
                        case 2: {
                            if (!BaseImporter.this.entryList.isEmpty()) {
                                if (BaseImporter.this.getTargetForm() != null) {
                                    BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.entryList.size());
                                }
                                if (BaseImporter.this.isUseBulk()) {
                                    BaseImporter.this.bulkImportEntry(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                                } else {
                                    BaseImporter.this.importEntries(BaseImporter.this.tokenList, BaseImporter.this.lineList);
                                }
                            }
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.importEndTime = new Date();
                                double importTime = BaseImporter.this.importEndTime.getTime() - BaseImporter.this.importStartTime.getTime();
                                importTime /= 1000.0;
                                if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_STATUS.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), importTime, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                                } else {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_COMPLTED.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), importTime, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                                }
                            }
                            BaseImporter.this.handleEndEvent();
                            break;
                        }
                        case 3: {
                            BaseImporter.this.handleTitlesEvent((List)event.getData());
                            break;
                        }
                        case 4: {
                            BaseImporter.this.handleStartTransaction();
                            break;
                        }
                        case 5: {
                            BaseImporter.this.handleEndTransaction(1);
                            break;
                        }
                        case 6: {
                            BaseImporter.this.handleEndTransaction(2);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                        logger.error((Object)MessageFormat.format(ImportErrors.OUTOFMEM_ERROR2.toDefMsg(), BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                    } else {
                        logger.error((Object)MessageFormat.format(ImportErrors.OUTOFMEM_ERROR1.toDefMsg(), BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                    }
                    throw e;
                }
            }

            @Override
            public boolean isAbort() {
                return false;
            }
        };
        if (this.parser != null) {
            this.parser.addListener(this.listener);
        }
    }

    protected List<BulkEntryReturn> handleEndTransaction(int action) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        List statusInfo = null;
        if (this.inTransaction) {
            this.inTransaction = false;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)ImportErrors.END_BULK_TRANSACTION.toDefMsg());
            }
            statusInfo = this.options.getContext().endBulkEntryTransaction(action);
        }
        return statusInfo;
    }

    protected void handleStartTransaction() throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            if (this.options.getDataOptions().getTransactionSize() > 1) {
                this.transactionCount = 0;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)ImportErrors.START_BULK_TRANSACTION.toDefMsg());
                }
                this.options.getContext().beginBulkEntryTransaction();
                this.inTransaction = true;
            }
        }
        catch (ARException e) {
            logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), "beginBulkEntryTransaction"));
            throw new ARImportException(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), e);
        }
    }

    protected void handleTitlesEvent(List<String> name) throws ARException, ARImportException {
    }

    protected List<BulkEntryReturn> handleEndEvent() throws ARException {
        List<BulkEntryReturn> statusInfo = null;
        if (this.inTransaction) {
            statusInfo = this.handleEndTransaction(1);
        }
        return statusInfo;
    }

    protected void handleDataEvent(List<String> tokens, String line) throws ARImportException, ARException {
        if (this.getParser().isAbort()) {
            if (this.getParser().isCopyToLog()) {
                Util.logEntry(line);
            }
        } else if (this.isProcessDataSet()) {
            this.createEntry(tokens, line);
        }
    }

    protected void handleNewFormEvent(FormInformation formInfo) throws ARImportException, ARException {
    }

    public ImportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ImportOptions options) {
        this.options = options;
    }

    public abstract void startImport() throws ARImportException, IOException, ARException;

    protected void importEntry(FormInformation targetForm, Entry entry) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.dataOptions.getDuplicateFields() != null && this.dataOptions.getDuplicateFields().size() > 0) {
            QualifierInfo qualInfo = this.buildDuplicateQualifier(entry, this.dataOptions.getDuplicateFields());
            if (this.isCompatibleServer() && this.dataOptions.getMultiMatch().equals((Object)DataOptions.MultiMatch.USEFIRST)) {
                this.importEntry(targetForm, entry, qualInfo);
            } else if (qualInfo != null) {
                ArrayList<EntryListFieldInfo> entryListFieldInfo = new ArrayList<EntryListFieldInfo>(1);
                entryListFieldInfo.add(new EntryListFieldInfo(1));
                int maxRetrieve = 0;
                if (this.dataOptions.getMultiMatch() == DataOptions.MultiMatch.USEFIRST) {
                    maxRetrieve = 1;
                }
                List duplicates = null;
                try {
                    duplicates = this.context.getListEntry(targetForm.getName(), qualInfo, 0, maxRetrieve, null, entryListFieldInfo, false, null);
                }
                catch (ARException e) {
                    // empty catch block
                }
                if (duplicates != null && !duplicates.isEmpty()) {
                    if (this.dataOptions.getMultiMatch() == DataOptions.MultiMatch.SKIP) {
                        logger.info((Object)MessageFormat.format(ImportErrors.DUPLICATE_RECORDES_FOUND.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName())));
                        this.getOptions().getResults().incrementSkipCount(this.getTargetForm().getName(), false);
                    } else {
                        for (EntryListInfo info : duplicates) {
                            entry.setEntryId(info.getEntryID());
                            this.lastId = this.context.mergeEntry(targetForm.getName(), entry, this.mergeOption);
                            if (this.getEntryFactory() != null) {
                                this.getEntryFactory().setLastId(this.lastId);
                            }
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.lastId));
                        }
                    }
                } else {
                    if (this.dataOptions.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                        entry.remove((Object)1);
                    } else {
                        this.mergeOption = this.calculateMergeOption(2);
                    }
                    int cloneOfMergeOption = this.mergeOption;
                    this.mergeOption = this.calculateMergeOption(this.dataOptions.getDuplicateIdHandling().getMergeOption());
                    this.lastId = this.context.mergeEntry(targetForm.getName(), entry, cloneOfMergeOption);
                    if (this.getEntryFactory() != null) {
                        this.getEntryFactory().setLastId(this.lastId);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.lastId));
                    }
                }
            } else {
                if (this.dataOptions.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                    entry.remove((Object)1);
                }
                this.lastId = this.context.mergeEntry(targetForm.getName(), entry, this.mergeOption);
                if (this.getEntryFactory() != null) {
                    this.getEntryFactory().setLastId(this.lastId);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.lastId));
                }
            }
        } else {
            if (this.dataOptions.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                entry.remove((Object)1);
            }
            this.lastId = this.context.mergeEntry(targetForm.getName(), entry, this.mergeOption);
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setLastId(this.lastId);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.lastId));
            }
        }
    }

    protected void importEntry(FormInformation targetForm, Entry entry, QualifierInfo qualInfo) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            if (entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                entry.remove((Object)1);
            }
            this.lastId = this.context.mergeEntry(targetForm.getName(), entry, this.mergeOption, qualInfo, 1);
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setLastId(this.lastId);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.lastId));
            }
        }
        catch (ARException e) {
            StatusInfo[] arStatus = e.getLastStatus().toArray(new StatusInfo[0]);
            long thisMsgNum = arStatus[0].getMessageNum();
            if (288L == thisMsgNum) {
                this.setCompatibleServer(false);
                this.importEntry(targetForm, entry);
            }
            throw e;
        }
    }

    private int calculateMergeOption(int initialValue) {
        Logger logger = ThreadLocalStorage.getLogger();
        int mergeOption = initialValue;
        if (this.options.getDataOptions().isDisablePattern()) {
            mergeOption |= 0x800;
        }
        if (this.options.getDataOptions().isDisableRequired()) {
            mergeOption |= 0x400;
        }
        if (this.options.getDataOptions().isSuppressFilters()) {
            try {
                if (this.getOptions().getContext() != null && this.getOptions().getContext().isAdministrator()) {
                    mergeOption |= 0x1000;
                }
            }
            catch (ARException e) {
                logger.error((Object)ImportErrors.USER_NOT_DETERMINED.toDefMsg(), (Throwable)e);
            }
        }
        if (this.options.getDataOptions().isSuppressAssociations()) {
            try {
                if (this.getOptions().getContext() != null && this.getOptions().getContext().isAdministrator()) {
                    mergeOption |= 0x2000;
                }
            }
            catch (ARException e) {
                logger.error((Object)ImportErrors.USER_NOT_DETERMINED.toDefMsg(), (Throwable)e);
            }
        }
        return mergeOption;
    }

    private QualifierInfo buildDuplicateQualifier(Entry entry, List<Integer> duplicateFields) {
        QualifierInfo result = null;
        if (duplicateFields != null && duplicateFields.size() > 0) {
            ArrayList<QualifierInfo> qualList = new ArrayList<QualifierInfo>(duplicateFields.size());
            for (Integer integer : duplicateFields) {
                Value value = (Value)entry.get((Object)integer);
                if (value == null) continue;
                RelationalOperationInfo relOp = new RelationalOperationInfo();
                relOp.setOperation(1);
                relOp.setLeftOperand(new ArithmeticOrRelationalOperand(integer.intValue()));
                relOp.setRightOperand(new ArithmeticOrRelationalOperand(value));
                QualifierInfo qualInfo = new QualifierInfo(relOp);
                qualList.add(qualInfo);
            }
            if (!qualList.isEmpty()) {
                int size = qualList.size();
                if (size == 1) {
                    return (QualifierInfo)qualList.get(0);
                }
                result = new QualifierInfo(1, (QualifierInfo)qualList.get(0), null);
                if (size == 2) {
                    result.setRightOperand((QualifierInfo)qualList.get(1));
                } else {
                    for (int qualLoop = 1; qualLoop < size; ++qualLoop) {
                        if (qualLoop + 1 < size) {
                            result.setRightOperand((QualifierInfo)qualList.get(qualLoop));
                            result = new QualifierInfo(1, result, null);
                            continue;
                        }
                        result.setRightOperand((QualifierInfo)qualList.get(qualLoop));
                    }
                }
            }
        }
        return result;
    }

    protected void verifyCoreFields(FormInformation targetForm, Entry entry) {
    }

    public EntryFactory getEntryFactory() {
        return this.entryFactory;
    }

    public void setEntryFactory(EntryFactory entryFactory) {
        this.entryFactory = entryFactory;
    }

    protected void createEntry(List<String> tokens, String line) throws ARImportException, ARException, NullPointerException {
        if (this.getEntryFactory() == null) {
            this.setEntryFactory(new EntryFactory(this.getParser(), this.options, this.getSourceForm(), this.getTargetForm()));
        }
        Entry entry = null;
        try {
            entry = this.getEntryFactory().createEntry(tokens, line);
            if (entry != null) {
                this.entryList.put(this.options.getResults().getRecordCount(this.getTargetForm().getName()), entry);
                this.tokenList.add(tokens);
                this.lineList.add(line);
            }
        }
        catch (Throwable e) {
            this.handleException(e, tokens, line, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFallback(List<String> tokens, ArrayList<Integer> fieldids, Entry backupEntry, ArrayList<Integer> fallbackIDs, String line) throws ARException, ARImportException, NullPointerException {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions maps = this.options.getMappingOptions(this.sourceForm.getName(), this.targetForm.getName());
        if (maps == null) {
            maps = this.options.getMappingOptions(DATA_FILE_FORM, this.targetForm.getName());
        }
        if (maps == null) {
            throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
        }
        for (int i = 0; i < fieldids.size(); ++i) {
            if (!this.isFallback(fieldids.get(i), fallbackIDs)) continue;
            fallbackIDs.remove(fieldids.get(i));
            this.getEntryFactory().applyFallbackMappings(maps, this.sourceForm, this.targetForm, tokens, fieldids.get(i));
            Mapping mapping = maps.getFallbacks().get(fieldids.get(i));
            if (mapping == null) {
                throw new NullPointerException(ImportErrors.NO_MAPPING_FOUND.toDefMsg() + fieldids.get(i));
            }
            FieldInformation targetFieldInfo = this.targetForm.getFields().get(fieldids.get(i));
            if (targetFieldInfo == null) {
                throw new NullPointerException("Field id " + fieldids.get(i) + "does not exist on schema: " + this.targetForm.getName());
            }
            Converter converter = new Converter(this.options);
            if (targetFieldInfo.getDataType() == null) continue;
            if (mapping.getType() == Mapping.Type.CONSTANT) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_CONSTANT.toDefMsg(), targetFieldInfo.getFieldId(), mapping));
                }
                backupEntry.put(Integer.valueOf(targetFieldInfo.getFieldId()), new Value(mapping.getConstant()));
                continue;
            }
            if (mapping.getType() == Mapping.Type.COMPOUND) {
                Value value = converter.convertToARValue(targetFieldInfo, mapping.getCompoundValue());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), targetFieldInfo.getFieldId(), value, mapping));
                }
                backupEntry.put(Integer.valueOf(targetFieldInfo.getFieldId()), value);
                continue;
            }
            if (mapping.getType() == Mapping.Type.KEYWORD) {
                Value value = converter.getKeywordValue(targetFieldInfo, mapping);
                backupEntry.put(Integer.valueOf(targetFieldInfo.getFieldId()), value);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), targetFieldInfo.getFieldId(), value, mapping));
                continue;
            }
            int index = mapping.getTokenIndex();
            if (index <= -1 || index > tokens.size() - 1) continue;
            String token = tokens.get(index);
            Value value = converter.convertToARValue(targetFieldInfo, token);
            backupEntry.put(Integer.valueOf(targetFieldInfo.getFieldId()), value);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), targetFieldInfo.getFieldId(), value, mapping));
        }
        try {
            this.importEntry(this.targetForm, backupEntry);
            List lastStatus = this.getOptions().getContext().getLastStatus();
            if (lastStatus != null && lastStatus.size() > 0) {
                if (((StatusInfo)lastStatus.get(0)).getMessageType() == 1) {
                    if (this.getSourceForm() == null || this.getTargetForm() == null) throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
                    this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                    logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName())));
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                    return;
                } else {
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                }
                return;
            } else {
                this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
            }
            return;
        }
        catch (ARException are) {
            fieldids.clear();
            StatusInfo[] arStatus = are.getLastStatus().toArray(new StatusInfo[0]);
            for (int j = 0; j < arStatus.length; ++j) {
                long thisMsgNum = arStatus[j].getMessageNum();
                String str = arStatus[j].getAppendedText();
                String[] str1 = str.split(" ");
                for (int k = 0; k < str1.length; ++k) {
                    try {
                        fieldids.add(Integer.parseInt(str1[k]));
                        continue;
                    }
                    catch (Exception ecc) {
                        // empty catch block
                    }
                }
                if (380L != thisMsgNum) continue;
                logger.info((Object)MessageFormat.format(ImportErrors.AR_ERROR_FILTER_REF_NO_MATCH_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), are.getMessage(), System.getProperty("line.separator"), line));
                return;
            }
            if (this.isFallback(fieldids.get(0), fallbackIDs)) {
                this.doFallback(tokens, fieldids, backupEntry, fallbackIDs, line);
                return;
            }
            this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), are.getMessage(), line));
        }
    }

    protected String getCurrentSource() {
        return this.currentSource;
    }

    protected void setCurrentSource(String currentSource) {
        this.currentSource = currentSource;
    }

    protected FormInformation getSourceForm() {
        if (this.sourceForm == null) {
            this.sourceForm = this.options.getFirstFileForm();
        }
        return this.sourceForm;
    }

    protected void setSourceForm(FormInformation sourceForm) {
        this.sourceForm = sourceForm;
    }

    protected FormInformation getTargetForm() throws ARException {
        return this.targetForm;
    }

    protected void setTargetForm(FormInformation targetForm) {
        this.targetForm = targetForm;
    }

    public IParser getParser() throws ARImportException {
        if (this.parser == null) {
            this.parser = this.createParser();
            this.createListener();
        }
        return this.parser;
    }

    protected boolean isProcessDataSet() {
        return this.processDataSet;
    }

    protected void setProcessDataSet(boolean processDataSet) {
        this.processDataSet = processDataSet;
    }

    protected boolean isFallback(Integer efieldID, ArrayList<Integer> fallbackIDs) {
        for (int i = 0; i < fallbackIDs.size(); ++i) {
            if (!fallbackIDs.get(i).equals(efieldID)) continue;
            return true;
        }
        return false;
    }

    protected void handleException(Throwable e, List<String> tokens, String line, Entry backupEntry) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        boolean isError338 = false;
        ArrayList<Integer> fieldids = new ArrayList<Integer>();
        boolean isSkipError = false;
        if (e instanceof ARException) {
            if (this.getOptions().getDataOptions().getDuplicateIdHandling() == DataOptions.DuplicateHandling.DUP_ERROR && this.getOptions().getDataOptions().isSkipDuplicate()) {
                ARException exc = (ARException)e;
                for (StatusInfo status : exc.getLastStatus()) {
                    if (status.getMessageNum() != 338L) continue;
                    isError338 = true;
                    break;
                }
            }
            ARException eAR = (ARException)e;
            StatusInfo[] arStatus = eAR.getLastStatus().toArray(new StatusInfo[0]);
            for (int j = 0; j < arStatus.length; ++j) {
                long thisMsgNum = arStatus[j].getMessageNum();
                String str = arStatus[j].getAppendedText();
                if (str != null) {
                    String[] str1 = str.split(" ");
                    for (int k = 0; k < str1.length; ++k) {
                        try {
                            fieldids.add(Integer.parseInt(str1[k]));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                }
                if (380L == thisMsgNum) {
                    logger.error((Object)MessageFormat.format(ImportErrors.AR_ERROR_FILTER_REF_NO_MATCH_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                    return;
                }
                if (338L != thisMsgNum) continue;
                isSkipError = true;
                this.getOptions().getResults().incrementSkipCount(this.getTargetForm().getName(), true);
            }
            if (!isSkipError && this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.FALLBACK) {
                this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), line));
            }
        } else {
            this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), line));
            logger.error((Object)ImportErrors.EXCEPTION_ENCOUNTERED.toDefMsg(), e);
        }
        if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.FALLBACK && backupEntry != null) {
            try {
                MappingOptions maps = this.options.getMappingOptions(this.sourceForm.getName(), this.targetForm.getName());
                if (maps == null) {
                    maps = this.options.getMappingOptions(DATA_FILE_FORM, this.targetForm.getName());
                }
                if (maps == null) {
                    throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
                }
                Object[] fallbackIDso = maps.getFallbacks().keySet().toArray();
                ArrayList<Integer> fallbackIDs = new ArrayList<Integer>();
                for (int i = 0; i < fallbackIDso.length; ++i) {
                    fallbackIDs.add((Integer)fallbackIDso[i]);
                }
                this.doFallback(tokens, fieldids, backupEntry, fallbackIDs, line);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.STOP) {
                if (isSkipError) {
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                    logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE.toDefMsg());
                } else {
                    logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                    logger.error((Object)ImportErrors.STOP_ON_FIRST_FAILURE.toDefMsg());
                }
                throw new ARImportException(e);
            }
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.SKIP) {
                if (isError338) {
                    logger.info((Object)MessageFormat.format(ImportErrors.SKIP_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), this.getTargetForm().getName()));
                } else if (isSkipError) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                } else if (this.getOptions().getDataOptions().getDuplicateIdHandling() == DataOptions.DuplicateHandling.DUP_ERROR && this.getOptions().getDataOptions().isSkipDuplicate()) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), ""));
                } else {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                }
            } else if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER && this.options.getUserAlertListener() != null) {
                int userChoice = this.options.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), line, e.getMessage());
                switch (userChoice) {
                    case 0: {
                        if (isSkipError) {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                        } else {
                            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                            logger.error((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                        }
                        this.getParser().setAbort(true);
                        this.handleEndTransaction(2);
                        break;
                    }
                    case 2: {
                        if (isSkipError) {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                        } else {
                            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line));
                            logger.error((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                        }
                        this.getParser().setAbort(true);
                        this.getParser().setCopyToLog(true);
                        this.handleEndTransaction(2);
                        break;
                    }
                    default: {
                        String message = MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), e.getMessage(), System.getProperty("line.separator"), line);
                        if (isSkipError) {
                            logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                            logger.info((Object)message);
                            break;
                        }
                        logger.error((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                        logger.error((Object)message);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importEntries(LinkedList<List<String>> tokenList, LinkedList<String> lineList) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        int size = this.entryList.size();
        Entry entry = null;
        List<String> tokens = null;
        String line = null;
        Iterator<Integer> rowItr = this.entryList.keySet().iterator();
        int recordNumber = -1;
        for (int i = 0; i < size; ++i) {
            try {
                line = lineList.removeFirst();
                if (this.getParser().isAbort()) {
                    if (!this.getParser().isCopyToLog()) continue;
                    Util.logEntry(line);
                    continue;
                }
                recordNumber = rowItr.next();
                entry = this.entryList.get(recordNumber);
                tokens = tokenList.removeFirst();
                rowItr.remove();
                if (this.getTargetForm() != null) {
                    this.getOptions().getResults().incrementRecordCount(this.getTargetForm().getName());
                    this.getOptions().getResults().setCurrentRecordNumber(this.getTargetForm().getName(), recordNumber);
                }
                this.importEntry(this.getTargetForm(), entry);
                ++this.transactionCount;
                List lastStatus = this.getOptions().getContext().getLastStatus();
                if (lastStatus != null && lastStatus.size() > 0) {
                    if (((StatusInfo)lastStatus.get(0)).getMessageType() == 1) {
                        if (this.getSourceForm() != null && this.getTargetForm() != null) {
                            this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                            logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.getTargetForm().getName())));
                            this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                            continue;
                        }
                        throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
                    }
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                    continue;
                }
                this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                continue;
            }
            catch (Exception e) {
                if (tokens == null || entry == null) {
                    throw new ARImportException(e);
                }
                this.handleException(e, tokens, line, entry);
                continue;
            }
            finally {
                if (this.getTargetForm() != null) {
                    this.getOptions().getResults().setCurrentRecordNumber(this.getTargetForm().getName(), -1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bulkImportEntry(LinkedList<List<String>> tokenList, LinkedList<String> lineList) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        List<BulkEntryReturn> statusInfo = null;
        int size = this.entryList.size();
        Entry entry = null;
        try {
            this.handleStartTransaction();
            for (int recordNumber : this.entryList.keySet()) {
                entry = this.entryList.get(recordNumber);
                if (this.getTargetForm() != null) {
                    this.getOptions().getResults().setCurrentRecordNumber(this.getTargetForm().getName(), recordNumber);
                }
                this.importEntry(this.getTargetForm(), entry);
                ++this.transactionCount;
            }
            statusInfo = this.handleEndEvent();
            this.checkLogStatus(statusInfo, size);
        }
        catch (ARBulkException arb) {
            List l1 = arb.getBulkEntryReturn();
            int lastWorkingIndex = l1.size() - 1;
            if (lastWorkingIndex >= 0) {
                BulkEntryReturn bulkStatus = (BulkEntryReturn)l1.get(lastWorkingIndex);
                logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), bulkStatus.getStatusList()));
            } else {
                logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), new Object[]{arb}));
            }
            try {
                if (lastWorkingIndex > 0) {
                    this.handleStartTransaction();
                    Iterator<Integer> rowItr = this.entryList.keySet().iterator();
                    for (int i = 0; i < lastWorkingIndex; ++i) {
                        entry = this.entryList.get(rowItr.next());
                        rowItr.remove();
                        tokenList.remove();
                        lineList.remove();
                        this.importEntry(this.getTargetForm(), entry);
                        ++this.transactionCount;
                    }
                    statusInfo = this.handleEndEvent();
                    this.checkLogStatus(statusInfo, lastWorkingIndex);
                }
                this.importEntries(tokenList, lineList);
            }
            catch (ARBulkException e) {
                StringBuilder failueMessage = new StringBuilder();
                List bulkFailures = e.getBulkEntryReturn();
                for (BulkEntryReturn failure : bulkFailures) {
                    List statusList = failure.getStatusList();
                    for (StatusInfo status : statusList) {
                        failueMessage.append("ERROR (" + status.getMessageNum() + ") : " + status.getMessageText() + ", " + status.getAppendedText() + ".;");
                    }
                }
                logger.error((Object)MessageFormat.format(ImportErrors.SECOND_ATTEMPT_BULK_TRANSACTION_FAILED.toDefMsg() + "[" + failueMessage.toString() + "]", new Object[]{e}), (Throwable)e);
                throw new ARImportException(ImportErrors.ERROR_IN_END_BULK_TRANSACTION_EXCEPTION.toDefMsg());
            }
        }
        catch (ARImportException e) {
            if (!this.inTransaction) {
                this.importEntries(tokenList, lineList);
            }
        }
        finally {
            this.entryList.clear();
            tokenList.clear();
            lineList.clear();
            if (this.getTargetForm() != null) {
                this.getOptions().getResults().setCurrentRecordNumber(this.getTargetForm().getName(), -1);
            }
        }
    }

    protected void checkLogStatus(List<BulkEntryReturn> statusInfo, int size) {
        Logger logger = ThreadLocalStorage.getLogger();
        if (statusInfo != null && statusInfo.size() != size) {
            logger.warn((Object)("Server has not returned expected number of entry status. [StatusInformation returned is : " + statusInfo.size() + "]"));
            size = statusInfo.size();
        }
        if (statusInfo != null && !statusInfo.isEmpty()) {
            for (int i = 0; i < size; ++i) {
                List lastStatus;
                if (this.targetForm != null) {
                    this.getOptions().getResults().incrementRecordCount(this.targetForm.getName());
                }
                if ((lastStatus = statusInfo.get(i).getStatusList()) != null && lastStatus.size() > 0) {
                    Iterator itr = lastStatus.iterator();
                    StringBuffer warnRes = null;
                    while (itr.hasNext()) {
                        StatusInfo statInfo = (StatusInfo)itr.next();
                        if (((StatusInfo)lastStatus.get(0)).getMessageType() != 1) continue;
                        if (warnRes == null) {
                            warnRes = new StringBuffer();
                        }
                        warnRes.append(statInfo.toString()).append(" ; ");
                    }
                    if (warnRes != null && this.sourceForm != null && this.targetForm != null) {
                        this.getOptions().getResults().addWarning(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getCurrentRecordNumber(this.targetForm.getName()), warnRes.toString(), null));
                        logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getCurrentRecordNumber(this.targetForm.getName()), warnRes.toString()));
                    }
                    this.getOptions().getResults().incrementSuccessCount(this.targetForm.getName());
                    continue;
                }
                this.getOptions().getResults().incrementSuccessCount(this.targetForm.getName());
            }
        } else {
            this.getOptions().getResults().incrementSuccessCount(this.targetForm.getName());
        }
    }

    private boolean isMergeWithQualAvailable() {
        if (this.getServerMajorVersion() > 7) {
            return true;
        }
        if (this.getServerMajorVersion() == 7 && this.getServerMinorVersion() >= 6) {
            if (this.getServerMinorVersion() == 6) {
                int buildVersion;
                String[] buildString;
                try {
                    buildString = this.getServerPatchString().toLowerCase().split("build");
                    buildVersion = Integer.parseInt(buildString[0].trim());
                }
                catch (Exception e) {
                    buildVersion = -1;
                    buildString = null;
                }
                if (buildVersion < 4) {
                    return false;
                }
                if (buildVersion == 4) {
                    int build;
                    try {
                        String[] builds = buildString[1].trim().split(" ");
                        build = Integer.parseInt(builds[0].trim());
                    }
                    catch (Exception e) {
                        build = -1;
                    }
                    if (build == 1) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean makeBulkDecision() {
        return this.isBulkCompatible() && this.options.getDataOptions().getTransactionSize() > 1 && (null == this.options.getDataOptions().getDuplicateFields() || this.options.getDataOptions().isForceBulk()) && this.isCompatibleServer() && !this.options.getDataOptions().getMultiMatch().equals((Object)DataOptions.MultiMatch.UPDATEALL);
    }
}

