/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ARDataImporter
extends BaseImporter {
    public ARDataImporter(ImportOptions options) throws ARImportException {
        super(options);
    }

    @Override
    protected void handleNewFormEvent(FormInformation formInfo) throws ARImportException, ARException {
        if (this.options.getDataOptions().getMultiDuplicateFields() != null) {
            this.options.getDataOptions().setDuplicateFields(this.options.getDataOptions().getDuplicateFieldsFormMultiMode(formInfo.getName()));
        }
        Logger logger = ThreadLocalStorage.getLogger();
        this.setSourceForm(formInfo);
        this.setProcessDataSet(true);
        logger.info((Object)MessageFormat.format(ImportErrors.NEW_FORM_FOUND.toDefMsg(), formInfo.getName()));
        String fileFormName = null;
        String destinationFormName = null;
        String sourceFormName = formInfo.getName();
        this.setTargetForm(null);
        if (!this.options.getFormMap().isEmpty()) {
            destinationFormName = this.options.getFormMap().get(sourceFormName);
            if (destinationFormName == null || destinationFormName != null && destinationFormName.length() == 0) {
                destinationFormName = this.options.getFormMap().get("ARImport_Data_Holder");
            }
            if (destinationFormName == null && (this.options.getFileOptions().getType().equals("ARX") || this.options.getFileOptions().getType().equals("XML"))) {
                Iterator<String> i$ = this.options.getFormMap().keySet().iterator();
                if (i$.hasNext()) {
                    String firstMappedForm;
                    fileFormName = firstMappedForm = i$.next();
                }
                if (!this.options.getFileForms().keySet().contains(fileFormName) && this.options.isImportAllDataSets()) {
                    destinationFormName = this.options.getFormMap().get(fileFormName);
                    logger.warn((Object)MessageFormat.format(ImportErrors.MAPPED_SOURCE_FORM_NOT_EXIST.toDefMsg(), fileFormName, sourceFormName, destinationFormName));
                    this.options.setImportAllDataSets(false);
                } else {
                    logger.info((Object)MessageFormat.format(ImportErrors.SKIP_UNMAPPED_DATA.toDefMsg(), sourceFormName));
                    this.setProcessDataSet(false);
                }
            }
        }
        if (destinationFormName != null) {
            try {
                this.setTargetForm(Util.getServerForm(this.options, destinationFormName));
                this.options.addServerForm(this.getTargetForm());
            }
            catch (ARException e) {
                throw new ARImportException(MessageFormat.format(ImportErrors.UNABLE_TO_RETRIEVE_DESTINATION_FORM.toDefMsg(), destinationFormName, this.options.getContext().getServer()), e);
            }
        }
        if (this.getTargetForm() == null && this.isProcessDataSet()) {
            if (this.options.isImportAllDataSets()) {
                this.options.addMappingOptions(sourceFormName, sourceFormName, null);
                FormInformation targetForm = null;
                try {
                    targetForm = Util.getServerForm(this.options, sourceFormName);
                    this.setTargetForm(targetForm);
                    this.options.addServerForm(this.getTargetForm());
                    destinationFormName = targetForm.getName();
                }
                catch (ARException e) {
                    String statusmessage = "";
                    if (e.getLastStatus() != null && !e.getLastStatus().isEmpty()) {
                        statusmessage = ((StatusInfo)e.getLastStatus().get(0)).getMessageText();
                    }
                    logger.error((Object)MessageFormat.format(ImportErrors.UNABLE_TO_RETRIEVE_DESTINATION_FORM_IMPORT_NOT_ATTEMPTED.toDefMsg(), sourceFormName, this.options.getContext().getServer(), statusmessage));
                    logger.error((Object)ImportErrors.FORM_MISSING.toDefMsg(), (Throwable)e);
                    this.setProcessDataSet(false);
                }
            } else if (this.options.isFromARM()) {
                Map<String, MappingOptions> mappingOptions = this.options.getMappingOptions(sourceFormName);
                if (mappingOptions == null) {
                    mappingOptions = this.options.getMappingOptions("ARImport_Data_Holder");
                }
                if (mappingOptions == null) {
                    throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
                }
                Iterator<Object> i$ = mappingOptions.keySet().iterator();
                if (i$.hasNext()) {
                    String form;
                    destinationFormName = form = i$.next();
                }
                try {
                    this.setTargetForm(Util.getServerForm(this.options, destinationFormName));
                    this.options.addServerForm(this.getTargetForm());
                }
                catch (ARException e) {
                    throw new ARImportException(ImportErrors.FORM_INFO_NOT_RETRIEVED.toDefMsg());
                }
                this.options.addMappingOptions(sourceFormName, destinationFormName, null);
            } else {
                try {
                    this.setTargetForm(Util.getServerForm(this.options, formInfo.getName()));
                    this.options.addServerForm(this.getTargetForm());
                    destinationFormName = this.getTargetForm().getName();
                }
                catch (ARException e) {
                    throw new ARImportException(ImportErrors.FORM_INFO_NOT_RETRIEVED.toDefMsg());
                }
            }
        }
        if (this.getTargetForm() != null && this.isProcessDataSet()) {
            MappingOptions maps = this.options.getMappingOptions(sourceFormName, destinationFormName);
            if (maps == null) {
                maps = this.options.getMappingOptions("ARImport_Data_Holder", destinationFormName);
            }
            if (maps == null || maps.isEmpty()) {
                Map<Integer, Mapping> fallbbc = null;
                if (maps != null) {
                    fallbbc = maps.getFallbacks();
                }
                maps = Util.generateMappingsForARX(this.getTargetForm(), this.getSourceForm());
                if (fallbbc != null) {
                    maps.setFallbacks(fallbbc);
                }
                this.options.addMappingOptions(sourceFormName, destinationFormName, maps);
            } else {
                FieldInformation sourceField;
                if (this.options.getDataOptions() != null && this.options.getDataOptions().getDuplicateFields() != null) {
                    for (Integer duplicateField : this.options.getDataOptions().getDuplicateFields()) {
                        FieldInformation field;
                        if (maps.getMappings().containsKey(duplicateField) || (field = this.getTargetForm().getFields().get(duplicateField)) == null) continue;
                        Mapping duplicateFieldMapping = new Mapping();
                        duplicateFieldMapping.setType(Mapping.Type.FIELDID);
                        duplicateFieldMapping.setFieldId(field.getFieldId());
                        duplicateFieldMapping.setFieldName(field.getName());
                        sourceField = this.getSourceForm().getFields().get(field.getFieldId());
                        if (sourceField == null || !field.getDataType().equals((Object)sourceField.getDataType())) continue;
                        duplicateFieldMapping.setTokenIndex(sourceField.getTokenIndex());
                        maps.addMapping(duplicateField, duplicateFieldMapping);
                    }
                }
                for (FieldInformation targetField : this.getTargetForm().getFields().values()) {
                    int index;
                    Mapping mapping = maps.getMappings().get(targetField.getFieldId());
                    if (mapping == null || (index = mapping.getTokenIndex()) != -1) continue;
                    sourceField = null;
                    if (mapping.getType() == Mapping.Type.FIELDID) {
                        sourceField = this.getSourceForm().getFields().get(mapping.getFieldId());
                        if (sourceField == null) continue;
                        mapping.setTokenIndex(sourceField.getTokenIndex());
                        continue;
                    }
                    if (mapping.getType() != Mapping.Type.FIELDNAME) continue;
                    for (FieldInformation fieldInfo : this.getSourceForm().getFields().values()) {
                        if (!mapping.getFieldName().equals(fieldInfo.getName())) continue;
                        sourceField = fieldInfo;
                        break;
                    }
                    if (sourceField == null) continue;
                    mapping.setTokenIndex(sourceField.getTokenIndex());
                }
            }
            this.options.addFileForm(formInfo);
            logger.info((Object)MessageFormat.format(ImportErrors.IMPORTING.toDefMsg(), sourceFormName, this.getTargetForm().getName(), this.getOptions().getContext().getServer()));
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setSourceForm(this.getSourceForm());
                this.getEntryFactory().setTargetForm(this.getTargetForm());
            }
        }
    }
}

