/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.plugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.CharDataEncryption;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.utils.StringByteUtil;
import com.bmc.arsys.ws.client.WebServiceSoapClient;
import com.bmc.thirdparty.org.apache.commons.codec.DecoderException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;

public class WSPlugin
implements ARFilterAPIPluggable {
    public static final String PLUGIN_NAME = "ARSYS.ARF.WEBSERVICE";
    public static final String POLICY_CONFIG_DIR = "policyConfigDir";
    private static final int WS_MAX_PARAMS = 19;
    private static final int AR_MAX_NAME_SIZE_30_BYTES = 30;
    private static final int AR_ENCRYPTION_VERSION_1 = 0;
    private static final int AR_ENCRYPTION_VERSION_2 = 1;
    private static final int AR_ENCRYPTION_VERSION_3 = 2;
    private static final int serverMaxFilterTimeout = 300;
    private static final int leaptime = 5;
    private ARPluginInfo mInfo = null;

    public static void init(ARPluginContext context) {
        context.logMessage(context.getPluginInfo(), 0, "Static initialize method invoked");
        int userDefiendTimeout = 0;
        int filterTimeout = 0;
        int timeoutSetting = 0;
        try {
            userDefiendTimeout = Integer.parseInt(context.getConfigItem("timeout"));
            context.logMessage(0, "userdefined timeout: " + userDefiendTimeout + " sec");
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            filterTimeout = Integer.parseInt(context.getARConfigEntry("Filter-Api-Timeout"));
            context.logMessage(0, "Filter-Api-Timeout: " + filterTimeout + " sec");
            if (filterTimeout > 300) {
                filterTimeout = 300;
                context.logMessage(0, "Filter-Api-Timeout: reset to max " + filterTimeout + " sec");
            }
        }
        catch (NumberFormatException ne1) {
            context.logMessage(1, "Default timeout(40 sec) is being used, as no timeout value is provided for 'Filter-Api-Timeout'");
            filterTimeout = 40;
        }
        if (userDefiendTimeout > 0) {
            timeoutSetting = Math.min(userDefiendTimeout, filterTimeout);
            context.logMessage(0, "min timeoutSettingt: " + timeoutSetting + " sec");
        } else {
            timeoutSetting = filterTimeout;
            context.logMessage(0, "timeoutSettingt: " + timeoutSetting + " sec");
        }
        if (timeoutSetting + 5 > filterTimeout) {
            context.logMessage(0, "timeoutSettingt: " + (timeoutSetting -= 5) + " sec");
        }
        if (timeoutSetting > 0) {
            WebServiceSoapClient.timeout = timeoutSetting;
        }
        context.logMessage(0, "WS timeout setting: " + WebServiceSoapClient.timeout);
    }

    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        if (pInValues.size() < 12 || pInValues.size() > 19) {
            this.ThrowException("Invalid number of parameters for Web Service call");
        }
        try {
            Value val;
            Value pwdValue;
            Value auValue;
            String[] arguments = new String[pInValues.size()];
            for (int i = 0; i < 11; ++i) {
                arguments[i] = pInValues.get(i).toString();
            }
            String inputDoc = pInValues.get(11).toString();
            arguments[11] = this.DecryptStringForImport(context, 101, inputDoc);
            if (pInValues.size() > 12 && (auValue = pInValues.get(12)).getDataType() == DataType.CHAR && auValue.getValue() != null) {
                arguments[12] = auValue.toString();
            }
            if (pInValues.size() > 13 && (pwdValue = pInValues.get(13)).getDataType() == DataType.CHAR && pwdValue.getValue() != null) {
                PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                byte[] decPasswd = pwdEnc.decryptPasswordEx(((String)pwdValue.getValue()).getBytes());
                arguments[13] = new String(decPasswd);
            }
            if ((val = pInValues.get(15)).getDataType() == DataType.CHAR && val.getValue() != null) {
                arguments[15] = val.toString();
            }
            if ((val = pInValues.get(14)).getDataType() == DataType.CHAR && val.getValue() != null) {
                arguments[14] = val.toString();
            }
            if ((val = pInValues.get(16)).getDataType() == DataType.CHAR && val.getValue() != null) {
                arguments[16] = val.toString();
            }
            String returnString = WebServiceSoapClient.call(context, this.mInfo, arguments, WebServiceSoapClient.timeout);
            Vector<Value> list = new Vector<Value>();
            Value value = new Value(returnString);
            list.add(value);
            return list;
        }
        catch (Exception e) {
            this.ThrowException(e.getMessage());
            return null;
        }
    }

    private void ThrowException(String appendedText) throws ARException {
        throw new ARException(2, 9130, appendedText);
    }

    private String fixServerCharsetName(String serverCharSetName) {
        if (serverCharSetName != null && serverCharSetName.equals("windows-31j")) {
            return "EUC_JP";
        }
        return serverCharSetName;
    }

    private String DecryptStringForImport(ARPluginContext context, int key, String inputDoc) throws AREncryptionException, UnsupportedEncodingException, DecoderException {
        byte[] tempBytes = null;
        if (inputDoc == null || inputDoc.length() == 0) {
            return null;
        }
        int indexEL = inputDoc.indexOf(92);
        if (indexEL == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String stringEL = inputDoc.substring(0, indexEL);
        int encryptedLength = Integer.parseInt(stringEL);
        int indexPC = inputDoc.indexOf(92, indexEL + 1);
        if (indexPC == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String stringPC = inputDoc.substring(indexEL + 1, indexPC);
        int paddedLength = Integer.parseInt(stringPC);
        int indexEV = inputDoc.indexOf(92, indexPC + 1);
        if (indexEV == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String stringEV = inputDoc.substring(indexPC + 1, indexEV);
        int encryptionVersion = Integer.parseInt(stringEV);
        int elModulus = encryptedLength % 30;
        if (encryptionVersion < 2 && elModulus != 0) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        int indexEnd = indexEV + encryptedLength + 1;
        String tempString = inputDoc.substring(indexEV + 1, indexEnd);
        switch (encryptionVersion) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                tempBytes = StringByteUtil.hexStrToBytes((String)tempString);
                break;
            }
        }
        String decryptedString = null;
        switch (encryptionVersion) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                CharDataEncryption charEnc = new CharDataEncryption(false);
                byte[] decryptedBytes = charEnc.decryptWebServiceBody(tempBytes);
                if (context != null) {
                    decryptedString = new String(decryptedBytes, this.fixServerCharsetName(context.getRemoteHostCharSet()));
                    break;
                }
                decryptedString = new String(decryptedBytes);
                break;
            }
        }
        if (paddedLength > 0) {
            int endIndex = decryptedString.length() - paddedLength;
            decryptedString = decryptedString.substring(0, endIndex);
        }
        return decryptedString;
    }

    public void initialize(ARPluginContext context) throws ARException {
    }

    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
    }

    public void terminate(ARPluginContext context) throws ARException {
    }

    public static void main(String[] args) throws Exception {
        String inputDoc = "826\\0\\02\\4336326a594a655552473556747a47524667396163656b3573734a7a344f563574454a6d615854792f694b736b50335557434d7938414961776d5832673548326c736746464e4853742b75780a54427a45657765656e467052453772785734713353656f726138444a537832334b56704e55775530375646684a7a383369346a2f6948314f30497a63557446543361525977374445437350390a6f5664687641325850464e6d635857594c4a59623034555349632f52724e4742434f6433784e764a6d4c694d5876552b56755938522b7065356a71636e32347a3252394b7a3262556e714a780a624230456f4a6a492f4671757239654f4f52707956384d546a53396c68537178687a6b4c696861775373354d71524565625856695533333861314c554436517145477a6a636157657272556b0a2f7a594d685258476e5a2b494c39364a495934546f35734b594e62393138513048386b3976485241564a3968784c4d4753303171304e6b7776714370686d526d4561536e46736232527655530a3635794e6531776433596b70436e5650716563306347554d6f513d3d";
        String decrypted = new WSPlugin().DecryptStringForImport(null, 101, inputDoc);
        System.out.println(decrypted);
    }
}

